-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local sml = require 'sml'
local c_controller = require 'controller.controller_object'
local lu = require 'luaunit'

TestStorage = {}

function TestStorage:test_start_update_task()
    origin_func1 = sml.get_ctrl_info
    origin_func2 = sml.update_ctrl_init_state
    
    local ctrl = {
        new_task = function()
            return {
                loop = function(obj, cb)
                    cb({is_exit = false})
                    return {
                        set_timeout_ms = function()
                        end
                    }
                end
            }
        end,
        Id = 1,
        TypeId = 20,
        tasks_pause = false
    }
    sml.update_ctrl_init_state = function()
        return 2
    end
    sml.get_ctrl_info = nil
    sml.get_ctrl_info = function(params, id)
        local nil_obj = nil
        nil_obj.field = "force error"
    end
    pcall(c_controller.start_update_task, ctrl)
    sml.get_ctrl_info = origin_func1
    sml.update_ctrl_init_state = origin_func2
end

function TestStorage:test_stop_update_task()
    local ctrl = {
        Id = 1,
        TypeId = 20,
        stop = function()
        end,
        set_default_values = function()
        end,
        set_default_volume_manage_values = function()
        end,
        set_default_health_status = function()
        end,
        set_default_battery_info = function()
        end,
        set_default_phy_err = function()
        end,
        clear_asset_data_info = function()
        end
    }
    local ok = pcall(c_controller.stop_related_tasks, ctrl)
    lu.assertEquals(ok, true)
end

function TestStorage:test_unregister_controller_to_sml()
    local origin_func = sml.unregister_controller
    local ctrl = {
        Id = 1,
        get_mapping_type_id = function ()
            return 20
        end
    }
    sml.unregister_controller = function ()
        return 1
    end
    local ok = pcall(c_controller.unregister_controller_to_sml, ctrl)
    lu.assertEquals(ok, false)
    sml.unregister_controller = function ()
        return 0
    end
    ok = pcall(c_controller.unregister_controller_to_sml, ctrl)
    lu.assertEquals(ok, true)
    sml.unregister_controller = origin_func
end
