-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local replica_drive = require 'nvme.replica_drive.replica_drive'
local lu = require 'luaunit'

TestReplicaDrive = {}

function TestReplicaDrive:test_update_info()
    local obj = {
        update_replica_drive_info = function(obj, info)
            replica_drive.update_replica_drive_info(obj, info)
        end
    }
    replica_drive.super.init = function()
    end
    replica_drive.ctor(obj)
    replica_drive.init(obj)
    obj.on_update:emit()
    lu.assertEquals(obj.SerialNumber, nil)
    obj.on_update:emit({SerialNumber = 'test'})
    lu.assertEquals(obj.SerialNumber, 'test')
end