local lu = require 'luaunit'
local vpd_connector = require 'nvme.vpd_connector'
local hook_tasks = require 'test_common.hook_tasks'

TestPolicy = {}

function TestPolicy:setUp()
    self.tasks = hook_tasks:hook()
end

function TestPolicy:tearDown()
    hook_tasks.unhook()
end

function TestPolicy:test_nvme_mi_load_cooling_policy()
    local mock_nvme = { Slot = 45,
                        pcie_nvme_get_protocol_type = function()
                            return 0
                        end,
                        VPDChip = {
                            Read = function()
                                return "HUAWEI"
                            end
                        }}
    local task_name = string.format("update_policy_connector%s", mock_nvme.Slot)
    vpd_connector.RefPolicyConnector = {
        AuxId = '255'
    }

    vpd_connector.load_cooling_policy(vpd_connector, mock_nvme)
    self.tasks:run_task(task_name)
    lu.assertEquals(vpd_connector.RefPolicyConnector.AuxId, "19e5")
end

function TestPolicy:test_ssd_form_load_cooling_policy()
    local mock_nvme = { Slot = 45,
                        pcie_nvme_get_protocol_type = function()
                            return 1
                        end,
                        VPDChip = {
                            Read = function()
                                return string.char(0x86) .. string.char(0x80)
                            end
                        }}
    local task_name = string.format("update_policy_connector%s", mock_nvme.Slot)
    vpd_connector.RefPolicyConnector = {
        AuxId = '255'
    }
    vpd_connector.load_cooling_policy(vpd_connector, mock_nvme)
    self.tasks:run_task(task_name)
    lu.assertEquals(vpd_connector.RefPolicyConnector.AuxId, "8086")
end

function TestPolicy:test_load_default_cooling_policy()
    local mock_nvme = { Slot = 45,
                        pcie_nvme_get_protocol_type = function()
                            return 1
                        end,
                        VPDChip = {
                            Read = function()
                                return string.char(0x86) .. string.char(0x99)
                            end
                        }}
    local task_name = string.format("update_policy_connector%s", mock_nvme.Slot)
    vpd_connector.RefPolicyConnector = {
        AuxId = '255'
    }
    vpd_connector.load_cooling_policy(vpd_connector, mock_nvme)
    self.tasks:run_task(task_name)
    lu.assertEquals(vpd_connector.RefPolicyConnector.AuxId, "ffff")
end