-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_drive = require 'drive.drive_object'
local c_storage_service = require 'storage.service'
local class = require 'mc.class'
local lu = require 'luaunit'
local client = require 'storage.client'


TestDriveGetPosition = class(c_storage_service)

function TestDriveGetPosition:test_get_drive_position()
    local drive = {
        ObjectIdentifier = {
            0, 0, 0, '01010D'
        }
    }
    local board_objs = {
        ['HddBackplane_01010D'] = {
            ['Position'] = 'SEU1',
            ['SilkText'] = 'front'
        },
        ['M2Transfer_010102'] = {
            ['Position'] = 'chassis',
            ['NodeId'] = 'chassisM2TransferCard2'
        }

    }
    client.GetBoardObjects = function ()
    end
    local ok, position = pcall(c_drive.get_drive_position, drive)
    lu.assertEquals(ok, true)
    lu.assertEquals(position, 'N/A')
    client.GetBoardObjects = function ()
        return board_objs
    end
    ok, position = pcall(c_drive.get_drive_position, drive)
    lu.assertEquals(ok, true)
    lu.assertEquals(position, 'SEU1front')
    drive.ObjectIdentifier[4] = '010102'
    ok, position = pcall(c_drive.get_drive_position, drive)
    lu.assertEquals(ok, true)
    lu.assertEquals(position, 'chassisM2TransferCard2')
end

function TestDriveGetPosition:test_update_drive_position()
    local tmp = 'xxx'
    local drive = {
        new_task = function ()
            return {
                loop = function (self, cb)
                    cb(self)
                    return {
                        set_timeout_ms = function ()
                        end
                    }
                end
            }
        end,
        stop_task = function ()
        end
    }
    c_drive.ContainerPhysicalContext = tmp
    c_drive.update_drive_physical_context(drive)
    lu.assertEquals(c_drive.ContainerPhysicalContext, tmp)
    c_drive.ContainerPhysicalContext = ''
    c_drive.update_drive_physical_context(drive)
    lu.assertEquals(c_drive.ContainerPhysicalContext, '')
end