-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local ctrl_info = require 'sml.ctrl_info'

TestCtrlInfo = {}

function TestCtrlInfo.test_get_strip_szie()
    local min, max = ctrl_info:get_ctrl_strip_szie_options()
    lu.assertEquals(min, 255)
    lu.assertEquals(max, 255)
    ctrl_info.min_strip = 1
    ctrl_info.max_strip = 2
    min, max = ctrl_info:get_ctrl_strip_szie_options()
    lu.assertEquals(min, 1024)
    lu.assertEquals(max, 2048)
end