-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local controller_dump = require 'controller.controller_dump'
local lu = require 'luaunit'

TestControllerDump = {}

function TestControllerDump:test_dump_oob_info()
    local controller = {
        FaultCode = 0xEF,
        MinStripSizeBytes = 4,
        MaxStripSizeBytes = 8,
        PCIeLinkWidth = 8,
        BootDevices = {}
    }
    local fp = {
        write = function()
        end
    }
    local ok = pcall(controller_dump.dump_oob_info, controller_dump, fp, controller)
    lu.assertEquals(ok, true)
end

function TestControllerDump:test_dump_basic_info()
    local controller = {
        ControllerName = "sp686c",
        Type = 4,
        DeviceName = "sp686c",
        OOBSupport = 1,
        WorkMode = {}
    }
    local fp = {
        write = function()
        end
    }
    local ok = pcall(controller_dump.dump_basic_info, controller_dump, fp, controller)
    lu.assertEquals(ok, true)
end