-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local sml = require 'sml'
local c_ctrl_info = require 'sml.ctrl_info'

local controller = {
    Id = 0,
    DevFunction = 1,
    SocketId = 1,
    DevDevice = 1,
    TypeId = 99,
    Segment = 1,
    SystemId = 1,
    DevBus = 1,
    Name = 'HI1880_SP686C_M_16i_2G',
    OOBSupport = 1,
    path = 'Controller_1_0001010102',
    CtrlOption1 = 2275649443,
    CtrlOption2 = 32647,
    CtrlOption3 = 0
}

local function add_controller(self)
    -- mctp_service prepare 前增加的对象，会在 object_manager 模块缓存,直到 prepare 成功
    self.object_manager.mc:add_object('Controller', controller, 1)

    self.bus_monitor_service.on_os_state_changed:emit(true)
    -- 运行 mctp_start_task 任务，成功后 object_manager 会发出 prepare_ok 信号
    self.tasks:run_until(function()
        return self.mctp_service.m_mctp_collection[controller.Id] ~= nil
    end)

    ---@diagnostic disable-next-line: duplicate-set-field
    sml.get_ctrl_info = function()
        return c_ctrl_info.new(self.test_controller_data)
    end
    self.tasks:run_all_task()
    return self.controller_collection:get_by_controller_id(controller.Id)
end

-- 测试打开一致性校验功能
function TestStorage:test_controller_enable_consistency_check()
    local controller = add_controller(self)
    -- 设置回拷成功
    sml.ctrl_operation = function()
        return 0
    end
    local rpc_service_controller = self.rpc_service_controller
    local ret = pcall(rpc_service_controller.ctrl_operate, rpc_service_controller,
        'EnableCCheck', controller.Id, nil, 48, 1, 1, 1)
    self.tasks:run_all_task()
    lu.assertEquals(ret, true)

    ret = pcall(rpc_service_controller.ctrl_operate, rpc_service_controller,
        'DisableCCheck', controller.Id, nil)
    self.tasks:run_all_task()
    lu.assertEquals(ret, true)

    -- 非法输入
    ret = pcall(rpc_service_controller.ctrl_operate, rpc_service_controller,
        'EnableCCheck', controller.Id, nil, 1, 1, 1, 1)
    self.tasks:run_all_task()
    lu.assertEquals(ret, false)

    -- 正在工作中
    controller.is_working = true
    ret = pcall(rpc_service_controller.ctrl_operate, rpc_service_controller,
        'EnableCCheck', controller.Id, nil, 48, 1, 1, 1)
    self.tasks:run_all_task()
    lu.assertEquals(ret, false)
    controller.is_working = false

    -- 设置返回失败
    sml.ctrl_operation = function()
        return 0x12
    end
    ret = pcall(rpc_service_controller.ctrl_operate, rpc_service_controller,
        'EnableCCheck', controller.Id, nil, 48, 1, 1, 1)
    self.tasks:run_all_task()
    lu.assertEquals(ret, false)

    -- 删除受模块管理的对象
    self.object_manager.mc:del_object('Controller', controller, 1)
    self.tasks:run_all_task()
end
