-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local controller = {
    Id = 0,
    DevFunction = 1,
    SocketId = 1,
    DevDevice = 1,
    TypeId = 99,
    Segment = 1,
    SystemId = 1,
    DevBus = 1,
    Name = 'HI1880_SP686C_M_16i_2G',
    OOBSupport = 1,
    path = 'Controller_1_0001010102',
    CtrlOption1 = 2275649443,
    CtrlOption2 = 32647,
    CtrlOption3 = 0,
    DeviceName = 'PCIE Card 2 (9560-8i)'
}

local battery = {
    TemperatureCelsius = 20,
    RefControllerDeviceName = 'PCIe Card 2 (9560-8i)',
    get_parent = function()
        return controller
    end
}

local function add_raid_battery(self)
    self.object_manager.mc:add_object('Battery', battery, 0)
end

-- 仅用于通过门禁，后续不需要该用例，由test_battery.lua实现
function TestStorage:test_init_basic()
    --  测试添加 battery对象成功
    add_raid_battery(self)
end