-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local sml = require 'sml'
local c_ctrl_info = require 'sml.ctrl_info'
local c_pd_info = require 'sml.pd_info'
local c_pd_sas_smart_info = require 'sml.pd_sas_smart_info'
local c_ld_info = require 'sml.ld_info'
local c_array_info = require 'sml.array_info'
local c_battery_info = require 'sml.battery_info'
local client = require 'storage.client'

client.OnComponentPropertiesChanged = function ()
end

local sml_apis = {
    'register_controller', 'set_i2c_chip', 'pd_operation', 'ctrl_operation', 'get_ctrl_pd_list', 'get_ctrl_ld_list',
    'get_ctrl_array_list', 'get_ctrl_init_state', 'clear_all_controller_info', 'get_ctrl_sas_addr',
    'get_pd_info', 'get_ld_info', 'get_ctrl_info', 'get_ctrl_boot_devices', 'get_ctrl_faultcode', 'get_array_info',
    'get_battery_info', 'update_ctrl_init_state','add_ld_on_exist_array', 'create_ld_on_new_array',
    'get_ld_sscd_caching_enable', 'get_sscd_associated_ld_list', 'get_ld_associated_sscd_list'
}

local function register_controller()
    return 0
end

local function set_i2c_chip()
    return 0
end

local function get_ctrl_init_state()
    return 2
end

local function update_ctrl_init_state()
    return 2
end

local function get_ctrl_sas_addr()
    return '0x10000'
end

local function get_ctrl_faultcode()
   return 0
end

local function clear_all_controller_info()
end

local function pd_operation()
end

local function ctrl_operation()
end

local function get_ctrl_pd_list()
    return {}
end

local function get_ctrl_ld_list()
    return {}
end

local function get_ctrl_array_list()
    return {}
end

local function get_pd_info()
    return c_pd_info.new({})
end

local function get_pd_sas_smart_info()
    return c_pd_sas_smart_info.new({})
end

local function get_ld_info()
    return c_ld_info.new({})
end

local function get_ctrl_info()
    return c_ctrl_info.new({})
end

local function get_array_info()
    return c_array_info.new({})
end

local function get_battery_info()
    return c_battery_info.new({})
end

local function get_ctrl_boot_devices()
    return 0, 0
end

local function set_ld_boot_priority()
    return 0
end

local function add_ld_on_exist_array()
    return 0
end

local function create_ld_on_new_array()
    return 0
end

local function get_ld_sscd_caching_enable()
    return 0
end

local function get_sscd_associated_ld_list()
    return {}
end

local function get_ld_associated_sscd_list()
    return {}
end

local register_ctrl_oob = {}
register_ctrl_oob.__index = register_ctrl_oob

function register_ctrl_oob.__close()
end

function register_ctrl_oob.new()
    return setmetatable({}, register_ctrl_oob)
end

function register_ctrl_oob:register_controller()
    return 0
end

function register_ctrl_oob:unregister_controller()
    return 0
end

local m = {}

local function save_old_apis()
    local olds = {}
    for _, n in ipairs(sml_apis) do
        olds[n] = sml[n]
    end
    m.olds = olds
end

local function restore_apis()
    if not m.olds then
        return
    end

    for n, v in pairs(m.olds) do
        sml[n] = v
    end
end

function m.hook()
    save_old_apis()

    sml.pd_operation = pd_operation
    sml.ctrl_operation = ctrl_operation
    sml.get_ctrl_pd_list = get_ctrl_pd_list
    sml.get_ctrl_ld_list = get_ctrl_ld_list
    sml.get_ctrl_array_list = get_ctrl_array_list
    sml.get_ctrl_init_state = get_ctrl_init_state
    sml.update_ctrl_init_state = update_ctrl_init_state
    sml.clear_all_controller_info = clear_all_controller_info
    sml.get_ctrl_sas_addr = get_ctrl_sas_addr
    sml.get_pd_info = get_pd_info
    sml.get_ld_info = get_ld_info
    sml.get_ctrl_info = get_ctrl_info
    sml.get_array_info = get_array_info
    sml.get_battery_info = get_battery_info
    sml.register_ctrl_oob = register_ctrl_oob
    sml.get_ctrl_boot_devices = get_ctrl_boot_devices
    sml.get_ctrl_faultcode = get_ctrl_faultcode
    sml.set_ld_boot_priority = set_ld_boot_priority
    sml.register_controller = register_controller
    sml.set_i2c_chip = set_i2c_chip
    sml.add_ld_on_exist_array = add_ld_on_exist_array
    sml.create_ld_on_new_array = create_ld_on_new_array
    sml.get_ld_sscd_caching_enable = get_ld_sscd_caching_enable
    sml.get_sscd_associated_ld_list = get_sscd_associated_ld_list
    sml.get_ld_associated_sscd_list = get_ld_associated_sscd_list
end

function m.unhook()
    restore_apis()
end

return m
