-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

local c_volume = class()
local function make_volume_key(controller_id, volume_id)
    return string.format('%d:%d', controller_id, volume_id)
end

function c_volume:ctor(controller_position, controller_id, volume_id)
    self.key = make_volume_key(controller_id, volume_id)
    self.path = string.format('Controller_1_%s', controller_position)
    self.controller_id = controller_id
    self.volume_id = volume_id
end

return c_volume