-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local class_mgnt = require 'mc.class_mgnt'
local skynet = require 'skynet'
local Patition = class()

function Patition:ctor(obj, info)
    self.obj = obj
    self.alarm_flag = false -- 告警标志
    self.alarm_usage = 0 -- 产生告警时的占用率，用于恢复告警
    self.alarm_threshold = 0 -- 产生告警时的门限，用于恢复告警
end

function Patition:update(info)
    if self.obj then
        self.obj.Name = info.OSDriveName
        self.obj.Usage = info.Usage
        self.obj.TotalCapacityGiB = info.TotalCapacityGiB
        self.obj.UsedCapacityGiB = info.UsedCapacityGiB
    end
end

function Patition:del()
    if self.obj then
        -- 从资源树删除
        for _ = 1, 3 do
            local ok, _ = pcall(function()
                class_mgnt(self.obj.class_name):remove(self.obj)
            end)
            if ok then
                return
            end
            skynet.sleep(100)
        end
    end
end

return Patition