-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local signal = require 'mc.signal'

---@class c_replica_drive: c_object
---@field Id integer
---@field SerialNumber string

local c_replica_drive = c_object('ReplicaDrive')

function c_replica_drive:ctor()
    self.on_update = signal.new()
end

function c_replica_drive:init()
    c_replica_drive.super.init(self)
    self.on_update:on(function(info)
        self:update_replica_drive_info(info)
    end)
end

function c_replica_drive:update_replica_drive_info(info)
    if not info then
        return
    end
    self.SerialNumber = info.SerialNumber
end

return c_replica_drive
