/* Copyright (c) 2025 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_ADAPTER
#define L_SML_ADAPTER

#include <dlfcn.h>
#include "sml.h"
#include "sml_public.h"

namespace sml {
using SmlRegisterController = gint32 (*)(SML_CTRL_OOB_INFO_S *ctrl);
using SmlibGetArrayInfo = gint32 (*)(guint8 ctrl_index, guint16 array_ref, SML_ARRAY_INFO_S *array);
using SmlUnRegisterController = gint32 (*)(SML_CTRL_OOB_INFO_S *ctrl);
using SmlibGetCtrlInfo = gint32 (*)(guint8 ctrl_index, SML_CTRL_BASIC_INFO_S *ctrl);
using SmlGetCtrlPdList = gint32 (*)(SML_CTRL_PD_LIST_S *ctrl);
using SmlGetCtrlLdList = gint32 (*)(SML_CTRL_LD_LIST_S *ctrl);
using SmlGetCtrlArrayList = gint32 (*)(SML_CTRL_ARRAY_LIST_S *ctrl);
using SmlGetCtrlBootDevices = gint32 (*)(SML_CTRL_BOOTABLE_DEVICES_S *boot_devices);
using SmlGetCtrlSasAddr = gint32 (*)(SML_CTRL_SAS_ADDR_S *ctrl);
using SmlCtrlOperation = gint32 (*)(SML_CTRL_OPERTATION_S* ctrl);
using SmlGetCtrlHealthStatus = gint32 (*)(SML_CTRL_HEALTH_STATUS_S* ctrl);
using SmlDumpCtrlSingleLog = gint32 (*)(guint8 ctrl_id, const gchar *src_dir, guint8 log_type, const gchar *log_name);
using SmlParseCtrlBinLog = gint32 (*)(guint8 ctrl_id, const gchar *src_dir, const gchar *dest_dir);
using SmlibGetCtrlBbuStatus = gint32 (*)(guint8 ctrl_index, SML_BBU_STATUS_S *ctrl);
using SmlibGetLdInfo = gint32 (*)(guint8 ctrl_index, guint16 ld_target_id, SML_LD_BASIC_INFO_S *ld);
using SmlibExecLdOperation = gint32 (*)(guint8 ctrl_index, guint16 ld_target_id,
    guint8 operation, gpointer param, guint32 param_length);
using SmlSetLdBootPriority = gint32 (*)(SML_LD_TARGET_S* ld);
using SmlSetLdDelete = gint32 (*)(SML_LD_TARGET_S* ld);
using SmlCreateLdOnExistedArray = gint32 (*)(SML_RAID_ON_EXISTED_ARRAY_PARAM_S* config);
using SmlCreateLdOnNewArray = gint32 (*)(SML_RAID_ON_NEW_ARRAY_PARAM_S* config);
using SmlGetLdSscdCachingEnable = gint32 (*)(SML_LD_SSCD_CACHING_ENABLE_S* ld);
using SmlGetSscdAssociatedLdList = gint32 (*)(SML_SSCD_ASSOCIATED_LD_LIST_S* ld);
using SmlGetLdAssociatedSscdList = gint32 (*)(SML_LD_ASSOCIATED_SSCD_LIST_S* ld);
using SmlSetLdCachecadeAssociation = gint32 (*)(SML_LD_SET_CACHECADE_ASSOCIATION_S* ld);
using SmlCreateLdAsCachecade = gint32 (*)(SML_RAID_CACHECADE_PARAM_S* config);
using SmlibGetPdInfo = gint32 (*)(guint8 ctrl_index, guint16 pd_device_id, SML_PD_BASIC_INFO_S *pd);
using SmlibGetPdSasSmartInfo = gint32 (*)(guint8 ctrl_index, guint16 pd_device_id, SML_PD_SAS_SMART_INFO *smart_info);
using SmlibGetPdSasSmartInfoSpec = gint32 (*)(guint8 ctrl_index,
                                              guint16 pd_device_id, SML_PD_SAS_SMART_INFO *smart_info, guint8 filter);
using SmlibGetPdSlowDiskInfo = gint32 (*)(guint8 ctrl_index, guint16 pd_device_id, void *slow_disk_info);
using SmlPdOperation = gint32 (*)(SML_PD_OPERTATION_S* pd);
using SmlDiagnoseEnclCommError = gint32 (*)(SML_PD_FAULT_ANALYSIS* diag_info);
using SmlDiagnosePdSenseError = gint32 (*)(SML_PD_FAULT_ANALYSIS* diag_info);
using SmlGetSmartDataStr = gint32 (*)(guint8 controller_index, guint16 pd_device_id,
    guint8 hdd_intf_type, GVariant **smart_info_var);
using SmlibDiagnoseLinkPhyError = gint32 (*)(SML_PD_FAULT_ANALYSIS *diag_info, guint32 serial_threshold,
    guint32 recent_threshold);
using SmlGetCtrlExpSasPhyErrCount = gint32 (*)(SML_CTRL_EXP_SAS_PHY_INFO_S* expander);
using SmlibGetCtrlPhyErrCount = gint32 (*)(guint8 ctrl_index, SML_SASPHY_INFO_S *ctrl, guint8 force_update);
using SmlClearAllControllerInfo = void (*)();
using SmlGetCtrlInitState = gint8 (*)(guint8 ctrl_index);
using SmlPdTransDriveData = gint32 (*)(guint8 ctrl_index, const char* json_raw_str);

using SML_ADAPTER_FUNC_S = struct _tag_sml_adapter_func {
    void **pfunc;
    const gchar *func_name;
};

using PD_LOG_PARSE_FUNC_S = struct _tag_pd_log_parse_func {
    void **pfunc;
    const gchar *func_name;
};

using SML_ADAPTER_S = struct _tag_sml_adapter {
    SmlRegisterController sml_register_controller;
    SmlibGetArrayInfo smlib_get_array_info;
    SmlUnRegisterController sml_unregister_controller;
    SmlibGetCtrlInfo smlib_get_ctrl_info;
    SmlGetCtrlPdList sml_get_ctrl_pd_list;
    SmlGetCtrlLdList sml_get_ctrl_ld_list;
    SmlGetCtrlArrayList sml_get_ctrl_array_list;
    SmlGetCtrlBootDevices sml_get_ctrl_boot_devices;
    SmlGetCtrlSasAddr sml_get_ctrl_sas_addr;
    SmlCtrlOperation sml_ctrl_operation;
    SmlGetCtrlHealthStatus sml_get_ctrl_health_status;
    SmlDumpCtrlSingleLog sml_dump_ctrl_single_log;
    SmlParseCtrlBinLog sml_parse_controller_bin_log;
    SmlibGetCtrlBbuStatus smlib_get_ctrl_bbu_status;
    SmlibGetLdInfo smlib_get_ld_info;
    SmlibExecLdOperation smlib_exec_ld_operation;
    SmlSetLdBootPriority sml_set_ld_boot_priority;
    SmlSetLdDelete sml_set_ld_delete;
    SmlCreateLdOnExistedArray sml_create_ld_on_existed_array;
    SmlCreateLdOnNewArray sml_create_ld_on_new_array;
    SmlGetLdSscdCachingEnable sml_get_ld_sscd_caching_enable;
    SmlGetSscdAssociatedLdList sml_get_sscd_associated_ld_list;
    SmlGetLdAssociatedSscdList sml_get_ld_associated_sscd_list;
    SmlSetLdCachecadeAssociation sml_set_ld_cachecade_association;
    SmlCreateLdAsCachecade sml_create_ld_as_cachecade;
    SmlibGetPdInfo smlib_get_pd_info;
    SmlibGetPdSasSmartInfo smlib_get_pd_sas_smart_info;
    SmlibGetPdSasSmartInfoSpec smlib_get_pd_sas_smart_info_spec;
    SmlibGetPdSlowDiskInfo smlib_get_pd_slow_disk_info;
    SmlPdOperation sml_pd_operation;
    SmlDiagnoseEnclCommError sml_diagnose_encl_comm_error;
    SmlDiagnosePdSenseError sml_diagnose_pd_sense_error;
    SmlGetSmartDataStr sml_get_smart_data_str;
    SmlibDiagnoseLinkPhyError smlib_diagnose_link_phy_error;
    SmlGetCtrlExpSasPhyErrCount sml_get_ctrl_exp_sas_phy_err_count;
    SmlibGetCtrlPhyErrCount smlib_get_ctrl_phy_err_count;
    SmlClearAllControllerInfo sml_clear_all_controller_info;
    SmlGetCtrlInitState sml_get_ctrl_init_state;
    SmlPdTransDriveData sml_pd_trans_drive_data;
};

class l_sml_adapter {
public:
    static void register_sml_adapter_function(SML_CTRL_OOB_INFO_S *ctrl);
    static gint32 sml_adapter_register_controller(SML_CTRL_OOB_INFO_S *ctrl);
    static gint32 sml_adapter_unregister_controller(SML_CTRL_OOB_INFO_S *ctrl);
    static gint32 sml_adapter_get_array_info(guint8 ctrl_index, guint16 array_ref, SML_ARRAY_INFO_S *array);
    static gint32 sml_adapter_get_ctrl_info(guint8 ctrl_index, SML_CTRL_BASIC_INFO_S *ctrl);
    static gint32 sml_adapter_get_ctrl_pd_list(SML_CTRL_PD_LIST_S *ctrl);
    static gint32 sml_adapter_get_ctrl_ld_list(SML_CTRL_LD_LIST_S *ctrl);
    static gint32 sml_adapter_get_ctrl_array_list(SML_CTRL_ARRAY_LIST_S *ctrl);
    static gint32 sml_adapter_get_ctrl_boot_devices(SML_CTRL_BOOTABLE_DEVICES_S *boot_devices);
    static gint32 sml_adapter_get_ctrl_sas_addr(SML_CTRL_SAS_ADDR_S *ctrl);
    static gint32 sml_adapter_ctrl_operation(SML_CTRL_OPERTATION_S* ctrl);
    static gint32 sml_adapter_get_ctrl_health_status(SML_CTRL_HEALTH_STATUS_S *ctrl);
    static gint32 sml_adapter_dump_ctrl_single_log(guint8 ctrl_id, const gchar *src_dir, guint8 log_type,
        const gchar *log_name);
    static gint32 sml_adapter_parse_controller_bin_log(guint8 ctrl_id, const gchar *src_dir, const gchar *dest_dir);
    static gint32 sml_adapter_get_ctrl_bbu_status(guint8 ctrl_index, SML_BBU_STATUS_S *ctrl);
    static gint32 sml_adapter_get_ld_info(guint8 ctrl_index, guint16 ld_target_id, SML_LD_BASIC_INFO_S *ld);
    static gint32 sml_adapter_exec_ld_operation(guint8 ctrl_index, guint16 ld_target_id,
        guint8 operation, gpointer param, guint32 param_length);
    static gint32 sml_adapter_set_ld_boot_priority(SML_LD_TARGET_S *ld);
    static gint32 sml_adapter_set_ld_delete(SML_LD_TARGET_S *ld);
    static gint32 sml_adapter_create_ld_on_existed_array(SML_RAID_ON_EXISTED_ARRAY_PARAM_S *config);
    static gint32 sml_adapter_create_ld_on_new_array(SML_RAID_ON_NEW_ARRAY_PARAM_S *config);
    static gint32 sml_adapter_get_ld_sscd_caching_enable(SML_LD_SSCD_CACHING_ENABLE_S *ld);
    static gint32 sml_adapter_get_sscd_associated_ld_list(SML_SSCD_ASSOCIATED_LD_LIST_S *ld);
    static gint32 sml_adapter_get_ld_associated_sscd_list(SML_LD_ASSOCIATED_SSCD_LIST_S *ld);
    static gint32 sml_adapter_set_ld_cachecade_association(SML_LD_SET_CACHECADE_ASSOCIATION_S *ld);
    static gint32 sml_adapter_create_ld_as_cachecade(SML_RAID_CACHECADE_PARAM_S *config);
    static gint32 sml_adapter_get_pd_info(guint8 ctrl_index, guint16 pd_device_id, SML_PD_BASIC_INFO_S *pd);
    static gint32 sml_adapter_get_pd_sas_smart_info(guint8 ctrl_index, guint16 pd_device_id,
        SML_PD_SAS_SMART_INFO *smart_info);
    static gint32 sml_adapter_get_pd_sas_smart_info_spec(guint8 ctrl_index, guint16 pd_device_id,
        SML_PD_SAS_SMART_INFO *smart_info, guint8 filter);
    static gint32 sml_adapter_get_pd_slow_disk_info(guint8 ctrl_index, guint16 pd_device_id,
        void *slow_disk_info);
    static gint32 sml_adapter_pd_operation(SML_PD_OPERTATION_S *pd);
    static gint32 sml_adapter_diagnose_encl_comm_error(SML_PD_FAULT_ANALYSIS *diag_info);
    static gint32 sml_adapter_diagnose_pd_sense_error(SML_PD_FAULT_ANALYSIS *diag_info);
    static gint32 sml_adapter_get_smart_data_str(guint8 controller_index, guint16 pd_device_id,
        guint8 hdd_intf_type, GVariant **smart_info_var);
    static gint32 sml_adapter_diagnose_link_phy_error(SML_PD_FAULT_ANALYSIS *diag_info, guint32 serial_threshold,
        guint32 recent_threshold);
    static gint32 sml_adapter_get_ctrl_exp_sas_phy_err_count(SML_CTRL_EXP_SAS_PHY_INFO_S *expander);
    static gint32 sml_adapter_get_ctrl_phy_err_count(guint8 ctrl_index, SML_SASPHY_INFO_S *ctrl, guint8 force_update);
    static void sml_adapter_clear_all_controller_info(void);
    static gint8 sml_adapter_get_ctrl_init_state(guint8 ctrl_index);
    static gint32 sml_adapter_pd_trans_drive_data(guint8 ctrl_id, const gchar *json_raw_data);
};
} // namespace sml

#endif