/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_PD
#define L_SML_PD

#include "l_sml.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */
#pragma pack(1)

#pragma pack()
#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

namespace sml {

using SML_PD_SLOW_DATA_S = struct tag_sml_pd_slow_data {
    guint32 cmd_timeout_times;
    guint32 unexpected_sense_times;
    guint32 reset_times;
    guint32 power_on_times;
};

class l_pd {
public:
    static void register_to(lua_State *L, luawrap::stack_table &t);

private:
    static void def_properties(lua_State *L, luawrap::lua_class<SML_PD_BASIC_INFO_S> &cls);
    static void register_pd_info(lua_State *L, luawrap::stack_table &t);
    static void def_sas_smart_properties(lua_State *L, luawrap::lua_class<SML_PD_SAS_SMART_INFO> &cls);
    static void register_pd_sas_smart_info(lua_State *L, luawrap::stack_table &t);
    static void def_slow_disk_properties(lua_State *L, luawrap::lua_class<SML_PD_SLOW_DATA_S> &cls);
    static void register_slow_disk_data(lua_State *L, luawrap::stack_table &t);
};

}  // namespace sml

#endif