-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local db_selector = {}

---@class StorageResetTable: Table
---@field PerId FieldBase
---@field Key FieldBase
---@field Value FieldBase

---@class StorageDBDatabaseReset
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field StorageReset StorageResetTable

local StorageDBDatabaseReset = {}
StorageDBDatabaseReset.__index = StorageDBDatabaseReset

function StorageDBDatabaseReset.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.StorageReset = db:Table('t_storage_reset', {
        PerId = Col.TextField():cid(1):primary_key(),
        Key = Col.TextField():cid(2):primary_key(),
        Value = Col.TextField():cid(3):null()
    }):create_if_not_exist(datas and datas['t_storage_reset'])

    obj.tables = db.tables
    return setmetatable(obj, StorageDBDatabaseReset)
end

function StorageDBDatabaseReset:select(table, ...)
    return self.db:select(table, ...)
end

function StorageDBDatabaseReset:update(table, ...)
    return self.db:update(table, ...)
end

function StorageDBDatabaseReset:insert(table, ...)
    return self.db:insert(table, ...)
end

function StorageDBDatabaseReset:delete(table, ...)
    return self.db:delete(table, ...)
end

function StorageDBDatabaseReset:exec(...)
    return self.db:exec(...)
end

db_selector['reset'] = StorageDBDatabaseReset.new

local StorageDBDatabase = {}
StorageDBDatabase.__index = StorageDBDatabase

function StorageDBDatabase.new(path, datas, type)
    return db_selector[type] and db_selector[type](path, datas) or nil
end

return StorageDBDatabase.new
