-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SASSMART = {}

---@class SASSMART.LastPrefailEventSeqNum
---@field LastPrefailEventSeqNum integer
local TLastPrefailEventSeqNum = {}
TLastPrefailEventSeqNum.__index = TLastPrefailEventSeqNum
TLastPrefailEventSeqNum.group = {}

local function TLastPrefailEventSeqNum_from_obj(obj)
    return setmetatable(obj, TLastPrefailEventSeqNum)
end

function TLastPrefailEventSeqNum.new(LastPrefailEventSeqNum)
    return TLastPrefailEventSeqNum_from_obj({LastPrefailEventSeqNum = LastPrefailEventSeqNum})
end
---@param obj SASSMART.LastPrefailEventSeqNum
function TLastPrefailEventSeqNum:init_from_obj(obj)
    self.LastPrefailEventSeqNum = obj.LastPrefailEventSeqNum
end

function TLastPrefailEventSeqNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastPrefailEventSeqNum.group)
end

TLastPrefailEventSeqNum.from_obj = TLastPrefailEventSeqNum_from_obj

TLastPrefailEventSeqNum.proto_property = {'LastPrefailEventSeqNum'}

TLastPrefailEventSeqNum.default = {0}

TLastPrefailEventSeqNum.struct = {{name = 'LastPrefailEventSeqNum', is_array = false, struct = nil}}

function TLastPrefailEventSeqNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastPrefailEventSeqNum', self.LastPrefailEventSeqNum, 'uint32', true, errs,
        need_convert)

    TLastPrefailEventSeqNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastPrefailEventSeqNum.proto_property, errs, need_convert)
    return self
end

function TLastPrefailEventSeqNum:unpack(_)
    return self.LastPrefailEventSeqNum
end

SASSMART.LastPrefailEventSeqNum = TLastPrefailEventSeqNum

---@class SASSMART.UntilNextInterSMARTTestMinutes
---@field UntilNextInterSMARTTestMinutes integer
local TUntilNextInterSMARTTestMinutes = {}
TUntilNextInterSMARTTestMinutes.__index = TUntilNextInterSMARTTestMinutes
TUntilNextInterSMARTTestMinutes.group = {}

local function TUntilNextInterSMARTTestMinutes_from_obj(obj)
    return setmetatable(obj, TUntilNextInterSMARTTestMinutes)
end

function TUntilNextInterSMARTTestMinutes.new(UntilNextInterSMARTTestMinutes)
    return TUntilNextInterSMARTTestMinutes_from_obj({UntilNextInterSMARTTestMinutes = UntilNextInterSMARTTestMinutes})
end
---@param obj SASSMART.UntilNextInterSMARTTestMinutes
function TUntilNextInterSMARTTestMinutes:init_from_obj(obj)
    self.UntilNextInterSMARTTestMinutes = obj.UntilNextInterSMARTTestMinutes
end

function TUntilNextInterSMARTTestMinutes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUntilNextInterSMARTTestMinutes.group)
end

TUntilNextInterSMARTTestMinutes.from_obj = TUntilNextInterSMARTTestMinutes_from_obj

TUntilNextInterSMARTTestMinutes.proto_property = {'UntilNextInterSMARTTestMinutes'}

TUntilNextInterSMARTTestMinutes.default = {0}

TUntilNextInterSMARTTestMinutes.struct = {{name = 'UntilNextInterSMARTTestMinutes', is_array = false, struct = nil}}

function TUntilNextInterSMARTTestMinutes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UntilNextInterSMARTTestMinutes', self.UntilNextInterSMARTTestMinutes, 'uint32', true,
        errs, need_convert)

    TUntilNextInterSMARTTestMinutes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUntilNextInterSMARTTestMinutes.proto_property, errs, need_convert)
    return self
end

function TUntilNextInterSMARTTestMinutes:unpack(_)
    return self.UntilNextInterSMARTTestMinutes
end

SASSMART.UntilNextInterSMARTTestMinutes = TUntilNextInterSMARTTestMinutes

---@class SASSMART.BlocksReceivedFromInitiator
---@field BlocksReceivedFromInitiator integer
local TBlocksReceivedFromInitiator = {}
TBlocksReceivedFromInitiator.__index = TBlocksReceivedFromInitiator
TBlocksReceivedFromInitiator.group = {}

local function TBlocksReceivedFromInitiator_from_obj(obj)
    return setmetatable(obj, TBlocksReceivedFromInitiator)
end

function TBlocksReceivedFromInitiator.new(BlocksReceivedFromInitiator)
    return TBlocksReceivedFromInitiator_from_obj({BlocksReceivedFromInitiator = BlocksReceivedFromInitiator})
end
---@param obj SASSMART.BlocksReceivedFromInitiator
function TBlocksReceivedFromInitiator:init_from_obj(obj)
    self.BlocksReceivedFromInitiator = obj.BlocksReceivedFromInitiator
end

function TBlocksReceivedFromInitiator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlocksReceivedFromInitiator.group)
end

TBlocksReceivedFromInitiator.from_obj = TBlocksReceivedFromInitiator_from_obj

TBlocksReceivedFromInitiator.proto_property = {'BlocksReceivedFromInitiator'}

TBlocksReceivedFromInitiator.default = {0}

TBlocksReceivedFromInitiator.struct = {{name = 'BlocksReceivedFromInitiator', is_array = false, struct = nil}}

function TBlocksReceivedFromInitiator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BlocksReceivedFromInitiator', self.BlocksReceivedFromInitiator, 'uint32', true, errs,
        need_convert)

    TBlocksReceivedFromInitiator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlocksReceivedFromInitiator.proto_property, errs, need_convert)
    return self
end

function TBlocksReceivedFromInitiator:unpack(_)
    return self.BlocksReceivedFromInitiator
end

SASSMART.BlocksReceivedFromInitiator = TBlocksReceivedFromInitiator

---@class SASSMART.BlocksSentToInitiator
---@field BlocksSentToInitiator integer
local TBlocksSentToInitiator = {}
TBlocksSentToInitiator.__index = TBlocksSentToInitiator
TBlocksSentToInitiator.group = {}

local function TBlocksSentToInitiator_from_obj(obj)
    return setmetatable(obj, TBlocksSentToInitiator)
end

function TBlocksSentToInitiator.new(BlocksSentToInitiator)
    return TBlocksSentToInitiator_from_obj({BlocksSentToInitiator = BlocksSentToInitiator})
end
---@param obj SASSMART.BlocksSentToInitiator
function TBlocksSentToInitiator:init_from_obj(obj)
    self.BlocksSentToInitiator = obj.BlocksSentToInitiator
end

function TBlocksSentToInitiator:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBlocksSentToInitiator.group)
end

TBlocksSentToInitiator.from_obj = TBlocksSentToInitiator_from_obj

TBlocksSentToInitiator.proto_property = {'BlocksSentToInitiator'}

TBlocksSentToInitiator.default = {0}

TBlocksSentToInitiator.struct = {{name = 'BlocksSentToInitiator', is_array = false, struct = nil}}

function TBlocksSentToInitiator:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BlocksSentToInitiator', self.BlocksSentToInitiator, 'uint32', true, errs, need_convert)

    TBlocksSentToInitiator:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBlocksSentToInitiator.proto_property, errs, need_convert)
    return self
end

function TBlocksSentToInitiator:unpack(_)
    return self.BlocksSentToInitiator
end

SASSMART.BlocksSentToInitiator = TBlocksSentToInitiator

---@class SASSMART.ManufacturedInWeekOfYear
---@field ManufacturedInWeekOfYear string
local TManufacturedInWeekOfYear = {}
TManufacturedInWeekOfYear.__index = TManufacturedInWeekOfYear
TManufacturedInWeekOfYear.group = {}

local function TManufacturedInWeekOfYear_from_obj(obj)
    return setmetatable(obj, TManufacturedInWeekOfYear)
end

function TManufacturedInWeekOfYear.new(ManufacturedInWeekOfYear)
    return TManufacturedInWeekOfYear_from_obj({ManufacturedInWeekOfYear = ManufacturedInWeekOfYear})
end
---@param obj SASSMART.ManufacturedInWeekOfYear
function TManufacturedInWeekOfYear:init_from_obj(obj)
    self.ManufacturedInWeekOfYear = obj.ManufacturedInWeekOfYear
end

function TManufacturedInWeekOfYear:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturedInWeekOfYear.group)
end

TManufacturedInWeekOfYear.from_obj = TManufacturedInWeekOfYear_from_obj

TManufacturedInWeekOfYear.proto_property = {'ManufacturedInWeekOfYear'}

TManufacturedInWeekOfYear.default = {''}

TManufacturedInWeekOfYear.struct = {{name = 'ManufacturedInWeekOfYear', is_array = false, struct = nil}}

function TManufacturedInWeekOfYear:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturedInWeekOfYear', self.ManufacturedInWeekOfYear, 'string', true, errs,
        need_convert)

    TManufacturedInWeekOfYear:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturedInWeekOfYear.proto_property, errs, need_convert)
    return self
end

function TManufacturedInWeekOfYear:unpack(_)
    return self.ManufacturedInWeekOfYear
end

SASSMART.ManufacturedInWeekOfYear = TManufacturedInWeekOfYear

---@class SASSMART.ElementsInPrimaryDefectList
---@field ElementsInPrimaryDefectList integer
local TElementsInPrimaryDefectList = {}
TElementsInPrimaryDefectList.__index = TElementsInPrimaryDefectList
TElementsInPrimaryDefectList.group = {}

local function TElementsInPrimaryDefectList_from_obj(obj)
    return setmetatable(obj, TElementsInPrimaryDefectList)
end

function TElementsInPrimaryDefectList.new(ElementsInPrimaryDefectList)
    return TElementsInPrimaryDefectList_from_obj({
        ElementsInPrimaryDefectList = ElementsInPrimaryDefectList or 4294967295
    })
end
---@param obj SASSMART.ElementsInPrimaryDefectList
function TElementsInPrimaryDefectList:init_from_obj(obj)
    self.ElementsInPrimaryDefectList = obj.ElementsInPrimaryDefectList or 4294967295
end

function TElementsInPrimaryDefectList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TElementsInPrimaryDefectList.group)
end

TElementsInPrimaryDefectList.from_obj = TElementsInPrimaryDefectList_from_obj

TElementsInPrimaryDefectList.proto_property = {'ElementsInPrimaryDefectList'}

TElementsInPrimaryDefectList.default = {0}

TElementsInPrimaryDefectList.struct = {{name = 'ElementsInPrimaryDefectList', is_array = false, struct = nil}}

function TElementsInPrimaryDefectList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ElementsInPrimaryDefectList', self.ElementsInPrimaryDefectList, 'uint32', true, errs,
        need_convert)

    TElementsInPrimaryDefectList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TElementsInPrimaryDefectList.proto_property, errs, need_convert)
    return self
end

function TElementsInPrimaryDefectList:unpack(_)
    return self.ElementsInPrimaryDefectList
end

SASSMART.ElementsInPrimaryDefectList = TElementsInPrimaryDefectList

---@class SASSMART.ElementsInGrownDefectList
---@field ElementsInGrownDefectList integer
local TElementsInGrownDefectList = {}
TElementsInGrownDefectList.__index = TElementsInGrownDefectList
TElementsInGrownDefectList.group = {}

local function TElementsInGrownDefectList_from_obj(obj)
    return setmetatable(obj, TElementsInGrownDefectList)
end

function TElementsInGrownDefectList.new(ElementsInGrownDefectList)
    return TElementsInGrownDefectList_from_obj({ElementsInGrownDefectList = ElementsInGrownDefectList})
end
---@param obj SASSMART.ElementsInGrownDefectList
function TElementsInGrownDefectList:init_from_obj(obj)
    self.ElementsInGrownDefectList = obj.ElementsInGrownDefectList
end

function TElementsInGrownDefectList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TElementsInGrownDefectList.group)
end

TElementsInGrownDefectList.from_obj = TElementsInGrownDefectList_from_obj

TElementsInGrownDefectList.proto_property = {'ElementsInGrownDefectList'}

TElementsInGrownDefectList.default = {0}

TElementsInGrownDefectList.struct = {{name = 'ElementsInGrownDefectList', is_array = false, struct = nil}}

function TElementsInGrownDefectList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ElementsInGrownDefectList', self.ElementsInGrownDefectList, 'uint32', true, errs,
        need_convert)

    TElementsInGrownDefectList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TElementsInGrownDefectList.proto_property, errs, need_convert)
    return self
end

function TElementsInGrownDefectList:unpack(_)
    return self.ElementsInGrownDefectList
end

SASSMART.ElementsInGrownDefectList = TElementsInGrownDefectList

---@class SASSMART.StripTemperatureCelsius
---@field StripTemperatureCelsius integer
local TStripTemperatureCelsius = {}
TStripTemperatureCelsius.__index = TStripTemperatureCelsius
TStripTemperatureCelsius.group = {}

local function TStripTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TStripTemperatureCelsius)
end

function TStripTemperatureCelsius.new(StripTemperatureCelsius)
    return TStripTemperatureCelsius_from_obj({StripTemperatureCelsius = StripTemperatureCelsius})
end
---@param obj SASSMART.StripTemperatureCelsius
function TStripTemperatureCelsius:init_from_obj(obj)
    self.StripTemperatureCelsius = obj.StripTemperatureCelsius
end

function TStripTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStripTemperatureCelsius.group)
end

TStripTemperatureCelsius.from_obj = TStripTemperatureCelsius_from_obj

TStripTemperatureCelsius.proto_property = {'StripTemperatureCelsius'}

TStripTemperatureCelsius.default = {0}

TStripTemperatureCelsius.struct = {{name = 'StripTemperatureCelsius', is_array = false, struct = nil}}

function TStripTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StripTemperatureCelsius', self.StripTemperatureCelsius, 'uint32', true, errs,
        need_convert)

    TStripTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStripTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TStripTemperatureCelsius:unpack(_)
    return self.StripTemperatureCelsius
end

SASSMART.StripTemperatureCelsius = TStripTemperatureCelsius

SASSMART.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive.SAS.SMART', {
    StripTemperatureCelsius = {'u', nil, true, nil, false},
    ElementsInGrownDefectList = {'u', nil, true, nil, false},
    ElementsInPrimaryDefectList = {'u', nil, true, 4294967295, false},
    ManufacturedInWeekOfYear = {'s', nil, true, nil, false},
    BlocksSentToInitiator = {'u', nil, true, nil, false},
    BlocksReceivedFromInitiator = {'u', nil, true, nil, false},
    UntilNextInterSMARTTestMinutes = {'u', {}, true, nil, false},
    LastPrefailEventSeqNum = {'u', {}, true, nil, false}
}, {}, {})

return SASSMART
