-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeRoutingEntry = {}

---@class PCIeRoutingEntry.PhysAddress
---@field PhysAddress integer[]
local TPhysAddress = {}
TPhysAddress.__index = TPhysAddress
TPhysAddress.group = {}

local function TPhysAddress_from_obj(obj)
    return setmetatable(obj, TPhysAddress)
end

function TPhysAddress.new(PhysAddress)
    return TPhysAddress_from_obj({PhysAddress = PhysAddress})
end
---@param obj PCIeRoutingEntry.PhysAddress
function TPhysAddress:init_from_obj(obj)
    self.PhysAddress = obj.PhysAddress
end

function TPhysAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysAddress.group)
end

TPhysAddress.from_obj = TPhysAddress_from_obj

TPhysAddress.proto_property = {'PhysAddress'}

TPhysAddress.default = {{}}

TPhysAddress.struct = {{name = 'PhysAddress', is_array = true, struct = nil}}

function TPhysAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PhysAddress', self.PhysAddress, 'uint8', true, errs, need_convert)

    TPhysAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysAddress.proto_property, errs, need_convert)
    return self
end

function TPhysAddress:unpack(_)
    return self.PhysAddress
end

PCIeRoutingEntry.PhysAddress = TPhysAddress

---@class PCIeRoutingEntry.MediaTypeId
---@field MediaTypeId integer
local TMediaTypeId = {}
TMediaTypeId.__index = TMediaTypeId
TMediaTypeId.group = {}

local function TMediaTypeId_from_obj(obj)
    return setmetatable(obj, TMediaTypeId)
end

function TMediaTypeId.new(MediaTypeId)
    return TMediaTypeId_from_obj({MediaTypeId = MediaTypeId})
end
---@param obj PCIeRoutingEntry.MediaTypeId
function TMediaTypeId:init_from_obj(obj)
    self.MediaTypeId = obj.MediaTypeId
end

function TMediaTypeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediaTypeId.group)
end

TMediaTypeId.from_obj = TMediaTypeId_from_obj

TMediaTypeId.proto_property = {'MediaTypeId'}

TMediaTypeId.default = {0}

TMediaTypeId.struct = {{name = 'MediaTypeId', is_array = false, struct = nil}}

function TMediaTypeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediaTypeId', self.MediaTypeId, 'uint8', true, errs, need_convert)

    TMediaTypeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediaTypeId.proto_property, errs, need_convert)
    return self
end

function TMediaTypeId:unpack(_)
    return self.MediaTypeId
end

PCIeRoutingEntry.MediaTypeId = TMediaTypeId

---@class PCIeRoutingEntry.PhysTransportBindingId
---@field PhysTransportBindingId integer
local TPhysTransportBindingId = {}
TPhysTransportBindingId.__index = TPhysTransportBindingId
TPhysTransportBindingId.group = {}

local function TPhysTransportBindingId_from_obj(obj)
    return setmetatable(obj, TPhysTransportBindingId)
end

function TPhysTransportBindingId.new(PhysTransportBindingId)
    return TPhysTransportBindingId_from_obj({PhysTransportBindingId = PhysTransportBindingId})
end
---@param obj PCIeRoutingEntry.PhysTransportBindingId
function TPhysTransportBindingId:init_from_obj(obj)
    self.PhysTransportBindingId = obj.PhysTransportBindingId
end

function TPhysTransportBindingId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysTransportBindingId.group)
end

TPhysTransportBindingId.from_obj = TPhysTransportBindingId_from_obj

TPhysTransportBindingId.proto_property = {'PhysTransportBindingId'}

TPhysTransportBindingId.default = {0}

TPhysTransportBindingId.struct = {{name = 'PhysTransportBindingId', is_array = false, struct = nil}}

function TPhysTransportBindingId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysTransportBindingId', self.PhysTransportBindingId, 'uint8', true, errs, need_convert)

    TPhysTransportBindingId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysTransportBindingId.proto_property, errs, need_convert)
    return self
end

function TPhysTransportBindingId:unpack(_)
    return self.PhysTransportBindingId
end

PCIeRoutingEntry.PhysTransportBindingId = TPhysTransportBindingId

---@class PCIeRoutingEntry.EntryType
---@field EntryType integer
local TEntryType = {}
TEntryType.__index = TEntryType
TEntryType.group = {}

local function TEntryType_from_obj(obj)
    return setmetatable(obj, TEntryType)
end

function TEntryType.new(EntryType)
    return TEntryType_from_obj({EntryType = EntryType})
end
---@param obj PCIeRoutingEntry.EntryType
function TEntryType:init_from_obj(obj)
    self.EntryType = obj.EntryType
end

function TEntryType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntryType.group)
end

TEntryType.from_obj = TEntryType_from_obj

TEntryType.proto_property = {'EntryType'}

TEntryType.default = {0}

TEntryType.struct = {{name = 'EntryType', is_array = false, struct = nil}}

function TEntryType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntryType', self.EntryType, 'uint8', true, errs, need_convert)

    TEntryType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntryType.proto_property, errs, need_convert)
    return self
end

function TEntryType:unpack(_)
    return self.EntryType
end

PCIeRoutingEntry.EntryType = TEntryType

---@class PCIeRoutingEntry.StartingEid
---@field StartingEid integer
local TStartingEid = {}
TStartingEid.__index = TStartingEid
TStartingEid.group = {}

local function TStartingEid_from_obj(obj)
    return setmetatable(obj, TStartingEid)
end

function TStartingEid.new(StartingEid)
    return TStartingEid_from_obj({StartingEid = StartingEid})
end
---@param obj PCIeRoutingEntry.StartingEid
function TStartingEid:init_from_obj(obj)
    self.StartingEid = obj.StartingEid
end

function TStartingEid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartingEid.group)
end

TStartingEid.from_obj = TStartingEid_from_obj

TStartingEid.proto_property = {'StartingEid'}

TStartingEid.default = {0}

TStartingEid.struct = {{name = 'StartingEid', is_array = false, struct = nil}}

function TStartingEid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartingEid', self.StartingEid, 'uint8', true, errs, need_convert)

    TStartingEid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartingEid.proto_property, errs, need_convert)
    return self
end

function TStartingEid:unpack(_)
    return self.StartingEid
end

PCIeRoutingEntry.StartingEid = TStartingEid

---@class PCIeRoutingEntry.EidRangeSize
---@field EidRangeSize integer
local TEidRangeSize = {}
TEidRangeSize.__index = TEidRangeSize
TEidRangeSize.group = {}

local function TEidRangeSize_from_obj(obj)
    return setmetatable(obj, TEidRangeSize)
end

function TEidRangeSize.new(EidRangeSize)
    return TEidRangeSize_from_obj({EidRangeSize = EidRangeSize})
end
---@param obj PCIeRoutingEntry.EidRangeSize
function TEidRangeSize:init_from_obj(obj)
    self.EidRangeSize = obj.EidRangeSize
end

function TEidRangeSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEidRangeSize.group)
end

TEidRangeSize.from_obj = TEidRangeSize_from_obj

TEidRangeSize.proto_property = {'EidRangeSize'}

TEidRangeSize.default = {0}

TEidRangeSize.struct = {{name = 'EidRangeSize', is_array = false, struct = nil}}

function TEidRangeSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EidRangeSize', self.EidRangeSize, 'uint8', true, errs, need_convert)

    TEidRangeSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEidRangeSize.proto_property, errs, need_convert)
    return self
end

function TEidRangeSize:unpack(_)
    return self.EidRangeSize
end

PCIeRoutingEntry.EidRangeSize = TEidRangeSize

PCIeRoutingEntry.interface = mdb.register_interface('bmc.kepler.Systems.Mctp.PCIeRoutingEntry', {
    EidRangeSize = {'y', nil, true, nil, false},
    StartingEid = {'y', nil, true, nil, false},
    EntryType = {'y', nil, true, nil, false},
    PhysTransportBindingId = {'y', nil, true, nil, false},
    MediaTypeId = {'y', nil, true, nil, false},
    PhysAddress = {'ay', nil, true, nil, false}
}, {}, {})

return PCIeRoutingEntry
