-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiskArray = {}

---@class DiskArray.RefControllerId
---@field RefControllerId integer
local TRefControllerId = {}
TRefControllerId.__index = TRefControllerId
TRefControllerId.group = {}

local function TRefControllerId_from_obj(obj)
    return setmetatable(obj, TRefControllerId)
end

function TRefControllerId.new(RefControllerId)
    return TRefControllerId_from_obj({RefControllerId = RefControllerId})
end
---@param obj DiskArray.RefControllerId
function TRefControllerId:init_from_obj(obj)
    self.RefControllerId = obj.RefControllerId
end

function TRefControllerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefControllerId.group)
end

TRefControllerId.from_obj = TRefControllerId_from_obj

TRefControllerId.proto_property = {'RefControllerId'}

TRefControllerId.default = {0}

TRefControllerId.struct = {{name = 'RefControllerId', is_array = false, struct = nil}}

function TRefControllerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'RefControllerId', self.RefControllerId, 'uint8', true, errs, need_convert)

    TRefControllerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefControllerId.proto_property, errs, need_convert)
    return self
end

function TRefControllerId:unpack(_)
    return self.RefControllerId
end

DiskArray.RefControllerId = TRefControllerId

---@class DiskArray.AverageDriveFreeSpaceMiB
---@field AverageDriveFreeSpaceMiB integer
local TAverageDriveFreeSpaceMiB = {}
TAverageDriveFreeSpaceMiB.__index = TAverageDriveFreeSpaceMiB
TAverageDriveFreeSpaceMiB.group = {}

local function TAverageDriveFreeSpaceMiB_from_obj(obj)
    return setmetatable(obj, TAverageDriveFreeSpaceMiB)
end

function TAverageDriveFreeSpaceMiB.new(AverageDriveFreeSpaceMiB)
    return TAverageDriveFreeSpaceMiB_from_obj({AverageDriveFreeSpaceMiB = AverageDriveFreeSpaceMiB})
end
---@param obj DiskArray.AverageDriveFreeSpaceMiB
function TAverageDriveFreeSpaceMiB:init_from_obj(obj)
    self.AverageDriveFreeSpaceMiB = obj.AverageDriveFreeSpaceMiB
end

function TAverageDriveFreeSpaceMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAverageDriveFreeSpaceMiB.group)
end

TAverageDriveFreeSpaceMiB.from_obj = TAverageDriveFreeSpaceMiB_from_obj

TAverageDriveFreeSpaceMiB.proto_property = {'AverageDriveFreeSpaceMiB'}

TAverageDriveFreeSpaceMiB.default = {0}

TAverageDriveFreeSpaceMiB.struct = {{name = 'AverageDriveFreeSpaceMiB', is_array = false, struct = nil}}

function TAverageDriveFreeSpaceMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AverageDriveFreeSpaceMiB', self.AverageDriveFreeSpaceMiB, 'uint32', true, errs,
        need_convert)

    TAverageDriveFreeSpaceMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAverageDriveFreeSpaceMiB.proto_property, errs, need_convert)
    return self
end

function TAverageDriveFreeSpaceMiB:unpack(_)
    return self.AverageDriveFreeSpaceMiB
end

DiskArray.AverageDriveFreeSpaceMiB = TAverageDriveFreeSpaceMiB

---@class DiskArray.RAIDType
---@field RAIDType string
local TRAIDType = {}
TRAIDType.__index = TRAIDType
TRAIDType.group = {}

local function TRAIDType_from_obj(obj)
    return setmetatable(obj, TRAIDType)
end

function TRAIDType.new(RAIDType)
    return TRAIDType_from_obj({RAIDType = RAIDType})
end
---@param obj DiskArray.RAIDType
function TRAIDType:init_from_obj(obj)
    self.RAIDType = obj.RAIDType
end

function TRAIDType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRAIDType.group)
end

TRAIDType.from_obj = TRAIDType_from_obj

TRAIDType.proto_property = {'RAIDType'}

TRAIDType.default = {''}

TRAIDType.struct = {{name = 'RAIDType', is_array = false, struct = nil}}

function TRAIDType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RAIDType', self.RAIDType, 'string', true, errs, need_convert)

    TRAIDType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRAIDType.proto_property, errs, need_convert)
    return self
end

function TRAIDType:unpack(_)
    return self.RAIDType
end

DiskArray.RAIDType = TRAIDType

---@class DiskArray.DriveNumPerSpan
---@field DriveNumPerSpan integer
local TDriveNumPerSpan = {}
TDriveNumPerSpan.__index = TDriveNumPerSpan
TDriveNumPerSpan.group = {}

local function TDriveNumPerSpan_from_obj(obj)
    return setmetatable(obj, TDriveNumPerSpan)
end

function TDriveNumPerSpan.new(DriveNumPerSpan)
    return TDriveNumPerSpan_from_obj({DriveNumPerSpan = DriveNumPerSpan})
end
---@param obj DiskArray.DriveNumPerSpan
function TDriveNumPerSpan:init_from_obj(obj)
    self.DriveNumPerSpan = obj.DriveNumPerSpan
end

function TDriveNumPerSpan:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriveNumPerSpan.group)
end

TDriveNumPerSpan.from_obj = TDriveNumPerSpan_from_obj

TDriveNumPerSpan.proto_property = {'DriveNumPerSpan'}

TDriveNumPerSpan.default = {0}

TDriveNumPerSpan.struct = {{name = 'DriveNumPerSpan', is_array = false, struct = nil}}

function TDriveNumPerSpan:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriveNumPerSpan', self.DriveNumPerSpan, 'uint8', true, errs, need_convert)

    TDriveNumPerSpan:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriveNumPerSpan.proto_property, errs, need_convert)
    return self
end

function TDriveNumPerSpan:unpack(_)
    return self.DriveNumPerSpan
end

DiskArray.DriveNumPerSpan = TDriveNumPerSpan

---@class DiskArray.RefDrives
---@field RefDrives string[]
local TRefDrives = {}
TRefDrives.__index = TRefDrives
TRefDrives.group = {}

local function TRefDrives_from_obj(obj)
    return setmetatable(obj, TRefDrives)
end

function TRefDrives.new(RefDrives)
    return TRefDrives_from_obj({RefDrives = RefDrives})
end
---@param obj DiskArray.RefDrives
function TRefDrives:init_from_obj(obj)
    self.RefDrives = obj.RefDrives
end

function TRefDrives:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefDrives.group)
end

TRefDrives.from_obj = TRefDrives_from_obj

TRefDrives.proto_property = {'RefDrives'}

TRefDrives.default = {{}}

TRefDrives.struct = {{name = 'RefDrives', is_array = true, struct = nil}}

function TRefDrives:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefDrives', self.RefDrives, 'string', true, errs, need_convert)

    TRefDrives:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefDrives.proto_property, errs, need_convert)
    return self
end

function TRefDrives:unpack(_)
    return self.RefDrives
end

DiskArray.RefDrives = TRefDrives

---@class DiskArray.RefVolumes
---@field RefVolumes integer[]
local TRefVolumes = {}
TRefVolumes.__index = TRefVolumes
TRefVolumes.group = {}

local function TRefVolumes_from_obj(obj)
    return setmetatable(obj, TRefVolumes)
end

function TRefVolumes.new(RefVolumes)
    return TRefVolumes_from_obj({RefVolumes = RefVolumes})
end
---@param obj DiskArray.RefVolumes
function TRefVolumes:init_from_obj(obj)
    self.RefVolumes = obj.RefVolumes
end

function TRefVolumes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefVolumes.group)
end

TRefVolumes.from_obj = TRefVolumes_from_obj

TRefVolumes.proto_property = {'RefVolumes'}

TRefVolumes.default = {{}}

TRefVolumes.struct = {{name = 'RefVolumes', is_array = true, struct = nil}}

function TRefVolumes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefVolumes', self.RefVolumes, 'uint16', true, errs, need_convert)

    TRefVolumes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefVolumes.proto_property, errs, need_convert)
    return self
end

function TRefVolumes:unpack(_)
    return self.RefVolumes
end

DiskArray.RefVolumes = TRefVolumes

---@class DiskArray.FreeBlocksSpaceMiB
---@field FreeBlocksSpaceMiB integer[]
local TFreeBlocksSpaceMiB = {}
TFreeBlocksSpaceMiB.__index = TFreeBlocksSpaceMiB
TFreeBlocksSpaceMiB.group = {}

local function TFreeBlocksSpaceMiB_from_obj(obj)
    return setmetatable(obj, TFreeBlocksSpaceMiB)
end

function TFreeBlocksSpaceMiB.new(FreeBlocksSpaceMiB)
    return TFreeBlocksSpaceMiB_from_obj({FreeBlocksSpaceMiB = FreeBlocksSpaceMiB})
end
---@param obj DiskArray.FreeBlocksSpaceMiB
function TFreeBlocksSpaceMiB:init_from_obj(obj)
    self.FreeBlocksSpaceMiB = obj.FreeBlocksSpaceMiB
end

function TFreeBlocksSpaceMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFreeBlocksSpaceMiB.group)
end

TFreeBlocksSpaceMiB.from_obj = TFreeBlocksSpaceMiB_from_obj

TFreeBlocksSpaceMiB.proto_property = {'FreeBlocksSpaceMiB'}

TFreeBlocksSpaceMiB.default = {{}}

TFreeBlocksSpaceMiB.struct = {{name = 'FreeBlocksSpaceMiB', is_array = true, struct = nil}}

function TFreeBlocksSpaceMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FreeBlocksSpaceMiB', self.FreeBlocksSpaceMiB, 'uint32', true, errs, need_convert)

    TFreeBlocksSpaceMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFreeBlocksSpaceMiB.proto_property, errs, need_convert)
    return self
end

function TFreeBlocksSpaceMiB:unpack(_)
    return self.FreeBlocksSpaceMiB
end

DiskArray.FreeBlocksSpaceMiB = TFreeBlocksSpaceMiB

---@class DiskArray.TotalFreeSpaceMiB
---@field TotalFreeSpaceMiB integer
local TTotalFreeSpaceMiB = {}
TTotalFreeSpaceMiB.__index = TTotalFreeSpaceMiB
TTotalFreeSpaceMiB.group = {}

local function TTotalFreeSpaceMiB_from_obj(obj)
    return setmetatable(obj, TTotalFreeSpaceMiB)
end

function TTotalFreeSpaceMiB.new(TotalFreeSpaceMiB)
    return TTotalFreeSpaceMiB_from_obj({TotalFreeSpaceMiB = TotalFreeSpaceMiB})
end
---@param obj DiskArray.TotalFreeSpaceMiB
function TTotalFreeSpaceMiB:init_from_obj(obj)
    self.TotalFreeSpaceMiB = obj.TotalFreeSpaceMiB
end

function TTotalFreeSpaceMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalFreeSpaceMiB.group)
end

TTotalFreeSpaceMiB.from_obj = TTotalFreeSpaceMiB_from_obj

TTotalFreeSpaceMiB.proto_property = {'TotalFreeSpaceMiB'}

TTotalFreeSpaceMiB.default = {0}

TTotalFreeSpaceMiB.struct = {{name = 'TotalFreeSpaceMiB', is_array = false, struct = nil}}

function TTotalFreeSpaceMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalFreeSpaceMiB', self.TotalFreeSpaceMiB, 'uint32', true, errs, need_convert)

    TTotalFreeSpaceMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalFreeSpaceMiB.proto_property, errs, need_convert)
    return self
end

function TTotalFreeSpaceMiB:unpack(_)
    return self.TotalFreeSpaceMiB
end

DiskArray.TotalFreeSpaceMiB = TTotalFreeSpaceMiB

---@class DiskArray.UsedSpaceMiB
---@field UsedSpaceMiB integer
local TUsedSpaceMiB = {}
TUsedSpaceMiB.__index = TUsedSpaceMiB
TUsedSpaceMiB.group = {}

local function TUsedSpaceMiB_from_obj(obj)
    return setmetatable(obj, TUsedSpaceMiB)
end

function TUsedSpaceMiB.new(UsedSpaceMiB)
    return TUsedSpaceMiB_from_obj({UsedSpaceMiB = UsedSpaceMiB})
end
---@param obj DiskArray.UsedSpaceMiB
function TUsedSpaceMiB:init_from_obj(obj)
    self.UsedSpaceMiB = obj.UsedSpaceMiB
end

function TUsedSpaceMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUsedSpaceMiB.group)
end

TUsedSpaceMiB.from_obj = TUsedSpaceMiB_from_obj

TUsedSpaceMiB.proto_property = {'UsedSpaceMiB'}

TUsedSpaceMiB.default = {0}

TUsedSpaceMiB.struct = {{name = 'UsedSpaceMiB', is_array = false, struct = nil}}

function TUsedSpaceMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UsedSpaceMiB', self.UsedSpaceMiB, 'uint32', true, errs, need_convert)

    TUsedSpaceMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUsedSpaceMiB.proto_property, errs, need_convert)
    return self
end

function TUsedSpaceMiB:unpack(_)
    return self.UsedSpaceMiB
end

DiskArray.UsedSpaceMiB = TUsedSpaceMiB

---@class DiskArray.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj DiskArray.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint16', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

DiskArray.Id = TId

DiskArray.interface = mdb.register_interface('bmc.kepler.Systems.Storage.DiskArray', {
    Id = {'q', nil, true, nil, false},
    UsedSpaceMiB = {'u', nil, true, nil, false},
    TotalFreeSpaceMiB = {'u', nil, true, nil, false},
    FreeBlocksSpaceMiB = {'au', nil, true, nil, false},
    RefVolumes = {'aq', nil, true, nil, false},
    RefDrives = {'as', nil, true, nil, false},
    DriveNumPerSpan = {'y', nil, true, nil, false},
    RAIDType = {'s', nil, true, nil, false},
    AverageDriveFreeSpaceMiB = {'u', nil, true, nil, false},
    RefControllerId = {'y', {}, true, nil, false}
}, {}, {})

return DiskArray
