-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Diagnose = {}

---@class Diagnose.PhyErrorSelUnlimitFlag
---@field PhyErrorSelUnlimitFlag boolean
local TPhyErrorSelUnlimitFlag = {}
TPhyErrorSelUnlimitFlag.__index = TPhyErrorSelUnlimitFlag
TPhyErrorSelUnlimitFlag.group = {}

local function TPhyErrorSelUnlimitFlag_from_obj(obj)
    return setmetatable(obj, TPhyErrorSelUnlimitFlag)
end

function TPhyErrorSelUnlimitFlag.new(PhyErrorSelUnlimitFlag)
    return TPhyErrorSelUnlimitFlag_from_obj({PhyErrorSelUnlimitFlag = PhyErrorSelUnlimitFlag})
end
---@param obj Diagnose.PhyErrorSelUnlimitFlag
function TPhyErrorSelUnlimitFlag:init_from_obj(obj)
    self.PhyErrorSelUnlimitFlag = obj.PhyErrorSelUnlimitFlag
end

function TPhyErrorSelUnlimitFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyErrorSelUnlimitFlag.group)
end

TPhyErrorSelUnlimitFlag.from_obj = TPhyErrorSelUnlimitFlag_from_obj

TPhyErrorSelUnlimitFlag.proto_property = {'PhyErrorSelUnlimitFlag'}

TPhyErrorSelUnlimitFlag.default = {false}

TPhyErrorSelUnlimitFlag.struct = {{name = 'PhyErrorSelUnlimitFlag', is_array = false, struct = nil}}

function TPhyErrorSelUnlimitFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyErrorSelUnlimitFlag', self.PhyErrorSelUnlimitFlag, 'bool', false, errs, need_convert)

    TPhyErrorSelUnlimitFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyErrorSelUnlimitFlag.proto_property, errs, need_convert)
    return self
end

function TPhyErrorSelUnlimitFlag:unpack(_)
    return self.PhyErrorSelUnlimitFlag
end

Diagnose.PhyErrorSelUnlimitFlag = TPhyErrorSelUnlimitFlag

---@class Diagnose.MaxPhyErrorLogFileRotationCount
---@field MaxPhyErrorLogFileRotationCount integer
local TMaxPhyErrorLogFileRotationCount = {}
TMaxPhyErrorLogFileRotationCount.__index = TMaxPhyErrorLogFileRotationCount
TMaxPhyErrorLogFileRotationCount.group = {}

local function TMaxPhyErrorLogFileRotationCount_from_obj(obj)
    return setmetatable(obj, TMaxPhyErrorLogFileRotationCount)
end

function TMaxPhyErrorLogFileRotationCount.new(MaxPhyErrorLogFileRotationCount)
    return TMaxPhyErrorLogFileRotationCount_from_obj({
        MaxPhyErrorLogFileRotationCount = MaxPhyErrorLogFileRotationCount or 10
    })
end
---@param obj Diagnose.MaxPhyErrorLogFileRotationCount
function TMaxPhyErrorLogFileRotationCount:init_from_obj(obj)
    self.MaxPhyErrorLogFileRotationCount = obj.MaxPhyErrorLogFileRotationCount or 10
end

function TMaxPhyErrorLogFileRotationCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxPhyErrorLogFileRotationCount.group)
end

TMaxPhyErrorLogFileRotationCount.from_obj = TMaxPhyErrorLogFileRotationCount_from_obj

TMaxPhyErrorLogFileRotationCount.proto_property = {'MaxPhyErrorLogFileRotationCount'}

TMaxPhyErrorLogFileRotationCount.default = {0}

TMaxPhyErrorLogFileRotationCount.struct = {{name = 'MaxPhyErrorLogFileRotationCount', is_array = false, struct = nil}}

function TMaxPhyErrorLogFileRotationCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxPhyErrorLogFileRotationCount', self.MaxPhyErrorLogFileRotationCount, 'uint8', false,
        errs, need_convert)

    TMaxPhyErrorLogFileRotationCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxPhyErrorLogFileRotationCount.proto_property, errs, need_convert)
    return self
end

function TMaxPhyErrorLogFileRotationCount:unpack(_)
    return self.MaxPhyErrorLogFileRotationCount
end

Diagnose.MaxPhyErrorLogFileRotationCount = TMaxPhyErrorLogFileRotationCount

---@class Diagnose.PhyErrorThreshold
---@field PhyErrorThreshold integer
local TPhyErrorThreshold = {}
TPhyErrorThreshold.__index = TPhyErrorThreshold
TPhyErrorThreshold.group = {}

local function TPhyErrorThreshold_from_obj(obj)
    return setmetatable(obj, TPhyErrorThreshold)
end

function TPhyErrorThreshold.new(PhyErrorThreshold)
    return TPhyErrorThreshold_from_obj({PhyErrorThreshold = PhyErrorThreshold or 100})
end
---@param obj Diagnose.PhyErrorThreshold
function TPhyErrorThreshold:init_from_obj(obj)
    self.PhyErrorThreshold = obj.PhyErrorThreshold or 100
end

function TPhyErrorThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyErrorThreshold.group)
end

TPhyErrorThreshold.from_obj = TPhyErrorThreshold_from_obj

TPhyErrorThreshold.proto_property = {'PhyErrorThreshold'}

TPhyErrorThreshold.default = {0}

TPhyErrorThreshold.struct = {{name = 'PhyErrorThreshold', is_array = false, struct = nil}}

function TPhyErrorThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyErrorThreshold', self.PhyErrorThreshold, 'uint32', false, errs, need_convert)

    TPhyErrorThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyErrorThreshold.proto_property, errs, need_convert)
    return self
end

function TPhyErrorThreshold:unpack(_)
    return self.PhyErrorThreshold
end

Diagnose.PhyErrorThreshold = TPhyErrorThreshold

---@class Diagnose.PhyErrorMaxRecord
---@field PhyErrorMaxRecord integer
local TPhyErrorMaxRecord = {}
TPhyErrorMaxRecord.__index = TPhyErrorMaxRecord
TPhyErrorMaxRecord.group = {}

local function TPhyErrorMaxRecord_from_obj(obj)
    return setmetatable(obj, TPhyErrorMaxRecord)
end

function TPhyErrorMaxRecord.new(PhyErrorMaxRecord)
    return TPhyErrorMaxRecord_from_obj({PhyErrorMaxRecord = PhyErrorMaxRecord or 20})
end
---@param obj Diagnose.PhyErrorMaxRecord
function TPhyErrorMaxRecord:init_from_obj(obj)
    self.PhyErrorMaxRecord = obj.PhyErrorMaxRecord or 20
end

function TPhyErrorMaxRecord:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyErrorMaxRecord.group)
end

TPhyErrorMaxRecord.from_obj = TPhyErrorMaxRecord_from_obj

TPhyErrorMaxRecord.proto_property = {'PhyErrorMaxRecord'}

TPhyErrorMaxRecord.default = {0}

TPhyErrorMaxRecord.struct = {{name = 'PhyErrorMaxRecord', is_array = false, struct = nil}}

function TPhyErrorMaxRecord:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyErrorMaxRecord', self.PhyErrorMaxRecord, 'uint8', false, errs, need_convert)

    TPhyErrorMaxRecord:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyErrorMaxRecord.proto_property, errs, need_convert)
    return self
end

function TPhyErrorMaxRecord:unpack(_)
    return self.PhyErrorMaxRecord
end

Diagnose.PhyErrorMaxRecord = TPhyErrorMaxRecord

---@class Diagnose.PhyErrorInterval
---@field PhyErrorInterval integer
local TPhyErrorInterval = {}
TPhyErrorInterval.__index = TPhyErrorInterval
TPhyErrorInterval.group = {}

local function TPhyErrorInterval_from_obj(obj)
    return setmetatable(obj, TPhyErrorInterval)
end

function TPhyErrorInterval.new(PhyErrorInterval)
    return TPhyErrorInterval_from_obj({PhyErrorInterval = PhyErrorInterval or 1800})
end
---@param obj Diagnose.PhyErrorInterval
function TPhyErrorInterval:init_from_obj(obj)
    self.PhyErrorInterval = obj.PhyErrorInterval or 1800
end

function TPhyErrorInterval:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyErrorInterval.group)
end

TPhyErrorInterval.from_obj = TPhyErrorInterval_from_obj

TPhyErrorInterval.proto_property = {'PhyErrorInterval'}

TPhyErrorInterval.default = {0}

TPhyErrorInterval.struct = {{name = 'PhyErrorInterval', is_array = false, struct = nil}}

function TPhyErrorInterval:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyErrorInterval', self.PhyErrorInterval, 'uint32', false, errs, need_convert)

    TPhyErrorInterval:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyErrorInterval.proto_property, errs, need_convert)
    return self
end

function TPhyErrorInterval:unpack(_)
    return self.PhyErrorInterval
end

Diagnose.PhyErrorInterval = TPhyErrorInterval

---@class Diagnose.PhyErrorEnabled
---@field PhyErrorEnabled boolean
local TPhyErrorEnabled = {}
TPhyErrorEnabled.__index = TPhyErrorEnabled
TPhyErrorEnabled.group = {}

local function TPhyErrorEnabled_from_obj(obj)
    return setmetatable(obj, TPhyErrorEnabled)
end

function TPhyErrorEnabled.new(PhyErrorEnabled)
    return TPhyErrorEnabled_from_obj({PhyErrorEnabled = PhyErrorEnabled == nil and true or PhyErrorEnabled})
end
---@param obj Diagnose.PhyErrorEnabled
function TPhyErrorEnabled:init_from_obj(obj)
    self.PhyErrorEnabled = obj.PhyErrorEnabled == nil and true or obj.PhyErrorEnabled
end

function TPhyErrorEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyErrorEnabled.group)
end

TPhyErrorEnabled.from_obj = TPhyErrorEnabled_from_obj

TPhyErrorEnabled.proto_property = {'PhyErrorEnabled'}

TPhyErrorEnabled.default = {false}

TPhyErrorEnabled.struct = {{name = 'PhyErrorEnabled', is_array = false, struct = nil}}

function TPhyErrorEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PhyErrorEnabled', self.PhyErrorEnabled, 'bool', false, errs, need_convert)

    TPhyErrorEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyErrorEnabled.proto_property, errs, need_convert)
    return self
end

function TPhyErrorEnabled:unpack(_)
    return self.PhyErrorEnabled
end

Diagnose.PhyErrorEnabled = TPhyErrorEnabled

Diagnose.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Diagnose', {
    PhyErrorEnabled = {'b', {}, false, true, false},
    PhyErrorInterval = {'u', {}, false, 1800, false},
    PhyErrorMaxRecord = {'y', {}, false, 20, false},
    PhyErrorThreshold = {'u', {}, false, 100, false},
    MaxPhyErrorLogFileRotationCount = {'y', {}, false, 10, false},
    PhyErrorSelUnlimitFlag = {'b', {}, false, nil, false}
}, {}, {})

return Diagnose
