--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPhysicalDriveLocation = {}

---@class StorageIpmiCmds.GetPhysicalDriveLocationReq
---@field ManufacturerId integer
---@field Reserve integer
---@field PhysicalDriveID integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetPhysicalDriveLocationReq = {}
TGetPhysicalDriveLocationReq.__index = TGetPhysicalDriveLocationReq
TGetPhysicalDriveLocationReq.group = {}

local function TGetPhysicalDriveLocationReq_from_obj(obj)
    return setmetatable(obj, TGetPhysicalDriveLocationReq)
end

function TGetPhysicalDriveLocationReq.new(ManufacturerId, Reserve, PhysicalDriveID, ReadingOffset, ReadingLength)
    return TGetPhysicalDriveLocationReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        PhysicalDriveID = PhysicalDriveID,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetPhysicalDriveLocationReq
function TGetPhysicalDriveLocationReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.PhysicalDriveID = obj.PhysicalDriveID
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetPhysicalDriveLocationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPhysicalDriveLocationReq.group)
end

TGetPhysicalDriveLocationReq.from_obj = TGetPhysicalDriveLocationReq_from_obj

TGetPhysicalDriveLocationReq.proto_property = {
    'ManufacturerId', 'Reserve', 'PhysicalDriveID', 'ReadingOffset', 'ReadingLength'
}

TGetPhysicalDriveLocationReq.default = {0, 0, 0, 0, 0}

TGetPhysicalDriveLocationReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'PhysicalDriveID', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetPhysicalDriveLocationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PhysicalDriveID', self.PhysicalDriveID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetPhysicalDriveLocationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPhysicalDriveLocationReq.proto_property, errs, need_convert)
    return self
end

function TGetPhysicalDriveLocationReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.PhysicalDriveID, self.ReadingOffset, self.ReadingLength
end

GetPhysicalDriveLocation.GetPhysicalDriveLocationReq = TGetPhysicalDriveLocationReq

---@class StorageIpmiCmds.GetPhysicalDriveLocationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetPhysicalDriveLocationRsp = {}
TGetPhysicalDriveLocationRsp.__index = TGetPhysicalDriveLocationRsp
TGetPhysicalDriveLocationRsp.group = {}

local function TGetPhysicalDriveLocationRsp_from_obj(obj)
    return setmetatable(obj, TGetPhysicalDriveLocationRsp)
end

function TGetPhysicalDriveLocationRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetPhysicalDriveLocationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetPhysicalDriveLocationRsp
function TGetPhysicalDriveLocationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetPhysicalDriveLocationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPhysicalDriveLocationRsp.group)
end

TGetPhysicalDriveLocationRsp.from_obj = TGetPhysicalDriveLocationRsp_from_obj

TGetPhysicalDriveLocationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetPhysicalDriveLocationRsp.default = {0, 0, 0, ''}

TGetPhysicalDriveLocationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetPhysicalDriveLocationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPhysicalDriveLocationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPhysicalDriveLocationRsp.proto_property, errs, need_convert)
    return self
end

function TGetPhysicalDriveLocationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetPhysicalDriveLocation.GetPhysicalDriveLocationRsp = TGetPhysicalDriveLocationRsp

return GetPhysicalDriveLocation
