--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetHddPwrStatus = {}

---@class StorageIpmiCmds.GetHddPwrStatusReq
---@field ManufacturerId integer
---@field HddLocation integer
---@field Reserve1 integer
---@field HddID integer
---@field Reserve2 integer
local TGetHddPwrStatusReq = {}
TGetHddPwrStatusReq.__index = TGetHddPwrStatusReq
TGetHddPwrStatusReq.group = {}

local function TGetHddPwrStatusReq_from_obj(obj)
    return setmetatable(obj, TGetHddPwrStatusReq)
end

function TGetHddPwrStatusReq.new(ManufacturerId, HddLocation, Reserve1, HddID, Reserve2)
    return TGetHddPwrStatusReq_from_obj({
        ManufacturerId = ManufacturerId,
        HddLocation = HddLocation,
        Reserve1 = Reserve1,
        HddID = HddID,
        Reserve2 = Reserve2
    })
end
---@param obj StorageIpmiCmds.GetHddPwrStatusReq
function TGetHddPwrStatusReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.HddLocation = obj.HddLocation
    self.Reserve1 = obj.Reserve1
    self.HddID = obj.HddID
    self.Reserve2 = obj.Reserve2
end

function TGetHddPwrStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetHddPwrStatusReq.group)
end

TGetHddPwrStatusReq.from_obj = TGetHddPwrStatusReq_from_obj

TGetHddPwrStatusReq.proto_property = {'ManufacturerId', 'HddLocation', 'Reserve1', 'HddID', 'Reserve2'}

TGetHddPwrStatusReq.default = {0, 0, 0, 0, 0}

TGetHddPwrStatusReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'HddLocation', is_array = false, struct = nil},
    {name = 'Reserve1', is_array = false, struct = nil}, {name = 'HddID', is_array = false, struct = nil},
    {name = 'Reserve2', is_array = false, struct = nil}
}

function TGetHddPwrStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'HddLocation', self.HddLocation, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve1', self.Reserve1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'HddID', self.HddID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve2', self.Reserve2, 'uint8', false, errs, need_convert)

    TGetHddPwrStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetHddPwrStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetHddPwrStatusReq:unpack(_)
    return self.ManufacturerId, self.HddLocation, self.Reserve1, self.HddID, self.Reserve2
end

GetHddPwrStatus.GetHddPwrStatusReq = TGetHddPwrStatusReq

---@class StorageIpmiCmds.GetHddPwrStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetHddPwrStatusRsp = {}
TGetHddPwrStatusRsp.__index = TGetHddPwrStatusRsp
TGetHddPwrStatusRsp.group = {}

local function TGetHddPwrStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetHddPwrStatusRsp)
end

function TGetHddPwrStatusRsp.new(CompletionCode, ManufactureId, Data)
    return TGetHddPwrStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj StorageIpmiCmds.GetHddPwrStatusRsp
function TGetHddPwrStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetHddPwrStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetHddPwrStatusRsp.group)
end

TGetHddPwrStatusRsp.from_obj = TGetHddPwrStatusRsp_from_obj

TGetHddPwrStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetHddPwrStatusRsp.default = {0, 0, ''}

TGetHddPwrStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetHddPwrStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetHddPwrStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetHddPwrStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetHddPwrStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetHddPwrStatus.GetHddPwrStatusRsp = TGetHddPwrStatusRsp

return GetHddPwrStatus
