--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetHddPlugCnt = {}

---@class StorageIpmiCmds.GetHddPlugCntReq
---@field ManufacturerId integer
---@field EventType integer
local TGetHddPlugCntReq = {}
TGetHddPlugCntReq.__index = TGetHddPlugCntReq
TGetHddPlugCntReq.group = {}

local function TGetHddPlugCntReq_from_obj(obj)
    return setmetatable(obj, TGetHddPlugCntReq)
end

function TGetHddPlugCntReq.new(ManufacturerId, EventType)
    return TGetHddPlugCntReq_from_obj({ManufacturerId = ManufacturerId, EventType = EventType})
end
---@param obj StorageIpmiCmds.GetHddPlugCntReq
function TGetHddPlugCntReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.EventType = obj.EventType
end

function TGetHddPlugCntReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetHddPlugCntReq.group)
end

TGetHddPlugCntReq.from_obj = TGetHddPlugCntReq_from_obj

TGetHddPlugCntReq.proto_property = {'ManufacturerId', 'EventType'}

TGetHddPlugCntReq.default = {0, 0}

TGetHddPlugCntReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil}
}

function TGetHddPlugCntReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)

    TGetHddPlugCntReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetHddPlugCntReq.proto_property, errs, need_convert)
    return self
end

function TGetHddPlugCntReq:unpack(_)
    return self.ManufacturerId, self.EventType
end

GetHddPlugCnt.GetHddPlugCntReq = TGetHddPlugCntReq

---@class StorageIpmiCmds.GetHddPlugCntRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field HddBackPlaneNum integer
---@field Data string
local TGetHddPlugCntRsp = {}
TGetHddPlugCntRsp.__index = TGetHddPlugCntRsp
TGetHddPlugCntRsp.group = {}

local function TGetHddPlugCntRsp_from_obj(obj)
    return setmetatable(obj, TGetHddPlugCntRsp)
end

function TGetHddPlugCntRsp.new(CompletionCode, ManufactureId, HddBackPlaneNum, Data)
    return TGetHddPlugCntRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        HddBackPlaneNum = HddBackPlaneNum,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetHddPlugCntRsp
function TGetHddPlugCntRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.HddBackPlaneNum = obj.HddBackPlaneNum
    self.Data = obj.Data
end

function TGetHddPlugCntRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetHddPlugCntRsp.group)
end

TGetHddPlugCntRsp.from_obj = TGetHddPlugCntRsp_from_obj

TGetHddPlugCntRsp.proto_property = {'CompletionCode', 'ManufactureId', 'HddBackPlaneNum', 'Data'}

TGetHddPlugCntRsp.default = {0, 0, 0, ''}

TGetHddPlugCntRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'HddBackPlaneNum', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetHddPlugCntRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'HddBackPlaneNum', self.HddBackPlaneNum, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetHddPlugCntRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetHddPlugCntRsp.proto_property, errs, need_convert)
    return self
end

function TGetHddPlugCntRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.HddBackPlaneNum, self.Data
end

GetHddPlugCnt.GetHddPlugCntRsp = TGetHddPlugCntRsp

return GetHddPlugCnt
