-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local log = require 'mc.logging'
local error = require 'mc.error'
local new_error = error.new_error
local print_log = error.print_log
local print_trace = error.print_trace
local regist_err_eng = error.register_err

local M = {}

local OperationFailed = {name = 'kepler.storage.OperationFailed', format = [=[Failed to operate!]=], severity = 'error'}
M.OperationFailed = OperationFailed.name
---@return Error
function M.operation_failed()
    local err_data = new_error(OperationFailed.name, OperationFailed.format)
    regist_err_eng(OperationFailed, 400, nil, 0xFF)
    print_log(log.ERROR, OperationFailed.format)
    return err_data
end

return M
