-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

---@class StorageConfigTable: Table
---@field StorageConfigReady FieldBase
---@field VolumesStateAbnormal FieldBase
---@field DiskPartitionUsagePercentageThreshold FieldBase
---@field PhyErrorEnabled FieldBase
---@field PhyErrorInterval FieldBase
---@field PhyErrorMaxRecord FieldBase
---@field PhyErrorThreshold FieldBase
---@field MaxPhyErrorLogFileRotationCount FieldBase
---@field PhyErrorSelUnlimitFlag FieldBase
---@field FileMockEnabled FieldBase

---@class ControllerTable: Table
---@field Id FieldBase
---@field Type FieldBase
---@field TypeId FieldBase
---@field DeviceName FieldBase
---@field Position FieldBase
---@field TemperatureCelsius FieldBase
---@field TemperatureAbnormal FieldBase
---@field ControllerName FieldBase
---@field OOBSupport FieldBase
---@field FirmwareVersion FieldBase
---@field SupportedMode FieldBase
---@field MemorySizeMiB FieldBase
---@field DeviceInterface FieldBase
---@field SASAddr FieldBase
---@field SerialNumber FieldBase
---@field MaxStripSizeBytes FieldBase
---@field MinStripSizeBytes FieldBase
---@field NVDataVersion FieldBase
---@field MaintainPDFailHistrory FieldBase
---@field PCIeLinkWidth FieldBase
---@field UnconfiguredDriveWriteCachePolicy FieldBase
---@field HBADriveWriteCachePolicy FieldBase
---@field ConfiguredDriveWriteCachePolicy FieldBase
---@field SupportedRAIDTypes FieldBase
---@field SmarterCopyBackState FieldBase
---@field CopyBackState FieldBase
---@field BootDevices FieldBase
---@field HardwareRevision FieldBase
---@field HotSpareActivationMode FieldBase
---@field NoBatteryWriteCacheEnabled FieldBase
---@field ReadCachePercent FieldBase
---@field JBODState FieldBase
---@field CachePinnedState FieldBase
---@field DDREccCount FieldBase
---@field WorkMode FieldBase
---@field RefDrives FieldBase
---@field BOMNumber FieldBase
---@field CryptoEraseSupported FieldBase
---@field EpdSupported FieldBase
---@field JbodSupported FieldBase
---@field DriverName FieldBase
---@field DriverVersion FieldBase
---@field Model FieldBase
---@field ChipManufacturer FieldBase
---@field ConsistencyCheckState FieldBase
---@field PeriodOfHours FieldBase
---@field Rate FieldBase
---@field AutoRepairEnabled FieldBase
---@field RunningStatus FieldBase
---@field TotalVolumeCounts FieldBase
---@field CompletedVolumeCounts FieldBase
---@field DelayToStart FieldBase
---@field CreateVolumeSupported FieldBase
---@field SupportedReadPolicyList FieldBase
---@field DefaultReadPolicy FieldBase
---@field ReadPolicyWritable FieldBase
---@field SupportedWritePolicyList FieldBase
---@field DefaultWritePolicy FieldBase
---@field WritePolicyWritable FieldBase
---@field SupportedIOPolicyList FieldBase
---@field DefaultIOPolicy FieldBase
---@field IOPolicyWritable FieldBase
---@field SupportedAccessPolicyList FieldBase
---@field DefaultAccessPolicy FieldBase
---@field AccessPolicyWritable FieldBase
---@field SupportedDriveCachePolicyList FieldBase
---@field DefaultDriveCachePolicy FieldBase
---@field DriveCachePolicyWritable FieldBase
---@field FaultCode FieldBase
---@field CommunicationLoss FieldBase
---@field Health FieldBase
---@field FaultCodeByBios FieldBase
---@field BatteryPresence FieldBase
---@field BatteryFault FieldBase
---@field BatteryHealth FieldBase
---@field Media FieldBase
---@field Source FieldBase
---@field Description FieldBase
---@field Method FieldBase
---@field Result FieldBase
---@field Progress FieldBase
---@field RetirementState FieldBase
---@field AssetType FieldBase
---@field AssetName FieldBase
---@field InventorySerialNumber FieldBase
---@field InventoryFirmwareVersion FieldBase
---@field PCBVersion FieldBase
---@field Manufacturer FieldBase
---@field AssetTag FieldBase
---@field PartNumber FieldBase
---@field ManufactureDate FieldBase
---@field Slot FieldBase
---@field InventoryModel FieldBase
---@field UUID FieldBase
---@field RefChip FieldBase
---@field SystemId FieldBase
---@field SocketId FieldBase
---@field Segment FieldBase
---@field DevBus FieldBase
---@field DevDevice FieldBase
---@field DevFunction FieldBase
---@field Eid FieldBase
---@field Phyaddr FieldBase
---@field CtrlOption1 FieldBase
---@field CtrlOption2 FieldBase
---@field CtrlOption3 FieldBase
---@field SlotId FieldBase

---@class DiskArrayTable: Table
---@field Id FieldBase
---@field UsedSpaceMiB FieldBase
---@field TotalFreeSpaceMiB FieldBase
---@field FreeBlocksSpaceMiB FieldBase
---@field RefVolumes FieldBase
---@field RefDrives FieldBase
---@field DriveNumPerSpan FieldBase
---@field RAIDType FieldBase
---@field AverageDriveFreeSpaceMiB FieldBase
---@field RefControllerId FieldBase
---@field RefPDSlots FieldBase
---@field RefPDEnclosures FieldBase

---@class DriveTable: Table
---@field NodeId FieldBase
---@field Id FieldBase
---@field SlotNumber FieldBase
---@field Name FieldBase
---@field Presence FieldBase
---@field LocateLed FieldBase
---@field FaultLed FieldBase
---@field EnclosureId FieldBase
---@field LocationIndicatorState FieldBase
---@field CapacityMiB FieldBase
---@field TemperatureCelsius FieldBase
---@field Model FieldBase
---@field Protocol FieldBase
---@field CapableSpeedGbs FieldBase
---@field NegotiatedSpeedGbs FieldBase
---@field MediaType FieldBase
---@field FirmwareStatus FieldBase
---@field SerialNumber FieldBase
---@field Manufacturer FieldBase
---@field PowerOnHours FieldBase
---@field Revision FieldBase
---@field RotationSpeedRPM FieldBase
---@field BlockSizeBytes FieldBase
---@field SASAddress1 FieldBase
---@field SASAddress2 FieldBase
---@field Location FieldBase
---@field DeviceName FieldBase
---@field PredictedMediaLifeLeftPercent FieldBase
---@field PredictedFailCount FieldBase
---@field MediaErrorCount FieldBase
---@field OtherErrorCount FieldBase
---@field PatrolState FieldBase
---@field PowerState FieldBase
---@field RebuildState FieldBase
---@field RebuildProgress FieldBase
---@field BootPriority FieldBase
---@field HotspareType FieldBase
---@field RefControllerId FieldBase
---@field RefVolumeList FieldBase
---@field RefDiskArrayId FieldBase
---@field ManufacturerId FieldBase
---@field PCIeLinkSpeed FieldBase
---@field ResourceId FieldBase
---@field ContainerPhysicalContext FieldBase
---@field Type FieldBase
---@field SocketId FieldBase
---@field SlotId FieldBase
---@field PortId FieldBase
---@field RootBDF FieldBase
---@field Missing FieldBase
---@field PredictiveFailure FieldBase
---@field InAFailedArray FieldBase
---@field CapacityError FieldBase
---@field FirmwareStatusError FieldBase
---@field Failure FieldBase
---@field Health FieldBase
---@field StripTemperatureCelsius FieldBase
---@field ElementsInGrownDefectList FieldBase
---@field ElementsInPrimaryDefectList FieldBase
---@field ManufacturedInWeekOfYear FieldBase
---@field BlocksSentToInitiator FieldBase
---@field BlocksReceivedFromInitiator FieldBase
---@field UntilNextInterSMARTTestMinutes FieldBase
---@field LastPrefailEventSeqNum FieldBase
---@field AssetType FieldBase
---@field AssetName FieldBase
---@field InventorySerialNumber FieldBase
---@field InventoryFirmwareVersion FieldBase
---@field PCBVersion FieldBase
---@field InventoryManufacturer FieldBase
---@field AssetTag FieldBase
---@field PartNumber FieldBase
---@field ManufactureDate FieldBase
---@field Slot FieldBase
---@field InventoryModel FieldBase
---@field UUID FieldBase
---@field EstimatedRemainingLifespanInsufficient FieldBase
---@field SLCSpareBlockPercentage FieldBase
---@field TLCSpareBlockPercentage FieldBase
---@field EstimatedRemainingLifespan FieldBase
---@field IODeteriorationHealthCode FieldBase
---@field LifeUsedPercentage FieldBase
---@field AvailableSpare FieldBase
---@field CriticalWarning FieldBase
---@field UsedPercentage FieldBase
---@field Status FieldBase
---@field LocateReg FieldBase
---@field FaultReg FieldBase
---@field ActivationLed FieldBase
---@field PhysicalLocation FieldBase
---@field PassThrough FieldBase
---@field HddBackplaneStartSlot FieldBase
---@field RelativeSlot FieldBase
---@field LinkFault FieldBase
---@field SetLocateLed FieldBase
---@field SetFaultLed FieldBase
---@field CommandTimeoutTimes FieldBase
---@field UnexpectedSenseTimes FieldBase

---@class DrivesTable: Table
---@field MaxTemperatureCelsius FieldBase
---@field LogAutoCollectEnable FieldBase
---@field LogAutoCollectInterval FieldBase
---@field Id FieldBase

---@class ReplicaDriveTable: Table
---@field Id FieldBase
---@field SerialNumber FieldBase

---@class VolumeTable: Table
---@field Id FieldBase
---@field VolumeName FieldBase
---@field OptimumIOSizeBytes FieldBase
---@field DefaultReadPolicy FieldBase
---@field DefaultWritePolicy FieldBase
---@field State FieldBase
---@field RAIDType FieldBase
---@field CapacityBytes FieldBase
---@field DriveCachePolicy FieldBase
---@field CurrentForegroundInitState FieldBase
---@field ForegroundInitProgress FieldBase
---@field CurrentReadPolicy FieldBase
---@field CurrentWritePolicy FieldBase
---@field BootPriority FieldBase
---@field BootEnable FieldBase
---@field OSDriveName FieldBase
---@field BGIEnable FieldBase
---@field SSDCachecadeVolume FieldBase
---@field ConsistencyCheck FieldBase
---@field SSDCachingEnable FieldBase
---@field AssociatedVolumes FieldBase
---@field AssociatedCacheCadeVolume FieldBase
---@field DefaultCachePolicy FieldBase
---@field AccessPolicy FieldBase
---@field CurrentCachePolicy FieldBase
---@field CacheLineSizeKiB FieldBase
---@field AccelerationMethod FieldBase
---@field RebuildProgress FieldBase
---@field InitializationMode FieldBase
---@field RebuildState FieldBase
---@field RefControllerId FieldBase
---@field RefDriveList FieldBase
---@field RefDiskArrayList FieldBase
---@field HotSpareDriveList FieldBase
---@field SpanCount FieldBase
---@field MaxResizableSizeBytes FieldBase
---@field NumDrivePerSpan FieldBase

---@class BatteryTable: Table
---@field Name FieldBase
---@field State FieldBase
---@field Fault FieldBase
---@field HealthStatus FieldBase
---@field Health FieldBase
---@field TemperatureCelsius FieldBase
---@field RefController FieldBase
---@field RefControllerDeviceName FieldBase
---@field RefControllerSlotId FieldBase
---@field RefControllerTypeId FieldBase

---@class NvmeTable: Table
---@field Slot FieldBase
---@field MediaType FieldBase
---@field Protocol FieldBase
---@field Revision FieldBase
---@field PredictedMediaLifeLeftPercent FieldBase
---@field VPDChip FieldBase
---@field SSDChip FieldBase
---@field RefComponent FieldBase
---@field TemperatureCelsius FieldBase
---@field Failure FieldBase
---@field PredictiveFailure FieldBase
---@field SerialNumber FieldBase

---@class VirtualVPDConnectTable: Table
---@field Slot FieldBase
---@field RefVPDChip FieldBase
---@field RefConnector FieldBase
---@field RefPolicyConnector FieldBase

---@class DriveInfoTableTable: Table
---@field Id FieldBase

---@class DrivesTableInfoTable: Table
---@field Id FieldBase
---@field TemperatureCelsius FieldBase
---@field IsAlerted FieldBase

---@class GlobalStorageConfigTableTable: Table
---@field Id FieldBase
---@field DiskPartitionUsagePercentageThreshold FieldBase

---@class StorageDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field StorageConfig StorageConfigTable
---@field Controller ControllerTable
---@field DiskArray DiskArrayTable
---@field Drive DriveTable
---@field Drives DrivesTable
---@field ReplicaDrive ReplicaDriveTable
---@field Volume VolumeTable
---@field Battery BatteryTable
---@field Nvme NvmeTable
---@field VirtualVPDConnect VirtualVPDConnectTable
---@field DriveInfoTable DriveInfoTableTable
---@field DrivesTableInfo DrivesTableInfoTable
---@field GlobalStorageConfigTable GlobalStorageConfigTableTable
local StorageDBDatabase = {}
StorageDBDatabase.__index = StorageDBDatabase

function StorageDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.StorageConfig = db:Table('t_storage_config_table_info', {
        StorageConfigReady = Col.IntegerField():cid(1):null():max_length(8),
        VolumesStateAbnormal = Col.IntegerField():cid(2):null():max_length(8),
        DiskPartitionUsagePercentageThreshold = Col.IntegerField():cid(3):null():max_length(8):default(100),
        PhyErrorEnabled = Col.BooleandField():cid(4):primary_key():persistence_key('protect_power_off'):default(true),
        PhyErrorInterval = Col.IntegerField():cid(5):persistence_key('protect_power_off'):null():max_length(32):default(
            1800),
        PhyErrorMaxRecord = Col.IntegerField():cid(6):persistence_key('protect_power_off'):null():max_length(8):default(
            20),
        PhyErrorThreshold = Col.IntegerField():cid(7):persistence_key('protect_power_off'):null():max_length(32)
            :default(100),
        MaxPhyErrorLogFileRotationCount = Col.IntegerField():cid(8):persistence_key('protect_power_off'):null()
            :max_length(8):default(10),
        PhyErrorSelUnlimitFlag = Col.BooleandField():cid(9):persistence_key('protect_power_off'):null(),
        FileMockEnabled = Col.BooleandField():cid(10):persistence_key('protect_power_off'):null()
    }):create_if_not_exist(datas and datas['t_storage_config_table_info'])
    obj.Controller = db:Table('t_controller_info', {
        Id = Col.IntegerField():cid(1):persistence_key('protect_reset_retain'):null():max_length(8):default(255),
        Type = Col.TextField():cid(2):null(),
        TypeId = Col.IntegerField():cid(3):null():max_length(8),
        DeviceName = Col.TextField():cid(4):primary_key(),
        Position = Col.TextField():cid(5):null(),
        TemperatureCelsius = Col.IntegerField():cid(6):null():max_length(16),
        TemperatureAbnormal = Col.IntegerField():cid(7):null():max_length(8),
        ControllerName = Col.TextField():cid(8):null(),
        OOBSupport = Col.IntegerField():cid(9):persistence_key('protect_power_off'):null():max_length(8),
        FirmwareVersion = Col.TextField():cid(10):null(),
        SupportedMode = Col.JsonField():cid(11):null(),
        MemorySizeMiB = Col.IntegerField():cid(12):null():max_length(16),
        DeviceInterface = Col.TextField():cid(13):null(),
        SASAddr = Col.TextField():cid(14):null(),
        SerialNumber = Col.TextField():cid(15):null(),
        MaxStripSizeBytes = Col.IntegerField():cid(16):null():max_length(32),
        MinStripSizeBytes = Col.IntegerField():cid(17):null():max_length(32),
        NVDataVersion = Col.TextField():cid(18):null(),
        MaintainPDFailHistrory = Col.IntegerField():cid(19):null():max_length(8),
        PCIeLinkWidth = Col.TextField():cid(20):null(),
        UnconfiguredDriveWriteCachePolicy = Col.TextField():cid(21):null(),
        HBADriveWriteCachePolicy = Col.TextField():cid(22):null(),
        ConfiguredDriveWriteCachePolicy = Col.TextField():cid(23):null(),
        SupportedRAIDTypes = Col.JsonField():cid(24):null(),
        SmarterCopyBackState = Col.IntegerField():cid(25):null():max_length(8),
        CopyBackState = Col.IntegerField():cid(26):null():max_length(8),
        BootDevices = Col.JsonField():cid(27):null(),
        HardwareRevision = Col.TextField():cid(28):null(),
        HotSpareActivationMode = Col.TextField():cid(29):null(),
        NoBatteryWriteCacheEnabled = Col.IntegerField():cid(30):null():max_length(8):default(255),
        ReadCachePercent = Col.IntegerField():cid(31):null():max_length(8):default(255),
        JBODState = Col.IntegerField():cid(32):null():max_length(8),
        CachePinnedState = Col.IntegerField():cid(33):null():max_length(8),
        DDREccCount = Col.IntegerField():cid(34):null():max_length(16),
        WorkMode = Col.TextField():cid(35):null(),
        RefDrives = Col.JsonField():cid(36):null(),
        BOMNumber = Col.TextField():cid(37):null(),
        CryptoEraseSupported = Col.BooleandField():cid(38):null(),
        EpdSupported = Col.BooleandField():cid(39):null(),
        JbodSupported = Col.BooleandField():cid(40):null(),
        DriverName = Col.TextField():cid(41):null(),
        DriverVersion = Col.TextField():cid(42):null(),
        Model = Col.TextField():cid(43):null(),
        ChipManufacturer = Col.TextField():cid(44):null(),
        ConsistencyCheckState = Col.IntegerField():cid(45):null():max_length(8),
        PeriodOfHours = Col.IntegerField():cid(46):null():max_length(16),
        Rate = Col.TextField():cid(47):null(),
        AutoRepairEnabled = Col.IntegerField():cid(48):null():max_length(8),
        RunningStatus = Col.TextField():cid(49):null(),
        TotalVolumeCounts = Col.IntegerField():cid(50):null():max_length(16),
        CompletedVolumeCounts = Col.IntegerField():cid(51):null():max_length(16),
        DelayToStart = Col.IntegerField():cid(52):null():max_length(32),
        CreateVolumeSupported = Col.BooleandField():cid(53):null(),
        SupportedReadPolicyList = Col.JsonField():cid(54):null(),
        DefaultReadPolicy = Col.TextField():cid(55):null(),
        ReadPolicyWritable = Col.BooleandField():cid(56):null(),
        SupportedWritePolicyList = Col.JsonField():cid(57):null(),
        DefaultWritePolicy = Col.TextField():cid(58):null(),
        WritePolicyWritable = Col.BooleandField():cid(59):null(),
        SupportedIOPolicyList = Col.JsonField():cid(60):null(),
        DefaultIOPolicy = Col.TextField():cid(61):null(),
        IOPolicyWritable = Col.BooleandField():cid(62):null(),
        SupportedAccessPolicyList = Col.JsonField():cid(63):null(),
        DefaultAccessPolicy = Col.TextField():cid(64):null(),
        AccessPolicyWritable = Col.BooleandField():cid(65):null(),
        SupportedDriveCachePolicyList = Col.JsonField():cid(66):null(),
        DefaultDriveCachePolicy = Col.TextField():cid(67):null(),
        DriveCachePolicyWritable = Col.BooleandField():cid(68):null(),
        FaultCode = Col.IntegerField():cid(69):null():max_length(16),
        CommunicationLoss = Col.IntegerField():cid(70):null():max_length(8),
        Health = Col.IntegerField():cid(71):null():max_length(8),
        FaultCodeByBios = Col.IntegerField():cid(72):persistence_key('protect_reset'):null():max_length(8),
        BatteryPresence = Col.IntegerField():cid(73):persistence_key('protect_reset'):null():max_length(8):default(255),
        BatteryFault = Col.IntegerField():cid(74):null():max_length(8),
        BatteryHealth = Col.IntegerField():cid(75):null():max_length(8),
        Media = Col.TextField():cid(76):null(),
        Source = Col.TextField():cid(77):null(),
        Description = Col.TextField():cid(78):null(),
        Method = Col.TextField():cid(79):null(),
        Result = Col.TextField():cid(80):null(),
        Progress = Col.IntegerField():cid(81):null():max_length(8),
        RetirementState = Col.TextField():cid(82):null():default('\'Idle\''),
        AssetType = Col.TextField():cid(83):null(),
        AssetName = Col.TextField():cid(84):null(),
        InventorySerialNumber = Col.TextField():cid(85):null(),
        InventoryFirmwareVersion = Col.TextField():cid(86):null(),
        PCBVersion = Col.TextField():cid(87):null(),
        Manufacturer = Col.TextField():cid(88):null(),
        AssetTag = Col.TextField():cid(89):null(),
        PartNumber = Col.TextField():cid(90):null(),
        ManufactureDate = Col.TextField():cid(91):null(),
        Slot = Col.TextField():cid(92):null(),
        InventoryModel = Col.TextField():cid(93):null(),
        UUID = Col.TextField():cid(94):null(),
        RefChip = Col.JsonField():cid(95):null(),
        SystemId = Col.IntegerField():cid(96):null():max_length(8),
        SocketId = Col.IntegerField():cid(97):null():max_length(8),
        Segment = Col.IntegerField():cid(98):null():max_length(8),
        DevBus = Col.IntegerField():cid(99):null():max_length(8),
        DevDevice = Col.IntegerField():cid(100):null():max_length(8),
        DevFunction = Col.IntegerField():cid(101):null():max_length(8),
        Eid = Col.IntegerField():cid(102):null():max_length(8),
        Phyaddr = Col.IntegerField():cid(103):null():max_length(16),
        CtrlOption1 = Col.IntegerField():cid(104):null():max_length(32),
        CtrlOption2 = Col.IntegerField():cid(105):null():max_length(32),
        CtrlOption3 = Col.IntegerField():cid(106):null():max_length(32),
        SlotId = Col.IntegerField():cid(107):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_controller_info'])
    obj.DiskArray = db:Table('t_diskarrays_info', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(16),
        UsedSpaceMiB = Col.IntegerField():cid(2):null():max_length(32),
        TotalFreeSpaceMiB = Col.IntegerField():cid(3):null():max_length(32),
        FreeBlocksSpaceMiB = Col.JsonField():cid(4):null(),
        RefVolumes = Col.JsonField():cid(5):null(),
        RefDrives = Col.JsonField():cid(6):null(),
        DriveNumPerSpan = Col.IntegerField():cid(7):null():max_length(8),
        RAIDType = Col.TextField():cid(8):null(),
        AverageDriveFreeSpaceMiB = Col.IntegerField():cid(9):null():max_length(32),
        RefControllerId = Col.IntegerField():cid(10):primary_key():max_length(8),
        RefPDSlots = Col.JsonField():cid(11):null(),
        RefPDEnclosures = Col.JsonField():cid(12):null()
    }):create_if_not_exist(datas and datas['t_diskarrays_info'])
    obj.Drive = db:Table('t_storage_drive', {
        NodeId = Col.TextField():cid(1):null(),
        Id = Col.IntegerField():cid(2):primary_key():max_length(8),
        SlotNumber = Col.IntegerField():cid(3):persistence_key('protect_reset'):null():max_length(8):default(255),
        Name = Col.TextField():cid(4):null(),
        Presence = Col.IntegerField():cid(5):null():max_length(8):default(255),
        LocateLed = Col.IntegerField():cid(6):null():max_length(8),
        FaultLed = Col.IntegerField():cid(7):null():max_length(8),
        EnclosureId = Col.IntegerField():cid(8):persistence_key('protect_reset'):null():max_length(16):default(65535),
        LocationIndicatorState = Col.IntegerField():cid(9):null():max_length(8),
        CapacityMiB = Col.IntegerField():cid(10):persistence_key('protect_reset'):null():max_length(32):default(
            4294967295),
        TemperatureCelsius = Col.IntegerField():cid(11):null():max_length(16):default(255),
        Model = Col.TextField():cid(12):persistence_key('protect_reset'):null():default('\'N/A\''),
        Protocol = Col.IntegerField():cid(13):persistence_key('protect_reset'):null():max_length(8):default(255),
        CapableSpeedGbs = Col.IntegerField():cid(14):persistence_key('protect_reset'):null():max_length(8):default(255),
        NegotiatedSpeedGbs = Col.IntegerField():cid(15):persistence_key('protect_reset'):null():max_length(8):default(
            255),
        MediaType = Col.IntegerField():cid(16):persistence_key('protect_reset'):null():max_length(8):default(255),
        FirmwareStatus = Col.IntegerField():cid(17):null():max_length(8):default(255),
        SerialNumber = Col.TextField():cid(18):persistence_key('protect_reset'):null():default('\'N/A\''),
        Manufacturer = Col.TextField():cid(19):persistence_key('protect_reset'):null():default('\'N/A\''),
        PowerOnHours = Col.RealField():cid(20):null(),
        Revision = Col.TextField():cid(21):persistence_key('protect_reset'):null():default('\'N/A\''),
        RotationSpeedRPM = Col.IntegerField():cid(22):null():max_length(16),
        BlockSizeBytes = Col.IntegerField():cid(23):null():max_length(16),
        SASAddress1 = Col.TextField():cid(24):null(),
        SASAddress2 = Col.TextField():cid(25):null(),
        Location = Col.TextField():cid(26):null(),
        DeviceName = Col.TextField():cid(27):null():default('\'N/A\''),
        PredictedMediaLifeLeftPercent = Col.IntegerField():cid(28):null():max_length(8):default(255),
        PredictedFailCount = Col.IntegerField():cid(29):null():max_length(32),
        MediaErrorCount = Col.IntegerField():cid(30):null():max_length(32),
        OtherErrorCount = Col.IntegerField():cid(31):null():max_length(32),
        PatrolState = Col.IntegerField():cid(32):null():max_length(8),
        PowerState = Col.IntegerField():cid(33):null():max_length(8),
        RebuildState = Col.IntegerField():cid(34):null():max_length(8),
        RebuildProgress = Col.IntegerField():cid(35):null():max_length(8),
        BootPriority = Col.IntegerField():cid(36):null():max_length(8),
        HotspareType = Col.IntegerField():cid(37):null():max_length(8),
        RefControllerId = Col.IntegerField():cid(38):persistence_key('protect_reset'):null():max_length(8):default(255),
        RefVolumeList = Col.JsonField():cid(39):null(),
        RefDiskArrayId = Col.IntegerField():cid(40):null():max_length(16),
        ManufacturerId = Col.IntegerField():cid(41):null():max_length(32),
        PCIeLinkSpeed = Col.RealField():cid(42):null(),
        ResourceId = Col.IntegerField():cid(43):null():max_length(8),
        ContainerPhysicalContext = Col.TextField():cid(44):null(),
        Type = Col.TextField():cid(45):null():default('\'N/A\''),
        SocketId = Col.IntegerField():cid(46):null():max_length(8),
        SlotId = Col.IntegerField():cid(47):null():max_length(8),
        PortId = Col.IntegerField():cid(48):null():max_length(8),
        RootBDF = Col.TextField():cid(49):null():default('\'N/A\''),
        Missing = Col.IntegerField():cid(50):null():max_length(16),
        PredictiveFailure = Col.IntegerField():cid(51):null():max_length(8),
        InAFailedArray = Col.IntegerField():cid(52):null():max_length(8),
        CapacityError = Col.BooleandField():cid(53):null(),
        FirmwareStatusError = Col.BooleandField():cid(54):null(),
        Failure = Col.BooleandField():cid(55):null(),
        Health = Col.IntegerField():cid(56):null():max_length(8),
        StripTemperatureCelsius = Col.IntegerField():cid(57):null():max_length(32),
        ElementsInGrownDefectList = Col.IntegerField():cid(58):null():max_length(32),
        ElementsInPrimaryDefectList = Col.IntegerField():cid(59):persistence_key('protect_reset'):null():max_length(32)
            :default(4294967295),
        ManufacturedInWeekOfYear = Col.TextField():cid(60):null(),
        BlocksSentToInitiator = Col.IntegerField():cid(61):null():max_length(32),
        BlocksReceivedFromInitiator = Col.IntegerField():cid(62):null():max_length(32),
        UntilNextInterSMARTTestMinutes = Col.IntegerField():cid(63):null():max_length(32),
        LastPrefailEventSeqNum = Col.IntegerField():cid(64):null():max_length(32),
        AssetType = Col.TextField():cid(65):null(),
        AssetName = Col.TextField():cid(66):null(),
        InventorySerialNumber = Col.TextField():cid(67):null(),
        InventoryFirmwareVersion = Col.TextField():cid(68):null(),
        PCBVersion = Col.TextField():cid(69):null(),
        InventoryManufacturer = Col.TextField():cid(70):null(),
        AssetTag = Col.TextField():cid(71):null(),
        PartNumber = Col.TextField():cid(72):null(),
        ManufactureDate = Col.TextField():cid(73):null(),
        Slot = Col.TextField():cid(74):null(),
        InventoryModel = Col.TextField():cid(75):null(),
        UUID = Col.TextField():cid(76):null(),
        EstimatedRemainingLifespanInsufficient = Col.IntegerField():cid(77):persistence_key('protect_reset'):null()
            :max_length(8),
        SLCSpareBlockPercentage = Col.IntegerField():cid(78):null():max_length(8):default(255),
        TLCSpareBlockPercentage = Col.IntegerField():cid(79):null():max_length(8):default(255),
        EstimatedRemainingLifespan = Col.IntegerField():cid(80):persistence_key('protect_power_off'):null():max_length(
            32):default(4294967295),
        IODeteriorationHealthCode = Col.IntegerField():cid(81):persistence_key('protect_power_off'):null()
            :max_length(16),
        LifeUsedPercentage = Col.IntegerField():cid(82):null():max_length(8),
        AvailableSpare = Col.IntegerField():cid(83):null():max_length(8),
        CriticalWarning = Col.IntegerField():cid(84):null():max_length(8),
        UsedPercentage = Col.IntegerField():cid(85):null():max_length(8),
        Status = Col.IntegerField():cid(86):null():max_length(8),
        LocateReg = Col.IntegerField():cid(87):null():max_length(8),
        FaultReg = Col.IntegerField():cid(88):null():max_length(8),
        ActivationLed = Col.IntegerField():cid(89):null():max_length(8),
        PhysicalLocation = Col.TextField():cid(90):null(),
        PassThrough = Col.IntegerField():cid(91):null():max_length(8):default(255),
        HddBackplaneStartSlot = Col.IntegerField():cid(92):null():max_length(8):default(255),
        RelativeSlot = Col.IntegerField():cid(93):null():max_length(8),
        LinkFault = Col.BooleandField():cid(94):persistence_key('protect_reset'):null():default(false),
        SetLocateLed = Col.IntegerField():cid(95):null():max_length(8),
        SetFaultLed = Col.IntegerField():cid(96):null():max_length(8),
        CommandTimeoutTimes = Col.IntegerField():cid(97):persistence_key('protect_power_off'):null():max_length(32)
            :default(0),
        UnexpectedSenseTimes = Col.IntegerField():cid(98):persistence_key('protect_power_off'):null():max_length(32)
            :default(0)
    }):create_if_not_exist(datas and datas['t_storage_drive'])
    obj.Drives = db:Table('t_drives_info', {
        MaxTemperatureCelsius = Col.IntegerField():cid(1):null():max_length(8),
        LogAutoCollectEnable = Col.BooleandField():cid(2):persistence_key('protect_power_off'):null():default(true),
        LogAutoCollectInterval = Col.IntegerField():cid(3):persistence_key('protect_power_off'):null():max_length(8)
            :default(24),
        Id = Col.IntegerField():cid(4):primary_key():max_length(8)
    }):create_if_not_exist(datas and datas['t_drives_info'])
    obj.ReplicaDrive = db:Table('t_ReplicaDrives_info', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        SerialNumber = Col.TextField():cid(2):null()
    }):create_if_not_exist(datas and datas['t_ReplicaDrives_info'])
    obj.Volume = db:Table('t_volumes_info', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(16),
        VolumeName = Col.TextField():cid(2):null(),
        OptimumIOSizeBytes = Col.IntegerField():cid(3):null():max_length(32),
        DefaultReadPolicy = Col.TextField():cid(4):null(),
        DefaultWritePolicy = Col.TextField():cid(5):null(),
        State = Col.IntegerField():cid(6):null():max_length(8):default(255),
        RAIDType = Col.IntegerField():cid(7):null():max_length(8),
        CapacityBytes = Col.IntegerField():cid(8):null():max_length(64),
        DriveCachePolicy = Col.IntegerField():cid(9):null():max_length(8),
        CurrentForegroundInitState = Col.IntegerField():cid(10):null():max_length(8),
        ForegroundInitProgress = Col.IntegerField():cid(11):null():max_length(8),
        CurrentReadPolicy = Col.TextField():cid(12):null(),
        CurrentWritePolicy = Col.TextField():cid(13):null(),
        BootPriority = Col.IntegerField():cid(14):null():max_length(8),
        BootEnable = Col.IntegerField():cid(15):null():max_length(8),
        OSDriveName = Col.TextField():cid(16):null(),
        BGIEnable = Col.IntegerField():cid(17):null():max_length(8),
        SSDCachecadeVolume = Col.IntegerField():cid(18):null():max_length(8),
        ConsistencyCheck = Col.IntegerField():cid(19):null():max_length(8),
        SSDCachingEnable = Col.IntegerField():cid(20):null():max_length(8),
        AssociatedVolumes = Col.JsonField():cid(21):null(),
        AssociatedCacheCadeVolume = Col.JsonField():cid(22):null(),
        DefaultCachePolicy = Col.TextField():cid(23):null(),
        AccessPolicy = Col.TextField():cid(24):null(),
        CurrentCachePolicy = Col.TextField():cid(25):null(),
        CacheLineSizeKiB = Col.IntegerField():cid(26):null():max_length(8),
        AccelerationMethod = Col.TextField():cid(27):null(),
        RebuildProgress = Col.IntegerField():cid(28):null():max_length(8),
        InitializationMode = Col.IntegerField():cid(29):null():max_length(8),
        RebuildState = Col.IntegerField():cid(30):null():max_length(8),
        RefControllerId = Col.IntegerField():cid(31):primary_key():max_length(8),
        RefDriveList = Col.JsonField():cid(32):null(),
        RefDiskArrayList = Col.JsonField():cid(33):null(),
        HotSpareDriveList = Col.JsonField():cid(34):null(),
        SpanCount = Col.IntegerField():cid(35):null():max_length(8),
        MaxResizableSizeBytes = Col.IntegerField():cid(36):null():max_length(64),
        NumDrivePerSpan = Col.IntegerField():cid(37):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_volumes_info'])
    obj.Battery = db:Table('t_batterys_info', {
        Name = Col.TextField():cid(1):null(),
        State = Col.IntegerField():cid(2):null():max_length(8),
        Fault = Col.IntegerField():cid(3):null():max_length(8),
        HealthStatus = Col.IntegerField():cid(4):null():max_length(32),
        Health = Col.IntegerField():cid(5):null():max_length(8),
        TemperatureCelsius = Col.IntegerField():cid(6):null():max_length(16),
        RefController = Col.IntegerField():cid(7):null():max_length(8),
        RefControllerDeviceName = Col.TextField():cid(8):primary_key(),
        RefControllerSlotId = Col.IntegerField():cid(9):null():max_length(8),
        RefControllerTypeId = Col.IntegerField():cid(10):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_batterys_info'])
    obj.Nvme = db:Table('t_nvme_info', {
        Slot = Col.IntegerField():cid(1):primary_key():max_length(8),
        MediaType = Col.IntegerField():cid(2):null():max_length(8),
        Protocol = Col.IntegerField():cid(3):null():max_length(8),
        Revision = Col.TextField():cid(4):null(),
        PredictedMediaLifeLeftPercent = Col.IntegerField():cid(5):null():max_length(8),
        VPDChip = Col.JsonField():cid(6):null(),
        SSDChip = Col.JsonField():cid(7):null(),
        RefComponent = Col.JsonField():cid(8):null(),
        TemperatureCelsius = Col.IntegerField():cid(9):null():max_length(8),
        Failure = Col.IntegerField():cid(10):null():max_length(16),
        PredictiveFailure = Col.IntegerField():cid(11):null():max_length(16),
        SerialNumber = Col.TextField():cid(12):null()
    }):create_if_not_exist(datas and datas['t_nvme_info'])
    obj.VirtualVPDConnect = db:Table('t_vpd_connect', {
        Slot = Col.IntegerField():cid(1):primary_key():max_length(8),
        RefVPDChip = Col.JsonField():cid(2):null(),
        RefConnector = Col.JsonField():cid(3):null(),
        RefPolicyConnector = Col.JsonField():cid(4):null()
    }):create_if_not_exist(datas and datas['t_vpd_connect'])
    obj.DriveInfoTable = db:Table('t_drive_info',
        {Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off')}):create_if_not_exist(datas and
                                                                                                                  datas['t_drive_info'])
    obj.DrivesTableInfo = db:Table('t_drives_table_info', {
        Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off'),
        TemperatureCelsius = Col.IntegerField():cid(2):persistence_key('protect_power_off'):null():max_length(8),
        IsAlerted = Col.BooleandField():cid(3):persistence_key('protect_power_off'):null()
    }):create_if_not_exist(datas and datas['t_drives_table_info'])
    obj.GlobalStorageConfigTable = db:Table('t_storage_global_config_table', {
        Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off')
            :default('\'GlobalStorageConfig\''),
        DiskPartitionUsagePercentageThreshold = Col.IntegerField():cid(2):persistence_key('protect_power_off'):null()
            :max_length(8):default(100)
    }):create_if_not_exist(datas and datas['t_storage_global_config_table'])

    obj.tables = db.tables
    return setmetatable(obj, StorageDBDatabase)
end

function StorageDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function StorageDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function StorageDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function StorageDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function StorageDBDatabase:exec(...)
    return self.db:exec(...)
end

return StorageDBDatabase.new
