-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MVolume = {}

---@class MVolume.NumDrivePerSpan
---@field NumDrivePerSpan integer
local TNumDrivePerSpan = {}
TNumDrivePerSpan.__index = TNumDrivePerSpan
TNumDrivePerSpan.group = {}

local function TNumDrivePerSpan_from_obj(obj)
    return setmetatable(obj, TNumDrivePerSpan)
end

function TNumDrivePerSpan.new(NumDrivePerSpan)
    return TNumDrivePerSpan_from_obj({NumDrivePerSpan = NumDrivePerSpan})
end
---@param obj MVolume.NumDrivePerSpan
function TNumDrivePerSpan:init_from_obj(obj)
    self.NumDrivePerSpan = obj.NumDrivePerSpan
end

function TNumDrivePerSpan:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNumDrivePerSpan.group)
end

TNumDrivePerSpan.from_obj = TNumDrivePerSpan_from_obj

TNumDrivePerSpan.proto_property = {'NumDrivePerSpan'}

TNumDrivePerSpan.default = {0}

TNumDrivePerSpan.struct = {{name = 'NumDrivePerSpan', is_array = false, struct = nil}}

function TNumDrivePerSpan:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NumDrivePerSpan', self.NumDrivePerSpan, 'uint8', false, errs, need_convert)

    TNumDrivePerSpan:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNumDrivePerSpan.proto_property, errs, need_convert)
    return self
end

function TNumDrivePerSpan:unpack(_)
    return self.NumDrivePerSpan
end

MVolume.NumDrivePerSpan = TNumDrivePerSpan

return MVolume
