-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MStorageReset = {}

---@class MStorageReset.Value
---@field Value string
local TValue = {}
TValue.__index = TValue
TValue.group = {}

local function TValue_from_obj(obj)
    return setmetatable(obj, TValue)
end

function TValue.new(Value)
    return TValue_from_obj({Value = Value})
end
---@param obj MStorageReset.Value
function TValue:init_from_obj(obj)
    self.Value = obj.Value
end

function TValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValue.group)
end

TValue.from_obj = TValue_from_obj

TValue.proto_property = {'Value'}

TValue.default = {''}

TValue.struct = {{name = 'Value', is_array = false, struct = nil}}

function TValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValue.proto_property, errs, need_convert)
    return self
end

function TValue:unpack(_)
    return self.Value
end

MStorageReset.Value = TValue

---@class MStorageReset.Key
---@field Key string
local TKey = {}
TKey.__index = TKey
TKey.group = {}

local function TKey_from_obj(obj)
    return setmetatable(obj, TKey)
end

function TKey.new(Key)
    return TKey_from_obj({Key = Key})
end
---@param obj MStorageReset.Key
function TKey:init_from_obj(obj)
    self.Key = obj.Key
end

function TKey:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKey.group)
end

TKey.from_obj = TKey_from_obj

TKey.proto_property = {'Key'}

TKey.default = {''}

TKey.struct = {{name = 'Key', is_array = false, struct = nil}}

function TKey:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Key', self.Key, 'string', false, errs, need_convert)

    TKey:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKey.proto_property, errs, need_convert)
    return self
end

function TKey:unpack(_)
    return self.Key
end

MStorageReset.Key = TKey

---@class MStorageReset.PerId
---@field PerId string
local TPerId = {}
TPerId.__index = TPerId
TPerId.group = {}

local function TPerId_from_obj(obj)
    return setmetatable(obj, TPerId)
end

function TPerId.new(PerId)
    return TPerId_from_obj({PerId = PerId})
end
---@param obj MStorageReset.PerId
function TPerId:init_from_obj(obj)
    self.PerId = obj.PerId
end

function TPerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPerId.group)
end

TPerId.from_obj = TPerId_from_obj

TPerId.proto_property = {'PerId'}

TPerId.default = {''}

TPerId.struct = {{name = 'PerId', is_array = false, struct = nil}}

function TPerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PerId', self.PerId, 'string', false, errs, need_convert)

    TPerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPerId.proto_property, errs, need_convert)
    return self
end

function TPerId:unpack(_)
    return self.PerId
end

MStorageReset.PerId = TPerId

return MStorageReset
