-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBattery = {}

---@class MBattery.RefControllerTypeId
---@field RefControllerTypeId integer
local TRefControllerTypeId = {}
TRefControllerTypeId.__index = TRefControllerTypeId
TRefControllerTypeId.group = {}

local function TRefControllerTypeId_from_obj(obj)
    return setmetatable(obj, TRefControllerTypeId)
end

function TRefControllerTypeId.new(RefControllerTypeId)
    return TRefControllerTypeId_from_obj({RefControllerTypeId = RefControllerTypeId})
end
---@param obj MBattery.RefControllerTypeId
function TRefControllerTypeId:init_from_obj(obj)
    self.RefControllerTypeId = obj.RefControllerTypeId
end

function TRefControllerTypeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefControllerTypeId.group)
end

TRefControllerTypeId.from_obj = TRefControllerTypeId_from_obj

TRefControllerTypeId.proto_property = {'RefControllerTypeId'}

TRefControllerTypeId.default = {0}

TRefControllerTypeId.struct = {{name = 'RefControllerTypeId', is_array = false, struct = nil}}

function TRefControllerTypeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefControllerTypeId', self.RefControllerTypeId, 'uint8', false, errs, need_convert)

    TRefControllerTypeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefControllerTypeId.proto_property, errs, need_convert)
    return self
end

function TRefControllerTypeId:unpack(_)
    return self.RefControllerTypeId
end

MBattery.RefControllerTypeId = TRefControllerTypeId

---@class MBattery.RefControllerSlotId
---@field RefControllerSlotId integer
local TRefControllerSlotId = {}
TRefControllerSlotId.__index = TRefControllerSlotId
TRefControllerSlotId.group = {}

local function TRefControllerSlotId_from_obj(obj)
    return setmetatable(obj, TRefControllerSlotId)
end

function TRefControllerSlotId.new(RefControllerSlotId)
    return TRefControllerSlotId_from_obj({RefControllerSlotId = RefControllerSlotId})
end
---@param obj MBattery.RefControllerSlotId
function TRefControllerSlotId:init_from_obj(obj)
    self.RefControllerSlotId = obj.RefControllerSlotId
end

function TRefControllerSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefControllerSlotId.group)
end

TRefControllerSlotId.from_obj = TRefControllerSlotId_from_obj

TRefControllerSlotId.proto_property = {'RefControllerSlotId'}

TRefControllerSlotId.default = {0}

TRefControllerSlotId.struct = {{name = 'RefControllerSlotId', is_array = false, struct = nil}}

function TRefControllerSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefControllerSlotId', self.RefControllerSlotId, 'uint8', false, errs, need_convert)

    TRefControllerSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefControllerSlotId.proto_property, errs, need_convert)
    return self
end

function TRefControllerSlotId:unpack(_)
    return self.RefControllerSlotId
end

MBattery.RefControllerSlotId = TRefControllerSlotId

---@class MBattery.RefControllerDeviceName
---@field RefControllerDeviceName string
local TRefControllerDeviceName = {}
TRefControllerDeviceName.__index = TRefControllerDeviceName
TRefControllerDeviceName.group = {}

local function TRefControllerDeviceName_from_obj(obj)
    return setmetatable(obj, TRefControllerDeviceName)
end

function TRefControllerDeviceName.new(RefControllerDeviceName)
    return TRefControllerDeviceName_from_obj({RefControllerDeviceName = RefControllerDeviceName})
end
---@param obj MBattery.RefControllerDeviceName
function TRefControllerDeviceName:init_from_obj(obj)
    self.RefControllerDeviceName = obj.RefControllerDeviceName
end

function TRefControllerDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefControllerDeviceName.group)
end

TRefControllerDeviceName.from_obj = TRefControllerDeviceName_from_obj

TRefControllerDeviceName.proto_property = {'RefControllerDeviceName'}

TRefControllerDeviceName.default = {''}

TRefControllerDeviceName.struct = {{name = 'RefControllerDeviceName', is_array = false, struct = nil}}

function TRefControllerDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'RefControllerDeviceName', self.RefControllerDeviceName, 'string', false, errs,
        need_convert)

    TRefControllerDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefControllerDeviceName.proto_property, errs, need_convert)
    return self
end

function TRefControllerDeviceName:unpack(_)
    return self.RefControllerDeviceName
end

MBattery.RefControllerDeviceName = TRefControllerDeviceName

---@class MBattery.RefController
---@field RefController integer
local TRefController = {}
TRefController.__index = TRefController
TRefController.group = {}

local function TRefController_from_obj(obj)
    return setmetatable(obj, TRefController)
end

function TRefController.new(RefController)
    return TRefController_from_obj({RefController = RefController})
end
---@param obj MBattery.RefController
function TRefController:init_from_obj(obj)
    self.RefController = obj.RefController
end

function TRefController:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefController.group)
end

TRefController.from_obj = TRefController_from_obj

TRefController.proto_property = {'RefController'}

TRefController.default = {0}

TRefController.struct = {{name = 'RefController', is_array = false, struct = nil}}

function TRefController:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RefController', self.RefController, 'uint8', false, errs, need_convert)

    TRefController:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefController.proto_property, errs, need_convert)
    return self
end

function TRefController:unpack(_)
    return self.RefController
end

MBattery.RefController = TRefController

return MBattery
