# Storage

[TOC]

## 功能简介
1. Storage模块是独立组件管理存储组件，对内提供资源树功能接口，目前storage的版本信息在manifest/hardware子系统中
2. 信息获取：支持从带外或通过BMA获取控制器、硬盘、超级电容、逻辑盘、RAID组信息
3. 对外功能：支持创建、删除、设置逻辑盘；支持设置控制器功能；支持点硬盘定位灯
4. 故障检测：支持控制器健康状态检测、硬盘健康状态检测、逻辑盘健康状态检测以及超级电容健康状态检测
5. 支持RAID卡：当前支持1880RAID卡、博通RAID卡和PMC RAID卡

### 目录结构

```
├── src
│   ├── lualib
│   │   ├── add_event.lua                         --事件上报功能
│   │   ├── array                                 --阵列功能相关
│   │   ├── battery                               --电容功能相关
│   │   ├── bma                                   --直通盘及bma相关功能
│   │   ├── bus_monitor_service.lua               --smbios功能
│   │   ├── common_def.lua                        --公共宏定义
│   │   ├── controller                            --raid卡功能相关
│   │   ├── ctrl_commu_loss_monitor.lua           --raid卡通信丢失检测功能
│   │   ├── drive                                 --硬盘功能相关
│   │   ├── drives                                --硬盘组功能相关
│   │   ├── diagnose                              --误码诊断功能
│   │   ├── error_engine.lua                      --错误引擎功能
│   │   ├── handler                               --配置导入导出功能
│   │   ├── ipmi_service.lua                      --ipmi服务
│   │   ├── link_volume_array_drive_service.lua   --逻辑盘、阵列、物理盘关联功能
│   │   ├── mctp                                  --mctp服务
│   │   ├── method_misc.lua                       --misc服务
│   │   ├── metric_collect.lua                    --硬盘数据采集功能
│   │   ├── nvme                                  --nvme盘功能
│   │   ├── object_manager                        --业务对象相关功能
│   │   ├── os_patition                           --os分区
│   │   ├── pd                                    --硬盘定位功能
│   │   ├── rpc_services                          --rpc方法
│   │   ├── sas_phy
│   │   ├── sml                                   --sml库相关
│   │   ├── storage_app.lua                       --组件服务相关功能
│   │   ├── storage_bus.lua
│   │   ├── storage_mdb_object.lua
│   │   ├── storageconfig
│   │   ├── sync_task.lua                         --基础任务功能
│   │   ├── tasks.lua                             --基础任务功能
│   │   ├── task_service.lua                      --通用任务服务
│   │   └── volume                                --逻辑盘功能
│   ├── lualib-src
│   │   ├── CMakeLists.txt
│   │   └── l_sml                                 --sml服务
│   ├── service
│   │   ├── main.lua
│   │   └── smld.lua
```

## 关键特性

### 博通Raid卡带外管理介绍

（1）介绍

对博通卡进行带外管理时，我们要使用卡的驱动通过I2C与RAID卡进行通讯。在这个过程中，我们需要将BMC的I2C读写函数传递给RAID卡的驱动，供RAID卡的驱动进行调用。由于当前BMC的I2C通道由hwproxy模块进行统一管理，因此我们需要使用插件的方式实现支持I2C的读写。

（2）实现机制

因为BMC的I2C通信实现方式，因此我们引入插件(plugin)的方式来让存储模块使用在hwproxy管理下的I2C总线，下图描述了其中的关系

![简要描述](http://image.huawei.com/tiny-lts/v1/images/8133c9d04eab3c12416d6c036d5c2d87_692x433.png)

- 控制器对象实现具体的功能时，调用注册好的i2c芯片的PluginRequest方法，并传入插件名、函数名和函数参数，插件名用来寻找是哪个插件
- 找到对应的插件后，调用插件的run_cmd函数，创建一个Worker虚拟机，后续的操作都在虚拟机中实现，所以Plugin的协程可以先睡觉
- 在虚拟机中调用实际的sml库中的函数
- sml库中的函数需要使用i2c通信时，将i2c命令打包后使用skynet_send函数将消息发送给plugin所在的skynet服务，并由skynet暂停hwproxy的i2c轮询线程，优先处理当前的i2c通信请求
- 当三方库函数处理结束后，Worker虚拟机会将处理结果发送给plugin，同时唤醒Plugin的协程，并由plugin将信息返回给函数调用方

下图是具体的信息流图：

![信息流图](http://image.huawei.com/tiny-lts/v1/images/95b272538323e27cb3328e6db0b3ea17_1124x530.png)

### 1880及PMC Raid卡代管理介绍
（1）介绍

1880和PMC的raid卡采用MCTP方式和RAID卡进行通信实现带外管理。首先需要正常建立起MCTP链路后才能正常进行数据更新。

（2）实现机制
MCTP组件提供相关服务，将收发信息的接口注册到Storage组件，需要收发信息会组件会调用回调函数进行处理。
- Storage注册的回调接口为：do_mctp_writeread
- 回调函数注册流程：CMD.register_controller

### 通用Raid卡更新流程
下图是Raid卡的一般更新流程：
![image.png](http://image.huawei.com/tiny-lts/v1/images/hi3ms/af215f14f57ffc5b058eddf9a5f24fce_736x963.png@900-0-90-f.png)

## 对外接口

### 资源树接口

#### bmc.kepler.Systems.Storage.StorageConfig

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| StorageConfigReady | 用于控制器配置导入导出场景,标志了所有控制器的状态 | 使用: ReadOnly | 不涉及 | 不涉及 | 不涉及 | 0x01 | 唯一 | 不涉及 |
| VolumesStateAbnormal | 是否存在状态异常的逻辑盘。0：否，1：是 | 使用: ReadOnly | 不涉及 | 不涉及 | 依赖所有Volume对象的State属性 | 不涉及 | 唯一 | 不涉及 |
| DiskPartitionUsagePercentageThreshold | 磁盘分区占用率告警阈值(百分比) | 默认: 100 | % | 不涉及 | 不涉及 | 100 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Diagnose

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| PhyErrorEnabled | PHY误码诊断使能 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| PhyErrorInterval | PHY误码数据采集的时间间隔，单位秒 | 默认: 1800 | 秒 | 不涉及 | PhyErrorEnabled为True时才生效 | 1800 | 不涉及 | 不涉及 |
| PhyErrorMaxRecord | PHY误码在一个OS启动周期内记录的最大条数（有增长的记录） | 默认: 20 | 条 | 不涉及 | PhyErrorEnabled为True时才生效 | 20 | 不涉及 | 不涉及 |
| PhyErrorThreshold | PHY误码单位时间增长过快的判断门限值 | 默认: 100 | dwordcount/s | 不涉及 | PhyErrorEnabled为True时才生效 | 100 | 不涉及 | 不涉及 |
| MaxPhyErrorLogFileRotationCount | PHY误码循环记录的最大文件数 | 默认: 10 | 个 | 不涉及 | PhyErrorEnabled为True时才生效 | 10 | 不涉及 | 不涉及 |
| PhyErrorSelUnlimitFlag | PHY误码是否允许产生多个SEL告警事件 | 默认: false | 不涉及 | 不涉及 | 不涉及 | false | 不涉及 | 不涉及 |

### 控制器对外接口

#### bmc.kepler.Systems.Storage.Controller

| 方法名                 | 类型     | 签名        | 返回值   | 标记 | 描述                     |
|------------------------|----------|-------------|----------|------|--------------------------|
| ClearForeignConfig     | method   | a{ss}       | -        | -    | 一键清除外部配置         |
| ImportForeignConfig    | method   | a{ss}       | -        | -    | 一键导入外部配置         |
| RestoreDefaultSettings | method   | a{ss}       | -        | -    | 恢复默认设置             |
| SetBootDevices         | method   | a{ss}ss     | -        | -    | 设置启动盘               |
| SetCopybackState       | method   | a{ss}y      | -        | -    | 设置回拷开关             |
| SetJBODState           | method   | a{ss}y      | -        | -    | 设置JBOD开关             |
| SetSmarterCopyBackState| method   | a{ss}y      | -        | -    | 设置smart信息错误回拷开关|
| SetWorkMode            | method   | a{ss}yy     | -        | -    | 设置控制器的工作模式     |
| DumpLog                | method   | a{ss}       | u        | -    | 收集RAID控制器信息       |

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Id | 控制器Id, 由软件生成，默认值0xFF | 默认: 255; 使用: ResetPerRetain | 不涉及 | 不涉及 | 不涉及 | 0 | 每张RAID卡对应唯一的Id | 不涉及 |
| Type | 控制器类型 | 不涉及 | 不涉及 | 不涉及 | 与TypeId一一对应 | 不涉及 | 不涉及 | 需兼容新适配的RAID卡 |
| TypeId | 控制器的类型Id | 使用: CSR | 不涉及 | 与TypeId一一对应 | 不涉及 | 不涉及 | 需兼容新适配的RAID卡 |  |
| DeviceName | 对应的PCIeDevice的设备名 | 使用: CSR | 不涉及 | 不涉及 | 关联对应PCIeDevice的DeviceName | 不涉及 | 主键 | 不涉及 |
| Position | 对应的PCIeDevice的位置 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| TemperatureCelsius | 控制器芯片温度 | 使用: CSR | °C | 不涉及 | TemperatureAbnormal为0才有效 | 不涉及 | 不涉及 | 不涉及 |
| TemperatureAbnormal | 温度异常描述，温度获取失败时置1 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Name | 控制器名称 | 使用: CSR | 不涉及 | 不涉及 | 不支持带外管理则为CSR配置，否则带外获取 | 不涉及 | 不涉及 | 不涉及 |
| OOBSupport | 支持带外管理模式，0：不支持带外；1：支持带外 | 使用: CSR, PoweroffPer | 不涉及 | 不涉及 | 可以通过IPMI命令持久化或非持久化的修改 | 不涉及 | 不涉及 | 不涉及 |
| FirmwareVersion | 控制器固件版本 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedMode | 控制器工作模式 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| MemorySizeMiB | 控制器内存大小，单位MB | 不涉及 | MiB | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DeviceInterface | 控制器设备接口 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SASAddr | 控制器SAS地址 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 唯一 | 不涉及 |
| SerialNumber | 控制器序列号 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 唯一 | 不涉及 |
| MaxStripSizeBytes | 控制器支持的最大条带 | 不涉及 | Bytes | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 唯一 | 不涉及 |
| MinStripSizeBytes | 控制器支持的最小条带 | 不涉及 | Bytes | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 唯一 | 不涉及 |
| NVDataVersion | 控制器配置版本 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| MaintainPDFailHistrory | 是否启用控制器的物理盘故障记忆功能 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| PCIeLinkWidth | 控制器的PCIE带宽 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| UnconfiguredDriveWriteCachePolicy | 非RAID组成员盘的写缓存策略:Enabled,Disabled,Default | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| HBADriveWriteCachePolicy | HBA模式下硬盘的写缓存策略:Enabled,Disabled,Default | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| ConfiguredDriveWriteCachePolicy | RAID组成员盘的写缓存策略:Enabled,Disabled,Default | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedRAIDTypes | RAID级别 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SmarterCopyBackState | RAID控制器在检测到物理盘SMART错误之后是否自动进行Copyback | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| CopyBackState | 指定控制器的回拷功能使能状态 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| BootDevices | 控制器的启动设备列表 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| HardwareRevision | 控制器的硬件版本 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| HotSpareActivationMode | 控制器的热备激活模式:Failure,Predictive,Unknown | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| NoBatteryWriteCacheEnabled | 控制器的无电池写缓存模式 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| ReadCachePercent | 控制器的读缓存百分比，取值范围：0~100 | 默认: 255 | % | 不涉及 | 依赖OOBSupport为1 | 255 | 不涉及 | 不涉及 |
| JBODState | 控制器的JBOD功能状态：false，true | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| CachePinnedState | 控制器的Cache Pinned开关 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DDREccCount | DDR ECC计数 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| WorkMode | 控制器的工作模式, 包括RAID、HBA、JBOD和MIXED四种 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefDrives | 控制器下挂载的所有硬盘名 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1进行点灯流程，与Drive对象的RefControllerId对应 | 不涉及 | 不涉及 | 不涉及 |
| BOMNumber | BOM编码 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CryptoEraseSupported | 驱动器是否支持加密盘数据擦除 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| EpdSupported | 控制器是否支持启用硬盘模式增强 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| JbodSupported | 当前控制器是否支持以直通方式管理硬盘,此属性由系统自动获取，禁止外部设置 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefChip |  | 使用: CSR | 不涉及 | 不涉及 | 引用接口: bmc.kepler.Chip.BlockIO | 不涉及 | 不涉及 | 特定RAIDCSR中配置 |
| DevBus |  | 使用: CSR | 不涉及 | 不涉及 | 关联对应PCIeDevice对象的DevBus | 不涉及 | 不涉及 | 不涉及 |
| DevDevice |  | 使用: CSR | 不涉及 | 不涉及 | 关联对应PCIeDevice对象的DevDevice | 不涉及 | 不涉及 | 不涉及 |
| DevFunction |  | 使用: CSR | 不涉及 | 不涉及 | 关联对应PCIeDevice对象的DevFunction | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Controller.ConsistencyCheck

| 方法名       | 类型     | 签名      | 返回值 | 标记 | 描述       |
|--------------|----------|-----------|--------|------|------------|
| Disable      | method   | a{ss}     | -      | -    | 禁用       |
| Enable       | method   | a{ss}qyyu | -      | -    | 使能开关   |
| SetParameters| method   | a{ss}qyy  | -      | -    | 设置参数   |

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| State | RAID控制器一致性校验功能状态 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| PeriodOfHours | RAID控制器一致性校验周期，单位(小时), 取值范围[1:1440] | 不涉及 | 小时 | 不涉及 |依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| Rate | RAID控制器一致性校验速率 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| AutoRepairEnabled | RAID控制器一致性校验自修复开关 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RunningStatus | RAID控制器一致性校验状态 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| TotalVolumeCounts | RAID控制器一致性校验需要校验的总数量 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| CompletedVolumeCounts | RAID控制器一致性校验运行已经完成的数量 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DelayToStart | RAID控制器一致性校验任务的等待开始时间，取值范围[0:24]，时间单位：h | 不涉及 | 小时 | 不涉及 |依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| Rate | RAID控制器一致性校验速率 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSuppor

#### bmc.kepler.Systems.Storage.Controller.VolumeManage

| 方法名                | 类型     | 签名               | 返回值 | 标记 | 描述                   |
|-----------------------|----------|--------------------|--------|------|------------------------|
| CreateCachecadeVolume | method   | a{ss}ayysyquyqy    | u      | -    | 创建cachecade逻辑盘    |
| CreateVolumeInExisingtArray | method | a{ss}qyyysuyyyyyyyyy | u | - | 在现有阵列上创建逻辑盘 |
| CreateVolumeInNewArray| method   | a{ss}ayyysuyyyyyyyyy | u | - | 在新的阵列上创建逻辑盘 |
| DeleteVolume          | method   | a{ss}q             | u      | -    | 删除逻辑盘             |

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| CreateVolumeSupported | 控制器是否支持创建逻辑盘 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedReadPolicyList | 支持的逻辑盘读策略列表 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DefaultReadPolicy | 默认的逻辑盘读策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| ReadPolicyWritable | 支持修改逻辑盘读策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedWritePolicyList | 支持的逻辑盘写策略列表 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DefaultWritePolicy | 默认的逻辑盘写策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| WritePolicyWritable | 支持修改逻辑盘写策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedIOPolicyList | 支持的逻辑盘IO策略列表 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DefaultIOPolicy | 默认的逻辑盘IO策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| IOPolicyWritable | 支持修改逻辑盘IO策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedAccessPolicyList | 支持的逻辑盘访问策略列表 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DefaultAccessPolicy | 默认的逻辑盘访问策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| AccessPolicyWritable | 支持修改逻辑盘访问策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| SupportedDriveCachePolicyList | 支持的逻辑盘硬盘缓存策略列表 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DefaultDriveCachePolicy | 默认的逻辑盘硬盘缓存策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DriveCachePolicyWritable | 支持修改逻辑盘硬盘缓存策略 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Controller.Driver

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Name | 控制器驱动器名称 | 不涉及 | 不涉及 | 不涉及 | 依赖ibma | 不涉及 | 不涉及 | 不涉及 |
| Version | 控制器驱动器版本 | 不涉及 | 不涉及 | 不涉及 | 依赖ibma | 不涉及 | 不涉及 | 不涉及 |
#### bmc.kepler.Systems.Storage.Controller.Chip

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Model | raid卡芯片型号 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| ChipManufacturer | raid卡芯片厂商 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Controller.ControllerStatus

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| FaultCode | RAID卡的故障码，每一位代表一种故障 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| CommunicationLoss | 通信丢失 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| Health | RAID卡的健康状态 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| FaultCodeByBios | 通过Bios设置的RAID卡故障码 | 使用: CSR, ResetPer | 不涉及 | 不涉及 | 通过IPMI命令设置 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Controller.BatteryStatus

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| BatteryPresence | RAID卡BBU的在位状态 | 默认: 255; 使用: CSR, ResetPer | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| BatteryFault | BBU故障 | 默认: 0; 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| BatteryHealth | BBU健康状态 | 默认: 0; 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| TemperatureCelsius | BBU温度 | 使用: CSR | °C | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |

### SASPhy对外接口
#### bmc.kepler.Systems.Storage.PhyError (SASPhy)

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| PhyId | PHY误码Id | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 每个RAID卡下唯一 | 不涉及 |
| InvalidDwordCount | 无效DWORD数 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| LossDwordSyncCount | 丢失DWORD同步数 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| PhyResetProblemCount | PHY重启问题数 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RunningDisparityErrorCount | 连续不均衡性错误数 | 使用: CSR | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |

### 阵列对外接口
#### bmc.kepler.Systems.Storage.DiskArray

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Id | RAID组的序号，由RAID卡读到 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 每个RAID卡下唯一 | 不涉及 |
| UsedSpaceMiB | RAID组的已使用的空间 | 应小于TotalFreeSpaceMiB | MiB | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| TotalFreeSpaceMiB | RAID组的空闲空间 | 不涉及 | MiB | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| FreeBlocksSpaceMiB | RAID组的空闲块容量列表 | 应小于TotalFreeSpaceMiB | MiB | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefVolumes | RAID组的关联逻辑盘列表，例：[145, 144] | 与Volume的RefDiskArrayList对应 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefDrives | RAID组的关联物理盘列表，例：[Disk0, Disk1] | 与Drive的RefDiskArrayId对应 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| DriveNumPerSpan | 驱动器阵列中每个Span的成员的个数 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RAIDType | 驱动器阵列组成的虚拟磁盘的级别 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| AverageDriveFreeSpaceMiB | 指定驱动器阵列中每个驱动器的剩余容量 | 不涉及 | MiB | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefControllerId | RAID组关联的控制器ID | 对应的Id的RAID卡存在 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefPDSlots | 关联的物理盘槽位（RAID卡上报的） | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| RefPDEnclosures | 关联的物理盘框位（RAID卡上报的）| 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |

### 超级电容对外接口
#### bmc.kepler.Systems.Storage.Battery

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Name | BBU名称 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| State | BBU在位信息 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| Fault | BBU故障标志 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| HealthStatus | bit0:电压过低,bit1:需要更换BBU,bit2:电量校准失败,bit3:电量校准超时,bit4:预故障,bit5:剩余容量低,bit6:没有用于缓存卸载的空间,others:resrved | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| Health | BBU健康状态 | 不涉及 | 不涉及 | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |
| TemperatureCelsius | BBU温度 | 不涉及 | °C | 不涉及 | 依赖OOBSupport为1 | 不涉及 | 不涉及 | 不涉及 |

### 硬盘对外接口

#### bmc.kepler.Systems.Storage.Drives

| 方法名                      | 类型     | 签名      | 返回值        | 标记 | 描述                   |
|-----------------------------|----------|-----------|---------------|------|------------------------|
| CollectIODeteriorationDiagInfo | method | a{ss}     | u             | -    | 收集硬盘IO信息         |
| GetDrivesSubHealthDiagInfo  | method   | a{ss}y    | aa{ua{ss}}    | -    | 收集硬盘亚健康诊断信息 |
| SetDriveSubHealthDiagResult | method   | a{ss}sq   | -             | -    | 设置硬盘亚健康诊断结果 |

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| MaxTemperatureCelsius | 驱动器最高温度，用于风扇调速 | 不涉及 | °C | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| LogAutoCollectEnable | 硬盘日志自动收集开启状态 | 默认: true; 使用: PoweroffPer | 不涉及 | 不涉及 | 不涉及 | true | 不涉及 | 不涉及 |
| LogAutoCollectInterval | 硬盘日志自动收集周期 | 默认: 24; 使用: PoweroffPer | 不涉及 | 不涉及 | LogAutoCollectEnable为true才有效 | 24 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Drive

| 方法名                 | 类型     | 签名      | 返回值 | 标记 | 描述               |
|------------------------|----------|-----------|--------|------|--------------------|
| CryptoErase            | method   | a{ss}     | -      | -    | 加密擦除           |
| SetBootPriority        | method   | a{ss}y    | -      | -    | 设置启动优先级     |
| SetFaultIndicatorState | method   | a{ss}y    | -      | -    | 设置故障灯状态     |
| SetFirmwareStatus      | method   | a{ss}y    | -      | -    | 设置固件状态       |
| SetHotspareType        | method   | a{ss}yq   | -      | -    | 设置热备盘         |
| SetLocationIndicatorState | method | a{ss}y    | -      | -    | 设置定位灯状态     |
| SetPatrolState         | method   | a{ss}y    | -      | -    | 设置巡检状态       |

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| NodeId | 资源的唯一Id | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Id | 硬盘Id,CSR配置 由软件更新| 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 主键 | 不涉及 | 不涉及 |
| SlotNumber | 硬盘槽位号 | 默认: 255; 使用: ResetPer | 不涉及 | 不涉及 | RAID卡定位成功后更新 | 255 | 不涉及 | 不涉及 |
| Name | 硬盘名称，Disk1等 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Presence | 硬盘在位状态,0不在位,1在位 | 默认: 255; 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| LocateLed | 硬盘locate寄存器的值 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| FaultLed | 硬盘fault寄存器的值 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| EnclosureId | 硬盘所在背板的id，由控制器分配 | 默认: 65535; 使用: ResetPer | 不涉及 | 不涉及 | RAID卡定位成功后更新 | 255 | 不涉及 | 不涉及 |
| LocationIndicatorState | 硬盘定位状态，根据locate寄存器和fault寄存器判断 | 不涉及 | 不涉及 | 不涉及 | 依赖LocateLed和FaultLed | 不涉及 | 不涉及 | 不涉及 |
| CapacityMiB | 硬盘容量，以MiB为单位 | 默认: 4294967295; 使用: ResetPer | MiB | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| TemperatureCelsius | 硬盘温度，硬盘存在零下负温场景 | 默认: 255; 使用: CSR | °C | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Model | 硬盘型号，比如MBF2300RC | 默认: N/A; 使用: ResetPer | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Protocol | 硬盘接口类型：0:Unknown,1:parallel.SCSI,2:SAS,3:SATA,4:FC | 默认: 255; 使用: ResetPer | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CapableSpeedGbs | 硬盘接口速率（最大速率） | 默认: 255; 使用: ResetPer | Gb/s | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| NegotiatedSpeedGbs | 硬盘连接速率（协商速率） | 默认: 255; 使用: ResetPer | Gb/s | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| MediaType | 硬盘介质类型：0:HDD,1:SSD,2:SSM,255:Unknown | 默认: 255; 使用: ResetPer | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| FirmwareStatus | 硬盘固件状态 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SerialNumber | 硬盘序列号 | 默认: N/A; 使用: CSR, ResetPer | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 唯一 | 不涉及 |
| Manufacturer | 硬盘厂商 | 默认: N/A; 使用: ResetPer | 不涉及 | 不涉及 | 与ManufacturerId一一对应 | 不涉及 | 不涉及 | 不涉及 |
| PowerOnHours | 硬盘通电时间 | 不涉及 | 小时 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Revision | 硬盘固件版本 | 默认: N/A; 使用: ResetPer | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RotationSpeedRPM | 硬盘转速 | HDD盘该属性才有效 | RPM | 不涉及 | 依赖MediaType | 不涉及 | 不涉及 | 不涉及 |
| BlockSizeBytes | 硬盘块大小 | 不涉及 | Bytes | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SASAddress1 | 硬盘SAS地址的第一部分 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SASAddress2 | 硬盘SAS地址的第二部分 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Location | 表示当前盘的物理位置 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| PredictedMediaLifeLeftPercent | 硬盘剩余磨损率，即剩余擦写次数的百分比（0-100，或者255表示无效） | SSD盘才有效 | % | 不涉及 | 依赖MediaType | 255 | 不涉及 | 不涉及 |
| PredictedFailCount | 硬盘预故障错误统计 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| MediaErrorCount | 硬盘媒介错误统计 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| OtherErrorCount | 硬盘其他错误统计 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| PatrolState | 硬盘巡检状态：0:没有巡检或巡检结束，1:巡检中，255:未知 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| PowerState | 硬件电源状态 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RebuildState | 硬盘重构状态：0:没有重建或重建结束，1:重建中，255:未知 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RebuildProgress | 硬盘重构进度 |RAID卡管理的盘才有效 | 不涉及 | 不涉及 | RebuildState为1才有效 | 不涉及 | 不涉及 | 不涉及 |
| BootPriority | 硬盘启动盘优先级 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| HotspareType | 硬盘热备状态 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RefControllerId | 关联的控制器Id | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RefVolumeList | 关联的逻辑盘Id列表 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 与Volume的RefDriveList对应 | 不涉及 | 不涉及 | 不涉及 |
| RefDiskArrayId | 关联的硬盘阵列Id | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 与DiskArray的RefDrives对应 | 不涉及 | 不涉及 | 不涉及 |
| ManufacturerId | 厂商Id | 不涉及 | 不涉及 | 不涉及 | 与Manufacturer一一对应 | 不涉及 | 不涉及 | 不涉及 |
| PCIeLinkSpeed | PCIe单个通道的速率 | NVMe盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| ResourceId | 表示当前盘的资源归属 | NVMe盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| PassThrough | 硬盘是否直通，1：是，0：否 | 默认: 255; 使用: CSR | 不涉及 | 不涉及 | CSR中关联寄存器 | 不涉及 | 不涉及 | 不涉及 |
| HddBackplaneStartSlot | 所在硬盘背板的起始槽位 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RelativeSlot | 相对槽位 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 每块硬盘背板下唯一 | 不涉及 |
| LinkFault | 链路状态 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SetLocateLed | 用于点硬盘定位灯 | 关联对应可写寄存器 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SetFaultLed | 用于点硬盘故障灯 | 关联对应可写寄存器 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CommandTimeoutTimes | 硬盘IO超时次数 | 默认: 0; 使用: PoweroffPer | 不涉及 | RAID卡管理的盘才有效 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 |
| UnexpectedSenseTimes | 预期之外的错误次数 | 默认: 0; 使用: PoweroffPer | 不涉及 | 不涉及 | RAID卡管理的盘才有效 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Drive.DriveStatus

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Missing | 硬盘丢失标志 | 默认: 0; 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| PredictiveFailure | 预故障标志 | 默认: 0; 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| InAFailedArray | 是否处于一个故障的硬盘阵列。0：否，1：是 | RAID组下的盘才有效 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CapacityError | 硬盘容量是否异常 | 默认: false; 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| FirmwareStatusError | 硬盘固件状态是否异常 | 默认: false; 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Failure | 硬盘是否故障 | 默认: false; 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| Health | 硬盘健康状态 | 使用: CSR | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Drive.DriveSubHealth

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| EstimatedRemainingLifespanInsufficient | 剩余动态预估寿命不足 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SLCSpareBlockPercentage | 非用户区空闲块百分比 | 默认: 255; 使用: CSR | % | 不涉及 | SSD盘才有效 | 不涉及 | 不涉及 | 不涉及 |
| TLCSpareBlockPercentage | 用户区空闲块百分比 | 默认: 255; 使用: CSR | % | 不涉及 | SSD盘才有效 | 不涉及 | 不涉及 | 不涉及 |
| EstimatedRemainingLifespan | 剩余动态预估寿命 | 默认: 4294967295; 使用: CSR, PoweroffPer | 不涉及 | 不涉及 | SSD盘才有效 | 不涉及 | 不涉及 | 不涉及 |
| IODeteriorationHealthCode | 硬盘IO性能健康码 | 默认: 0; PoweroffPer | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Drive.NVMe

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| LifeUsedPercentage | 硬盘已使用寿命百分比 | 不涉及 | % | 不涉及 | NVMe盘才有效 | 不涉及 | 不涉及 | 不涉及 |

#### bmc.kepler.Systems.Storage.Drive.NVMe.SMART

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| AvailableSpare | 驱动器可用冗余空间的百分比（0到100） | 不涉及 | % | 不涉及 | NVMe盘才有效 | 不涉及 | 不涉及 | 不涉及 |
| CriticalWarning | 控制器状态的重要的告警,bit0:表示冗余空间小于设定的阈值,bit1:表示温度超过或低于一个重要的阈值,bit2:表示由于重要的media错误，器件的可靠性已经降低,bit3:该介质已经被置为只读模式,bit4:表示控制器的易失性器件fail，该域仅在控制器内部存在易失性器件时有效,bit5-7:保留 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| UsedPercentage | 用户实际使用和厂家设定的器件寿命的百分比（0到100） | 不涉及 | % | 不涉及 | NVMe盘才有效 | 不涉及 | 不涉及 | 不涉及 |
| Status | SMART告警状态 | 不涉及 | 不涉及 | 不涉及 | 依赖CriticalWarning | 不涉及 | 不涉及 | 不涉及 |

### 逻辑盘对外接口

#### bmc.kepler.Systems.Storage.Volume

| 方法名               | 类型     | 签名      | 返回值 | 标记 | 描述               |
|----------------------|----------|-----------|--------|------|--------------------|
| CancelForegroundInit | method   | a{ss}     | u      | -    | 取消前台初始化     |
| SetAccelerator       | method   | a{ss}y    | -      | -    | 设置加速方法       |
| SetAccessPolicy      | method   | a{ss}y    | -      | -    | 设置获取策略       |
| SetBGIEnable         | method   | a{ss}y    | -      | -    | 设置bgi使能        |
| SetBootable          | method   | a{ss}y    | -      | -    | 设置启动优先级     |
| SetCachecadeEnable   | method   | a{ss}y    | -      | -    | 设置cache使能      |
| SetDiskCachePolicy   | method   | a{ss}y    | -      | -    | 设置逻辑盘cache策略|
| SetIOPolicy          | method   | a{ss}y    | -      | -    | 设置IO策略         |
| SetName              | method   | a{ss}s    | -      | -    | 设置名称           |
| SetReadPolicy        | method   | a{ss}y    | -      | -    | 设置读策略         |
| SetWritePolicy       | method   | a{ss}y    | -      | -    | 设置写策略         |
| SetCapacitySize      | method   | a{ss}uy   | -      | -    | 设置容量           |
| SetStripSize         | method   | a{ss}y    | -      | -    | 设置条带大小       |

**属性**

| 字段 | 说明 | 约束 | 单位 | 互斥关系 | 依赖关系 | 格式样例 | 唯一性要求 | 兼容性要求 |
|------|------|------|------|----------|----------|----------|------------|------------|
| Id | 逻辑盘的Id | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 每个RAID卡下唯一 | 不涉及 |
| VolumeName | 逻辑盘的名称 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| OptimumIOSizeBytes | 逻辑盘的条带大小 | 不涉及 | Byte | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| DefaultReadPolicy | 逻辑盘的默认读策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| DefaultWritePolicy | 逻辑盘的默认写策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| State | 逻辑盘的状态 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RAIDType | 逻辑盘的Raid级别 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 依赖Controller的SupportRAIDType | 不涉及 | 不涉及 | 不涉及 |
| CapacityBytes | 逻辑盘的容量 | 不涉及 | Byte | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| DriveCachePolicy | 逻辑盘的硬盘缓存策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CurrentForegroundInitState | 逻辑盘当前是否在FGI中 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| ForegroundInitProgress | 逻辑盘当前的FGI进度，百分比 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 依赖CurrentForegroundInitState | 不涉及 | 不涉及 | 不涉及 |
| CurrentReadPolicy | 逻辑盘当前读策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CurrentWritePolicy | 逻辑盘当前写策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| BootPriority | 启动优先级 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 依赖BootEnable | 不涉及 | 不涉及 | 不涉及 |
| BootEnable | 是否为启动盘 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| OSDriveName | 逻辑盘对应的OS盘符 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| BGIEnable | 后台初始化使能状态 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SSDCachecadeVolume | 是否为CacheCade逻辑盘 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| SSDCachingEnable | 是否可使用CacheCade逻辑盘 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| AssociatedVolumes | 所关联的普通逻辑盘的访问路径 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| AssociatedCacheCadeVolume | 所关联的CacheCade逻辑盘的访问路径 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| DefaultCachePolicy | 逻辑盘默认的Cache策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| AccessPolicy | 逻辑盘的访问策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CurrentCachePolicy | 逻辑盘当前Cache策略 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| CacheLineSizeKiB | 缓存行大小 | 不涉及 | KiB | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| AccelerationMethod | 加速方法 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RebuildProgress | 指定逻辑盘数据重建进度 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 依赖RebuildState为1 | 不涉及 | 不涉及 | 不涉及 |
| InitializationMode | 初始化模式 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RebuildState | 指定逻辑盘数据重建状态 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| RefControllerId | 指定逻辑盘所属控制器id | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 为所关联的RAID卡Id | 不涉及 | 不涉及 | 不涉及 |
| RefDriveList | 指定逻辑盘关联的物理盘列表 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 依赖Drive的RefVolumeList | 不涉及 | 不涉及 | 不涉及 |
| RefDiskArrayList | 指定逻辑盘关联的阵列列表 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 依赖DiskArray的RefVolumeList | 不涉及 | 不涉及 | 不涉及 |
| HotSpareDriveList | 逻辑盘关联热备盘列表 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 对应硬盘的HotSpare不为0 | 不涉及 | 不涉及 | 不涉及 |
| SpanCount | 逻辑盘包含的子组数 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 与NumDrivePerSpan可得到逻辑盘下的物理盘总数 | 不涉及 | 不涉及 | 不涉及 |
| MaxResizableSizeBytes | 逻辑盘的最大可设置的容量 | 不涉及 | Byte | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 | 不涉及 |
| NumDrivePerSpan | 不涉及 | 不涉及 | 不涉及 | 不涉及 | SpanCount | 不涉及 | 不涉及 | 不涉及 |


### IPMI命令
- 具体详细请参考：mds/ipmi.json

```
└─/bmc
  └─/bmc/kepler
    ├─/bmc/kepler/IpmiCmds
    │ ├─/bmc/kepler/IpmiCmds/30
    │ │ ├─/bmc/kepler/IpmiCmds/30/92
    │ │ │ └─/bmc/kepler/IpmiCmds/30/92/SetRaidFaultStatus                 设置raid卡硬件故障
    │ │ └─/bmc/kepler/IpmiCmds/30/93
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/CreateCachecadeLogicalDrive        创建CacheCade逻辑盘
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/CreateLogicalDriveOnExistedArray   在已有的DiskArray上创建逻辑盘
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/CreateLogicalDriveOnNewArray       在新的DiskArray上创建逻辑盘
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/DeleteLogicalDrive                 删除指定的逻辑盘
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetArrayInfo                       获取指定RAID控制器的Disk Array的信息
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetArrayLds                        获取指定Array上的逻辑盘ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetArrayLdsEx                      获取指定Array上的逻辑盘ID列表, ID是16bit数据
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetArrayList                       查询指定RAID控制器下的DiskArray ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetArrayPds                        获取指定Array的物理盘ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetCachecadeAssociatedLds          查询CacheCade逻辑盘关联的普通逻辑盘ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetCachecadeAssociatedLdsEx        查询CacheCade逻辑盘关联的普通逻辑盘ID列表(ID是16bit数据)
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetControllerCapability            获取RAID带外管理能力
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetControllerFwVersion             查询RAID控制器的Firmware版本信息
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetControllerInfo                  查询RAID控制器的配置信息
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetControllerList                  查询RAID控制器的ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetControllerNvdataVersion         查询RAID控制器的NVDATA版本信息
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetControllerPds                   查询指定RAID控制器管理的物理盘ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetDiskManufacturer                查询指定物理盘厂商
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetDiskSilk                        查询指定硬盘丝印信息
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetHddPwrStatus                    查询硬盘的通电状态
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetLogicalDriveList                查询RAID控制器下的逻辑盘ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetLogicalDriveListEx              查询RAID控制器下的逻辑盘ID列表(ID为16bit数据)
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetLogicalDrivePds                 查询指定逻辑盘的物理成员盘ID列表
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetPhysicalDriveInfo               查询指定逻辑盘的基本信息
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetPhysicalDriveLedStatus          查询硬盘灯状态
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetPhysicalDriveLocation           查询指定物理盘的位置信息（丝印）
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/GetRaidControllerTemp              查询raid控制器温度
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetControllerCopyback              修改指定RAID控制器是否启用Copyback功能
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetControllerJbod                  设置指定RAID控制器是否开启JBOD功能
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetControllerOutofband             设置指定RIAD控制器是否支持带外管理
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetControllerRestoreSettings       恢复指定RAID控制器到初始设置
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetControllerSmarterCopyback       设置指定RAID控制器在检测到物理盘SMART错误之后是否自动进行Copyback
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetFirmwareStatus                  设置固件状态
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetHotspareType                    设置设备盘类型
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLocationIndicatorState          设置定位灯状态
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicDriveBootable              设置指定逻辑盘为启动盘
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicDriveRp                    设置指定逻辑盘的读策略
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicDriveWp                    设置指定逻辑盘的写策略
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicalDriveAP                  设置指定逻辑盘的访问策略
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicalDriveBGI                 设置指定逻辑盘的BGI使能状态
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicalDriveCachecade           设置指定逻辑盘是否关联CacheCade逻辑盘
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicalDriveDCP                 设置指定逻辑盘的Disk缓存策略
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicalDriveIOP                 设置指定逻辑盘的IO策略
    │ │   ├─/bmc/kepler/IpmiCmds/30/93/SetLogicalDriveName                设置逻辑盘名称
    │ │   └─/bmc/kepler/IpmiCmds/30/93/SetPdLogCollect                    主动触发硬盘日志收集
    │ └─/bmc/kepler/IpmiCmds/38
    │   └─/bmc/kepler/IpmiCmds/38/13
    │     ├─/bmc/kepler/IpmiCmds/38/13/GetNvmeInfo                        获取nvme盘信息
    │     └─/bmc/kepler/IpmiCmds/38/13/GetNvmeNum                         获取nvme盘数量
```

## 配置介绍

### 配置NVME盘
1.在硬盘背板上面配置"Connector_ComVPDConnect_x"对象，关键字段："Bom":"14140224", "Id":"VPD", "AuxId":"0"，固定配置。
2.跟据Bom+Id+AuxId组合找到对应的文件14140224_VPD_0.sr。
3.然后框架会进一步加载14140224_VPD_0.sr文件中定义2个对象：
- "Connector_ComVPD"对象，关键字段："Bom":"14140224","Id":"PROTOCOL","AuxId":"255"。
- "VirtualVPDConnect"对象，关键字段："RefVPDChip":"#/Chip_Virtual_SSD","RefConnector":"#/Connector_ComVPD"。

4.Storage组件会通过"VirtualVPDConnect"对象从NVME盘中读取协议信息并更新到"Connector_ComVPD"对象的"AuxId"上，用于表示NVME支持的具体协议。
- 支持协议有：NVME_VPD_PROTOCOL_NVME_MI = 0, NVME_VPD_PROTOCOL_SSD_FORM_FACTOR = 1, SAMSUNG_NVME_VPD_PROTOCOL_SSD_FORM_FACTOR = 2

5.更新之后，框架会进一步利用Bom+Id+AuxId组合来加载具体的协议文件，比如：14140224_PROTOCOL_0.sr，14140224_PROTOCOL_0_soft.sr
6.在14140224_PROTOCOL_0.sr中定义有具体的Nvme_1对象，也就是对应Storage的c_nvme对象。


