-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: The unit test for sensor utils interfaces.
local lu = require 'luaunit'
local utils = require 'sensor_utils'

test_sensor_utils = {}

function test_sensor_utils.test_tos()
    lu.assertEquals(utils.tos(0x64, 10), 100)
    lu.assertEquals(utils.tos(3, 4), 3)
    lu.assertEquals(utils.tos(0x0E, 4), -2)
    lu.assertEquals(utils.tos(27, 5), -5)
end

function test_sensor_utils.test_toc()
    lu.assertEquals(utils.toc('aaa', 8), 'aaa')
    lu.assertEquals(utils.toc(true, 8), true)
    lu.assertEquals(utils.toc(nil, 8), nil)
    lu.assertEquals(utils.toc(0x41, 8), 'A')
    lu.assertEquals(utils.toc(0x414243, 24), 'ABC')
    lu.assertEquals(utils.toc(0x414243, 16), 'BC')
    lu.assertEquals(utils.toc(0x414243, 24, true), 'CBA')
    lu.assertEquals(utils.toc(0x414243, 16, true), 'CB')
end

function test_sensor_utils.test_toww()
    lu.assertEquals(utils.toww(0x12, 0x34, 0x56, 0x78), 0x12345678)
    lu.assertEquals(utils.toww(0x24, 0x00, 0x00, 0xEE), 0x240000EE)
end

function test_sensor_utils.test_utos()
    lu.assertEquals(utils.utos_byte(0), 0)
    lu.assertEquals(utils.utos_byte(127), 127)
    lu.assertEquals(utils.utos_byte(128), -128)
    lu.assertEquals(utils.utos_byte(129), -127)
end

function test_sensor_utils.test_format_system_id()
    local path = '/bmc/kepler/Systems/1/ThresholdSensors'
    lu.assertEquals(utils.format_system_id(path), 1)

    path = '/bmc/kepler/Systems/2/ThresholdSensors/ThresholdSensor_InletTemp_0101'
    lu.assertEquals(utils.format_system_id(path), 2)
end

function test_sensor_utils.test_is_in()
    -- 测试数组
    local names = {'EntityId', 'SensorName', 'Reading'}
    lu.assertEquals(utils.is_in('EntityId', names), true)
    lu.assertEquals(utils.is_in('Reading', names), true)
    lu.assertEquals(utils.is_in('Disabled', names), false)

    -- 测试表
    names = {EntityId = 7, SensorName = 'Test Sensor', Reading = 30.0}
    lu.assertEquals(utils.is_in('EntityId', names), true)
    lu.assertEquals(utils.is_in('Reading', names), true)
    lu.assertEquals(utils.is_in('Disabled', names), false)
end

return test_sensor_utils