-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: The unit test for sel common interfaces.
local lu = require 'luaunit'
local sdr_management = require 'sdr.sdr_management'

test_fru = {}
function test_fru.test_register_fru()
    local sdr_mgmt_obj = sdr_management.new()
    local obj = {FruDataId = 'test', FruId = 0, FruName = 'TestName', path = 'TestPath', extra_params = {SystemId = 0}}
    sdr_mgmt_obj:register_fru(0, obj)
    lu.assertEquals(sdr_mgmt_obj.sdr_count, 1)

    local ids = {id = 0, name = 'TestName', path = 'TestPath'}
    sdr_mgmt_obj:register_fru(1, ids)
    lu.assertEquals(sdr_mgmt_obj.sdr_count, 2)
end

return test_fru