-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: The unit test for entity common interfaces.
local lu = require 'luaunit'
local mgmt = require 'entity.entity_management'

test_entity_mgmt = {}

function test_entity_mgmt:setupClass()
    self.mgr = mgmt.new()
end

function test_entity_mgmt:teardownClass()
    self.mgr = nil
end

function test_entity_mgmt:test_generate_unique_instance()
    local obj = {
        Id = 1,
        Instance = 1,
        Slot = 3
    }
    local host_id = 1

    local instance = self.mgr:generate_unique_instance(obj, host_id)
    lu.assertEquals(instance, 3)

    obj.Slot = 0xFF
    instance = self.mgr:generate_unique_instance(obj, host_id)
    lu.assertEquals(instance, 1)
end

return test_entity_mgmt