-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: constants for sensor.
local sensor_const = {}
sensor_const.__index = sensor_const

-- 门限传感器的事件类型
sensor_const.OFFSET_NONCRITICAL_LGL = 0
sensor_const.OFFSET_NONCRITICAL_LGH = 1
sensor_const.OFFSET_CRITICAL_LGL = 2
sensor_const.OFFSET_CRITICAL_LGH = 3
sensor_const.OFFSET_NONRECOVERABLE_LGL = 4
sensor_const.OFFSET_NONRECOVERABLE_LGH = 5
sensor_const.OFFSET_NONCRITICAL_UGL = 6
sensor_const.OFFSET_NONCRITICAL_UGH = 7
sensor_const.OFFSET_CRITICAL_UGL = 8
sensor_const.OFFSET_CRITICAL_UGH = 9
sensor_const.OFFSET_NONRECOVERABLE_UGL = 10
sensor_const.OFFSET_NONRECOVERABLE_UGH = 11

-- 传感器访问能力定义
sensor_const.SENSOR_CAP_NOSPECIFIED = 0
sensor_const.SENSOR_CAP_READABLE = 1
sensor_const.SENSOR_CAP_READABLE_SETTABLE = 2
sensor_const.SENSOR_CAP_FIXED = 3

-- 传感器支持的能力集
sensor_const.SENSOR_CAP_EVENT_PER_TRESH = 0
sensor_const.SENSOR_CAP_EVENT_ENTIRE_SENSOR = 1
sensor_const.SENSOR_CAP_EVENT_GLOBAL_DISABLE = 2
sensor_const.SENSOR_CAP_EVENT_NONE = 3

-- 传感器读值类型 SensorReadingType
sensor_const.READING_TYPE_THRESHOLD = 1
sensor_const.READING_TYPE_GENERIC = 2
sensor_const.READING_TYPE_SENSOR_SPECIFIC = 3
sensor_const.READING_TYPE_OEM = 4

-- 传感器更新完成标识
sensor_const.SENSOR_UPDATE_IN_PROGRESS = 0
sensor_const.SENSOR_UPDATE_END = 1

-- 传感器的事件使能选择
sensor_const.SENSOR_EVENT_DONT_CHANGE = 0
sensor_const.SENSOR_EVENT_ENABLE_SELECTED = 1
sensor_const.SENSOR_EVENT_DISABLE_SELECTED = 2

-- 传感器的使能状态
sensor_const.SENSOR_DISALBED = 0
sensor_const.SENSOR_ENABLED = 1

-- 传感器对应器件扫描状态
sensor_const.SCAN_NORMAL = 0
sensor_const.SCAN_FAILURE = 1
sensor_const.SCAN_PRE_FAILURE = 2
sensor_const.SCAN_NOT_ACCESSIBLE = 3
sensor_const.SCAN_NOT_SCANNED = 4

-- 传感器原始值到显示值的计算公式定义
sensor_const.SENSOR_L_LINEAR = 0x00
sensor_const.SENSOR_L_LN = 0x01
sensor_const.SENSOR_L_LOG10 = 0x02
sensor_const.SENSOR_L_LOG2 = 0x03
sensor_const.SENSOR_L_E = 0x04
sensor_const.SENSOR_L_EXP10 = 0x05
sensor_const.SENSOR_L_EXP2 = 0x06
sensor_const.SENSOR_L_1_X = 0x07
sensor_const.SENSOR_L_SQR = 0x08
sensor_const.SENSOR_L_CUBE = 0x09
sensor_const.SENSOR_L_SQRT = 0x0a
sensor_const.SENSOR_L_CUBERT = 0x0b
sensor_const.SENSOR_L_NONLINEAR = 0x70

-- 查询传感器列表的命令类型
sensor_const.GET_THRESHOLD_SENSOR_LIST = 1
sensor_const.GET_ALL_SENSOR_LIST = 2
sensor_const.GET_DISCRETE_SENSOR_LIST= 3

-- 离散传感器离散类型
sensor_const.DISCRETE_NORNAL = 0
sensor_const.DISCRETE_DIGITAL = 1

-- 离散事件侦听模式
sensor_const.COMBO_MODE = 0
sensor_const.SINGLE_MODE = 1

-- SDRDevice对象及属性
sensor_const.SDR_DEVICE = 'SDRDevice'
sensor_const.SENSOR_NUMBER_BASE = 'SensorNumberBase'
sensor_const.DEFAULT_BASE_NUMBER = 1

-- SensorNumber分配情况
sensor_const.UNAPPLIED = 0
sensor_const.APPLIED = 1
sensor_const.CUSTOM_APPLIED = 2

return sensor_const