-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FruCtrl = {}

---@class FruCtrl.PreviousPowerState
---@field PreviousPowerState string
local TPreviousPowerState = {}
TPreviousPowerState.__index = TPreviousPowerState
TPreviousPowerState.group = {}

local function TPreviousPowerState_from_obj(obj)
    return setmetatable(obj, TPreviousPowerState)
end

function TPreviousPowerState.new(PreviousPowerState)
    return TPreviousPowerState_from_obj({PreviousPowerState = PreviousPowerState})
end
---@param obj FruCtrl.PreviousPowerState
function TPreviousPowerState:init_from_obj(obj)
    self.PreviousPowerState = obj.PreviousPowerState
end

function TPreviousPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreviousPowerState.group)
end

TPreviousPowerState.from_obj = TPreviousPowerState_from_obj

TPreviousPowerState.proto_property = {'PreviousPowerState'}

TPreviousPowerState.default = {''}

TPreviousPowerState.struct = {{name = 'PreviousPowerState', is_array = false, struct = nil}}

function TPreviousPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreviousPowerState', self.PreviousPowerState, 'string', true, errs, need_convert)

    TPreviousPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreviousPowerState.proto_property, errs, need_convert)
    return self
end

function TPreviousPowerState:unpack(_)
    return self.PreviousPowerState
end

FruCtrl.PreviousPowerState = TPreviousPowerState

---@class FruCtrl.PowerCycleType
---@field PowerCycleType integer
local TPowerCycleType = {}
TPowerCycleType.__index = TPowerCycleType
TPowerCycleType.group = {}

local function TPowerCycleType_from_obj(obj)
    return setmetatable(obj, TPowerCycleType)
end

function TPowerCycleType.new(PowerCycleType)
    return TPowerCycleType_from_obj({PowerCycleType = PowerCycleType})
end
---@param obj FruCtrl.PowerCycleType
function TPowerCycleType:init_from_obj(obj)
    self.PowerCycleType = obj.PowerCycleType
end

function TPowerCycleType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCycleType.group)
end

TPowerCycleType.from_obj = TPowerCycleType_from_obj

TPowerCycleType.proto_property = {'PowerCycleType'}

TPowerCycleType.default = {0}

TPowerCycleType.struct = {{name = 'PowerCycleType', is_array = false, struct = nil}}

function TPowerCycleType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCycleType', self.PowerCycleType, 'uint8', true, errs, need_convert)

    TPowerCycleType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCycleType.proto_property, errs, need_convert)
    return self
end

function TPowerCycleType:unpack(_)
    return self.PowerCycleType
end

FruCtrl.PowerCycleType = TPowerCycleType

---@class FruCtrl.PowerCtrlFault
---@field PowerCtrlFault integer
local TPowerCtrlFault = {}
TPowerCtrlFault.__index = TPowerCtrlFault
TPowerCtrlFault.group = {}

local function TPowerCtrlFault_from_obj(obj)
    return setmetatable(obj, TPowerCtrlFault)
end

function TPowerCtrlFault.new(PowerCtrlFault)
    return TPowerCtrlFault_from_obj({PowerCtrlFault = PowerCtrlFault})
end
---@param obj FruCtrl.PowerCtrlFault
function TPowerCtrlFault:init_from_obj(obj)
    self.PowerCtrlFault = obj.PowerCtrlFault
end

function TPowerCtrlFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlFault.group)
end

TPowerCtrlFault.from_obj = TPowerCtrlFault_from_obj

TPowerCtrlFault.proto_property = {'PowerCtrlFault'}

TPowerCtrlFault.default = {0}

TPowerCtrlFault.struct = {{name = 'PowerCtrlFault', is_array = false, struct = nil}}

function TPowerCtrlFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCtrlFault', self.PowerCtrlFault, 'uint8', true, errs, need_convert)

    TPowerCtrlFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlFault.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlFault:unpack(_)
    return self.PowerCtrlFault
end

FruCtrl.PowerCtrlFault = TPowerCtrlFault

---@class FruCtrl.LastPowerEvent
---@field LastPowerEvent integer
local TLastPowerEvent = {}
TLastPowerEvent.__index = TLastPowerEvent
TLastPowerEvent.group = {}

local function TLastPowerEvent_from_obj(obj)
    return setmetatable(obj, TLastPowerEvent)
end

function TLastPowerEvent.new(LastPowerEvent)
    return TLastPowerEvent_from_obj({LastPowerEvent = LastPowerEvent})
end
---@param obj FruCtrl.LastPowerEvent
function TLastPowerEvent:init_from_obj(obj)
    self.LastPowerEvent = obj.LastPowerEvent
end

function TLastPowerEvent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLastPowerEvent.group)
end

TLastPowerEvent.from_obj = TLastPowerEvent_from_obj

TLastPowerEvent.proto_property = {'LastPowerEvent'}

TLastPowerEvent.default = {0}

TLastPowerEvent.struct = {{name = 'LastPowerEvent', is_array = false, struct = nil}}

function TLastPowerEvent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LastPowerEvent', self.LastPowerEvent, 'uint8', true, errs, need_convert)

    TLastPowerEvent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLastPowerEvent.proto_property, errs, need_convert)
    return self
end

function TLastPowerEvent:unpack(_)
    return self.LastPowerEvent
end

FruCtrl.LastPowerEvent = TLastPowerEvent

---@class FruCtrl.HotswapState
---@field HotswapState string
local THotswapState = {}
THotswapState.__index = THotswapState
THotswapState.group = {}

local function THotswapState_from_obj(obj)
    return setmetatable(obj, THotswapState)
end

function THotswapState.new(HotswapState)
    return THotswapState_from_obj({HotswapState = HotswapState})
end
---@param obj FruCtrl.HotswapState
function THotswapState:init_from_obj(obj)
    self.HotswapState = obj.HotswapState
end

function THotswapState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THotswapState.group)
end

THotswapState.from_obj = THotswapState_from_obj

THotswapState.proto_property = {'HotswapState'}

THotswapState.default = {''}

THotswapState.struct = {{name = 'HotswapState', is_array = false, struct = nil}}

function THotswapState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HotswapState', self.HotswapState, 'string', true, errs, need_convert)

    THotswapState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THotswapState.proto_property, errs, need_convert)
    return self
end

function THotswapState:unpack(_)
    return self.HotswapState
end

FruCtrl.HotswapState = THotswapState

---@class FruCtrl.GracefulShutdownMinTimeoutSeconds
---@field GracefulShutdownMinTimeoutSeconds integer
local TGracefulShutdownMinTimeoutSeconds = {}
TGracefulShutdownMinTimeoutSeconds.__index = TGracefulShutdownMinTimeoutSeconds
TGracefulShutdownMinTimeoutSeconds.group = {}

local function TGracefulShutdownMinTimeoutSeconds_from_obj(obj)
    return setmetatable(obj, TGracefulShutdownMinTimeoutSeconds)
end

function TGracefulShutdownMinTimeoutSeconds.new(GracefulShutdownMinTimeoutSeconds)
    return TGracefulShutdownMinTimeoutSeconds_from_obj({
        GracefulShutdownMinTimeoutSeconds = GracefulShutdownMinTimeoutSeconds
    })
end
---@param obj FruCtrl.GracefulShutdownMinTimeoutSeconds
function TGracefulShutdownMinTimeoutSeconds:init_from_obj(obj)
    self.GracefulShutdownMinTimeoutSeconds = obj.GracefulShutdownMinTimeoutSeconds
end

function TGracefulShutdownMinTimeoutSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulShutdownMinTimeoutSeconds.group)
end

TGracefulShutdownMinTimeoutSeconds.from_obj = TGracefulShutdownMinTimeoutSeconds_from_obj

TGracefulShutdownMinTimeoutSeconds.proto_property = {'GracefulShutdownMinTimeoutSeconds'}

TGracefulShutdownMinTimeoutSeconds.default = {0}

TGracefulShutdownMinTimeoutSeconds.struct = {
    {name = 'GracefulShutdownMinTimeoutSeconds', is_array = false, struct = nil}
}

function TGracefulShutdownMinTimeoutSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GracefulShutdownMinTimeoutSeconds', self.GracefulShutdownMinTimeoutSeconds, 'uint32',
        true, errs, need_convert)

    TGracefulShutdownMinTimeoutSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulShutdownMinTimeoutSeconds.proto_property, errs, need_convert)
    return self
end

function TGracefulShutdownMinTimeoutSeconds:unpack(_)
    return self.GracefulShutdownMinTimeoutSeconds
end

FruCtrl.GracefulShutdownMinTimeoutSeconds = TGracefulShutdownMinTimeoutSeconds

---@class FruCtrl.GracefulShutdownMaxTimeoutSeconds
---@field GracefulShutdownMaxTimeoutSeconds integer
local TGracefulShutdownMaxTimeoutSeconds = {}
TGracefulShutdownMaxTimeoutSeconds.__index = TGracefulShutdownMaxTimeoutSeconds
TGracefulShutdownMaxTimeoutSeconds.group = {}

local function TGracefulShutdownMaxTimeoutSeconds_from_obj(obj)
    return setmetatable(obj, TGracefulShutdownMaxTimeoutSeconds)
end

function TGracefulShutdownMaxTimeoutSeconds.new(GracefulShutdownMaxTimeoutSeconds)
    return TGracefulShutdownMaxTimeoutSeconds_from_obj({
        GracefulShutdownMaxTimeoutSeconds = GracefulShutdownMaxTimeoutSeconds
    })
end
---@param obj FruCtrl.GracefulShutdownMaxTimeoutSeconds
function TGracefulShutdownMaxTimeoutSeconds:init_from_obj(obj)
    self.GracefulShutdownMaxTimeoutSeconds = obj.GracefulShutdownMaxTimeoutSeconds
end

function TGracefulShutdownMaxTimeoutSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulShutdownMaxTimeoutSeconds.group)
end

TGracefulShutdownMaxTimeoutSeconds.from_obj = TGracefulShutdownMaxTimeoutSeconds_from_obj

TGracefulShutdownMaxTimeoutSeconds.proto_property = {'GracefulShutdownMaxTimeoutSeconds'}

TGracefulShutdownMaxTimeoutSeconds.default = {0}

TGracefulShutdownMaxTimeoutSeconds.struct = {
    {name = 'GracefulShutdownMaxTimeoutSeconds', is_array = false, struct = nil}
}

function TGracefulShutdownMaxTimeoutSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GracefulShutdownMaxTimeoutSeconds', self.GracefulShutdownMaxTimeoutSeconds, 'uint32',
        true, errs, need_convert)

    TGracefulShutdownMaxTimeoutSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulShutdownMaxTimeoutSeconds.proto_property, errs, need_convert)
    return self
end

function TGracefulShutdownMaxTimeoutSeconds:unpack(_)
    return self.GracefulShutdownMaxTimeoutSeconds
end

FruCtrl.GracefulShutdownMaxTimeoutSeconds = TGracefulShutdownMaxTimeoutSeconds

---@class FruCtrl.GracefulShutdownDefaultTimeoutSeconds
---@field GracefulShutdownDefaultTimeoutSeconds integer
local TGracefulShutdownDefaultTimeoutSeconds = {}
TGracefulShutdownDefaultTimeoutSeconds.__index = TGracefulShutdownDefaultTimeoutSeconds
TGracefulShutdownDefaultTimeoutSeconds.group = {}

local function TGracefulShutdownDefaultTimeoutSeconds_from_obj(obj)
    return setmetatable(obj, TGracefulShutdownDefaultTimeoutSeconds)
end

function TGracefulShutdownDefaultTimeoutSeconds.new(GracefulShutdownDefaultTimeoutSeconds)
    return TGracefulShutdownDefaultTimeoutSeconds_from_obj({
        GracefulShutdownDefaultTimeoutSeconds = GracefulShutdownDefaultTimeoutSeconds
    })
end
---@param obj FruCtrl.GracefulShutdownDefaultTimeoutSeconds
function TGracefulShutdownDefaultTimeoutSeconds:init_from_obj(obj)
    self.GracefulShutdownDefaultTimeoutSeconds = obj.GracefulShutdownDefaultTimeoutSeconds
end

function TGracefulShutdownDefaultTimeoutSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulShutdownDefaultTimeoutSeconds.group)
end

TGracefulShutdownDefaultTimeoutSeconds.from_obj = TGracefulShutdownDefaultTimeoutSeconds_from_obj

TGracefulShutdownDefaultTimeoutSeconds.proto_property = {'GracefulShutdownDefaultTimeoutSeconds'}

TGracefulShutdownDefaultTimeoutSeconds.default = {0}

TGracefulShutdownDefaultTimeoutSeconds.struct = {
    {name = 'GracefulShutdownDefaultTimeoutSeconds', is_array = false, struct = nil}
}

function TGracefulShutdownDefaultTimeoutSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GracefulShutdownDefaultTimeoutSeconds', self.GracefulShutdownDefaultTimeoutSeconds,
        'uint32', true, errs, need_convert)

    TGracefulShutdownDefaultTimeoutSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulShutdownDefaultTimeoutSeconds.proto_property, errs, need_convert)
    return self
end

function TGracefulShutdownDefaultTimeoutSeconds:unpack(_)
    return self.GracefulShutdownDefaultTimeoutSeconds
end

FruCtrl.GracefulShutdownDefaultTimeoutSeconds = TGracefulShutdownDefaultTimeoutSeconds

---@class FruCtrl.GracefulShutdownTimeoutSeconds
---@field GracefulShutdownTimeoutSeconds integer
local TGracefulShutdownTimeoutSeconds = {}
TGracefulShutdownTimeoutSeconds.__index = TGracefulShutdownTimeoutSeconds
TGracefulShutdownTimeoutSeconds.group = {}

local function TGracefulShutdownTimeoutSeconds_from_obj(obj)
    return setmetatable(obj, TGracefulShutdownTimeoutSeconds)
end

function TGracefulShutdownTimeoutSeconds.new(GracefulShutdownTimeoutSeconds)
    return TGracefulShutdownTimeoutSeconds_from_obj({GracefulShutdownTimeoutSeconds = GracefulShutdownTimeoutSeconds})
end
---@param obj FruCtrl.GracefulShutdownTimeoutSeconds
function TGracefulShutdownTimeoutSeconds:init_from_obj(obj)
    self.GracefulShutdownTimeoutSeconds = obj.GracefulShutdownTimeoutSeconds
end

function TGracefulShutdownTimeoutSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulShutdownTimeoutSeconds.group)
end

TGracefulShutdownTimeoutSeconds.from_obj = TGracefulShutdownTimeoutSeconds_from_obj

TGracefulShutdownTimeoutSeconds.proto_property = {'GracefulShutdownTimeoutSeconds'}

TGracefulShutdownTimeoutSeconds.default = {0}

TGracefulShutdownTimeoutSeconds.struct = {{name = 'GracefulShutdownTimeoutSeconds', is_array = false, struct = nil}}

function TGracefulShutdownTimeoutSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GracefulShutdownTimeoutSeconds', self.GracefulShutdownTimeoutSeconds, 'uint32', false,
        errs, need_convert)

    TGracefulShutdownTimeoutSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulShutdownTimeoutSeconds.proto_property, errs, need_convert)
    return self
end

function TGracefulShutdownTimeoutSeconds:unpack(_)
    return self.GracefulShutdownTimeoutSeconds
end

FruCtrl.GracefulShutdownTimeoutSeconds = TGracefulShutdownTimeoutSeconds

---@class FruCtrl.GracefulShutdownTimeoutEnabled
---@field GracefulShutdownTimeoutEnabled integer
local TGracefulShutdownTimeoutEnabled = {}
TGracefulShutdownTimeoutEnabled.__index = TGracefulShutdownTimeoutEnabled
TGracefulShutdownTimeoutEnabled.group = {}

local function TGracefulShutdownTimeoutEnabled_from_obj(obj)
    return setmetatable(obj, TGracefulShutdownTimeoutEnabled)
end

function TGracefulShutdownTimeoutEnabled.new(GracefulShutdownTimeoutEnabled)
    return TGracefulShutdownTimeoutEnabled_from_obj({GracefulShutdownTimeoutEnabled = GracefulShutdownTimeoutEnabled})
end
---@param obj FruCtrl.GracefulShutdownTimeoutEnabled
function TGracefulShutdownTimeoutEnabled:init_from_obj(obj)
    self.GracefulShutdownTimeoutEnabled = obj.GracefulShutdownTimeoutEnabled
end

function TGracefulShutdownTimeoutEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulShutdownTimeoutEnabled.group)
end

TGracefulShutdownTimeoutEnabled.from_obj = TGracefulShutdownTimeoutEnabled_from_obj

TGracefulShutdownTimeoutEnabled.proto_property = {'GracefulShutdownTimeoutEnabled'}

TGracefulShutdownTimeoutEnabled.default = {0}

TGracefulShutdownTimeoutEnabled.struct = {{name = 'GracefulShutdownTimeoutEnabled', is_array = false, struct = nil}}

function TGracefulShutdownTimeoutEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GracefulShutdownTimeoutEnabled', self.GracefulShutdownTimeoutEnabled, 'uint32', false,
        errs, need_convert)

    TGracefulShutdownTimeoutEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulShutdownTimeoutEnabled.proto_property, errs, need_convert)
    return self
end

function TGracefulShutdownTimeoutEnabled:unpack(_)
    return self.GracefulShutdownTimeoutEnabled
end

FruCtrl.GracefulShutdownTimeoutEnabled = TGracefulShutdownTimeoutEnabled

---@class FruCtrl.PanelPowerButtonEnabled
---@field PanelPowerButtonEnabled boolean
local TPanelPowerButtonEnabled = {}
TPanelPowerButtonEnabled.__index = TPanelPowerButtonEnabled
TPanelPowerButtonEnabled.group = {}

local function TPanelPowerButtonEnabled_from_obj(obj)
    return setmetatable(obj, TPanelPowerButtonEnabled)
end

function TPanelPowerButtonEnabled.new(PanelPowerButtonEnabled)
    return TPanelPowerButtonEnabled_from_obj({PanelPowerButtonEnabled = PanelPowerButtonEnabled})
end
---@param obj FruCtrl.PanelPowerButtonEnabled
function TPanelPowerButtonEnabled:init_from_obj(obj)
    self.PanelPowerButtonEnabled = obj.PanelPowerButtonEnabled
end

function TPanelPowerButtonEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPanelPowerButtonEnabled.group)
end

TPanelPowerButtonEnabled.from_obj = TPanelPowerButtonEnabled_from_obj

TPanelPowerButtonEnabled.proto_property = {'PanelPowerButtonEnabled'}

TPanelPowerButtonEnabled.default = {false}

TPanelPowerButtonEnabled.struct = {{name = 'PanelPowerButtonEnabled', is_array = false, struct = nil}}

function TPanelPowerButtonEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PanelPowerButtonEnabled', self.PanelPowerButtonEnabled, 'bool', false, errs,
        need_convert)

    TPanelPowerButtonEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPanelPowerButtonEnabled.proto_property, errs, need_convert)
    return self
end

function TPanelPowerButtonEnabled:unpack(_)
    return self.PanelPowerButtonEnabled
end

FruCtrl.PanelPowerButtonEnabled = TPanelPowerButtonEnabled

---@class FruCtrl.PowerOnStrategyExceptions
---@field PowerOnStrategyExceptions integer
local TPowerOnStrategyExceptions = {}
TPowerOnStrategyExceptions.__index = TPowerOnStrategyExceptions
TPowerOnStrategyExceptions.group = {}

local function TPowerOnStrategyExceptions_from_obj(obj)
    return setmetatable(obj, TPowerOnStrategyExceptions)
end

function TPowerOnStrategyExceptions.new(PowerOnStrategyExceptions)
    return TPowerOnStrategyExceptions_from_obj({PowerOnStrategyExceptions = PowerOnStrategyExceptions})
end
---@param obj FruCtrl.PowerOnStrategyExceptions
function TPowerOnStrategyExceptions:init_from_obj(obj)
    self.PowerOnStrategyExceptions = obj.PowerOnStrategyExceptions
end

function TPowerOnStrategyExceptions:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnStrategyExceptions.group)
end

TPowerOnStrategyExceptions.from_obj = TPowerOnStrategyExceptions_from_obj

TPowerOnStrategyExceptions.proto_property = {'PowerOnStrategyExceptions'}

TPowerOnStrategyExceptions.default = {0}

TPowerOnStrategyExceptions.struct = {{name = 'PowerOnStrategyExceptions', is_array = false, struct = nil}}

function TPowerOnStrategyExceptions:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnStrategyExceptions', self.PowerOnStrategyExceptions, 'uint32', false, errs,
        need_convert)

    TPowerOnStrategyExceptions:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnStrategyExceptions.proto_property, errs, need_convert)
    return self
end

function TPowerOnStrategyExceptions:unpack(_)
    return self.PowerOnStrategyExceptions
end

FruCtrl.PowerOnStrategyExceptions = TPowerOnStrategyExceptions

---@class FruCtrl.PowerOnStrategy
---@field PowerOnStrategy string
local TPowerOnStrategy = {}
TPowerOnStrategy.__index = TPowerOnStrategy
TPowerOnStrategy.group = {}

local function TPowerOnStrategy_from_obj(obj)
    return setmetatable(obj, TPowerOnStrategy)
end

function TPowerOnStrategy.new(PowerOnStrategy)
    return TPowerOnStrategy_from_obj({PowerOnStrategy = PowerOnStrategy})
end
---@param obj FruCtrl.PowerOnStrategy
function TPowerOnStrategy:init_from_obj(obj)
    self.PowerOnStrategy = obj.PowerOnStrategy
end

function TPowerOnStrategy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnStrategy.group)
end

TPowerOnStrategy.from_obj = TPowerOnStrategy_from_obj

TPowerOnStrategy.proto_property = {'PowerOnStrategy'}

TPowerOnStrategy.default = {''}

TPowerOnStrategy.struct = {{name = 'PowerOnStrategy', is_array = false, struct = nil}}

function TPowerOnStrategy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnStrategy', self.PowerOnStrategy, 'string', false, errs, need_convert)

    TPowerOnStrategy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnStrategy.proto_property, errs, need_convert)
    return self
end

function TPowerOnStrategy:unpack(_)
    return self.PowerOnStrategy
end

FruCtrl.PowerOnStrategy = TPowerOnStrategy

---@class FruCtrl.RestartCount
---@field RestartCount integer
local TRestartCount = {}
TRestartCount.__index = TRestartCount
TRestartCount.group = {}

local function TRestartCount_from_obj(obj)
    return setmetatable(obj, TRestartCount)
end

function TRestartCount.new(RestartCount)
    return TRestartCount_from_obj({RestartCount = RestartCount})
end
---@param obj FruCtrl.RestartCount
function TRestartCount:init_from_obj(obj)
    self.RestartCount = obj.RestartCount
end

function TRestartCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestartCount.group)
end

TRestartCount.from_obj = TRestartCount_from_obj

TRestartCount.proto_property = {'RestartCount'}

TRestartCount.default = {0}

TRestartCount.struct = {{name = 'RestartCount', is_array = false, struct = nil}}

function TRestartCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RestartCount', self.RestartCount, 'uint8', true, errs, need_convert)

    TRestartCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestartCount.proto_property, errs, need_convert)
    return self
end

function TRestartCount:unpack(_)
    return self.RestartCount
end

FruCtrl.RestartCount = TRestartCount

---@class FruCtrl.RestartCauseRecords
---@field RestartCauseRecords string[]
local TRestartCauseRecords = {}
TRestartCauseRecords.__index = TRestartCauseRecords
TRestartCauseRecords.group = {}

local function TRestartCauseRecords_from_obj(obj)
    return setmetatable(obj, TRestartCauseRecords)
end

function TRestartCauseRecords.new(RestartCauseRecords)
    return TRestartCauseRecords_from_obj({RestartCauseRecords = RestartCauseRecords})
end
---@param obj FruCtrl.RestartCauseRecords
function TRestartCauseRecords:init_from_obj(obj)
    self.RestartCauseRecords = obj.RestartCauseRecords
end

function TRestartCauseRecords:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestartCauseRecords.group)
end

TRestartCauseRecords.from_obj = TRestartCauseRecords_from_obj

TRestartCauseRecords.proto_property = {'RestartCauseRecords'}

TRestartCauseRecords.default = {{}}

TRestartCauseRecords.struct = {{name = 'RestartCauseRecords', is_array = true, struct = nil}}

function TRestartCauseRecords:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RestartCauseRecords', self.RestartCauseRecords, 'string', true, errs, need_convert)

    TRestartCauseRecords:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestartCauseRecords.proto_property, errs, need_convert)
    return self
end

function TRestartCauseRecords:unpack(_)
    return self.RestartCauseRecords
end

FruCtrl.RestartCauseRecords = TRestartCauseRecords

---@class FruCtrl.CurrentRestartType
---@field CurrentRestartType integer
local TCurrentRestartType = {}
TCurrentRestartType.__index = TCurrentRestartType
TCurrentRestartType.group = {}

local function TCurrentRestartType_from_obj(obj)
    return setmetatable(obj, TCurrentRestartType)
end

function TCurrentRestartType.new(CurrentRestartType)
    return TCurrentRestartType_from_obj({CurrentRestartType = CurrentRestartType})
end
---@param obj FruCtrl.CurrentRestartType
function TCurrentRestartType:init_from_obj(obj)
    self.CurrentRestartType = obj.CurrentRestartType
end

function TCurrentRestartType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentRestartType.group)
end

TCurrentRestartType.from_obj = TCurrentRestartType_from_obj

TCurrentRestartType.proto_property = {'CurrentRestartType'}

TCurrentRestartType.default = {0}

TCurrentRestartType.struct = {{name = 'CurrentRestartType', is_array = false, struct = nil}}

function TCurrentRestartType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentRestartType', self.CurrentRestartType, 'uint8', true, errs, need_convert)

    TCurrentRestartType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentRestartType.proto_property, errs, need_convert)
    return self
end

function TCurrentRestartType:unpack(_)
    return self.CurrentRestartType
end

FruCtrl.CurrentRestartType = TCurrentRestartType

---@class FruCtrl.CurrentRestartCauseId
---@field CurrentRestartCauseId integer
local TCurrentRestartCauseId = {}
TCurrentRestartCauseId.__index = TCurrentRestartCauseId
TCurrentRestartCauseId.group = {}

local function TCurrentRestartCauseId_from_obj(obj)
    return setmetatable(obj, TCurrentRestartCauseId)
end

function TCurrentRestartCauseId.new(CurrentRestartCauseId)
    return TCurrentRestartCauseId_from_obj({CurrentRestartCauseId = CurrentRestartCauseId})
end
---@param obj FruCtrl.CurrentRestartCauseId
function TCurrentRestartCauseId:init_from_obj(obj)
    self.CurrentRestartCauseId = obj.CurrentRestartCauseId
end

function TCurrentRestartCauseId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentRestartCauseId.group)
end

TCurrentRestartCauseId.from_obj = TCurrentRestartCauseId_from_obj

TCurrentRestartCauseId.proto_property = {'CurrentRestartCauseId'}

TCurrentRestartCauseId.default = {0}

TCurrentRestartCauseId.struct = {{name = 'CurrentRestartCauseId', is_array = false, struct = nil}}

function TCurrentRestartCauseId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentRestartCauseId', self.CurrentRestartCauseId, 'uint8', true, errs, need_convert)

    TCurrentRestartCauseId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentRestartCauseId.proto_property, errs, need_convert)
    return self
end

function TCurrentRestartCauseId:unpack(_)
    return self.CurrentRestartCauseId
end

FruCtrl.CurrentRestartCauseId = TCurrentRestartCauseId

---@class FruCtrl.CurrentRestartCause
---@field CurrentRestartCause string
local TCurrentRestartCause = {}
TCurrentRestartCause.__index = TCurrentRestartCause
TCurrentRestartCause.group = {}

local function TCurrentRestartCause_from_obj(obj)
    return setmetatable(obj, TCurrentRestartCause)
end

function TCurrentRestartCause.new(CurrentRestartCause)
    return TCurrentRestartCause_from_obj({CurrentRestartCause = CurrentRestartCause})
end
---@param obj FruCtrl.CurrentRestartCause
function TCurrentRestartCause:init_from_obj(obj)
    self.CurrentRestartCause = obj.CurrentRestartCause
end

function TCurrentRestartCause:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentRestartCause.group)
end

TCurrentRestartCause.from_obj = TCurrentRestartCause_from_obj

TCurrentRestartCause.proto_property = {'CurrentRestartCause'}

TCurrentRestartCause.default = {''}

TCurrentRestartCause.struct = {{name = 'CurrentRestartCause', is_array = false, struct = nil}}

function TCurrentRestartCause:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentRestartCause', self.CurrentRestartCause, 'string', true, errs, need_convert)

    TCurrentRestartCause:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentRestartCause.proto_property, errs, need_convert)
    return self
end

function TCurrentRestartCause:unpack(_)
    return self.CurrentRestartCause
end

FruCtrl.CurrentRestartCause = TCurrentRestartCause

---@class FruCtrl.FruType
---@field FruType string
local TFruType = {}
TFruType.__index = TFruType
TFruType.group = {}

local function TFruType_from_obj(obj)
    return setmetatable(obj, TFruType)
end

function TFruType.new(FruType)
    return TFruType_from_obj({FruType = FruType})
end
---@param obj FruCtrl.FruType
function TFruType:init_from_obj(obj)
    self.FruType = obj.FruType
end

function TFruType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruType.group)
end

TFruType.from_obj = TFruType_from_obj

TFruType.proto_property = {'FruType'}

TFruType.default = {''}

TFruType.struct = {{name = 'FruType', is_array = false, struct = nil}}

function TFruType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruType', self.FruType, 'string', true, errs, need_convert)

    TFruType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruType.proto_property, errs, need_convert)
    return self
end

function TFruType:unpack(_)
    return self.FruType
end

FruCtrl.FruType = TFruType

---@class FruCtrl.SysResetDetected
---@field SysResetDetected integer
local TSysResetDetected = {}
TSysResetDetected.__index = TSysResetDetected
TSysResetDetected.group = {}

local function TSysResetDetected_from_obj(obj)
    return setmetatable(obj, TSysResetDetected)
end

function TSysResetDetected.new(SysResetDetected)
    return TSysResetDetected_from_obj({SysResetDetected = SysResetDetected})
end
---@param obj FruCtrl.SysResetDetected
function TSysResetDetected:init_from_obj(obj)
    self.SysResetDetected = obj.SysResetDetected
end

function TSysResetDetected:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysResetDetected.group)
end

TSysResetDetected.from_obj = TSysResetDetected_from_obj

TSysResetDetected.proto_property = {'SysResetDetected'}

TSysResetDetected.default = {0}

TSysResetDetected.struct = {{name = 'SysResetDetected', is_array = false, struct = nil}}

function TSysResetDetected:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysResetDetected', self.SysResetDetected, 'uint8', true, errs, need_convert)

    TSysResetDetected:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysResetDetected.proto_property, errs, need_convert)
    return self
end

function TSysResetDetected:unpack(_)
    return self.SysResetDetected
end

FruCtrl.SysResetDetected = TSysResetDetected

---@class FruCtrl.PowerState
---@field PowerState string
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj FruCtrl.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {''}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'string', true, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

FruCtrl.PowerState = TPowerState

---@class FruCtrl.BeforePowerOnSignalSignature
---@field Timeout integer
local TBeforePowerOnSignalSignature = {}
TBeforePowerOnSignalSignature.__index = TBeforePowerOnSignalSignature
TBeforePowerOnSignalSignature.group = {}

local function TBeforePowerOnSignalSignature_from_obj(obj)
    return setmetatable(obj, TBeforePowerOnSignalSignature)
end

function TBeforePowerOnSignalSignature.new(Timeout)
    return TBeforePowerOnSignalSignature_from_obj({Timeout = Timeout or 3})
end
---@param obj FruCtrl.BeforePowerOnSignalSignature
function TBeforePowerOnSignalSignature:init_from_obj(obj)
    self.Timeout = obj.Timeout or 3
end

function TBeforePowerOnSignalSignature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBeforePowerOnSignalSignature.group)
end

TBeforePowerOnSignalSignature.from_obj = TBeforePowerOnSignalSignature_from_obj

TBeforePowerOnSignalSignature.proto_property = {'Timeout'}

TBeforePowerOnSignalSignature.default = {0}

TBeforePowerOnSignalSignature.struct = {{name = 'Timeout', is_array = false, struct = nil}}

function TBeforePowerOnSignalSignature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint8', false, errs, need_convert)

    TBeforePowerOnSignalSignature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBeforePowerOnSignalSignature.proto_property, errs, need_convert)
    return self
end

function TBeforePowerOnSignalSignature:unpack(_)
    return self.Timeout
end

FruCtrl.BeforePowerOnSignalSignature = TBeforePowerOnSignalSignature

---@class FruCtrl.FruPowerCtrlRsp
---@field CmdResult integer
local TFruPowerCtrlRsp = {}
TFruPowerCtrlRsp.__index = TFruPowerCtrlRsp
TFruPowerCtrlRsp.group = {}

local function TFruPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TFruPowerCtrlRsp)
end

function TFruPowerCtrlRsp.new(CmdResult)
    return TFruPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj FruCtrl.FruPowerCtrlRsp
function TFruPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TFruPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruPowerCtrlRsp.group)
end

TFruPowerCtrlRsp.from_obj = TFruPowerCtrlRsp_from_obj

TFruPowerCtrlRsp.proto_property = {'CmdResult'}

TFruPowerCtrlRsp.default = {0}

TFruPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TFruPowerCtrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs, need_convert)

    TFruPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruPowerCtrlRsp.proto_property, errs, need_convert)
    return self
end

function TFruPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

FruCtrl.FruPowerCtrlRsp = TFruPowerCtrlRsp

---@class FruCtrl.FruPowerCtrlReq
---@field PowerCtrlType string
---@field RestartCause string
---@field FruID integer
local TFruPowerCtrlReq = {}
TFruPowerCtrlReq.__index = TFruPowerCtrlReq
TFruPowerCtrlReq.group = {}

local function TFruPowerCtrlReq_from_obj(obj)
    return setmetatable(obj, TFruPowerCtrlReq)
end

function TFruPowerCtrlReq.new(PowerCtrlType, RestartCause, FruID)
    return TFruPowerCtrlReq_from_obj({PowerCtrlType = PowerCtrlType, RestartCause = RestartCause, FruID = FruID})
end
---@param obj FruCtrl.FruPowerCtrlReq
function TFruPowerCtrlReq:init_from_obj(obj)
    self.PowerCtrlType = obj.PowerCtrlType
    self.RestartCause = obj.RestartCause
    self.FruID = obj.FruID
end

function TFruPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruPowerCtrlReq.group)
end

TFruPowerCtrlReq.from_obj = TFruPowerCtrlReq_from_obj

TFruPowerCtrlReq.proto_property = {'PowerCtrlType', 'RestartCause', 'FruID'}

TFruPowerCtrlReq.default = {'', '', 0}

TFruPowerCtrlReq.struct = {
    {name = 'PowerCtrlType', is_array = false, struct = nil}, {name = 'RestartCause', is_array = false, struct = nil},
    {name = 'FruID', is_array = false, struct = nil}
}

function TFruPowerCtrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCtrlType', self.PowerCtrlType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruPowerCtrlReq.proto_property, errs, need_convert)
    return self
end

function TFruPowerCtrlReq:unpack(_)
    return self.PowerCtrlType, self.RestartCause, self.FruID
end

FruCtrl.FruPowerCtrlReq = TFruPowerCtrlReq

---@class FruCtrl.SetACLostRsp
---@field CmdResult integer
local TSetACLostRsp = {}
TSetACLostRsp.__index = TSetACLostRsp
TSetACLostRsp.group = {}

local function TSetACLostRsp_from_obj(obj)
    return setmetatable(obj, TSetACLostRsp)
end

function TSetACLostRsp.new(CmdResult)
    return TSetACLostRsp_from_obj({CmdResult = CmdResult})
end
---@param obj FruCtrl.SetACLostRsp
function TSetACLostRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetACLostRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACLostRsp.group)
end

TSetACLostRsp.from_obj = TSetACLostRsp_from_obj

TSetACLostRsp.proto_property = {'CmdResult'}

TSetACLostRsp.default = {0}

TSetACLostRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetACLostRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint32', false, errs, need_convert)

    TSetACLostRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACLostRsp.proto_property, errs, need_convert)
    return self
end

function TSetACLostRsp:unpack(_)
    return self.CmdResult
end

FruCtrl.SetACLostRsp = TSetACLostRsp

---@class FruCtrl.SetACLostReq
---@field Type integer
local TSetACLostReq = {}
TSetACLostReq.__index = TSetACLostReq
TSetACLostReq.group = {}

local function TSetACLostReq_from_obj(obj)
    return setmetatable(obj, TSetACLostReq)
end

function TSetACLostReq.new(Type)
    return TSetACLostReq_from_obj({Type = Type})
end
---@param obj FruCtrl.SetACLostReq
function TSetACLostReq:init_from_obj(obj)
    self.Type = obj.Type
end

function TSetACLostReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACLostReq.group)
end

TSetACLostReq.from_obj = TSetACLostReq_from_obj

TSetACLostReq.proto_property = {'Type'}

TSetACLostReq.default = {0}

TSetACLostReq.struct = {{name = 'Type', is_array = false, struct = nil}}

function TSetACLostReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {1}, errs, need_convert)
    end

    TSetACLostReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACLostReq.proto_property, errs, need_convert)
    return self
end

function TSetACLostReq:unpack(_)
    return self.Type
end

FruCtrl.SetACLostReq = TSetACLostReq

---@class FruCtrl.SetPowerOnStrategyExceptionsRsp
---@field CmdResult integer
local TSetPowerOnStrategyExceptionsRsp = {}
TSetPowerOnStrategyExceptionsRsp.__index = TSetPowerOnStrategyExceptionsRsp
TSetPowerOnStrategyExceptionsRsp.group = {}

local function TSetPowerOnStrategyExceptionsRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerOnStrategyExceptionsRsp)
end

function TSetPowerOnStrategyExceptionsRsp.new(CmdResult)
    return TSetPowerOnStrategyExceptionsRsp_from_obj({CmdResult = CmdResult})
end
---@param obj FruCtrl.SetPowerOnStrategyExceptionsRsp
function TSetPowerOnStrategyExceptionsRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerOnStrategyExceptionsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnStrategyExceptionsRsp.group)
end

TSetPowerOnStrategyExceptionsRsp.from_obj = TSetPowerOnStrategyExceptionsRsp_from_obj

TSetPowerOnStrategyExceptionsRsp.proto_property = {'CmdResult'}

TSetPowerOnStrategyExceptionsRsp.default = {0}

TSetPowerOnStrategyExceptionsRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerOnStrategyExceptionsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint32', false, errs, need_convert)

    TSetPowerOnStrategyExceptionsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnStrategyExceptionsRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnStrategyExceptionsRsp:unpack(_)
    return self.CmdResult
end

FruCtrl.SetPowerOnStrategyExceptionsRsp = TSetPowerOnStrategyExceptionsRsp

---@class FruCtrl.SetPowerOnStrategyExceptionsReq
---@field Reason string
---@field Execute string
---@field EffectivePeriod string
---@field Priority integer
local TSetPowerOnStrategyExceptionsReq = {}
TSetPowerOnStrategyExceptionsReq.__index = TSetPowerOnStrategyExceptionsReq
TSetPowerOnStrategyExceptionsReq.group = {}

local function TSetPowerOnStrategyExceptionsReq_from_obj(obj)
    return setmetatable(obj, TSetPowerOnStrategyExceptionsReq)
end

function TSetPowerOnStrategyExceptionsReq.new(Reason, Execute, EffectivePeriod, Priority)
    return TSetPowerOnStrategyExceptionsReq_from_obj({
        Reason = Reason,
        Execute = Execute,
        EffectivePeriod = EffectivePeriod,
        Priority = Priority
    })
end
---@param obj FruCtrl.SetPowerOnStrategyExceptionsReq
function TSetPowerOnStrategyExceptionsReq:init_from_obj(obj)
    self.Reason = obj.Reason
    self.Execute = obj.Execute
    self.EffectivePeriod = obj.EffectivePeriod
    self.Priority = obj.Priority
end

function TSetPowerOnStrategyExceptionsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnStrategyExceptionsReq.group)
end

TSetPowerOnStrategyExceptionsReq.from_obj = TSetPowerOnStrategyExceptionsReq_from_obj

TSetPowerOnStrategyExceptionsReq.proto_property = {'Reason', 'Execute', 'EffectivePeriod', 'Priority'}

TSetPowerOnStrategyExceptionsReq.default = {'', '', '', 0}

TSetPowerOnStrategyExceptionsReq.struct = {
    {name = 'Reason', is_array = false, struct = nil}, {name = 'Execute', is_array = false, struct = nil},
    {name = 'EffectivePeriod', is_array = false, struct = nil}, {name = 'Priority', is_array = false, struct = nil}
}

function TSetPowerOnStrategyExceptionsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reason', self.Reason, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Execute', self.Execute, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'EffectivePeriod', self.EffectivePeriod, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Priority', self.Priority, 'uint8', false, errs, need_convert)

    TSetPowerOnStrategyExceptionsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnStrategyExceptionsReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnStrategyExceptionsReq:unpack(_)
    return self.Reason, self.Execute, self.EffectivePeriod, self.Priority
end

FruCtrl.SetPowerOnStrategyExceptionsReq = TSetPowerOnStrategyExceptionsReq

---@class FruCtrl.PowerCtrlRsp
---@field CmdResult integer
local TPowerCtrlRsp = {}
TPowerCtrlRsp.__index = TPowerCtrlRsp
TPowerCtrlRsp.group = {}

local function TPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TPowerCtrlRsp)
end

function TPowerCtrlRsp.new(CmdResult)
    return TPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj FruCtrl.PowerCtrlRsp
function TPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlRsp.group)
end

TPowerCtrlRsp.from_obj = TPowerCtrlRsp_from_obj

TPowerCtrlRsp.proto_property = {'CmdResult'}

TPowerCtrlRsp.default = {0}

TPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TPowerCtrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs, need_convert)

    TPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlRsp.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

FruCtrl.PowerCtrlRsp = TPowerCtrlRsp

---@class FruCtrl.PowerCtrlReq
---@field PowerCtrlType string
---@field RestartCause string
local TPowerCtrlReq = {}
TPowerCtrlReq.__index = TPowerCtrlReq
TPowerCtrlReq.group = {}

local function TPowerCtrlReq_from_obj(obj)
    return setmetatable(obj, TPowerCtrlReq)
end

function TPowerCtrlReq.new(PowerCtrlType, RestartCause)
    return TPowerCtrlReq_from_obj({PowerCtrlType = PowerCtrlType, RestartCause = RestartCause})
end
---@param obj FruCtrl.PowerCtrlReq
function TPowerCtrlReq:init_from_obj(obj)
    self.PowerCtrlType = obj.PowerCtrlType
    self.RestartCause = obj.RestartCause
end

function TPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlReq.group)
end

TPowerCtrlReq.from_obj = TPowerCtrlReq_from_obj

TPowerCtrlReq.proto_property = {'PowerCtrlType', 'RestartCause'}

TPowerCtrlReq.default = {'', ''}

TPowerCtrlReq.struct = {
    {name = 'PowerCtrlType', is_array = false, struct = nil}, {name = 'RestartCause', is_array = false, struct = nil}
}

function TPowerCtrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCtrlType', self.PowerCtrlType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'string', false, errs, need_convert)

    TPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlReq.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlReq:unpack(_)
    return self.PowerCtrlType, self.RestartCause
end

FruCtrl.PowerCtrlReq = TPowerCtrlReq

FruCtrl.interface = mdb.register_interface('bmc.kepler.Systems.FruCtrl', {
    PowerState = {'s', nil, true, nil, false},
    SysResetDetected = {'y', nil, true, nil, false},
    FruType = {'s', nil, true, nil, false},
    CurrentRestartCause = {'s', nil, true, nil, false},
    CurrentRestartCauseId = {'y', {}, true, nil, false},
    CurrentRestartType = {'y', nil, true, nil, false},
    RestartCauseRecords = {'as', {}, true, nil, false},
    RestartCount = {'y', {}, true, nil, false},
    PowerOnStrategy = {'s', nil, false, nil, false},
    PowerOnStrategyExceptions = {'u', nil, false, nil, false},
    PanelPowerButtonEnabled = {'b', nil, false, nil, false},
    GracefulShutdownTimeoutEnabled = {'u', nil, false, nil, false},
    GracefulShutdownTimeoutSeconds = {'u', nil, false, nil, false},
    GracefulShutdownDefaultTimeoutSeconds = {'u', nil, true, nil, false},
    GracefulShutdownMaxTimeoutSeconds = {'u', {'CONST'}, true, nil, false},
    GracefulShutdownMinTimeoutSeconds = {'u', {'CONST'}, true, nil, false},
    HotswapState = {'s', nil, true, nil, false},
    LastPowerEvent = {'y', {}, true, nil, false},
    PowerCtrlFault = {'y', {}, true, nil, false},
    PowerCycleType = {'y', {}, true, nil, false},
    PreviousPowerState = {'s', {}, true, nil, false}
}, {
    PowerCtrl = {'a{ss}ss', 'i', TPowerCtrlReq, TPowerCtrlRsp},
    SetPowerOnStrategyExceptions = {
        'a{ss}sssy', 'u', TSetPowerOnStrategyExceptionsReq, TSetPowerOnStrategyExceptionsRsp
    },
    SetACLost = {'a{ss}y', 'u', TSetACLostReq, TSetACLostRsp},
    FruPowerCtrl = {'a{ss}ssy', 'i', TFruPowerCtrlReq, TFruPowerCtrlRsp}
}, {BeforePowerOnSignal = 'a{ss}y'})

return FruCtrl
