-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fru = {}

---@class Fru.ConnectorGroupId
---@field ConnectorGroupId integer
local TConnectorGroupId = {}
TConnectorGroupId.__index = TConnectorGroupId
TConnectorGroupId.group = {}

local function TConnectorGroupId_from_obj(obj)
    return setmetatable(obj, TConnectorGroupId)
end

function TConnectorGroupId.new(ConnectorGroupId)
    return TConnectorGroupId_from_obj({ConnectorGroupId = ConnectorGroupId})
end
---@param obj Fru.ConnectorGroupId
function TConnectorGroupId:init_from_obj(obj)
    self.ConnectorGroupId = obj.ConnectorGroupId
end

function TConnectorGroupId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectorGroupId.group)
end

TConnectorGroupId.from_obj = TConnectorGroupId_from_obj

TConnectorGroupId.proto_property = {'ConnectorGroupId'}

TConnectorGroupId.default = {0}

TConnectorGroupId.struct = {{name = 'ConnectorGroupId', is_array = false, struct = nil}}

function TConnectorGroupId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConnectorGroupId', self.ConnectorGroupId, 'uint32', true, errs, need_convert)

    TConnectorGroupId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectorGroupId.proto_property, errs, need_convert)
    return self
end

function TConnectorGroupId:unpack(_)
    return self.ConnectorGroupId
end

Fru.ConnectorGroupId = TConnectorGroupId

---@class Fru.UniqueId
---@field UniqueId string
local TUniqueId = {}
TUniqueId.__index = TUniqueId
TUniqueId.group = {}

local function TUniqueId_from_obj(obj)
    return setmetatable(obj, TUniqueId)
end

function TUniqueId.new(UniqueId)
    return TUniqueId_from_obj({UniqueId = UniqueId})
end
---@param obj Fru.UniqueId
function TUniqueId:init_from_obj(obj)
    self.UniqueId = obj.UniqueId
end

function TUniqueId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUniqueId.group)
end

TUniqueId.from_obj = TUniqueId_from_obj

TUniqueId.proto_property = {'UniqueId'}

TUniqueId.default = {''}

TUniqueId.struct = {{name = 'UniqueId', is_array = false, struct = nil}}

function TUniqueId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UniqueId', self.UniqueId, 'string', true, errs, need_convert)

    TUniqueId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUniqueId.proto_property, errs, need_convert)
    return self
end

function TUniqueId:unpack(_)
    return self.UniqueId
end

Fru.UniqueId = TUniqueId

---@class Fru.BoardId
---@field BoardId integer
local TBoardId = {}
TBoardId.__index = TBoardId
TBoardId.group = {}

local function TBoardId_from_obj(obj)
    return setmetatable(obj, TBoardId)
end

function TBoardId.new(BoardId)
    return TBoardId_from_obj({BoardId = BoardId})
end
---@param obj Fru.BoardId
function TBoardId:init_from_obj(obj)
    self.BoardId = obj.BoardId
end

function TBoardId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardId.group)
end

TBoardId.from_obj = TBoardId_from_obj

TBoardId.proto_property = {'BoardId'}

TBoardId.default = {0}

TBoardId.struct = {{name = 'BoardId', is_array = false, struct = nil}}

function TBoardId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardId', self.BoardId, 'uint16', true, errs, need_convert)

    TBoardId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardId.proto_property, errs, need_convert)
    return self
end

function TBoardId:unpack(_)
    return self.BoardId
end

Fru.BoardId = TBoardId

---@class Fru.FruDataId
---@field FruDataId string
local TFruDataId = {}
TFruDataId.__index = TFruDataId
TFruDataId.group = {}

local function TFruDataId_from_obj(obj)
    return setmetatable(obj, TFruDataId)
end

function TFruDataId.new(FruDataId)
    return TFruDataId_from_obj({FruDataId = FruDataId})
end
---@param obj Fru.FruDataId
function TFruDataId:init_from_obj(obj)
    self.FruDataId = obj.FruDataId
end

function TFruDataId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruDataId.group)
end

TFruDataId.from_obj = TFruDataId_from_obj

TFruDataId.proto_property = {'FruDataId'}

TFruDataId.default = {''}

TFruDataId.struct = {{name = 'FruDataId', is_array = false, struct = nil}}

function TFruDataId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruDataId', self.FruDataId, 'string', true, errs, need_convert)

    TFruDataId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruDataId.proto_property, errs, need_convert)
    return self
end

function TFruDataId:unpack(_)
    return self.FruDataId
end

Fru.FruDataId = TFruDataId

---@class Fru.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj Fru.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

Fru.Type = TType

---@class Fru.GroupPosition
---@field GroupPosition string
local TGroupPosition = {}
TGroupPosition.__index = TGroupPosition
TGroupPosition.group = {}

local function TGroupPosition_from_obj(obj)
    return setmetatable(obj, TGroupPosition)
end

function TGroupPosition.new(GroupPosition)
    return TGroupPosition_from_obj({GroupPosition = GroupPosition})
end
---@param obj Fru.GroupPosition
function TGroupPosition:init_from_obj(obj)
    self.GroupPosition = obj.GroupPosition
end

function TGroupPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupPosition.group)
end

TGroupPosition.from_obj = TGroupPosition_from_obj

TGroupPosition.proto_property = {'GroupPosition'}

TGroupPosition.default = {''}

TGroupPosition.struct = {{name = 'GroupPosition', is_array = false, struct = nil}}

function TGroupPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupPosition', self.GroupPosition, 'string', true, errs, need_convert)

    TGroupPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupPosition.proto_property, errs, need_convert)
    return self
end

function TGroupPosition:unpack(_)
    return self.GroupPosition
end

Fru.GroupPosition = TGroupPosition

---@class Fru.EepStatus
---@field EepStatus integer
local TEepStatus = {}
TEepStatus.__index = TEepStatus
TEepStatus.group = {}

local function TEepStatus_from_obj(obj)
    return setmetatable(obj, TEepStatus)
end

function TEepStatus.new(EepStatus)
    return TEepStatus_from_obj({EepStatus = EepStatus})
end
---@param obj Fru.EepStatus
function TEepStatus:init_from_obj(obj)
    self.EepStatus = obj.EepStatus
end

function TEepStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEepStatus.group)
end

TEepStatus.from_obj = TEepStatus_from_obj

TEepStatus.proto_property = {'EepStatus'}

TEepStatus.default = {0}

TEepStatus.struct = {{name = 'EepStatus', is_array = false, struct = nil}}

function TEepStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EepStatus', self.EepStatus, 'uint8', true, errs, need_convert)

    TEepStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEepStatus.proto_property, errs, need_convert)
    return self
end

function TEepStatus:unpack(_)
    return self.EepStatus
end

Fru.EepStatus = TEepStatus

---@class Fru.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj Fru.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Fru.Health = THealth

---@class Fru.PowerState
---@field PowerState integer
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj Fru.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {0}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', true, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

Fru.PowerState = TPowerState

---@class Fru.FruName
---@field FruName string
local TFruName = {}
TFruName.__index = TFruName
TFruName.group = {}

local function TFruName_from_obj(obj)
    return setmetatable(obj, TFruName)
end

function TFruName.new(FruName)
    return TFruName_from_obj({FruName = FruName})
end
---@param obj Fru.FruName
function TFruName:init_from_obj(obj)
    self.FruName = obj.FruName
end

function TFruName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruName.group)
end

TFruName.from_obj = TFruName_from_obj

TFruName.proto_property = {'FruName'}

TFruName.default = {''}

TFruName.struct = {{name = 'FruName', is_array = false, struct = nil}}

function TFruName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruName', self.FruName, 'string', true, errs, need_convert)

    TFruName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruName.proto_property, errs, need_convert)
    return self
end

function TFruName:unpack(_)
    return self.FruName
end

Fru.FruName = TFruName

---@class Fru.FruId
---@field FruId integer
local TFruId = {}
TFruId.__index = TFruId
TFruId.group = {}

local function TFruId_from_obj(obj)
    return setmetatable(obj, TFruId)
end

function TFruId.new(FruId)
    return TFruId_from_obj({FruId = FruId})
end
---@param obj Fru.FruId
function TFruId:init_from_obj(obj)
    self.FruId = obj.FruId
end

function TFruId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruId.group)
end

TFruId.from_obj = TFruId_from_obj

TFruId.proto_property = {'FruId'}

TFruId.default = {0}

TFruId.struct = {{name = 'FruId', is_array = false, struct = nil}}

function TFruId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', true, errs, need_convert)

    TFruId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruId.proto_property, errs, need_convert)
    return self
end

function TFruId:unpack(_)
    return self.FruId
end

Fru.FruId = TFruId

---@class Fru.PcbVersion
---@field PcbVersion string
local TPcbVersion = {}
TPcbVersion.__index = TPcbVersion
TPcbVersion.group = {}

local function TPcbVersion_from_obj(obj)
    return setmetatable(obj, TPcbVersion)
end

function TPcbVersion.new(PcbVersion)
    return TPcbVersion_from_obj({PcbVersion = PcbVersion})
end
---@param obj Fru.PcbVersion
function TPcbVersion:init_from_obj(obj)
    self.PcbVersion = obj.PcbVersion
end

function TPcbVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbVersion.group)
end

TPcbVersion.from_obj = TPcbVersion_from_obj

TPcbVersion.proto_property = {'PcbVersion'}

TPcbVersion.default = {''}

TPcbVersion.struct = {{name = 'PcbVersion', is_array = false, struct = nil}}

function TPcbVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbVersion', self.PcbVersion, 'string', true, errs, need_convert)

    TPcbVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbVersion.proto_property, errs, need_convert)
    return self
end

function TPcbVersion:unpack(_)
    return self.PcbVersion
end

Fru.PcbVersion = TPcbVersion

---@class Fru.PcbId
---@field PcbId integer
local TPcbId = {}
TPcbId.__index = TPcbId
TPcbId.group = {}

local function TPcbId_from_obj(obj)
    return setmetatable(obj, TPcbId)
end

function TPcbId.new(PcbId)
    return TPcbId_from_obj({PcbId = PcbId})
end
---@param obj Fru.PcbId
function TPcbId:init_from_obj(obj)
    self.PcbId = obj.PcbId
end

function TPcbId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbId.group)
end

TPcbId.from_obj = TPcbId_from_obj

TPcbId.proto_property = {'PcbId'}

TPcbId.default = {0}

TPcbId.struct = {{name = 'PcbId', is_array = false, struct = nil}}

function TPcbId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbId', self.PcbId, 'uint8', true, errs, need_convert)

    TPcbId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbId.proto_property, errs, need_convert)
    return self
end

function TPcbId:unpack(_)
    return self.PcbId
end

Fru.PcbId = TPcbId

Fru.interface = mdb.register_interface('bmc.kepler.Systems.Fru', {
    PcbId = {'y', nil, true, nil, false},
    PcbVersion = {'s', nil, true, nil, false},
    FruId = {'y', nil, true, nil, false},
    FruName = {'s', nil, true, nil, false},
    PowerState = {'y', {}, true, nil, false},
    Health = {'y', nil, true, nil, false},
    EepStatus = {'y', {}, true, nil, false},
    GroupPosition = {'s', {}, true, nil, false},
    Type = {'y', {}, true, nil, false},
    FruDataId = {'s', {}, true, nil, false},
    BoardId = {'q', nil, true, nil, false},
    UniqueId = {'s', {}, true, nil, false},
    ConnectorGroupId = {'u', {}, true, nil, false}
}, {}, {})

return Fru
