-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiscreteSensor = {}

---@class DiscreteSensor.SensorNumber
---@field SensorNumber integer
local TSensorNumber = {}
TSensorNumber.__index = TSensorNumber
TSensorNumber.group = {}

local function TSensorNumber_from_obj(obj)
    return setmetatable(obj, TSensorNumber)
end

function TSensorNumber.new(SensorNumber)
    return TSensorNumber_from_obj({SensorNumber = SensorNumber or 255})
end
---@param obj DiscreteSensor.SensorNumber
function TSensorNumber:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber or 255
end

function TSensorNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorNumber.group)
end

TSensorNumber.from_obj = TSensorNumber_from_obj

TSensorNumber.proto_property = {'SensorNumber'}

TSensorNumber.default = {0}

TSensorNumber.struct = {{name = 'SensorNumber', is_array = false, struct = nil}}

function TSensorNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint8', true, errs, need_convert)

    TSensorNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorNumber.proto_property, errs, need_convert)
    return self
end

function TSensorNumber:unpack(_)
    return self.SensorNumber
end

DiscreteSensor.SensorNumber = TSensorNumber

---@class DiscreteSensor.Reading
---@field Reading integer
local TReading = {}
TReading.__index = TReading
TReading.group = {}

local function TReading_from_obj(obj)
    return setmetatable(obj, TReading)
end

function TReading.new(Reading)
    return TReading_from_obj({Reading = Reading or 0})
end
---@param obj DiscreteSensor.Reading
function TReading:init_from_obj(obj)
    self.Reading = obj.Reading or 0
end

function TReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReading.group)
end

TReading.from_obj = TReading_from_obj

TReading.proto_property = {'Reading'}

TReading.default = {0}

TReading.struct = {{name = 'Reading', is_array = false, struct = nil}}

function TReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reading', self.Reading, 'uint16', true, errs, need_convert)

    TReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReading.proto_property, errs, need_convert)
    return self
end

function TReading:unpack(_)
    return self.Reading
end

DiscreteSensor.Reading = TReading

---@class DiscreteSensor.NegativeHysteresis
---@field NegativeHysteresis integer
local TNegativeHysteresis = {}
TNegativeHysteresis.__index = TNegativeHysteresis
TNegativeHysteresis.group = {}

local function TNegativeHysteresis_from_obj(obj)
    return setmetatable(obj, TNegativeHysteresis)
end

function TNegativeHysteresis.new(NegativeHysteresis)
    return TNegativeHysteresis_from_obj({NegativeHysteresis = NegativeHysteresis or 0})
end
---@param obj DiscreteSensor.NegativeHysteresis
function TNegativeHysteresis:init_from_obj(obj)
    self.NegativeHysteresis = obj.NegativeHysteresis or 0
end

function TNegativeHysteresis:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNegativeHysteresis.group)
end

TNegativeHysteresis.from_obj = TNegativeHysteresis_from_obj

TNegativeHysteresis.proto_property = {'NegativeHysteresis'}

TNegativeHysteresis.default = {0}

TNegativeHysteresis.struct = {{name = 'NegativeHysteresis', is_array = false, struct = nil}}

function TNegativeHysteresis:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NegativeHysteresis', self.NegativeHysteresis, 'uint8', true, errs, need_convert)

    TNegativeHysteresis:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNegativeHysteresis.proto_property, errs, need_convert)
    return self
end

function TNegativeHysteresis:unpack(_)
    return self.NegativeHysteresis
end

DiscreteSensor.NegativeHysteresis = TNegativeHysteresis

---@class DiscreteSensor.PositiveHysteresis
---@field PositiveHysteresis integer
local TPositiveHysteresis = {}
TPositiveHysteresis.__index = TPositiveHysteresis
TPositiveHysteresis.group = {}

local function TPositiveHysteresis_from_obj(obj)
    return setmetatable(obj, TPositiveHysteresis)
end

function TPositiveHysteresis.new(PositiveHysteresis)
    return TPositiveHysteresis_from_obj({PositiveHysteresis = PositiveHysteresis or 0})
end
---@param obj DiscreteSensor.PositiveHysteresis
function TPositiveHysteresis:init_from_obj(obj)
    self.PositiveHysteresis = obj.PositiveHysteresis or 0
end

function TPositiveHysteresis:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPositiveHysteresis.group)
end

TPositiveHysteresis.from_obj = TPositiveHysteresis_from_obj

TPositiveHysteresis.proto_property = {'PositiveHysteresis'}

TPositiveHysteresis.default = {0}

TPositiveHysteresis.struct = {{name = 'PositiveHysteresis', is_array = false, struct = nil}}

function TPositiveHysteresis:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PositiveHysteresis', self.PositiveHysteresis, 'uint8', true, errs, need_convert)

    TPositiveHysteresis:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPositiveHysteresis.proto_property, errs, need_convert)
    return self
end

function TPositiveHysteresis:unpack(_)
    return self.PositiveHysteresis
end

DiscreteSensor.PositiveHysteresis = TPositiveHysteresis

---@class DiscreteSensor.SensorName
---@field SensorName string
local TSensorName = {}
TSensorName.__index = TSensorName
TSensorName.group = {}

local function TSensorName_from_obj(obj)
    return setmetatable(obj, TSensorName)
end

function TSensorName.new(SensorName)
    return TSensorName_from_obj({SensorName = SensorName or [=[]=]})
end
---@param obj DiscreteSensor.SensorName
function TSensorName:init_from_obj(obj)
    self.SensorName = obj.SensorName or [=[]=]
end

function TSensorName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorName.group)
end

TSensorName.from_obj = TSensorName_from_obj

TSensorName.proto_property = {'SensorName'}

TSensorName.default = {''}

TSensorName.struct = {{name = 'SensorName', is_array = false, struct = nil}}

function TSensorName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', true, errs, need_convert)

    TSensorName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorName.proto_property, errs, need_convert)
    return self
end

function TSensorName:unpack(_)
    return self.SensorName
end

DiscreteSensor.SensorName = TSensorName

---@class DiscreteSensor.Capabilities
---@field Capabilities integer
local TCapabilities = {}
TCapabilities.__index = TCapabilities
TCapabilities.group = {}

local function TCapabilities_from_obj(obj)
    return setmetatable(obj, TCapabilities)
end

function TCapabilities.new(Capabilities)
    return TCapabilities_from_obj({Capabilities = Capabilities or 0})
end
---@param obj DiscreteSensor.Capabilities
function TCapabilities:init_from_obj(obj)
    self.Capabilities = obj.Capabilities or 0
end

function TCapabilities:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapabilities.group)
end

TCapabilities.from_obj = TCapabilities_from_obj

TCapabilities.proto_property = {'Capabilities'}

TCapabilities.default = {0}

TCapabilities.struct = {{name = 'Capabilities', is_array = false, struct = nil}}

function TCapabilities:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Capabilities', self.Capabilities, 'uint8', true, errs, need_convert)

    TCapabilities:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapabilities.proto_property, errs, need_convert)
    return self
end

function TCapabilities:unpack(_)
    return self.Capabilities
end

DiscreteSensor.Capabilities = TCapabilities

---@class DiscreteSensor.OwnerLun
---@field OwnerLun integer
local TOwnerLun = {}
TOwnerLun.__index = TOwnerLun
TOwnerLun.group = {}

local function TOwnerLun_from_obj(obj)
    return setmetatable(obj, TOwnerLun)
end

function TOwnerLun.new(OwnerLun)
    return TOwnerLun_from_obj({OwnerLun = OwnerLun or 0})
end
---@param obj DiscreteSensor.OwnerLun
function TOwnerLun:init_from_obj(obj)
    self.OwnerLun = obj.OwnerLun or 0
end

function TOwnerLun:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOwnerLun.group)
end

TOwnerLun.from_obj = TOwnerLun_from_obj

TOwnerLun.proto_property = {'OwnerLun'}

TOwnerLun.default = {0}

TOwnerLun.struct = {{name = 'OwnerLun', is_array = false, struct = nil}}

function TOwnerLun:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OwnerLun', self.OwnerLun, 'uint8', true, errs, need_convert)

    TOwnerLun:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOwnerLun.proto_property, errs, need_convert)
    return self
end

function TOwnerLun:unpack(_)
    return self.OwnerLun
end

DiscreteSensor.OwnerLun = TOwnerLun

---@class DiscreteSensor.OwnerId
---@field OwnerId integer
local TOwnerId = {}
TOwnerId.__index = TOwnerId
TOwnerId.group = {}

local function TOwnerId_from_obj(obj)
    return setmetatable(obj, TOwnerId)
end

function TOwnerId.new(OwnerId)
    return TOwnerId_from_obj({OwnerId = OwnerId or 32})
end
---@param obj DiscreteSensor.OwnerId
function TOwnerId:init_from_obj(obj)
    self.OwnerId = obj.OwnerId or 32
end

function TOwnerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOwnerId.group)
end

TOwnerId.from_obj = TOwnerId_from_obj

TOwnerId.proto_property = {'OwnerId'}

TOwnerId.default = {0}

TOwnerId.struct = {{name = 'OwnerId', is_array = false, struct = nil}}

function TOwnerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OwnerId', self.OwnerId, 'uint8', true, errs, need_convert)

    TOwnerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOwnerId.proto_property, errs, need_convert)
    return self
end

function TOwnerId:unpack(_)
    return self.OwnerId
end

DiscreteSensor.OwnerId = TOwnerId

---@class DiscreteSensor.SensorIdentifier
---@field SensorIdentifier string
local TSensorIdentifier = {}
TSensorIdentifier.__index = TSensorIdentifier
TSensorIdentifier.group = {}

local function TSensorIdentifier_from_obj(obj)
    return setmetatable(obj, TSensorIdentifier)
end

function TSensorIdentifier.new(SensorIdentifier)
    return TSensorIdentifier_from_obj({SensorIdentifier = SensorIdentifier or [=[]=]})
end
---@param obj DiscreteSensor.SensorIdentifier
function TSensorIdentifier:init_from_obj(obj)
    self.SensorIdentifier = obj.SensorIdentifier or [=[]=]
end

function TSensorIdentifier:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorIdentifier.group)
end

TSensorIdentifier.from_obj = TSensorIdentifier_from_obj

TSensorIdentifier.proto_property = {'SensorIdentifier'}

TSensorIdentifier.default = {''}

TSensorIdentifier.struct = {{name = 'SensorIdentifier', is_array = false, struct = nil}}

function TSensorIdentifier:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorIdentifier', self.SensorIdentifier, 'string', true, errs, need_convert)

    TSensorIdentifier:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorIdentifier.proto_property, errs, need_convert)
    return self
end

function TSensorIdentifier:unpack(_)
    return self.SensorIdentifier
end

DiscreteSensor.SensorIdentifier = TSensorIdentifier

---@class DiscreteSensor.EntityInstance
---@field EntityInstance integer
local TEntityInstance = {}
TEntityInstance.__index = TEntityInstance
TEntityInstance.group = {}

local function TEntityInstance_from_obj(obj)
    return setmetatable(obj, TEntityInstance)
end

function TEntityInstance.new(EntityInstance)
    return TEntityInstance_from_obj({EntityInstance = EntityInstance or 0})
end
---@param obj DiscreteSensor.EntityInstance
function TEntityInstance:init_from_obj(obj)
    self.EntityInstance = obj.EntityInstance or 0
end

function TEntityInstance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityInstance.group)
end

TEntityInstance.from_obj = TEntityInstance_from_obj

TEntityInstance.proto_property = {'EntityInstance'}

TEntityInstance.default = {0}

TEntityInstance.struct = {{name = 'EntityInstance', is_array = false, struct = nil}}

function TEntityInstance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityInstance', self.EntityInstance, 'uint8', true, errs, need_convert)

    TEntityInstance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityInstance.proto_property, errs, need_convert)
    return self
end

function TEntityInstance:unpack(_)
    return self.EntityInstance
end

DiscreteSensor.EntityInstance = TEntityInstance

---@class DiscreteSensor.EntityId
---@field EntityId integer
local TEntityId = {}
TEntityId.__index = TEntityId
TEntityId.group = {}

local function TEntityId_from_obj(obj)
    return setmetatable(obj, TEntityId)
end

function TEntityId.new(EntityId)
    return TEntityId_from_obj({EntityId = EntityId or 0})
end
---@param obj DiscreteSensor.EntityId
function TEntityId:init_from_obj(obj)
    self.EntityId = obj.EntityId or 0
end

function TEntityId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityId.group)
end

TEntityId.from_obj = TEntityId_from_obj

TEntityId.proto_property = {'EntityId'}

TEntityId.default = {0}

TEntityId.struct = {{name = 'EntityId', is_array = false, struct = nil}}

function TEntityId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityId', self.EntityId, 'uint8', true, errs, need_convert)

    TEntityId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityId.proto_property, errs, need_convert)
    return self
end

function TEntityId:unpack(_)
    return self.EntityId
end

DiscreteSensor.EntityId = TEntityId

DiscreteSensor.interface = mdb.register_interface('bmc.kepler.Systems.DiscreteSensor', {
    EntityId = {'y', {}, true, 0, false},
    EntityInstance = {'y', {}, true, 0, false},
    SensorIdentifier = {'s', {'CONST'}, true, '', false},
    OwnerId = {'y', {'CONST'}, true, 32, false},
    OwnerLun = {'y', {'CONST'}, true, 0, false},
    Capabilities = {'y', {'CONST'}, true, 0, false},
    SensorName = {'s', {'CONST'}, true, '', false},
    PositiveHysteresis = {'y', {}, true, 0, false},
    NegativeHysteresis = {'y', {}, true, 0, false},
    Reading = {'q', {}, true, 0, false},
    SensorNumber = {'y', {}, true, 255, false}
}, {}, {})

return DiscreteSensor
