--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'sensor.ipmi.ipmi_message'

local CT = enums.ChannelType

local SensorIpmiCmds = {}

SensorIpmiCmds.SetSensorEventReceiver = {
    name = 'SetSensorEventReceiver',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x00,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Addr:1/unit:8, Lun:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSensorEventReceiverReq,
    rsp = msg.SetSensorEventReceiverRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSensorEventReceiver = {
    name = 'GetSensorEventReceiver',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x01,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, Addr:1/unit:8, Reserved]=] .. [=[:6/unit:1, Lun:2/unit:1>>]=],
    req = msg.GetSensorEventReceiverReq,
    rsp = msg.GetSensorEventReceiverRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.ReportSensorEvent = {
    name = 'ReportSensorEvent',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x02,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Datas/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.ReportSensorEventReq,
    rsp = msg.ReportSensorEventRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetPEFCapabilities = {
    name = 'GetPEFCapabilities',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x10,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, PEFVersion:1/unit:8, Al]=] ..
        [=[ert:1/unit:1, PowerDown:1/unit:1, Reset:1/unit:1, ]=] ..
        [=[PowerCycle:1/unit:1, OEMAction:1/unit:1, DiagInter]=] ..
        [=[rupt:1/unit:1, Reserved:1/unit:1, OEMFilterSupport]=] .. [=[:1/unit:1, FilterNumber:1/unit:8>>]=],
    req = msg.GetPEFCapabilitiesReq,
    rsp = msg.GetPEFCapabilitiesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetPEFPostponeTimer = {
    name = 'SetPEFPostponeTimer',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x11,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Timeout:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Timeout:1/unit:8>>]=],
    req = msg.SetPEFPostponeTimerReq,
    rsp = msg.SetPEFPostponeTimerRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.SetPEFParameters = {
    name = 'SetPEFParameters',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x12,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Datas/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetPEFParametersReq,
    rsp = msg.SetPEFParametersRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetPEFParameters = {
    name = 'GetPEFParameters',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x13,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Selector:7/unit:1, Revision:1/unit:1, SetSelecto]=] .. [=[r:1/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Revision:1/unit:8, Data]=] .. [=[s/string>>]=],
    req = msg.GetPEFParametersReq,
    rsp = msg.GetPEFParametersRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetPEFLastEventId = {
    name = 'SetPEFLastEventId',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x14,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Reserved:7/unit:1, BMC:1/unit:1, RecordId:2/unit]=] .. [=[:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetPEFLastEventIdReq,
    rsp = msg.SetPEFLastEventIdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetPEFLastEventId = {
    name = 'GetPEFLastEventId',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x15,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, Timestamp:4/unit:8, SEL]=] ..
        [=[Id:2/unit:8, SMSId:2/unit:8, BMCId:2/unit:8>>]=],
    req = msg.GetPEFLastEventIdReq,
    rsp = msg.GetPEFLastEventIdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetDeviceSDRInfo = {
    name = 'GetDeviceSDRInfo',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x20,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Datas/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Count:1/unit:8, Dynamic]=] ..
        [=[Sensor:1/unit:1, Reserved:3/unit:1, Lun:4/unit:1, ]=] .. [=[Population:4/unit:8>>]=],
    req = msg.GetDeviceSDRInfoReq,
    rsp = msg.GetDeviceSDRInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetDeviceSDR = {
    name = 'GetDeviceSDR',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x21,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<ReserveIdL:1/unit:8, ReserveIdH:1/unit:8, Record]=] ..
        [=[IdL:1/unit:8, RecordIdH:1/unit:8, Offset:1/unit:8,]=] .. [=[ Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RecordIdL:1/unit:8, Rec]=] .. [=[ordIdH:1/unit:8, Datas/string>>]=],
    req = msg.GetDeviceSDRReq,
    rsp = msg.GetDeviceSDRRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.ReserveDeviceSDR = {
    name = 'ReserveDeviceSDR',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x22,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, ReserveIdL:1/unit:8, Re]=] .. [=[serveIdH:1/unit:8>>]=],
    req = msg.ReserveDeviceSDRReq,
    rsp = msg.ReserveDeviceSDRRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSensorFactors = {
    name = 'GetSensorFactors',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x23,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8, ReadingByte:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, NextReading:1/unit:8, M]=] ..
        [=[:1/unit:8, MT:1/unit:8, B:1/unit:8, BA:1/unit:8, A]=] .. [=[ccuracy:1/unit:8, RBExp:1/unit:8>>]=],
    req = msg.GetSensorFactorsReq,
    rsp = msg.GetSensorFactorsRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetSensorHysteresis = {
    name = 'SetSensorHysteresis',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x24,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8, Reserved:1/unit:8, PHysteresis:]=] .. [=[1/unit:8, NHysteresis:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSensorHysteresisReq,
    rsp = msg.SetSensorHysteresisRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSensorHysteresis = {
    name = 'GetSensorHysteresis',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x25,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8, Reserved:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PHysteresis:1/unit:8, N]=] .. [=[Hysteresis:1/unit:8>>]=],
    req = msg.GetSensorHysteresisReq,
    rsp = msg.GetSensorHysteresisRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetSensorThreshold = {
    name = 'SetSensorThreshold',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x26,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8, LNCFlag:1/unit:1, LCRFlag:1/uni]=] ..
        [=[t:1, LNRFlag:1/unit:1, UNCFlag:1/unit:1, UCRFlag:1]=] ..
        [=[/unit:1, UNRFlag:1/unit:1, Reserved:2/unit:1, LNCV]=] ..
        [=[alue:1/unit:8, LCRValue:1/unit:8, LNRValue:1/unit:]=] ..
        [=[8, UNCValue:1/unit:8, UCRValue:1/unit:8, UNRValue:]=] .. [=[1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSensorThresholdReq,
    rsp = msg.SetSensorThresholdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSensorThreshold = {
    name = 'GetSensorThreshold',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x27,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, LNCFlag:1/unit:1, LCRFl]=] ..
        [=[ag:1/unit:1, LNRFlag:1/unit:1, UNCFlag:1/unit:1, U]=] ..
        [=[CRFlag:1/unit:1, UNRFlag:1/unit:1, Reserved:2/unit]=] ..
        [=[:1, LNCValue:1/unit:8, LCRValue:1/unit:8, LNRValue]=] ..
        [=[:1/unit:8, UNCValue:1/unit:8, UCRValue:1/unit:8, U]=] .. [=[NRValue:1/unit:8>>]=],
    req = msg.GetSensorThresholdReq,
    rsp = msg.GetSensorThresholdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetSensorEventEnable = {
    name = 'SetSensorEventEnable',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x28,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Datas:6/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSensorEventEnableReq,
    rsp = msg.SetSensorEventEnableRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSensorEventEnable = {
    name = 'GetSensorEventEnable',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x29,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Reserved:6/unit:1, Scan]=] ..
        [=[Disabled:1/unit:1, AllDisabled:1/unit:1, AssertMas]=] .. [=[k:2/unit:8, DeassertMask:2/unit:8>>]=],
    req = msg.GetSensorEventEnableReq,
    rsp = msg.GetSensorEventEnableRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.RearmSensorEvent = {
    name = 'RearmSensorEvent',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x2a,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8, Reserved:7/unit:1, RearmAll:1/u]=] ..
        [=[nit:1, RearmAssert:2/unit:8, RearmDeassert:2/unit:]=] .. [=[8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.RearmSensorEventReq,
    rsp = msg.RearmSensorEventRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSensorEventStatus = {
    name = 'GetSensorEventStatus',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x2b,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Reserved:5/unit:1, Read]=] ..
        [=[ingUnavailable:1/unit:1, ScanDisabled:1/unit:1, Al]=] ..
        [=[lDisabled:1/unit:1, AssertStatusL:1/unit:8, Assert]=] ..
        [=[StatusH:1/unit:8, DeassertStatusL:1/unit:8, Deasse]=] .. [=[rtStatusH:1/unit:8>>]=],
    req = msg.GetSensorEventStatusReq,
    rsp = msg.GetSensorEventStatusRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSensorReading = {
    name = 'GetSensorReading',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x2d,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Reading:1/unit:8, Reser]=] ..
        [=[ved:5/unit:1, InitialProgress:1/unit:1, ScanDisabl]=] ..
        [=[ed:1/unit:1, AllDisabled:1/unit:1, AssertStatus:2/]=] .. [=[unit:8>>]=],
    req = msg.GetSensorReadingReq,
    rsp = msg.GetSensorReadingRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSensorType = {
    name = 'GetSensorType',
    prio = types.Priority.Default,
    netfn = 0x04,
    cmd = 0x2f,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Number:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Type:1/unit:8, TypeCode]=] .. [=[:7/unit:1, Reserved:1/unit:1>>]=],
    req = msg.GetSensorTypeReq,
    rsp = msg.GetSensorTypeRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSDRRepoInfo = {
    name = 'GetSDRRepoInfo',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x20,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, SDRVersion:1/unit:8, Re]=] ..
        [=[cordCountL:1/unit:8, RecordCountH:1/unit:8, FreeL:]=] ..
        [=[1/unit:8, FreeH:1/unit:8, AddTime0:1/unit:8, AddTi]=] ..
        [=[me1:1/unit:8, AddTime2:1/unit:8, AddTime3:1/unit:8]=] ..
        [=[, DelTime0:1/unit:8, DelTime1:1/unit:8, DelTime2:1]=] ..
        [=[/unit:8, DelTime3:1/unit:8, OpSupport:1/unit:8>>]=],
    req = msg.GetSDRRepoInfoReq,
    rsp = msg.GetSDRRepoInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSDRRepoAllocInfo = {
    name = 'GetSDRRepoAllocInfo',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x21,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, UnitCntL:1/unit:8, Unit]=] ..
        [=[CntH:1/unit:8, UnitSizeL:1/unit:8, UnitSizeH:1/uni]=] ..
        [=[t:8, FreeUnitL:1/unit:8, FreeUnitH:1/unit:8, FreeB]=] ..
        [=[lockL:1/unit:8, FreeBlockH:1/unit:8, MaxUnitSize:1]=] .. [=[/unit:8>>]=],
    req = msg.GetSDRRepoAllocInfoReq,
    rsp = msg.GetSDRRepoAllocInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSDRReserveId = {
    name = 'GetSDRReserveId',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x22,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, ReserveIdL:1/unit:8, Re]=] .. [=[serveIdH:1/unit:8>>]=],
    req = msg.GetSDRReserveIdReq,
    rsp = msg.GetSDRReserveIdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSDR = {
    name = 'GetSDR',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x23,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<ReserveIdL:1/unit:8, ReserveIdH:1/unit:8, Record]=] ..
        [=[IdL:1/unit:8, RecordIdH:1/unit:8, Offset:1/unit:8,]=] .. [=[ Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RecordIdL:1/unit:8, Rec]=] .. [=[ordIdH:1/unit:8, Datas/string>>]=],
    req = msg.GetSDRReq,
    rsp = msg.GetSDRRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.AddSDR = {
    name = 'AddSDR',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x24,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Datas/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RecordIdL:1/unit:8, Rec]=] .. [=[ordIdH:1/unit:8>>]=],
    req = msg.AddSDRReq,
    rsp = msg.AddSDRRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.AddPartialSDR = {
    name = 'AddPartialSDR',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x25,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<ReserveIdL:1/unit:8, ReserveIdH:1/unit:8, Record]=] ..
        [=[IdL:1/unit:8, RecordIdH:1/unit:8, Offset:1/unit:8,]=] ..
        [=[ Progress:4/unit:1, Reserved:4/unit:1, Datas/strin]=] .. [=[g>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RecordIdL:1/unit:8, Rec]=] .. [=[ordIdH:1/unit:8>>]=],
    req = msg.AddPartialSDRReq,
    rsp = msg.AddPartialSDRRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.ClearSDR = {
    name = 'ClearSDR',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x27,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<RecordIdL:1/unit:8, RecordIdH:1/unit:8, FlagC:1/]=] ..
        [=[unit:8, FlagL:1/unit:8, FlagR:1/unit:8, Operation:]=] .. [=[1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Status:4/unit:1, Reserv]=] .. [=[ed:4/unit:1>>]=],
    req = msg.ClearSDRReq,
    rsp = msg.ClearSDRRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.EnterSDRRepoUpdate = {
    name = 'EnterSDRRepoUpdate',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x2a,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.EnterSDRRepoUpdateReq,
    rsp = msg.EnterSDRRepoUpdateRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.ExitSDRRepoUpdate = {
    name = 'ExitSDRRepoUpdate',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x2b,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.ExitSDRRepoUpdateReq,
    rsp = msg.ExitSDRRepoUpdateRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.RunSDRInitAgent = {
    name = 'RunSDRInitAgent',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x2c,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<RunFlag:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Progress:1/unit:8>>]=],
    req = msg.RunSDRInitAgentReq,
    rsp = msg.RunSDRInitAgentRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetSelInfo = {
    name = 'GetSelInfo',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x40,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, SelVersion:1/unit:8, Se]=] ..
        [=[lCountL:1/unit:8, SelCountH:1/unit:8, FreeL:1/unit]=] ..
        [=[:8, FreeH:1/unit:8, AddTime0:1/unit:8, AddTime1:1/]=] ..
        [=[unit:8, AddTime2:1/unit:8, AddTime3:1/unit:8, DelT]=] ..
        [=[ime0:1/unit:8, DelTime1:1/unit:8, DelTime2:1/unit:]=] ..
        [=[8, DelTime3:1/unit:8, OperationSupport:1/unit:8>>]=],
    req = msg.GetSelInfoReq,
    rsp = msg.GetSelInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSelAllocInfo = {
    name = 'GetSelAllocInfo',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x41,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, UnitL:1/unit:8, UnitH:1]=] ..
        [=[/unit:8, SizeL:1/unit:8, SizeH:1/unit:8, FreeL:1/u]=] ..
        [=[nit:8, FreeH:1/unit:8, BlockL:1/unit:8, BlockH:1/u]=] .. [=[nit:8, MaxSize:1/unit:8>>]=],
    req = msg.GetSelAllocInfoReq,
    rsp = msg.GetSelAllocInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSelReserveId = {
    name = 'GetSelReserveId',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x42,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, ReserveIdL:1/unit:8, Re]=] .. [=[serveIdH:1/unit:8>>]=],
    req = msg.GetSelReserveIdReq,
    rsp = msg.GetSelReserveIdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetSelEntry = {
    name = 'GetSelEntry',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x43,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<ReserveIdL:1/unit:8, ReserveIdH:1/unit:8, Record]=] ..
        [=[IdL:1/unit:8, RecordIdH:1/unit:8, Offset:1/unit:8,]=] .. [=[ Count:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RecordIdL:1/unit:8, Rec]=] .. [=[ordIdH:1/unit:8, Datas:16/string>>]=],
    req = msg.GetSelEntryReq,
    rsp = msg.GetSelEntryRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.AddSelEntry = {
    name = 'AddSelEntry',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x44,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<RecordId:2/unit:8, SelType:1/unit:8, Timestamp:4]=] ..
        [=[/unit:8, GeneratorId:2/unit:8, MsgVersion:1/unit:8]=] ..
        [=[, SensorType:1/unit:8, SensorNumber:1/unit:8, Even]=] ..
        [=[tType:7/unit:1, EventDir:1/unit:1, Datas:3/string>]=] .. [=[>]=],
    encode = [=[<<CompletionCode:1/unit:8, RecordId:2/unit:8>>]=],
    req = msg.AddSelEntryReq,
    rsp = msg.AddSelEntryRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.ClearSel = {
    name = 'ClearSel',
    prio = types.Priority.Default,
    netfn = 0x0a,
    cmd = 0x47,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<ReserveIdL:1/unit:8, ReserveIdH:1/unit:8, FlagC:]=] ..
        [=[1/unit:8, FlagL:1/unit:8, FlagR:1/unit:8, Operatio]=] .. [=[n:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Status:4/unit:1, Reserv]=] .. [=[ed:4/unit:1>>]=],
    req = msg.ClearSelReq,
    rsp = msg.ClearSelRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.OEMGetSystemSel = {
    name = 'OEMGetSystemSel',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x91,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,09]=],
    decode = [=[<<ManuId:3/unit:8, 0x09:1/unit:8, RecordId:2/unit:]=] .. [=[8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8, Record]=] .. [=[Id:2/unit:8, Datas:16/string>>]=],
    req = msg.OEMGetSystemSelReq,
    rsp = msg.OEMGetSystemSelRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.OEMGetSystemSel2 = {
    name = 'OEMGetSystemSel2',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,2B]=],
    decode = [=[<<ManuId:3/unit:8, 0x2B:1/unit:8, RecordId:2/unit:]=] .. [=[8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8, Record]=] .. [=[Id:2/unit:8, Datas:16/string>>]=],
    req = msg.OEMGetSystemSel2Req,
    rsp = msg.OEMGetSystemSel2Rsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetBMCEnables = {
    name = 'SetBMCEnables',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x2e,
    role = types.Role.User,
    privilege = privilege.UserMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<Enable:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetBMCEnablesReq,
    rsp = msg.SetBMCEnablesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Forbidden'
}

SensorIpmiCmds.GetBMCEnables = {
    name = 'GetBMCEnables',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x2f,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[]=],
    encode = [=[<<CompletionCode:1/unit:8, Enable:1/unit:8>>]=],
    req = msg.GetBMCEnablesReq,
    rsp = msg.GetBMCEnablesRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.SetBIOSEventData = {
    name = 'SetBIOSEventData',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,0F]=],
    decode = [=[<<ManuId:3/unit:8, 0x05:1/unit:8, 0x0F:1/unit:8, E]=] ..
        [=[ventDir:1/unit:8, DeviceStatus:1/unit:8, Datas/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8>>]=],
    req = msg.SetBIOSEventDataReq,
    rsp = msg.SetBIOSEventDataRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

SensorIpmiCmds.GetDeviceLocatorRecordId = {
    name = 'GetDeviceLocatorRecordId',
    prio = types.Priority.Default,
    netfn = 0x2c,
    cmd = 0x0d,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, FruDeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PicmgIdentifier:1/unit:]=] ..
        [=[8, RecordIdLs:1/unit:8, RecordIdMs:1/unit:8>>]=],
    req = msg.GetDeviceLocatorRecordIdReq,
    rsp = msg.GetDeviceLocatorRecordIdRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return SensorIpmiCmds
