--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBMCEnables = {}

---@class SensorIpmiCmds.SetBMCEnablesReq
---@field Enable integer
local TSetBMCEnablesReq = {}
TSetBMCEnablesReq.__index = TSetBMCEnablesReq
TSetBMCEnablesReq.group = {}

local function TSetBMCEnablesReq_from_obj(obj)
    return setmetatable(obj, TSetBMCEnablesReq)
end

function TSetBMCEnablesReq.new(Enable)
    return TSetBMCEnablesReq_from_obj({Enable = Enable})
end
---@param obj SensorIpmiCmds.SetBMCEnablesReq
function TSetBMCEnablesReq:init_from_obj(obj)
    self.Enable = obj.Enable
end

function TSetBMCEnablesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBMCEnablesReq.group)
end

TSetBMCEnablesReq.from_obj = TSetBMCEnablesReq_from_obj

TSetBMCEnablesReq.proto_property = {'Enable'}

TSetBMCEnablesReq.default = {0}

TSetBMCEnablesReq.struct = {{name = 'Enable', is_array = false, struct = nil}}

function TSetBMCEnablesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enable', self.Enable, 'uint8', false, errs, need_convert)

    TSetBMCEnablesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBMCEnablesReq.proto_property, errs, need_convert)
    return self
end

function TSetBMCEnablesReq:unpack(_)
    return self.Enable
end

SetBMCEnables.SetBMCEnablesReq = TSetBMCEnablesReq

---@class SensorIpmiCmds.SetBMCEnablesRsp
---@field CompletionCode integer
local TSetBMCEnablesRsp = {}
TSetBMCEnablesRsp.__index = TSetBMCEnablesRsp
TSetBMCEnablesRsp.group = {}

local function TSetBMCEnablesRsp_from_obj(obj)
    return setmetatable(obj, TSetBMCEnablesRsp)
end

function TSetBMCEnablesRsp.new(CompletionCode)
    return TSetBMCEnablesRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetBMCEnablesRsp
function TSetBMCEnablesRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetBMCEnablesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBMCEnablesRsp.group)
end

TSetBMCEnablesRsp.from_obj = TSetBMCEnablesRsp_from_obj

TSetBMCEnablesRsp.proto_property = {'CompletionCode'}

TSetBMCEnablesRsp.default = {0}

TSetBMCEnablesRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetBMCEnablesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetBMCEnablesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBMCEnablesRsp.proto_property, errs, need_convert)
    return self
end

function TSetBMCEnablesRsp:unpack(_)
    return self.CompletionCode
end

SetBMCEnables.SetBMCEnablesRsp = TSetBMCEnablesRsp

return SetBMCEnables
