--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorReading = {}

---@class SensorIpmiCmds.GetSensorReadingReq
---@field Number integer
local TGetSensorReadingReq = {}
TGetSensorReadingReq.__index = TGetSensorReadingReq
TGetSensorReadingReq.group = {}

local function TGetSensorReadingReq_from_obj(obj)
    return setmetatable(obj, TGetSensorReadingReq)
end

function TGetSensorReadingReq.new(Number)
    return TGetSensorReadingReq_from_obj({Number = Number})
end
---@param obj SensorIpmiCmds.GetSensorReadingReq
function TGetSensorReadingReq:init_from_obj(obj)
    self.Number = obj.Number
end

function TGetSensorReadingReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorReadingReq.group)
end

TGetSensorReadingReq.from_obj = TGetSensorReadingReq_from_obj

TGetSensorReadingReq.proto_property = {'Number'}

TGetSensorReadingReq.default = {0}

TGetSensorReadingReq.struct = {{name = 'Number', is_array = false, struct = nil}}

function TGetSensorReadingReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)

    TGetSensorReadingReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorReadingReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorReadingReq:unpack(_)
    return self.Number
end

GetSensorReading.GetSensorReadingReq = TGetSensorReadingReq

---@class SensorIpmiCmds.GetSensorReadingRsp
---@field CompletionCode integer
---@field Reading integer
---@field Reserved integer
---@field InitialProgress integer
---@field ScanDisabled integer
---@field AllDisabled integer
---@field AssertStatus integer
local TGetSensorReadingRsp = {}
TGetSensorReadingRsp.__index = TGetSensorReadingRsp
TGetSensorReadingRsp.group = {}

local function TGetSensorReadingRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorReadingRsp)
end

function TGetSensorReadingRsp.new(CompletionCode, Reading, Reserved, InitialProgress, ScanDisabled, AllDisabled,
    AssertStatus)
    return TGetSensorReadingRsp_from_obj({
        CompletionCode = CompletionCode,
        Reading = Reading,
        Reserved = Reserved,
        InitialProgress = InitialProgress,
        ScanDisabled = ScanDisabled,
        AllDisabled = AllDisabled,
        AssertStatus = AssertStatus
    })
end
---@param obj SensorIpmiCmds.GetSensorReadingRsp
function TGetSensorReadingRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Reading = obj.Reading
    self.Reserved = obj.Reserved
    self.InitialProgress = obj.InitialProgress
    self.ScanDisabled = obj.ScanDisabled
    self.AllDisabled = obj.AllDisabled
    self.AssertStatus = obj.AssertStatus
end

function TGetSensorReadingRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorReadingRsp.group)
end

TGetSensorReadingRsp.from_obj = TGetSensorReadingRsp_from_obj

TGetSensorReadingRsp.proto_property = {
    'CompletionCode', 'Reading', 'Reserved', 'InitialProgress', 'ScanDisabled', 'AllDisabled', 'AssertStatus'
}

TGetSensorReadingRsp.default = {0, 0, 0, 0, 0, 0, 0}

TGetSensorReadingRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Reading', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'InitialProgress', is_array = false, struct = nil},
    {name = 'ScanDisabled', is_array = false, struct = nil}, {name = 'AllDisabled', is_array = false, struct = nil},
    {name = 'AssertStatus', is_array = false, struct = nil}
}

function TGetSensorReadingRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InitialProgress', self.InitialProgress, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ScanDisabled', self.ScanDisabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AllDisabled', self.AllDisabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AssertStatus', self.AssertStatus, 'uint16', false, errs, need_convert)

    TGetSensorReadingRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorReadingRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorReadingRsp:unpack(_)
    return self.CompletionCode, self.Reading, self.Reserved, self.InitialProgress, self.ScanDisabled, self.AllDisabled,
        self.AssertStatus
end

GetSensorReading.GetSensorReadingRsp = TGetSensorReadingRsp

return GetSensorReading
