--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorHysteresis = {}

---@class SensorIpmiCmds.GetSensorHysteresisReq
---@field Number integer
---@field Reserved integer
local TGetSensorHysteresisReq = {}
TGetSensorHysteresisReq.__index = TGetSensorHysteresisReq
TGetSensorHysteresisReq.group = {}

local function TGetSensorHysteresisReq_from_obj(obj)
    return setmetatable(obj, TGetSensorHysteresisReq)
end

function TGetSensorHysteresisReq.new(Number, Reserved)
    return TGetSensorHysteresisReq_from_obj({Number = Number, Reserved = Reserved})
end
---@param obj SensorIpmiCmds.GetSensorHysteresisReq
function TGetSensorHysteresisReq:init_from_obj(obj)
    self.Number = obj.Number
    self.Reserved = obj.Reserved
end

function TGetSensorHysteresisReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorHysteresisReq.group)
end

TGetSensorHysteresisReq.from_obj = TGetSensorHysteresisReq_from_obj

TGetSensorHysteresisReq.proto_property = {'Number', 'Reserved'}

TGetSensorHysteresisReq.default = {0, 0}

TGetSensorHysteresisReq.struct = {
    {name = 'Number', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil}
}

function TGetSensorHysteresisReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)

    TGetSensorHysteresisReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorHysteresisReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorHysteresisReq:unpack(_)
    return self.Number, self.Reserved
end

GetSensorHysteresis.GetSensorHysteresisReq = TGetSensorHysteresisReq

---@class SensorIpmiCmds.GetSensorHysteresisRsp
---@field CompletionCode integer
---@field PHysteresis integer
---@field NHysteresis integer
local TGetSensorHysteresisRsp = {}
TGetSensorHysteresisRsp.__index = TGetSensorHysteresisRsp
TGetSensorHysteresisRsp.group = {}

local function TGetSensorHysteresisRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorHysteresisRsp)
end

function TGetSensorHysteresisRsp.new(CompletionCode, PHysteresis, NHysteresis)
    return TGetSensorHysteresisRsp_from_obj({
        CompletionCode = CompletionCode,
        PHysteresis = PHysteresis,
        NHysteresis = NHysteresis
    })
end
---@param obj SensorIpmiCmds.GetSensorHysteresisRsp
function TGetSensorHysteresisRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PHysteresis = obj.PHysteresis
    self.NHysteresis = obj.NHysteresis
end

function TGetSensorHysteresisRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorHysteresisRsp.group)
end

TGetSensorHysteresisRsp.from_obj = TGetSensorHysteresisRsp_from_obj

TGetSensorHysteresisRsp.proto_property = {'CompletionCode', 'PHysteresis', 'NHysteresis'}

TGetSensorHysteresisRsp.default = {0, 0, 0}

TGetSensorHysteresisRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'PHysteresis', is_array = false, struct = nil},
    {name = 'NHysteresis', is_array = false, struct = nil}
}

function TGetSensorHysteresisRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PHysteresis', self.PHysteresis, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'NHysteresis', self.NHysteresis, 'uint8', false, errs, need_convert)

    TGetSensorHysteresisRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorHysteresisRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorHysteresisRsp:unpack(_)
    return self.CompletionCode, self.PHysteresis, self.NHysteresis
end

GetSensorHysteresis.GetSensorHysteresisRsp = TGetSensorHysteresisRsp

return GetSensorHysteresis
