--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorEventEnable = {}

---@class SensorIpmiCmds.GetSensorEventEnableReq
---@field Number integer
local TGetSensorEventEnableReq = {}
TGetSensorEventEnableReq.__index = TGetSensorEventEnableReq
TGetSensorEventEnableReq.group = {}

local function TGetSensorEventEnableReq_from_obj(obj)
    return setmetatable(obj, TGetSensorEventEnableReq)
end

function TGetSensorEventEnableReq.new(Number)
    return TGetSensorEventEnableReq_from_obj({Number = Number})
end
---@param obj SensorIpmiCmds.GetSensorEventEnableReq
function TGetSensorEventEnableReq:init_from_obj(obj)
    self.Number = obj.Number
end

function TGetSensorEventEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorEventEnableReq.group)
end

TGetSensorEventEnableReq.from_obj = TGetSensorEventEnableReq_from_obj

TGetSensorEventEnableReq.proto_property = {'Number'}

TGetSensorEventEnableReq.default = {0}

TGetSensorEventEnableReq.struct = {{name = 'Number', is_array = false, struct = nil}}

function TGetSensorEventEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)

    TGetSensorEventEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorEventEnableReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorEventEnableReq:unpack(_)
    return self.Number
end

GetSensorEventEnable.GetSensorEventEnableReq = TGetSensorEventEnableReq

---@class SensorIpmiCmds.GetSensorEventEnableRsp
---@field CompletionCode integer
---@field Reserved integer
---@field ScanDisabled integer
---@field AllDisabled integer
---@field AssertMask integer
---@field DeassertMask integer
local TGetSensorEventEnableRsp = {}
TGetSensorEventEnableRsp.__index = TGetSensorEventEnableRsp
TGetSensorEventEnableRsp.group = {}

local function TGetSensorEventEnableRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorEventEnableRsp)
end

function TGetSensorEventEnableRsp.new(CompletionCode, Reserved, ScanDisabled, AllDisabled, AssertMask, DeassertMask)
    return TGetSensorEventEnableRsp_from_obj({
        CompletionCode = CompletionCode,
        Reserved = Reserved,
        ScanDisabled = ScanDisabled,
        AllDisabled = AllDisabled,
        AssertMask = AssertMask,
        DeassertMask = DeassertMask
    })
end
---@param obj SensorIpmiCmds.GetSensorEventEnableRsp
function TGetSensorEventEnableRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Reserved = obj.Reserved
    self.ScanDisabled = obj.ScanDisabled
    self.AllDisabled = obj.AllDisabled
    self.AssertMask = obj.AssertMask
    self.DeassertMask = obj.DeassertMask
end

function TGetSensorEventEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorEventEnableRsp.group)
end

TGetSensorEventEnableRsp.from_obj = TGetSensorEventEnableRsp_from_obj

TGetSensorEventEnableRsp.proto_property = {
    'CompletionCode', 'Reserved', 'ScanDisabled', 'AllDisabled', 'AssertMask', 'DeassertMask'
}

TGetSensorEventEnableRsp.default = {0, 0, 0, 0, 0, 0}

TGetSensorEventEnableRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'ScanDisabled', is_array = false, struct = nil}, {name = 'AllDisabled', is_array = false, struct = nil},
    {name = 'AssertMask', is_array = false, struct = nil}, {name = 'DeassertMask', is_array = false, struct = nil}
}

function TGetSensorEventEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ScanDisabled', self.ScanDisabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AllDisabled', self.AllDisabled, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AssertMask', self.AssertMask, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'DeassertMask', self.DeassertMask, 'uint16', false, errs, need_convert)

    TGetSensorEventEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorEventEnableRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorEventEnableRsp:unpack(_)
    return self.CompletionCode, self.Reserved, self.ScanDisabled, self.AllDisabled, self.AssertMask, self.DeassertMask
end

GetSensorEventEnable.GetSensorEventEnableRsp = TGetSensorEventEnableRsp

return GetSensorEventEnable
