--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSDR = {}

---@class SensorIpmiCmds.GetSDRReq
---@field ReserveIdL integer
---@field ReserveIdH integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Offset integer
---@field Length integer
local TGetSDRReq = {}
TGetSDRReq.__index = TGetSDRReq
TGetSDRReq.group = {}

local function TGetSDRReq_from_obj(obj)
    return setmetatable(obj, TGetSDRReq)
end

function TGetSDRReq.new(ReserveIdL, ReserveIdH, RecordIdL, RecordIdH, Offset, Length)
    return TGetSDRReq_from_obj({
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Offset = Offset,
        Length = Length
    })
end
---@param obj SensorIpmiCmds.GetSDRReq
function TGetSDRReq:init_from_obj(obj)
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRReq.group)
end

TGetSDRReq.from_obj = TGetSDRReq_from_obj

TGetSDRReq.proto_property = {'ReserveIdL', 'ReserveIdH', 'RecordIdL', 'RecordIdH', 'Offset', 'Length'}

TGetSDRReq.default = {0, 0, 0, 0, 0, 0}

TGetSDRReq.struct = {
    {name = 'ReserveIdL', is_array = false, struct = nil}, {name = 'ReserveIdH', is_array = false, struct = nil},
    {name = 'RecordIdL', is_array = false, struct = nil}, {name = 'RecordIdH', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil}
}

function TGetSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRReq.proto_property, errs, need_convert)
    return self
end

function TGetSDRReq:unpack(_)
    return self.ReserveIdL, self.ReserveIdH, self.RecordIdL, self.RecordIdH, self.Offset, self.Length
end

GetSDR.GetSDRReq = TGetSDRReq

---@class SensorIpmiCmds.GetSDRRsp
---@field CompletionCode integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Datas string
local TGetSDRRsp = {}
TGetSDRRsp.__index = TGetSDRRsp
TGetSDRRsp.group = {}

local function TGetSDRRsp_from_obj(obj)
    return setmetatable(obj, TGetSDRRsp)
end

function TGetSDRRsp.new(CompletionCode, RecordIdL, RecordIdH, Datas)
    return TGetSDRRsp_from_obj({
        CompletionCode = CompletionCode,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.GetSDRRsp
function TGetSDRRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Datas = obj.Datas
end

function TGetSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRRsp.group)
end

TGetSDRRsp.from_obj = TGetSDRRsp_from_obj

TGetSDRRsp.proto_property = {'CompletionCode', 'RecordIdL', 'RecordIdH', 'Datas'}

TGetSDRRsp.default = {0, 0, 0, ''}

TGetSDRRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RecordIdL', is_array = false, struct = nil},
    {name = 'RecordIdH', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TGetSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TGetSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRRsp.proto_property, errs, need_convert)
    return self
end

function TGetSDRRsp:unpack(_)
    return self.CompletionCode, self.RecordIdL, self.RecordIdH, self.Datas
end

GetSDR.GetSDRRsp = TGetSDRRsp

return GetSDR
