--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ExitSDRRepoUpdate = {}

---@class SensorIpmiCmds.ExitSDRRepoUpdateReq
local TExitSDRRepoUpdateReq = {}
TExitSDRRepoUpdateReq.__index = TExitSDRRepoUpdateReq
TExitSDRRepoUpdateReq.group = {}

local function TExitSDRRepoUpdateReq_from_obj(obj)
    return setmetatable(obj, TExitSDRRepoUpdateReq)
end

function TExitSDRRepoUpdateReq.new()
    return TExitSDRRepoUpdateReq_from_obj({})
end
---@param obj SensorIpmiCmds.ExitSDRRepoUpdateReq
function TExitSDRRepoUpdateReq:init_from_obj(obj)

end

function TExitSDRRepoUpdateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExitSDRRepoUpdateReq.group)
end

TExitSDRRepoUpdateReq.from_obj = TExitSDRRepoUpdateReq_from_obj

TExitSDRRepoUpdateReq.proto_property = {}

TExitSDRRepoUpdateReq.default = {}

TExitSDRRepoUpdateReq.struct = {}

function TExitSDRRepoUpdateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExitSDRRepoUpdateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExitSDRRepoUpdateReq.proto_property, errs, need_convert)
    return self
end

function TExitSDRRepoUpdateReq:unpack(_)
end

ExitSDRRepoUpdate.ExitSDRRepoUpdateReq = TExitSDRRepoUpdateReq

---@class SensorIpmiCmds.ExitSDRRepoUpdateRsp
---@field CompletionCode integer
local TExitSDRRepoUpdateRsp = {}
TExitSDRRepoUpdateRsp.__index = TExitSDRRepoUpdateRsp
TExitSDRRepoUpdateRsp.group = {}

local function TExitSDRRepoUpdateRsp_from_obj(obj)
    return setmetatable(obj, TExitSDRRepoUpdateRsp)
end

function TExitSDRRepoUpdateRsp.new(CompletionCode)
    return TExitSDRRepoUpdateRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.ExitSDRRepoUpdateRsp
function TExitSDRRepoUpdateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TExitSDRRepoUpdateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExitSDRRepoUpdateRsp.group)
end

TExitSDRRepoUpdateRsp.from_obj = TExitSDRRepoUpdateRsp_from_obj

TExitSDRRepoUpdateRsp.proto_property = {'CompletionCode'}

TExitSDRRepoUpdateRsp.default = {0}

TExitSDRRepoUpdateRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TExitSDRRepoUpdateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TExitSDRRepoUpdateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExitSDRRepoUpdateRsp.proto_property, errs, need_convert)
    return self
end

function TExitSDRRepoUpdateRsp:unpack(_)
    return self.CompletionCode
end

ExitSDRRepoUpdate.ExitSDRRepoUpdateRsp = TExitSDRRepoUpdateRsp

return ExitSDRRepoUpdate
