--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local AddPartialSDR = {}

---@class SensorIpmiCmds.AddPartialSDRReq
---@field ReserveIdL integer
---@field ReserveIdH integer
---@field RecordIdL integer
---@field RecordIdH integer
---@field Offset integer
---@field Progress integer
---@field Reserved integer
---@field Datas string
local TAddPartialSDRReq = {}
TAddPartialSDRReq.__index = TAddPartialSDRReq
TAddPartialSDRReq.group = {}

local function TAddPartialSDRReq_from_obj(obj)
    return setmetatable(obj, TAddPartialSDRReq)
end

function TAddPartialSDRReq.new(ReserveIdL, ReserveIdH, RecordIdL, RecordIdH, Offset, Progress, Reserved, Datas)
    return TAddPartialSDRReq_from_obj({
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH,
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        Offset = Offset,
        Progress = Progress,
        Reserved = Reserved,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.AddPartialSDRReq
function TAddPartialSDRReq:init_from_obj(obj)
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.Offset = obj.Offset
    self.Progress = obj.Progress
    self.Reserved = obj.Reserved
    self.Datas = obj.Datas
end

function TAddPartialSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddPartialSDRReq.group)
end

TAddPartialSDRReq.from_obj = TAddPartialSDRReq_from_obj

TAddPartialSDRReq.proto_property = {
    'ReserveIdL', 'ReserveIdH', 'RecordIdL', 'RecordIdH', 'Offset', 'Progress', 'Reserved', 'Datas'
}

TAddPartialSDRReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TAddPartialSDRReq.struct = {
    {name = 'ReserveIdL', is_array = false, struct = nil}, {name = 'ReserveIdH', is_array = false, struct = nil},
    {name = 'RecordIdL', is_array = false, struct = nil}, {name = 'RecordIdH', is_array = false, struct = nil},
    {name = 'Offset', is_array = false, struct = nil}, {name = 'Progress', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TAddPartialSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Progress', self.Progress, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TAddPartialSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddPartialSDRReq.proto_property, errs, need_convert)
    return self
end

function TAddPartialSDRReq:unpack(_)
    return self.ReserveIdL, self.ReserveIdH, self.RecordIdL, self.RecordIdH, self.Offset, self.Progress, self.Reserved,
        self.Datas
end

AddPartialSDR.AddPartialSDRReq = TAddPartialSDRReq

---@class SensorIpmiCmds.AddPartialSDRRsp
---@field CompletionCode integer
---@field RecordIdL integer
---@field RecordIdH integer
local TAddPartialSDRRsp = {}
TAddPartialSDRRsp.__index = TAddPartialSDRRsp
TAddPartialSDRRsp.group = {}

local function TAddPartialSDRRsp_from_obj(obj)
    return setmetatable(obj, TAddPartialSDRRsp)
end

function TAddPartialSDRRsp.new(CompletionCode, RecordIdL, RecordIdH)
    return TAddPartialSDRRsp_from_obj({CompletionCode = CompletionCode, RecordIdL = RecordIdL, RecordIdH = RecordIdH})
end
---@param obj SensorIpmiCmds.AddPartialSDRRsp
function TAddPartialSDRRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
end

function TAddPartialSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddPartialSDRRsp.group)
end

TAddPartialSDRRsp.from_obj = TAddPartialSDRRsp_from_obj

TAddPartialSDRRsp.proto_property = {'CompletionCode', 'RecordIdL', 'RecordIdH'}

TAddPartialSDRRsp.default = {0, 0, 0}

TAddPartialSDRRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RecordIdL', is_array = false, struct = nil},
    {name = 'RecordIdH', is_array = false, struct = nil}
}

function TAddPartialSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)

    TAddPartialSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddPartialSDRRsp.proto_property, errs, need_convert)
    return self
end

function TAddPartialSDRRsp:unpack(_)
    return self.CompletionCode, self.RecordIdL, self.RecordIdH
end

AddPartialSDR.AddPartialSDRRsp = TAddPartialSDRRsp

return AddPartialSDR
