-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local M = {}

M.t_ipmi_sel_filters = {
    {FilterMask1 = 2708, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 1, SensorType = 1},
    {FilterMask1 = 6, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 1},
    {FilterMask1 = 2709, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 1, SensorType = 2},
    {FilterMask1 = 2580, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 1, SensorType = 4},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 4},
    {FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 8, SensorType = 4},
    {FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 5},
    {FilterMask1 = 8191, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 7},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 5, SensorType = 7},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 9, SensorType = 7},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 7},
    {FilterMask1 = 127, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 8},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 11, SensorType = 8},
    {FilterMask1 = 15, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 8},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 8, SensorType = 9},
    {FilterMask1 = 64, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 9},
    {FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 8, SensorType = 10},
    {FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 9, SensorType = 10},
    {FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 10},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 5, SensorType = 12},
    {FilterMask1 = 26623, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 12},
    {FilterMask1 = 455, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 13},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 13},
    {FilterMask1 = 7, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 15},
    {FilterMask1 = 63, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 16},
    {FilterMask1 = 256, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 16},
    {FilterMask1 = 20, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 18},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 18},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 4, SensorType = 18},
    {FilterMask1 = 256, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 18},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 20},
    {FilterMask1 = 21, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 20},
    {FilterMask1 = 70, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 21},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 21},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 4, SensorType = 21},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 23},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 4, SensorType = 23},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 8, SensorType = 23},
    {FilterMask1 = 280, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 10, SensorType = 23},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 25},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 25},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 27},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 4, SensorType = 27},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 4, SensorType = 28},
    {FilterMask1 = 1, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 8, SensorType = 28},
    {FilterMask1 = 135, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 29},
    {FilterMask1 = 31, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 30},
    {FilterMask1 = 64, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 31},
    {FilterMask1 = 771, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 33},
    {FilterMask1 = 16497, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 34},
    {FilterMask1 = 271, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 35},
    {FilterMask1 = 15, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 38},
    {FilterMask1 = 15, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 38},
    {FilterMask1 = 3, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 39},
    {FilterMask1 = 63, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 40},
    {FilterMask1 = 7, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 41},
    {FilterMask1 = 135, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 43},
    {FilterMask1 = 255, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 240},
    {FilterMask1 = 255, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 241},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 6},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 9, SensorType = 22},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 3, SensorType = 22},
    {FilterMask1 = 3504, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 111, SensorType = 19},
    {FilterMask1 = 131, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 7, SensorType = 36},
    {FilterMask1 = 2, FilterMask2 = 65535, FilterMask3 = 65535, ReadingType = 8, SensorType = 33}
}
M.t_ipmi_sel_descs = {
    {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Lower Non-critical going low ]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Lower Non-critical going high]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Lower Critical going low ]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Lower Critical going high]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Lower Non-recoverable going low ]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Lower Non-recoverable going high]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Upper Non-critical going low ]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Upper Non-critical going high]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Upper Critical going low ]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Upper Critical going high]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 10,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Upper Non-recoverable going low ]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 1,
        SelData1 = 11,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Upper Non-recoverable going high]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 2,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Idle]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 2,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Active]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 2,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Busy]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 3,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[State Deasserted]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 3,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[State Asserted]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 4,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Predictive Failure Deasserted]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 4,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Predictive Failure Asserted]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 5,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Limit Not Exceeded]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 5,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Limit Exceeded]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 6,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Performance Met]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 6,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Performance Lags]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to OK]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Non-critical from OK]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Critical from less severe]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Non-recoverable from less severe]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Non-critical from more severe]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Critical from Non-recoverable]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Non-recoverable]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Monitor]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 7,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Informational]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 8,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Device Absent]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 8,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Device Present]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 9,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Device Disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 9,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Device Enabled]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Running]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to In Test]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Power Off]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to On Line]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Off Line]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Off Duty]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Degraded]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to Power Save]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 10,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Install Error]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Fully Redundant]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Redundancy Lost]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Redundancy Degraded]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Non-Redundant: Sufficient from Redundant]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Non-Redundant: Sufficient from Insufficient]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Non-Redundant: Insufficient Resources]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Redundancy Degraded from Fully Redundant]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 11,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Redundancy Degraded from Non-Redundant]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 12,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[D0 Power State]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 12,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[D1 Power State]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 12,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[D2 Power State]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 255,
        ReadingType = 12,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[D3 Power State]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[General Chassis intrusion]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Drive Bay intrusion]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[I/O Card area intrusion]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Processor area intrusion]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[System unplugged from LAN]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Unauthorized dock]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 5,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FAN area intrusion]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 6,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Front Panel Lockout violation attempted]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 6,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Pre-boot password violation - user password]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 6,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Pre-boot password violation - setup password]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 6,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Pre-boot password violation - network boot passwor]=] .. [=[d]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 6,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Other pre-boot password violation]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 6,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Out-of-band access password violation]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[IERR]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Thermal Trip]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FRB1/BIST failure]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FRB2/Hang in POST failure]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FRB3/Processor startup/init failure]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Configuration Error]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[SM BIOS Uncorrectable CPU-complex Error]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Presence detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Terminator presence detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 10,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Throttled]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 11,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Uncorrectable machine check exception]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 7,
        ReadingType = 111,
        SelData1 = 12,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Correctable machine check error]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Presence detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Failure detected]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Predictive failure]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power Supply AC lost]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[AC lost or out-of-range]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[AC out-of-range, but present]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 0,
        SelData3 = 255,
        SelDesc = [=[Config Error: Vendor Mismatch]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Config Error: Revision Mismatch]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Config Error: Processor Missing]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Config Error: Power Supply Rating Mismatch]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[Config Error: Voltage Rating Mismatch]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Config Error]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 8,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power Supply Inactive]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power off/down]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power cycle]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[240VA power down]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Interlock power down]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[AC lost]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Soft-power control failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Failure detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 9,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Predictive failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Correctable ECC]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Uncorrectable ECC]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Parity]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Memory Scrub Failed]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Memory Device Disabled]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Correctable ECC logging limit reached]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Presence detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Configuration Error]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Spare]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Throttled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 12,
        ReadingType = 111,
        SelData1 = 10,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Critical Overtemperature]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Drive Present]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Drive Fault]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Predictive Failure]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Hot Spare]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Parity Check In Progress]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[In Critical Array]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[In Failed Array]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Rebuild In Progress]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 13,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Rebuild Aborted]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 0,
        SelData3 = 255,
        SelDesc = [=[Unspecified]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[No system memory installed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[No usable system memory]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Unrecoverable IDE device failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[Unrecoverable system-board failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 5,
        SelData3 = 255,
        SelDesc = [=[Unrecoverable diskette failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 6,
        SelData3 = 255,
        SelDesc = [=[Unrecoverable hard-disk controller failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 7,
        SelData3 = 255,
        SelDesc = [=[Unrecoverable PS/2 or USB keyboard failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 8,
        SelData3 = 255,
        SelDesc = [=[Removable boot media not found]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 9,
        SelData3 = 255,
        SelDesc = [=[Unrecoverable video controller failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 10,
        SelData3 = 255,
        SelDesc = [=[No video device selected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 11,
        SelData3 = 255,
        SelDesc = [=[BIOS corruption detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 12,
        SelData3 = 255,
        SelDesc = [=[CPU voltage mismatch]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 13,
        SelData3 = 255,
        SelDesc = [=[CPU speed mismatch failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Unknown Error]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 0,
        SelData3 = 255,
        SelDesc = [=[Unspecified]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Memory initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Hard-disk initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Secondary CPU Initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[User authentication]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 5,
        SelData3 = 255,
        SelDesc = [=[User-initiated system setup]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 6,
        SelData3 = 255,
        SelDesc = [=[USB resource configuration]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 7,
        SelData3 = 255,
        SelDesc = [=[PCI resource configuration]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 8,
        SelData3 = 255,
        SelDesc = [=[Option ROM initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 9,
        SelData3 = 255,
        SelDesc = [=[Video initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 10,
        SelData3 = 255,
        SelDesc = [=[Cache initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 11,
        SelData3 = 255,
        SelDesc = [=[SMBus initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 12,
        SelData3 = 255,
        SelDesc = [=[Keyboard controller initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 13,
        SelData3 = 255,
        SelDesc = [=[Management controller initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 14,
        SelData3 = 255,
        SelDesc = [=[Docking station attachment]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 15,
        SelData3 = 255,
        SelDesc = [=[Enabling docking station]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 16,
        SelData3 = 255,
        SelDesc = [=[Docking station ejection]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 17,
        SelData3 = 255,
        SelDesc = [=[Disabling docking station]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 18,
        SelData3 = 255,
        SelDesc = [=[Calling operating system wake-up vector]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 19,
        SelData3 = 255,
        SelDesc = [=[System boot initiated]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 20,
        SelData3 = 255,
        SelDesc = [=[Motherboard initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 21,
        SelData3 = 255,
        SelDesc = [=[reserved]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 22,
        SelData3 = 255,
        SelDesc = [=[Floppy initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 23,
        SelData3 = 255,
        SelDesc = [=[Keyboard test]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 24,
        SelData3 = 255,
        SelDesc = [=[Pointing device test]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 25,
        SelData3 = 255,
        SelDesc = [=[Primary CPU initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Unknown Hang]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 0,
        SelData3 = 255,
        SelDesc = [=[Unspecified]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Memory initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Hard-disk initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Secondary CPU Initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[User authentication]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 5,
        SelData3 = 255,
        SelDesc = [=[User-initiated system setup]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 6,
        SelData3 = 255,
        SelDesc = [=[USB resource configuration]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 7,
        SelData3 = 255,
        SelDesc = [=[PCI resource configuration]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 8,
        SelData3 = 255,
        SelDesc = [=[Option ROM initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 9,
        SelData3 = 255,
        SelDesc = [=[Video initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 10,
        SelData3 = 255,
        SelDesc = [=[Cache initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 11,
        SelData3 = 255,
        SelDesc = [=[SMBus initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 12,
        SelData3 = 255,
        SelDesc = [=[Keyboard controller initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 13,
        SelData3 = 255,
        SelDesc = [=[Management controller initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 14,
        SelData3 = 255,
        SelDesc = [=[Docking station attachment]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 15,
        SelData3 = 255,
        SelDesc = [=[Enabling docking station]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 16,
        SelData3 = 255,
        SelDesc = [=[Docking station ejection]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 17,
        SelData3 = 255,
        SelDesc = [=[Disabling docking station]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 18,
        SelData3 = 255,
        SelDesc = [=[Calling operating system wake-up vector]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 19,
        SelData3 = 255,
        SelDesc = [=[System boot initiated]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 20,
        SelData3 = 255,
        SelDesc = [=[Motherboard initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 21,
        SelData3 = 255,
        SelDesc = [=[reserved]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 22,
        SelData3 = 255,
        SelDesc = [=[Floppy initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 23,
        SelData3 = 255,
        SelDesc = [=[Keyboard test]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 24,
        SelData3 = 255,
        SelDesc = [=[Pointing device test]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 25,
        SelData3 = 255,
        SelDesc = [=[Primary CPU initialization]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 15,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Unknown Progress]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 16,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Correctable memory error logging disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 16,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Event logging disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 16,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Log area reset/cleared]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 16,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[All event logging disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 16,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Log full]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 16,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Log almost full]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[BIOS Reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS Reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS Shut Down]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS Power Down]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS Power Cycle]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS NMI/Diag Interrupt]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS Expired]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 17,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS pre-timeout Interrupt]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 18,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[System Reconfigured]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 18,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OEM System boot event]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 18,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Undetermined system hardware failure]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 18,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Entry added to auxiliary log]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 18,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[PEF Action]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 18,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Timestamp Clock Sync]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[NMI/Diag Interrupt]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Bus Timeout]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[I/O Channel check NMI]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Software NMI]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[PCI PERR]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[PCI SERR]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[EISA failsafe timeout]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Bus Correctable error]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Bus Uncorrectable error]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Fatal NMI]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 10,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Bus Fatal Error]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 19,
        ReadingType = 111,
        SelData1 = 11,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Bus Degraded]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 20,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power Button pressed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 20,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Sleep Button pressed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 20,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Reset Button pressed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 20,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FRU Latch]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 20,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FRU Service]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 25,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Soft Power Control Failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 25,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Thermal Trip]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 27,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Connected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 27,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Config Error]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Initiated by power up]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Initiated by hard reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Initiated by warm reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[User requested PXE boot]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Automatic boot to diagnostic]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS initiated hard reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS initiated warm reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[System Restart]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 30,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[No bootable media]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 30,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Non-bootable disk in drive]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 30,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[PXE server not found]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 30,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Invalid boot sector]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 30,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Timeout waiting for selection]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[A: boot completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[C: boot completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[PXE boot completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Diagnostic boot completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[CD-ROM boot completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[ROM boot completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[boot completed - boot device not specified]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Installation started]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Installation completed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Installation aborted]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 31,
        ReadingType = 111,
        SelData1 = 10,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Installation failed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 32,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Error during system startup]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 32,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Run-time critical stop]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 32,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS graceful stop]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 32,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[OS graceful shutdown]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 32,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[PEF initiated soft shutdown]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 32,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Agent not responding]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Fault Status]=],
        AlarmLevel = 2,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Identify Status]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Device Installed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Ready for Device Installation]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Ready for Device Removal]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Slot Power is Off]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Device Removal Request]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Interlock]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Slot is Disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 33,
        ReadingType = 111,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Spare Device]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S0/G0: working]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S1: sleeping with system hw & processor context ma]=] .. [=[intained]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S2: sleeping, processor context lost]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S3: sleeping, processor & hw context lost, memory ]=] .. [=[retained]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S4: non-volatile sleep/suspend-to-disk]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S5/G2: soft-off]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S4/S5: soft-off]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[G3: mechanical off]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Sleeping in S1/S2/S3 state]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 9,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[G1: sleeping]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 10,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[S5: entered by override]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 11,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Legacy ON state]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 12,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Legacy OFF state]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 34,
        ReadingType = 111,
        SelData1 = 14,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Unknown]=],
        AlarmLevel = 3,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Timer expired]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Hard reset]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power down]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Power cycle]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[reserved]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[reserved]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[reserved]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[reserved]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 35,
        ReadingType = 111,
        SelData1 = 8,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Timer interrupt]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 36,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Platform generated page]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 36,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Platform generated LAN alert]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 36,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Platform Event Trap generated]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 36,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Platform generated SNMP trap, OEM format]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 37,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Present]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 37,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Absent]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 37,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 39,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Heartbeat Lost]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 39,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Heartbeat]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 40,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Sensor access degraded or unavailable]=],
        AlarmLevel = 1,
        ShieldFlag = 0
    }, {
        SensorType = 40,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Controller access degraded or unavailable]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 40,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Management controller off-line]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 40,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Management controller unavailable]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 40,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Sensor failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 40,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[FRU failure]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 41,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Low]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 41,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Failed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 41,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Presence Detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Hardware change detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 0,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl D]=] .. [=[ev Id]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl F]=] .. [=[irm Rev]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl D]=] .. [=[ev Rev]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl M]=] .. [=[anuf Id]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 5,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl I]=] .. [=[PMI Vers]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 6,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl A]=] .. [=[ux Firm Id]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 7,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl F]=] .. [=[irm Boot Block]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 8,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt Ctrl O]=] .. [=[ther]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 9,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, BIOS/EFI cha]=] .. [=[nge]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 10,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, SMBIOS chang]=] .. [=[e]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 11,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, O/S change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 12,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, O/S loader c]=] .. [=[hange]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 13,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Service Diag]=] .. [=[ change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 14,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt SW age]=] .. [=[nt change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 15,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt SW App]=] .. [=[ change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 16,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Mngmt SW Mid]=] .. [=[dle]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 17,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, Prog HW Chan]=] .. [=[ge (FPGA)]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 18,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, board/FRU mo]=] .. [=[dule change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 19,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, board/FRU co]=] .. [=[mponent change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 20,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, board/FRU re]=] .. [=[place equ ver]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 21,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, board/FRU re]=] .. [=[place new ver]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 22,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, board/FRU re]=] .. [=[place old ver]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 23,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change detected, board/FRU HW]=] .. [=[ conf change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Hardware incompatibility detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Firmware or software incompatibility detected]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Invalid or unsupported hardware version]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Invalid or unsupported firmware or software versio]=] .. [=[n]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Hardware change success]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 0,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl De]=] .. [=[v Id]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl Fi]=] .. [=[rm Rev]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl De]=] .. [=[v Rev]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl Ma]=] .. [=[nuf Id]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 5,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl IP]=] .. [=[MI Vers]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 6,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl Au]=] .. [=[x Firm Id]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 7,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl Fi]=] .. [=[rm Boot Block]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 8,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt Ctrl Ot]=] .. [=[her]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 9,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, BIOS/EFI chan]=] .. [=[ge]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 10,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, SMBIOS change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 11,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, O/S change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 12,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, O/S loader ch]=] .. [=[ange]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 13,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Service Diag ]=] .. [=[change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 14,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt SW agen]=] .. [=[t change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 15,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt SW App ]=] .. [=[change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 16,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Mngmt SW Midd]=] .. [=[le]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 17,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, Prog HW Chang]=] .. [=[e (FPGA)]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 18,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, board/FRU mod]=] .. [=[ule change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 19,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, board/FRU com]=] .. [=[ponent change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 20,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, board/FRU rep]=] .. [=[lace equ ver]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 21,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, board/FRU rep]=] .. [=[lace new ver]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 22,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, board/FRU rep]=] .. [=[lace old ver]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 43,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 23,
        SelData3 = 255,
        SelDesc = [=[Firmware or software change success, board/FRU HW ]=] .. [=[conf change]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Not Installed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Inactive]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Activation Requested]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Activation in Progress]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Active]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Deactivation Requested]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Deactivation in Progress]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 44,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Communication lost]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M0]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M1]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M2]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M3]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 4,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M4]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 5,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M5]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 6,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M6]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 240,
        ReadingType = 111,
        SelData1 = 7,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Transition to M7]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 241,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[IPMB-A disabled, IPMB-B disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 241,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[IPMB-A enabled, IPMB-B disabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 241,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[IPMB-A disabled, IPMB-B enabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 241,
        ReadingType = 111,
        SelData1 = 3,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[IPMB-A enabled, IPMP-B enabled]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 242,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Module Handle Closed]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 242,
        ReadingType = 111,
        SelData1 = 1,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Module Handle Opened]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 242,
        ReadingType = 111,
        SelData1 = 2,
        SelData2 = 255,
        SelData3 = 255,
        SelDesc = [=[Quiesced]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 29,
        ReadingType = 111,
        SelData1 = 0,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Initiated by power up]=],
        AlarmLevel = 0,
        ShieldFlag = 0
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 0,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Leakage disappears on the CPU Drawer or any Liquid]=] .. [=[ quick connector]=],
        AlarmLevel = 0,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 1,
        SelData2 = 1,
        SelData3 = 255,
        SelDesc = [=[Leakage occurred on the CPU Drawer or any Liquid q]=] .. [=[uick connector]=],
        AlarmLevel = 3,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 0,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Leakage disappears on the CpuBoard1]=],
        AlarmLevel = 0,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 1,
        SelData2 = 2,
        SelData3 = 255,
        SelDesc = [=[Leakage occurred on the CpuBoard1]=],
        AlarmLevel = 3,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 0,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Leakage disappears on the NPU A1 Drawer]=],
        AlarmLevel = 0,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 1,
        SelData2 = 3,
        SelData3 = 255,
        SelDesc = [=[Leakage occurred on the NPU A1 Drawer]=],
        AlarmLevel = 3,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 0,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[Leakage disappears on the NPU A2 Drawer]=],
        AlarmLevel = 0,
        ShieldFlag = 255
    }, {
        SensorType = 36,
        ReadingType = 7,
        SelData1 = 1,
        SelData2 = 4,
        SelData3 = 255,
        SelDesc = [=[Leakage occurred on the NPU A2 Drawer]=],
        AlarmLevel = 3,
        ShieldFlag = 255
    }
}

return M
