-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MThresholdSensor = {}

---@class MThresholdSensor.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MThresholdSensor.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MThresholdSensor.IsValid = TIsValid

---@class MThresholdSensor.BelongsToSystem
---@field BelongsToSystem boolean
local TBelongsToSystem = {}
TBelongsToSystem.__index = TBelongsToSystem
TBelongsToSystem.group = {}

local function TBelongsToSystem_from_obj(obj)
    return setmetatable(obj, TBelongsToSystem)
end

function TBelongsToSystem.new(BelongsToSystem)
    return TBelongsToSystem_from_obj({BelongsToSystem = BelongsToSystem or false})
end
---@param obj MThresholdSensor.BelongsToSystem
function TBelongsToSystem:init_from_obj(obj)
    self.BelongsToSystem = obj.BelongsToSystem or false
end

function TBelongsToSystem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBelongsToSystem.group)
end

TBelongsToSystem.from_obj = TBelongsToSystem_from_obj

TBelongsToSystem.proto_property = {'BelongsToSystem'}

TBelongsToSystem.default = {false}

TBelongsToSystem.struct = {{name = 'BelongsToSystem', is_array = false, struct = nil}}

function TBelongsToSystem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BelongsToSystem', self.BelongsToSystem, 'bool', true, errs, need_convert)

    TBelongsToSystem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBelongsToSystem.proto_property, errs, need_convert)
    return self
end

function TBelongsToSystem:unpack(_)
    return self.BelongsToSystem
end

MThresholdSensor.BelongsToSystem = TBelongsToSystem

---@class MThresholdSensor.MinimumReading
---@field MinimumReading integer
local TMinimumReading = {}
TMinimumReading.__index = TMinimumReading
TMinimumReading.group = {}

local function TMinimumReading_from_obj(obj)
    return setmetatable(obj, TMinimumReading)
end

function TMinimumReading.new(MinimumReading)
    return TMinimumReading_from_obj({MinimumReading = MinimumReading or 0})
end
---@param obj MThresholdSensor.MinimumReading
function TMinimumReading:init_from_obj(obj)
    self.MinimumReading = obj.MinimumReading or 0
end

function TMinimumReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinimumReading.group)
end

TMinimumReading.from_obj = TMinimumReading_from_obj

TMinimumReading.proto_property = {'MinimumReading'}

TMinimumReading.default = {0}

TMinimumReading.struct = {{name = 'MinimumReading', is_array = false, struct = nil}}

function TMinimumReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinimumReading', self.MinimumReading, 'uint8', true, errs, need_convert)

    TMinimumReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinimumReading.proto_property, errs, need_convert)
    return self
end

function TMinimumReading:unpack(_)
    return self.MinimumReading
end

MThresholdSensor.MinimumReading = TMinimumReading

---@class MThresholdSensor.MaximumReading
---@field MaximumReading integer
local TMaximumReading = {}
TMaximumReading.__index = TMaximumReading
TMaximumReading.group = {}

local function TMaximumReading_from_obj(obj)
    return setmetatable(obj, TMaximumReading)
end

function TMaximumReading.new(MaximumReading)
    return TMaximumReading_from_obj({MaximumReading = MaximumReading or 0})
end
---@param obj MThresholdSensor.MaximumReading
function TMaximumReading:init_from_obj(obj)
    self.MaximumReading = obj.MaximumReading or 0
end

function TMaximumReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaximumReading.group)
end

TMaximumReading.from_obj = TMaximumReading_from_obj

TMaximumReading.proto_property = {'MaximumReading'}

TMaximumReading.default = {0}

TMaximumReading.struct = {{name = 'MaximumReading', is_array = false, struct = nil}}

function TMaximumReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaximumReading', self.MaximumReading, 'uint8', true, errs, need_convert)

    TMaximumReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaximumReading.proto_property, errs, need_convert)
    return self
end

function TMaximumReading:unpack(_)
    return self.MaximumReading
end

MThresholdSensor.MaximumReading = TMaximumReading

---@class MThresholdSensor.NormalMinimum
---@field NormalMinimum integer
local TNormalMinimum = {}
TNormalMinimum.__index = TNormalMinimum
TNormalMinimum.group = {}

local function TNormalMinimum_from_obj(obj)
    return setmetatable(obj, TNormalMinimum)
end

function TNormalMinimum.new(NormalMinimum)
    return TNormalMinimum_from_obj({NormalMinimum = NormalMinimum or 0})
end
---@param obj MThresholdSensor.NormalMinimum
function TNormalMinimum:init_from_obj(obj)
    self.NormalMinimum = obj.NormalMinimum or 0
end

function TNormalMinimum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNormalMinimum.group)
end

TNormalMinimum.from_obj = TNormalMinimum_from_obj

TNormalMinimum.proto_property = {'NormalMinimum'}

TNormalMinimum.default = {0}

TNormalMinimum.struct = {{name = 'NormalMinimum', is_array = false, struct = nil}}

function TNormalMinimum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NormalMinimum', self.NormalMinimum, 'uint8', true, errs, need_convert)

    TNormalMinimum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNormalMinimum.proto_property, errs, need_convert)
    return self
end

function TNormalMinimum:unpack(_)
    return self.NormalMinimum
end

MThresholdSensor.NormalMinimum = TNormalMinimum

---@class MThresholdSensor.NormalMaximum
---@field NormalMaximum integer
local TNormalMaximum = {}
TNormalMaximum.__index = TNormalMaximum
TNormalMaximum.group = {}

local function TNormalMaximum_from_obj(obj)
    return setmetatable(obj, TNormalMaximum)
end

function TNormalMaximum.new(NormalMaximum)
    return TNormalMaximum_from_obj({NormalMaximum = NormalMaximum or 0})
end
---@param obj MThresholdSensor.NormalMaximum
function TNormalMaximum:init_from_obj(obj)
    self.NormalMaximum = obj.NormalMaximum or 0
end

function TNormalMaximum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNormalMaximum.group)
end

TNormalMaximum.from_obj = TNormalMaximum_from_obj

TNormalMaximum.proto_property = {'NormalMaximum'}

TNormalMaximum.default = {0}

TNormalMaximum.struct = {{name = 'NormalMaximum', is_array = false, struct = nil}}

function TNormalMaximum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NormalMaximum', self.NormalMaximum, 'uint8', true, errs, need_convert)

    TNormalMaximum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNormalMaximum.proto_property, errs, need_convert)
    return self
end

function TNormalMaximum:unpack(_)
    return self.NormalMaximum
end

MThresholdSensor.NormalMaximum = TNormalMaximum

---@class MThresholdSensor.NominalReading
---@field NominalReading integer
local TNominalReading = {}
TNominalReading.__index = TNominalReading
TNominalReading.group = {}

local function TNominalReading_from_obj(obj)
    return setmetatable(obj, TNominalReading)
end

function TNominalReading.new(NominalReading)
    return TNominalReading_from_obj({NominalReading = NominalReading or 0})
end
---@param obj MThresholdSensor.NominalReading
function TNominalReading:init_from_obj(obj)
    self.NominalReading = obj.NominalReading or 0
end

function TNominalReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNominalReading.group)
end

TNominalReading.from_obj = TNominalReading_from_obj

TNominalReading.proto_property = {'NominalReading'}

TNominalReading.default = {0}

TNominalReading.struct = {{name = 'NominalReading', is_array = false, struct = nil}}

function TNominalReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NominalReading', self.NominalReading, 'uint8', true, errs, need_convert)

    TNominalReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNominalReading.proto_property, errs, need_convert)
    return self
end

function TNominalReading:unpack(_)
    return self.NominalReading
end

MThresholdSensor.NominalReading = TNominalReading

---@class MThresholdSensor.Analog
---@field Analog integer
local TAnalog = {}
TAnalog.__index = TAnalog
TAnalog.group = {}

local function TAnalog_from_obj(obj)
    return setmetatable(obj, TAnalog)
end

function TAnalog.new(Analog)
    return TAnalog_from_obj({Analog = Analog or 1})
end
---@param obj MThresholdSensor.Analog
function TAnalog:init_from_obj(obj)
    self.Analog = obj.Analog or 1
end

function TAnalog:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAnalog.group)
end

TAnalog.from_obj = TAnalog_from_obj

TAnalog.proto_property = {'Analog'}

TAnalog.default = {0}

TAnalog.struct = {{name = 'Analog', is_array = false, struct = nil}}

function TAnalog:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Analog', self.Analog, 'uint8', true, errs, need_convert)

    TAnalog:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAnalog.proto_property, errs, need_convert)
    return self
end

function TAnalog:unpack(_)
    return self.Analog
end

MThresholdSensor.Analog = TAnalog

---@class MThresholdSensor.RBExp
---@field RBExp integer
local TRBExp = {}
TRBExp.__index = TRBExp
TRBExp.group = {}

local function TRBExp_from_obj(obj)
    return setmetatable(obj, TRBExp)
end

function TRBExp.new(RBExp)
    return TRBExp_from_obj({RBExp = RBExp or 0})
end
---@param obj MThresholdSensor.RBExp
function TRBExp:init_from_obj(obj)
    self.RBExp = obj.RBExp or 0
end

function TRBExp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRBExp.group)
end

TRBExp.from_obj = TRBExp_from_obj

TRBExp.proto_property = {'RBExp'}

TRBExp.default = {0}

TRBExp.struct = {{name = 'RBExp', is_array = false, struct = nil}}

function TRBExp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RBExp', self.RBExp, 'uint8', true, errs, need_convert)

    TRBExp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRBExp.proto_property, errs, need_convert)
    return self
end

function TRBExp:unpack(_)
    return self.RBExp
end

MThresholdSensor.RBExp = TRBExp

---@class MThresholdSensor.Accuracy
---@field Accuracy integer
local TAccuracy = {}
TAccuracy.__index = TAccuracy
TAccuracy.group = {}

local function TAccuracy_from_obj(obj)
    return setmetatable(obj, TAccuracy)
end

function TAccuracy.new(Accuracy)
    return TAccuracy_from_obj({Accuracy = Accuracy or 0})
end
---@param obj MThresholdSensor.Accuracy
function TAccuracy:init_from_obj(obj)
    self.Accuracy = obj.Accuracy or 0
end

function TAccuracy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccuracy.group)
end

TAccuracy.from_obj = TAccuracy_from_obj

TAccuracy.proto_property = {'Accuracy'}

TAccuracy.default = {0}

TAccuracy.struct = {{name = 'Accuracy', is_array = false, struct = nil}}

function TAccuracy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Accuracy', self.Accuracy, 'uint8', true, errs, need_convert)

    TAccuracy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccuracy.proto_property, errs, need_convert)
    return self
end

function TAccuracy:unpack(_)
    return self.Accuracy
end

MThresholdSensor.Accuracy = TAccuracy

---@class MThresholdSensor.BA
---@field BA integer
local TBA = {}
TBA.__index = TBA
TBA.group = {}

local function TBA_from_obj(obj)
    return setmetatable(obj, TBA)
end

function TBA.new(BA)
    return TBA_from_obj({BA = BA or 0})
end
---@param obj MThresholdSensor.BA
function TBA:init_from_obj(obj)
    self.BA = obj.BA or 0
end

function TBA:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBA.group)
end

TBA.from_obj = TBA_from_obj

TBA.proto_property = {'BA'}

TBA.default = {0}

TBA.struct = {{name = 'BA', is_array = false, struct = nil}}

function TBA:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BA', self.BA, 'uint8', true, errs, need_convert)

    TBA:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBA.proto_property, errs, need_convert)
    return self
end

function TBA:unpack(_)
    return self.BA
end

MThresholdSensor.BA = TBA

---@class MThresholdSensor.B
---@field B integer
local TB = {}
TB.__index = TB
TB.group = {}

local function TB_from_obj(obj)
    return setmetatable(obj, TB)
end

function TB.new(B)
    return TB_from_obj({B = B or 0})
end
---@param obj MThresholdSensor.B
function TB:init_from_obj(obj)
    self.B = obj.B or 0
end

function TB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TB.group)
end

TB.from_obj = TB_from_obj

TB.proto_property = {'B'}

TB.default = {0}

TB.struct = {{name = 'B', is_array = false, struct = nil}}

function TB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'B', self.B, 'uint8', true, errs, need_convert)

    TB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TB.proto_property, errs, need_convert)
    return self
end

function TB:unpack(_)
    return self.B
end

MThresholdSensor.B = TB

---@class MThresholdSensor.MT
---@field MT integer
local TMT = {}
TMT.__index = TMT
TMT.group = {}

local function TMT_from_obj(obj)
    return setmetatable(obj, TMT)
end

function TMT.new(MT)
    return TMT_from_obj({MT = MT or 0})
end
---@param obj MThresholdSensor.MT
function TMT:init_from_obj(obj)
    self.MT = obj.MT or 0
end

function TMT:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMT.group)
end

TMT.from_obj = TMT_from_obj

TMT.proto_property = {'MT'}

TMT.default = {0}

TMT.struct = {{name = 'MT', is_array = false, struct = nil}}

function TMT:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MT', self.MT, 'uint8', true, errs, need_convert)

    TMT:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMT.proto_property, errs, need_convert)
    return self
end

function TMT:unpack(_)
    return self.MT
end

MThresholdSensor.MT = TMT

---@class MThresholdSensor.M
---@field M integer
local TM = {}
TM.__index = TM
TM.group = {}

local function TM_from_obj(obj)
    return setmetatable(obj, TM)
end

function TM.new(M)
    return TM_from_obj({M = M or 0})
end
---@param obj MThresholdSensor.M
function TM:init_from_obj(obj)
    self.M = obj.M or 0
end

function TM:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TM.group)
end

TM.from_obj = TM_from_obj

TM.proto_property = {'M'}

TM.default = {0}

TM.struct = {{name = 'M', is_array = false, struct = nil}}

function TM:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'M', self.M, 'uint8', true, errs, need_convert)

    TM:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TM.proto_property, errs, need_convert)
    return self
end

function TM:unpack(_)
    return self.M
end

MThresholdSensor.M = TM

---@class MThresholdSensor.Linearization
---@field Linearization integer
local TLinearization = {}
TLinearization.__index = TLinearization
TLinearization.group = {}

local function TLinearization_from_obj(obj)
    return setmetatable(obj, TLinearization)
end

function TLinearization.new(Linearization)
    return TLinearization_from_obj({Linearization = Linearization or 0})
end
---@param obj MThresholdSensor.Linearization
function TLinearization:init_from_obj(obj)
    self.Linearization = obj.Linearization or 0
end

function TLinearization:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinearization.group)
end

TLinearization.from_obj = TLinearization_from_obj

TLinearization.proto_property = {'Linearization'}

TLinearization.default = {0}

TLinearization.struct = {{name = 'Linearization', is_array = false, struct = nil}}

function TLinearization:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Linearization', self.Linearization, 'uint8', true, errs, need_convert)

    TLinearization:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinearization.proto_property, errs, need_convert)
    return self
end

function TLinearization:unpack(_)
    return self.Linearization
end

MThresholdSensor.Linearization = TLinearization

---@class MThresholdSensor.ModifierUnit
---@field ModifierUnit integer
local TModifierUnit = {}
TModifierUnit.__index = TModifierUnit
TModifierUnit.group = {}

local function TModifierUnit_from_obj(obj)
    return setmetatable(obj, TModifierUnit)
end

function TModifierUnit.new(ModifierUnit)
    return TModifierUnit_from_obj({ModifierUnit = ModifierUnit or 0})
end
---@param obj MThresholdSensor.ModifierUnit
function TModifierUnit:init_from_obj(obj)
    self.ModifierUnit = obj.ModifierUnit or 0
end

function TModifierUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModifierUnit.group)
end

TModifierUnit.from_obj = TModifierUnit_from_obj

TModifierUnit.proto_property = {'ModifierUnit'}

TModifierUnit.default = {0}

TModifierUnit.struct = {{name = 'ModifierUnit', is_array = false, struct = nil}}

function TModifierUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ModifierUnit', self.ModifierUnit, 'uint8', true, errs, need_convert)

    TModifierUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModifierUnit.proto_property, errs, need_convert)
    return self
end

function TModifierUnit:unpack(_)
    return self.ModifierUnit
end

MThresholdSensor.ModifierUnit = TModifierUnit

---@class MThresholdSensor.BaseUnit
---@field BaseUnit integer
local TBaseUnit = {}
TBaseUnit.__index = TBaseUnit
TBaseUnit.group = {}

local function TBaseUnit_from_obj(obj)
    return setmetatable(obj, TBaseUnit)
end

function TBaseUnit.new(BaseUnit)
    return TBaseUnit_from_obj({BaseUnit = BaseUnit or 0})
end
---@param obj MThresholdSensor.BaseUnit
function TBaseUnit:init_from_obj(obj)
    self.BaseUnit = obj.BaseUnit or 0
end

function TBaseUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseUnit.group)
end

TBaseUnit.from_obj = TBaseUnit_from_obj

TBaseUnit.proto_property = {'BaseUnit'}

TBaseUnit.default = {0}

TBaseUnit.struct = {{name = 'BaseUnit', is_array = false, struct = nil}}

function TBaseUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseUnit', self.BaseUnit, 'uint8', true, errs, need_convert)

    TBaseUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseUnit.proto_property, errs, need_convert)
    return self
end

function TBaseUnit:unpack(_)
    return self.BaseUnit
end

MThresholdSensor.BaseUnit = TBaseUnit

---@class MThresholdSensor.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit or 0})
end
---@param obj MThresholdSensor.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit or 0
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint8', true, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MThresholdSensor.Unit = TUnit

---@class MThresholdSensor.DeassertMask
---@field DeassertMask integer
local TDeassertMask = {}
TDeassertMask.__index = TDeassertMask
TDeassertMask.group = {}

local function TDeassertMask_from_obj(obj)
    return setmetatable(obj, TDeassertMask)
end

function TDeassertMask.new(DeassertMask)
    return TDeassertMask_from_obj({DeassertMask = DeassertMask or 0})
end
---@param obj MThresholdSensor.DeassertMask
function TDeassertMask:init_from_obj(obj)
    self.DeassertMask = obj.DeassertMask or 0
end

function TDeassertMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeassertMask.group)
end

TDeassertMask.from_obj = TDeassertMask_from_obj

TDeassertMask.proto_property = {'DeassertMask'}

TDeassertMask.default = {0}

TDeassertMask.struct = {{name = 'DeassertMask', is_array = false, struct = nil}}

function TDeassertMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeassertMask', self.DeassertMask, 'uint16', true, errs, need_convert)

    TDeassertMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeassertMask.proto_property, errs, need_convert)
    return self
end

function TDeassertMask:unpack(_)
    return self.DeassertMask
end

MThresholdSensor.DeassertMask = TDeassertMask

---@class MThresholdSensor.AssertMask
---@field AssertMask integer
local TAssertMask = {}
TAssertMask.__index = TAssertMask
TAssertMask.group = {}

local function TAssertMask_from_obj(obj)
    return setmetatable(obj, TAssertMask)
end

function TAssertMask.new(AssertMask)
    return TAssertMask_from_obj({AssertMask = AssertMask or 0})
end
---@param obj MThresholdSensor.AssertMask
function TAssertMask:init_from_obj(obj)
    self.AssertMask = obj.AssertMask or 0
end

function TAssertMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssertMask.group)
end

TAssertMask.from_obj = TAssertMask_from_obj

TAssertMask.proto_property = {'AssertMask'}

TAssertMask.default = {0}

TAssertMask.struct = {{name = 'AssertMask', is_array = false, struct = nil}}

function TAssertMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssertMask', self.AssertMask, 'uint16', true, errs, need_convert)

    TAssertMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssertMask.proto_property, errs, need_convert)
    return self
end

function TAssertMask:unpack(_)
    return self.AssertMask
end

MThresholdSensor.AssertMask = TAssertMask

---@class MThresholdSensor.ReadingType
---@field ReadingType integer
local TReadingType = {}
TReadingType.__index = TReadingType
TReadingType.group = {}

local function TReadingType_from_obj(obj)
    return setmetatable(obj, TReadingType)
end

function TReadingType.new(ReadingType)
    return TReadingType_from_obj({ReadingType = ReadingType or 0})
end
---@param obj MThresholdSensor.ReadingType
function TReadingType:init_from_obj(obj)
    self.ReadingType = obj.ReadingType or 0
end

function TReadingType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingType.group)
end

TReadingType.from_obj = TReadingType_from_obj

TReadingType.proto_property = {'ReadingType'}

TReadingType.default = {0}

TReadingType.struct = {{name = 'ReadingType', is_array = false, struct = nil}}

function TReadingType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingType', self.ReadingType, 'uint8', true, errs, need_convert)

    TReadingType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingType.proto_property, errs, need_convert)
    return self
end

function TReadingType:unpack(_)
    return self.ReadingType
end

MThresholdSensor.ReadingType = TReadingType

---@class MThresholdSensor.Initialization
---@field Initialization integer
local TInitialization = {}
TInitialization.__index = TInitialization
TInitialization.group = {}

local function TInitialization_from_obj(obj)
    return setmetatable(obj, TInitialization)
end

function TInitialization.new(Initialization)
    return TInitialization_from_obj({Initialization = Initialization or 0})
end
---@param obj MThresholdSensor.Initialization
function TInitialization:init_from_obj(obj)
    self.Initialization = obj.Initialization or 0
end

function TInitialization:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitialization.group)
end

TInitialization.from_obj = TInitialization_from_obj

TInitialization.proto_property = {'Initialization'}

TInitialization.default = {0}

TInitialization.struct = {{name = 'Initialization', is_array = false, struct = nil}}

function TInitialization:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Initialization', self.Initialization, 'uint8', true, errs, need_convert)

    TInitialization:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitialization.proto_property, errs, need_convert)
    return self
end

function TInitialization:unpack(_)
    return self.Initialization
end

MThresholdSensor.Initialization = TInitialization

---@class MThresholdSensor.OwnerId
---@field OwnerId integer
local TOwnerId = {}
TOwnerId.__index = TOwnerId
TOwnerId.group = {}

local function TOwnerId_from_obj(obj)
    return setmetatable(obj, TOwnerId)
end

function TOwnerId.new(OwnerId)
    return TOwnerId_from_obj({OwnerId = OwnerId or 32})
end
---@param obj MThresholdSensor.OwnerId
function TOwnerId:init_from_obj(obj)
    self.OwnerId = obj.OwnerId or 32
end

function TOwnerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOwnerId.group)
end

TOwnerId.from_obj = TOwnerId_from_obj

TOwnerId.proto_property = {'OwnerId'}

TOwnerId.default = {0}

TOwnerId.struct = {{name = 'OwnerId', is_array = false, struct = nil}}

function TOwnerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OwnerId', self.OwnerId, 'uint8', true, errs, need_convert)

    TOwnerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOwnerId.proto_property, errs, need_convert)
    return self
end

function TOwnerId:unpack(_)
    return self.OwnerId
end

MThresholdSensor.OwnerId = TOwnerId

return MThresholdSensor
