-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MMCDLSDR = {}

---@class MMCDLSDR.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj)
    return setmetatable(obj, TDeviceName)
end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj MMCDLSDR.DeviceName
function TDeviceName:init_from_obj(obj)
    self.DeviceName = obj.DeviceName
end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, 'string', false, errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs, need_convert)
    return self
end

function TDeviceName:unpack(_)
    return self.DeviceName
end

MMCDLSDR.DeviceName = TDeviceName

---@class MMCDLSDR.EntityInstance
---@field EntityInstance integer
local TEntityInstance = {}
TEntityInstance.__index = TEntityInstance
TEntityInstance.group = {}

local function TEntityInstance_from_obj(obj)
    return setmetatable(obj, TEntityInstance)
end

function TEntityInstance.new(EntityInstance)
    return TEntityInstance_from_obj({EntityInstance = EntityInstance})
end
---@param obj MMCDLSDR.EntityInstance
function TEntityInstance:init_from_obj(obj)
    self.EntityInstance = obj.EntityInstance
end

function TEntityInstance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityInstance.group)
end

TEntityInstance.from_obj = TEntityInstance_from_obj

TEntityInstance.proto_property = {'EntityInstance'}

TEntityInstance.default = {0}

TEntityInstance.struct = {{name = 'EntityInstance', is_array = false, struct = nil}}

function TEntityInstance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityInstance', self.EntityInstance, 'uint8', false, errs, need_convert)

    TEntityInstance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityInstance.proto_property, errs, need_convert)
    return self
end

function TEntityInstance:unpack(_)
    return self.EntityInstance
end

MMCDLSDR.EntityInstance = TEntityInstance

---@class MMCDLSDR.EntityId
---@field EntityId integer
local TEntityId = {}
TEntityId.__index = TEntityId
TEntityId.group = {}

local function TEntityId_from_obj(obj)
    return setmetatable(obj, TEntityId)
end

function TEntityId.new(EntityId)
    return TEntityId_from_obj({EntityId = EntityId})
end
---@param obj MMCDLSDR.EntityId
function TEntityId:init_from_obj(obj)
    self.EntityId = obj.EntityId
end

function TEntityId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityId.group)
end

TEntityId.from_obj = TEntityId_from_obj

TEntityId.proto_property = {'EntityId'}

TEntityId.default = {0}

TEntityId.struct = {{name = 'EntityId', is_array = false, struct = nil}}

function TEntityId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityId', self.EntityId, 'uint8', false, errs, need_convert)

    TEntityId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityId.proto_property, errs, need_convert)
    return self
end

function TEntityId:unpack(_)
    return self.EntityId
end

MMCDLSDR.EntityId = TEntityId

---@class MMCDLSDR.Capabilities
---@field Capabilities integer
local TCapabilities = {}
TCapabilities.__index = TCapabilities
TCapabilities.group = {}

local function TCapabilities_from_obj(obj)
    return setmetatable(obj, TCapabilities)
end

function TCapabilities.new(Capabilities)
    return TCapabilities_from_obj({Capabilities = Capabilities or 45})
end
---@param obj MMCDLSDR.Capabilities
function TCapabilities:init_from_obj(obj)
    self.Capabilities = obj.Capabilities or 45
end

function TCapabilities:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapabilities.group)
end

TCapabilities.from_obj = TCapabilities_from_obj

TCapabilities.proto_property = {'Capabilities'}

TCapabilities.default = {0}

TCapabilities.struct = {{name = 'Capabilities', is_array = false, struct = nil}}

function TCapabilities:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Capabilities', self.Capabilities, 'uint8', false, errs, need_convert)

    TCapabilities:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapabilities.proto_property, errs, need_convert)
    return self
end

function TCapabilities:unpack(_)
    return self.Capabilities
end

MMCDLSDR.Capabilities = TCapabilities

---@class MMCDLSDR.PowerStateInitialization
---@field PowerStateInitialization integer
local TPowerStateInitialization = {}
TPowerStateInitialization.__index = TPowerStateInitialization
TPowerStateInitialization.group = {}

local function TPowerStateInitialization_from_obj(obj)
    return setmetatable(obj, TPowerStateInitialization)
end

function TPowerStateInitialization.new(PowerStateInitialization)
    return TPowerStateInitialization_from_obj({PowerStateInitialization = PowerStateInitialization or 128})
end
---@param obj MMCDLSDR.PowerStateInitialization
function TPowerStateInitialization:init_from_obj(obj)
    self.PowerStateInitialization = obj.PowerStateInitialization or 128
end

function TPowerStateInitialization:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerStateInitialization.group)
end

TPowerStateInitialization.from_obj = TPowerStateInitialization_from_obj

TPowerStateInitialization.proto_property = {'PowerStateInitialization'}

TPowerStateInitialization.default = {0}

TPowerStateInitialization.struct = {{name = 'PowerStateInitialization', is_array = false, struct = nil}}

function TPowerStateInitialization:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerStateInitialization', self.PowerStateInitialization, 'uint8', false, errs,
        need_convert)

    TPowerStateInitialization:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerStateInitialization.proto_property, errs, need_convert)
    return self
end

function TPowerStateInitialization:unpack(_)
    return self.PowerStateInitialization
end

MMCDLSDR.PowerStateInitialization = TPowerStateInitialization

---@class MMCDLSDR.Channel
---@field Channel integer
local TChannel = {}
TChannel.__index = TChannel
TChannel.group = {}

local function TChannel_from_obj(obj)
    return setmetatable(obj, TChannel)
end

function TChannel.new(Channel)
    return TChannel_from_obj({Channel = Channel or 0})
end
---@param obj MMCDLSDR.Channel
function TChannel:init_from_obj(obj)
    self.Channel = obj.Channel or 0
end

function TChannel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannel.group)
end

TChannel.from_obj = TChannel_from_obj

TChannel.proto_property = {'Channel'}

TChannel.default = {0}

TChannel.struct = {{name = 'Channel', is_array = false, struct = nil}}

function TChannel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel', self.Channel, 'uint8', false, errs, need_convert)

    TChannel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannel.proto_property, errs, need_convert)
    return self
end

function TChannel:unpack(_)
    return self.Channel
end

MMCDLSDR.Channel = TChannel

---@class MMCDLSDR.SlaveAddr
---@field SlaveAddr integer
local TSlaveAddr = {}
TSlaveAddr.__index = TSlaveAddr
TSlaveAddr.group = {}

local function TSlaveAddr_from_obj(obj)
    return setmetatable(obj, TSlaveAddr)
end

function TSlaveAddr.new(SlaveAddr)
    return TSlaveAddr_from_obj({SlaveAddr = SlaveAddr or 32})
end
---@param obj MMCDLSDR.SlaveAddr
function TSlaveAddr:init_from_obj(obj)
    self.SlaveAddr = obj.SlaveAddr or 32
end

function TSlaveAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlaveAddr.group)
end

TSlaveAddr.from_obj = TSlaveAddr_from_obj

TSlaveAddr.proto_property = {'SlaveAddr'}

TSlaveAddr.default = {0}

TSlaveAddr.struct = {{name = 'SlaveAddr', is_array = false, struct = nil}}

function TSlaveAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlaveAddr', self.SlaveAddr, 'uint8', false, errs, need_convert)

    TSlaveAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlaveAddr.proto_property, errs, need_convert)
    return self
end

function TSlaveAddr:unpack(_)
    return self.SlaveAddr
end

MMCDLSDR.SlaveAddr = TSlaveAddr

return MMCDLSDR
