-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDiscreteSensor = {}

---@class MDiscreteSensor.IsValid
---@field IsValid boolean
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj)
    return setmetatable(obj, TIsValid)
end

function TIsValid.new(IsValid)
    return TIsValid_from_obj({IsValid = IsValid == nil and true or IsValid})
end
---@param obj MDiscreteSensor.IsValid
function TIsValid:init_from_obj(obj)
    self.IsValid = obj.IsValid == nil and true or obj.IsValid
end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {false}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, 'bool', false, errs, need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs, need_convert)
    return self
end

function TIsValid:unpack(_)
    return self.IsValid
end

MDiscreteSensor.IsValid = TIsValid

---@class MDiscreteSensor.BelongsToSystem
---@field BelongsToSystem boolean
local TBelongsToSystem = {}
TBelongsToSystem.__index = TBelongsToSystem
TBelongsToSystem.group = {}

local function TBelongsToSystem_from_obj(obj)
    return setmetatable(obj, TBelongsToSystem)
end

function TBelongsToSystem.new(BelongsToSystem)
    return TBelongsToSystem_from_obj({BelongsToSystem = BelongsToSystem or false})
end
---@param obj MDiscreteSensor.BelongsToSystem
function TBelongsToSystem:init_from_obj(obj)
    self.BelongsToSystem = obj.BelongsToSystem or false
end

function TBelongsToSystem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBelongsToSystem.group)
end

TBelongsToSystem.from_obj = TBelongsToSystem_from_obj

TBelongsToSystem.proto_property = {'BelongsToSystem'}

TBelongsToSystem.default = {false}

TBelongsToSystem.struct = {{name = 'BelongsToSystem', is_array = false, struct = nil}}

function TBelongsToSystem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BelongsToSystem', self.BelongsToSystem, 'bool', true, errs, need_convert)

    TBelongsToSystem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBelongsToSystem.proto_property, errs, need_convert)
    return self
end

function TBelongsToSystem:unpack(_)
    return self.BelongsToSystem
end

MDiscreteSensor.BelongsToSystem = TBelongsToSystem

---@class MDiscreteSensor.RecordSharing
---@field RecordSharing integer
local TRecordSharing = {}
TRecordSharing.__index = TRecordSharing
TRecordSharing.group = {}

local function TRecordSharing_from_obj(obj)
    return setmetatable(obj, TRecordSharing)
end

function TRecordSharing.new(RecordSharing)
    return TRecordSharing_from_obj({RecordSharing = RecordSharing or 0})
end
---@param obj MDiscreteSensor.RecordSharing
function TRecordSharing:init_from_obj(obj)
    self.RecordSharing = obj.RecordSharing or 0
end

function TRecordSharing:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecordSharing.group)
end

TRecordSharing.from_obj = TRecordSharing_from_obj

TRecordSharing.proto_property = {'RecordSharing'}

TRecordSharing.default = {0}

TRecordSharing.struct = {{name = 'RecordSharing', is_array = false, struct = nil}}

function TRecordSharing:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecordSharing', self.RecordSharing, 'uint16', true, errs, need_convert)

    TRecordSharing:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecordSharing.proto_property, errs, need_convert)
    return self
end

function TRecordSharing:unpack(_)
    return self.RecordSharing
end

MDiscreteSensor.RecordSharing = TRecordSharing

---@class MDiscreteSensor.ModifierUnit
---@field ModifierUnit integer
local TModifierUnit = {}
TModifierUnit.__index = TModifierUnit
TModifierUnit.group = {}

local function TModifierUnit_from_obj(obj)
    return setmetatable(obj, TModifierUnit)
end

function TModifierUnit.new(ModifierUnit)
    return TModifierUnit_from_obj({ModifierUnit = ModifierUnit or 0})
end
---@param obj MDiscreteSensor.ModifierUnit
function TModifierUnit:init_from_obj(obj)
    self.ModifierUnit = obj.ModifierUnit or 0
end

function TModifierUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModifierUnit.group)
end

TModifierUnit.from_obj = TModifierUnit_from_obj

TModifierUnit.proto_property = {'ModifierUnit'}

TModifierUnit.default = {0}

TModifierUnit.struct = {{name = 'ModifierUnit', is_array = false, struct = nil}}

function TModifierUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ModifierUnit', self.ModifierUnit, 'uint8', true, errs, need_convert)

    TModifierUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModifierUnit.proto_property, errs, need_convert)
    return self
end

function TModifierUnit:unpack(_)
    return self.ModifierUnit
end

MDiscreteSensor.ModifierUnit = TModifierUnit

---@class MDiscreteSensor.BaseUnit
---@field BaseUnit integer
local TBaseUnit = {}
TBaseUnit.__index = TBaseUnit
TBaseUnit.group = {}

local function TBaseUnit_from_obj(obj)
    return setmetatable(obj, TBaseUnit)
end

function TBaseUnit.new(BaseUnit)
    return TBaseUnit_from_obj({BaseUnit = BaseUnit or 0})
end
---@param obj MDiscreteSensor.BaseUnit
function TBaseUnit:init_from_obj(obj)
    self.BaseUnit = obj.BaseUnit or 0
end

function TBaseUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseUnit.group)
end

TBaseUnit.from_obj = TBaseUnit_from_obj

TBaseUnit.proto_property = {'BaseUnit'}

TBaseUnit.default = {0}

TBaseUnit.struct = {{name = 'BaseUnit', is_array = false, struct = nil}}

function TBaseUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseUnit', self.BaseUnit, 'uint8', true, errs, need_convert)

    TBaseUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseUnit.proto_property, errs, need_convert)
    return self
end

function TBaseUnit:unpack(_)
    return self.BaseUnit
end

MDiscreteSensor.BaseUnit = TBaseUnit

---@class MDiscreteSensor.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit or 0})
end
---@param obj MDiscreteSensor.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit or 0
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint8', true, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MDiscreteSensor.Unit = TUnit

---@class MDiscreteSensor.DiscreteType
---@field DiscreteType integer
local TDiscreteType = {}
TDiscreteType.__index = TDiscreteType
TDiscreteType.group = {}

local function TDiscreteType_from_obj(obj)
    return setmetatable(obj, TDiscreteType)
end

function TDiscreteType.new(DiscreteType)
    return TDiscreteType_from_obj({DiscreteType = DiscreteType or 0})
end
---@param obj MDiscreteSensor.DiscreteType
function TDiscreteType:init_from_obj(obj)
    self.DiscreteType = obj.DiscreteType or 0
end

function TDiscreteType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiscreteType.group)
end

TDiscreteType.from_obj = TDiscreteType_from_obj

TDiscreteType.proto_property = {'DiscreteType'}

TDiscreteType.default = {0}

TDiscreteType.struct = {{name = 'DiscreteType', is_array = false, struct = nil}}

function TDiscreteType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiscreteType', self.DiscreteType, 'uint8', true, errs, need_convert)

    TDiscreteType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiscreteType.proto_property, errs, need_convert)
    return self
end

function TDiscreteType:unpack(_)
    return self.DiscreteType
end

MDiscreteSensor.DiscreteType = TDiscreteType

---@class MDiscreteSensor.DiscreteMask
---@field DiscreteMask integer
local TDiscreteMask = {}
TDiscreteMask.__index = TDiscreteMask
TDiscreteMask.group = {}

local function TDiscreteMask_from_obj(obj)
    return setmetatable(obj, TDiscreteMask)
end

function TDiscreteMask.new(DiscreteMask)
    return TDiscreteMask_from_obj({DiscreteMask = DiscreteMask or 0})
end
---@param obj MDiscreteSensor.DiscreteMask
function TDiscreteMask:init_from_obj(obj)
    self.DiscreteMask = obj.DiscreteMask or 0
end

function TDiscreteMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiscreteMask.group)
end

TDiscreteMask.from_obj = TDiscreteMask_from_obj

TDiscreteMask.proto_property = {'DiscreteMask'}

TDiscreteMask.default = {0}

TDiscreteMask.struct = {{name = 'DiscreteMask', is_array = false, struct = nil}}

function TDiscreteMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiscreteMask', self.DiscreteMask, 'uint16', true, errs, need_convert)

    TDiscreteMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiscreteMask.proto_property, errs, need_convert)
    return self
end

function TDiscreteMask:unpack(_)
    return self.DiscreteMask
end

MDiscreteSensor.DiscreteMask = TDiscreteMask

---@class MDiscreteSensor.DeassertMask
---@field DeassertMask integer
local TDeassertMask = {}
TDeassertMask.__index = TDeassertMask
TDeassertMask.group = {}

local function TDeassertMask_from_obj(obj)
    return setmetatable(obj, TDeassertMask)
end

function TDeassertMask.new(DeassertMask)
    return TDeassertMask_from_obj({DeassertMask = DeassertMask or 0})
end
---@param obj MDiscreteSensor.DeassertMask
function TDeassertMask:init_from_obj(obj)
    self.DeassertMask = obj.DeassertMask or 0
end

function TDeassertMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeassertMask.group)
end

TDeassertMask.from_obj = TDeassertMask_from_obj

TDeassertMask.proto_property = {'DeassertMask'}

TDeassertMask.default = {0}

TDeassertMask.struct = {{name = 'DeassertMask', is_array = false, struct = nil}}

function TDeassertMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeassertMask', self.DeassertMask, 'uint16', true, errs, need_convert)

    TDeassertMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeassertMask.proto_property, errs, need_convert)
    return self
end

function TDeassertMask:unpack(_)
    return self.DeassertMask
end

MDiscreteSensor.DeassertMask = TDeassertMask

---@class MDiscreteSensor.AssertMask
---@field AssertMask integer
local TAssertMask = {}
TAssertMask.__index = TAssertMask
TAssertMask.group = {}

local function TAssertMask_from_obj(obj)
    return setmetatable(obj, TAssertMask)
end

function TAssertMask.new(AssertMask)
    return TAssertMask_from_obj({AssertMask = AssertMask or 0})
end
---@param obj MDiscreteSensor.AssertMask
function TAssertMask:init_from_obj(obj)
    self.AssertMask = obj.AssertMask or 0
end

function TAssertMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssertMask.group)
end

TAssertMask.from_obj = TAssertMask_from_obj

TAssertMask.proto_property = {'AssertMask'}

TAssertMask.default = {0}

TAssertMask.struct = {{name = 'AssertMask', is_array = false, struct = nil}}

function TAssertMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssertMask', self.AssertMask, 'uint16', true, errs, need_convert)

    TAssertMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssertMask.proto_property, errs, need_convert)
    return self
end

function TAssertMask:unpack(_)
    return self.AssertMask
end

MDiscreteSensor.AssertMask = TAssertMask

---@class MDiscreteSensor.ReadingType
---@field ReadingType integer
local TReadingType = {}
TReadingType.__index = TReadingType
TReadingType.group = {}

local function TReadingType_from_obj(obj)
    return setmetatable(obj, TReadingType)
end

function TReadingType.new(ReadingType)
    return TReadingType_from_obj({ReadingType = ReadingType or 0})
end
---@param obj MDiscreteSensor.ReadingType
function TReadingType:init_from_obj(obj)
    self.ReadingType = obj.ReadingType or 0
end

function TReadingType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingType.group)
end

TReadingType.from_obj = TReadingType_from_obj

TReadingType.proto_property = {'ReadingType'}

TReadingType.default = {0}

TReadingType.struct = {{name = 'ReadingType', is_array = false, struct = nil}}

function TReadingType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingType', self.ReadingType, 'uint8', true, errs, need_convert)

    TReadingType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingType.proto_property, errs, need_convert)
    return self
end

function TReadingType:unpack(_)
    return self.ReadingType
end

MDiscreteSensor.ReadingType = TReadingType

---@class MDiscreteSensor.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType or 0})
end
---@param obj MDiscreteSensor.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType or 0
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', true, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

MDiscreteSensor.SensorType = TSensorType

---@class MDiscreteSensor.Initialization
---@field Initialization integer
local TInitialization = {}
TInitialization.__index = TInitialization
TInitialization.group = {}

local function TInitialization_from_obj(obj)
    return setmetatable(obj, TInitialization)
end

function TInitialization.new(Initialization)
    return TInitialization_from_obj({Initialization = Initialization or 0})
end
---@param obj MDiscreteSensor.Initialization
function TInitialization:init_from_obj(obj)
    self.Initialization = obj.Initialization or 0
end

function TInitialization:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitialization.group)
end

TInitialization.from_obj = TInitialization_from_obj

TInitialization.proto_property = {'Initialization'}

TInitialization.default = {0}

TInitialization.struct = {{name = 'Initialization', is_array = false, struct = nil}}

function TInitialization:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Initialization', self.Initialization, 'uint8', true, errs, need_convert)

    TInitialization:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitialization.proto_property, errs, need_convert)
    return self
end

function TInitialization:unpack(_)
    return self.Initialization
end

MDiscreteSensor.Initialization = TInitialization

return MDiscreteSensor
