-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local threshold_sensor_class_types = require 'class.types.ThresholdSensor'
local discrete_sensor_class_types = require 'class.types.DiscreteSensor'
local entity_class_types = require 'class.types.Entity'
local discrete_event_class_types = require 'class.types.DiscreteEvent'
local ipmi_sel_desc_class_types = require 'class.types.IpmiSelDesc'
local ipmi_sel_filter_class_types = require 'class.types.IpmiSelFilter'
local ipmi_sel_list_class_types = require 'class.types.IpmiSelList'
local ipmi_sel_list_dump_class_types = require 'class.types.IpmiSelListDump'
local sensor_sel_info_class_types = require 'class.types.SensorSelInfo'
local ipmi_pef_config_class_types = require 'class.types.IpmiPefConfig'
local ipmi_pef_control_class_types = require 'class.types.IpmiPefControl'
local ipmi_pef_filter_class_types = require 'class.types.IpmiPefFilter'
local ipmi_pef_alert_filter_class_types = require 'class.types.IpmiPefAlertFilter'
local ipmi_pef_alert_string_class_types = require 'class.types.IpmiPefAlertString'
local sel_msg_list_class_types = require 'class.types.SelMsgList'
local persist_property_class_types = require 'class.types.PersistProperty'
local mcdlsdr_class_types = require 'class.types.MCDLSDR'
local deasdr_class_types = require 'class.types.DEASDR'
local bmc_enables_class_types = require 'class.types.BMCEnables'
local boot_error_class_types = require 'class.types.BootError'
local threshold_sensor_intf_types = require 'sensor.json_types.ThresholdSensor'
local threshold_sensor_display_intf_types = require 'sensor.json_types.ThresholdSensorDisplay'
local properties_intf_types = require 'sensor.json_types.Properties'
local sensors_intf_types = require 'sensor.json_types.Sensors'
local discrete_sensor_intf_types = require 'sensor.json_types.DiscreteSensor'
local discrete_sensor_display_intf_types = require 'sensor.json_types.DiscreteSensorDisplay'
local entity_intf_types = require 'sensor.json_types.Entity'
local discrete_event_intf_types = require 'sensor.json_types.DiscreteEvent'
local sensor_sel_info_intf_types = require 'sensor.json_types.SensorSelInfo'
local ipmi_event_intf_types = require 'sensor.json_types.IPMIEvent'

local ThresholdSensor = {
    ['prop_configs'] = {
        ['OwnerId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 32,
            ['validator'] = threshold_sensor_class_types.OwnerId
        },
        ['Initialization'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.Initialization
        },
        ['ReadingType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.ReadingType
        },
        ['AssertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.AssertMask
        },
        ['DeassertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.DeassertMask
        },
        ['Unit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.Unit
        },
        ['BaseUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.BaseUnit
        },
        ['ModifierUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.ModifierUnit
        },
        ['Linearization'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.Linearization
        },
        ['M'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.M
        },
        ['MT'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.MT
        },
        ['B'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.B
        },
        ['BA'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.BA
        },
        ['Accuracy'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.Accuracy
        },
        ['RBExp'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.RBExp
        },
        ['Analog'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 1,
            ['validator'] = threshold_sensor_class_types.Analog
        },
        ['NominalReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.NominalReading
        },
        ['NormalMaximum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.NormalMaximum
        },
        ['NormalMinimum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.NormalMinimum
        },
        ['MaximumReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.MaximumReading
        },
        ['MinimumReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = threshold_sensor_class_types.MinimumReading
        },
        ['BelongsToSystem'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['readOnly'] = true,
            ['validator'] = threshold_sensor_class_types.BelongsToSystem
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = threshold_sensor_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['OwnerId'] = 32,
        ['Initialization'] = 0,
        ['ReadingType'] = 0,
        ['AssertMask'] = 0,
        ['DeassertMask'] = 0,
        ['Unit'] = 0,
        ['BaseUnit'] = 0,
        ['ModifierUnit'] = 0,
        ['Linearization'] = 0,
        ['M'] = 0,
        ['MT'] = 0,
        ['B'] = 0,
        ['BA'] = 0,
        ['Accuracy'] = 0,
        ['RBExp'] = 0,
        ['Analog'] = 1,
        ['NominalReading'] = 0,
        ['NormalMaximum'] = 0,
        ['NormalMinimum'] = 0,
        ['MaximumReading'] = 0,
        ['MinimumReading'] = 0,
        ['BelongsToSystem'] = false,
        ['IsValid'] = true
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.ThresholdSensor'] = {
            ['EntityId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.EntityId
            },
            ['EntityInstance'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.EntityInstance
            },
            ['SensorIdentifier'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = '',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorIdentifier
            },
            ['SensorName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = '',
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorName
            },
            ['Capabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.Capabilities
            },
            ['SensorType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorType
            },
            ['ReadingMask'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.ReadingMask
            },
            ['UpperNonrecoverable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.UpperNonrecoverable
            },
            ['UpperCritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.UpperCritical
            },
            ['UpperNoncritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.UpperNoncritical
            },
            ['LowerNonrecoverable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.LowerNonrecoverable
            },
            ['LowerNoncritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.LowerNoncritical
            },
            ['LowerCritical'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.LowerCritical
            },
            ['PositiveHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.PositiveHysteresis
            },
            ['NegativeHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.NegativeHysteresis
            },
            ['SensorNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.SensorNumber
            },
            ['OwnerLun'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.OwnerLun
            },
            ['Reading'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.Reading
            },
            ['ReadingStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.ReadingStatus
            },
            ['OriginalReading'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_intf_types.OriginalReading
            }
        },
        ['bmc.kepler.Systems.ThresholdSensorDisplay'] = {
            ['UpperNonrecoverableDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.UpperNonrecoverableDisplay
            },
            ['UpperCriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.UpperCriticalDisplay
            },
            ['UpperNoncriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.UpperNoncriticalDisplay
            },
            ['LowerNonrecoverableDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.LowerNonrecoverableDisplay
            },
            ['LowerNoncriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.LowerNoncriticalDisplay
            },
            ['LowerCriticalDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.LowerCriticalDisplay
            },
            ['PositiveHysteresisDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.PositiveHysteresisDisplay
            },
            ['NegativeHysteresisDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.NegativeHysteresisDisplay
            },
            ['ReadingDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.ReadingDisplay
            },
            ['UnitDisplay'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = threshold_sensor_display_intf_types.UnitDisplay
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = threshold_sensor_display_intf_types.Status
            },
            ['Health'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = threshold_sensor_display_intf_types.Health
            },
            ['AssertStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = threshold_sensor_display_intf_types.AssertStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/ThresholdSensors/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.ThresholdSensor'] = {
            ['property_defaults'] = {
                ['EntityId'] = 0,
                ['EntityInstance'] = 0,
                ['SensorIdentifier'] = '',
                ['SensorName'] = '',
                ['Capabilities'] = 0,
                ['SensorType'] = 0,
                ['ReadingMask'] = 0,
                ['UpperNonrecoverable'] = 0,
                ['UpperCritical'] = 0,
                ['UpperNoncritical'] = 0,
                ['LowerNonrecoverable'] = 0,
                ['LowerNoncritical'] = 0,
                ['LowerCritical'] = 0,
                ['PositiveHysteresis'] = 0,
                ['NegativeHysteresis'] = 0,
                ['SensorNumber'] = 255,
                ['OwnerLun'] = 0,
                ['Reading'] = 0,
                ['ReadingStatus'] = 0,
                ['OriginalReading'] = 0
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = threshold_sensor_intf_types
        },
        ['bmc.kepler.Systems.ThresholdSensorDisplay'] = {
            ['property_defaults'] = {
                ['UpperNonrecoverableDisplay'] = threshold_sensor_display_intf_types.UpperNonrecoverableDisplay.default[1],
                ['UpperCriticalDisplay'] = threshold_sensor_display_intf_types.UpperCriticalDisplay.default[1],
                ['UpperNoncriticalDisplay'] = threshold_sensor_display_intf_types.UpperNoncriticalDisplay.default[1],
                ['LowerNonrecoverableDisplay'] = threshold_sensor_display_intf_types.LowerNonrecoverableDisplay.default[1],
                ['LowerNoncriticalDisplay'] = threshold_sensor_display_intf_types.LowerNoncriticalDisplay.default[1],
                ['LowerCriticalDisplay'] = threshold_sensor_display_intf_types.LowerCriticalDisplay.default[1],
                ['PositiveHysteresisDisplay'] = threshold_sensor_display_intf_types.PositiveHysteresisDisplay.default[1],
                ['NegativeHysteresisDisplay'] = threshold_sensor_display_intf_types.NegativeHysteresisDisplay.default[1],
                ['ReadingDisplay'] = threshold_sensor_display_intf_types.ReadingDisplay.default[1],
                ['UnitDisplay'] = threshold_sensor_display_intf_types.UnitDisplay.default[1],
                ['Status'] = threshold_sensor_display_intf_types.Status.default[1],
                ['Health'] = threshold_sensor_display_intf_types.Health.default[1],
                ['AssertStatus'] = threshold_sensor_display_intf_types.AssertStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = threshold_sensor_display_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Sensors = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.Sensors'] = {
            ['Health'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'Normal',
                ['validator'] = sensors_intf_types.Health
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.Sensors'] = {
            ['GetThresholdSensorList'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/ThresholdSensorItem'},
                        ['param'] = 'SensorList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['MockSensor'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['minimum'] = 0, ['maximum'] = 1, ['param'] = 'Enabled'},
                    {['baseType'] = 'String', ['param'] = 'SensorName'}, {['baseType'] = 'String', ['param'] = 'Value'}
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetSensorList'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/AllSensorItem'}, ['param'] = 'SensorList'}
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['SetSensorStatus'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'SensorName'}, {['baseType'] = 'String', ['param'] = 'Status'}
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['ExportSel'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Path'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'ReadOnly'}
            },
            ['GetSel'] = {
                ['req'] = {{['baseType'] = 'U16', ['param'] = 'StartId'}, {['baseType'] = 'U16', ['param'] = 'Count'}},
                ['rsp'] = {
                    {['baseType'] = 'U16', ['param'] = 'Total'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/SelInfo'}, ['param'] = 'SelList'}
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['GetDiscreteSensorList'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DiscreteSensorItem'},
                        ['param'] = 'SensorList'
                    }
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['GetReportedSel'] = {
                ['req'] = {{['baseType'] = 'U64', ['param'] = 'StartId'}, {['baseType'] = 'U16', ['param'] = 'Count'}},
                ['rsp'] = {
                    {['baseType'] = 'U16', ['param'] = 'Total'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/SelInfo'}, ['param'] = 'SelList'}
                },
                ['privilege'] = {'ReadOnly'}
            },
            ['DumpSDR'] = {
                ['req'] = {{['baseType'] = 'String', ['enum'] = {'LAN', 'BT'}, ['param'] = 'DumpMode'}},
                ['rsp'] = {},
                ['privilege'] = {'ReadOnly'}
            },
            ['AddOemSel'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'RecordType'}, {['baseType'] = 'U32', ['param'] = 'Timestamp'},
                    {['baseType'] = 'U32', ['param'] = 'ManufactureID'},
                    {['baseType'] = 'String', ['param'] = 'SELDatas'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'RecordId'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['ClearSel'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'BasicSetting'}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/Sensors'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.Sensors'] = {
            ['property_defaults'] = {['Health'] = 'Normal'},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['GetThresholdSensorList'] = privilege.ReadOnly,
                    ['MockSensor'] = privilege.BasicSetting,
                    ['GetSensorList'] = privilege.ReadOnly,
                    ['SetSensorStatus'] = privilege.BasicSetting,
                    ['ExportSel'] = privilege.ReadOnly,
                    ['GetSel'] = privilege.ReadOnly,
                    ['GetDiscreteSensorList'] = privilege.ReadOnly,
                    ['GetReportedSel'] = privilege.ReadOnly,
                    ['DumpSDR'] = privilege.ReadOnly,
                    ['AddOemSel'] = privilege.BasicSetting,
                    ['ClearSel'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = sensors_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DiscreteSensor = {
    ['prop_configs'] = {
        ['Initialization'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.Initialization
        },
        ['SensorType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.SensorType
        },
        ['ReadingType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.ReadingType
        },
        ['AssertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.AssertMask
        },
        ['DeassertMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.DeassertMask
        },
        ['DiscreteMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.DiscreteMask
        },
        ['DiscreteType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.DiscreteType
        },
        ['Unit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.Unit
        },
        ['BaseUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.BaseUnit
        },
        ['ModifierUnit'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.ModifierUnit
        },
        ['RecordSharing'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['readOnly'] = true,
            ['default'] = 0,
            ['validator'] = discrete_sensor_class_types.RecordSharing
        },
        ['BelongsToSystem'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['readOnly'] = true,
            ['validator'] = discrete_sensor_class_types.BelongsToSystem
        },
        ['IsValid'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = true,
            ['validator'] = discrete_sensor_class_types.IsValid
        }
    },
    ['default_props'] = {
        ['Initialization'] = 0,
        ['SensorType'] = 0,
        ['ReadingType'] = 0,
        ['AssertMask'] = 0,
        ['DeassertMask'] = 0,
        ['DiscreteMask'] = 0,
        ['DiscreteType'] = 0,
        ['Unit'] = 0,
        ['BaseUnit'] = 0,
        ['ModifierUnit'] = 0,
        ['RecordSharing'] = 0,
        ['BelongsToSystem'] = false,
        ['IsValid'] = true
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.DiscreteSensor'] = {
            ['EntityId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.EntityId
            },
            ['EntityInstance'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.EntityInstance
            },
            ['SensorIdentifier'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = '',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.SensorIdentifier
            },
            ['OwnerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 32,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.OwnerId
            },
            ['OwnerLun'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.OwnerLun
            },
            ['Capabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.Capabilities
            },
            ['SensorName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['default'] = '',
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.SensorName
            },
            ['PositiveHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.PositiveHysteresis
            },
            ['NegativeHysteresis'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.NegativeHysteresis
            },
            ['Reading'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.Reading
            },
            ['SensorNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 255,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_sensor_intf_types.SensorNumber
            }
        },
        ['bmc.kepler.Systems.DiscreteSensorDisplay'] = {
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = discrete_sensor_display_intf_types.Status
            },
            ['Health'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = discrete_sensor_display_intf_types.Health
            },
            ['AssertStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = discrete_sensor_display_intf_types.AssertStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/DiscreteSensors/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.DiscreteSensor'] = {
            ['property_defaults'] = {
                ['EntityId'] = 0,
                ['EntityInstance'] = 0,
                ['SensorIdentifier'] = '',
                ['OwnerId'] = 32,
                ['OwnerLun'] = 0,
                ['Capabilities'] = 0,
                ['SensorName'] = '',
                ['PositiveHysteresis'] = 0,
                ['NegativeHysteresis'] = 0,
                ['Reading'] = 0,
                ['SensorNumber'] = 255
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = discrete_sensor_intf_types
        },
        ['bmc.kepler.Systems.DiscreteSensorDisplay'] = {
            ['property_defaults'] = {
                ['Status'] = discrete_sensor_display_intf_types.Status.default[1],
                ['Health'] = discrete_sensor_display_intf_types.Health.default[1],
                ['AssertStatus'] = discrete_sensor_display_intf_types.AssertStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = discrete_sensor_display_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Entity = {
    ['prop_configs'] = {
        ['BelongsToSystem'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['readOnly'] = true,
            ['validator'] = entity_class_types.BelongsToSystem
        }
    },
    ['default_props'] = {['BelongsToSystem'] = false},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Entity'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.Id
            },
            ['Instance'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 96,
                ['validator'] = entity_intf_types.Instance
            },
            ['Slot'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = entity_intf_types.Slot
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.Name
            },
            ['PowerState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.PowerState
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = entity_intf_types.Presence
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = entity_intf_types.Health
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Entities/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Entity'] = {
            ['property_defaults'] = {
                ['Id'] = entity_intf_types.Id.default[1],
                ['Instance'] = 96,
                ['Slot'] = 255,
                ['Name'] = entity_intf_types.Name.default[1],
                ['PowerState'] = entity_intf_types.PowerState.default[1],
                ['Presence'] = entity_intf_types.Presence.default[1],
                ['Health'] = entity_intf_types.Health.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = entity_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DiscreteEvent = {
    ['prop_configs'] = {
        ['ListenType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['minimum'] = 0,
            ['maximum'] = 1,
            ['validator'] = discrete_event_class_types.ListenType
        },
        ['EventData1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = discrete_event_class_types.EventData1
        },
        ['EventData2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = discrete_event_class_types.EventData2
        },
        ['EventData3'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = discrete_event_class_types.EventData3
        },
        ['Conversion'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = discrete_event_class_types.Conversion
        },
        ['InvalidReadingIgnore'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = discrete_event_class_types.InvalidReadingIgnore
        },
        ['InvalidReading'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = discrete_event_class_types.InvalidReading
        },
        ['Severity'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = discrete_event_class_types.Severity
        }
    },
    ['default_props'] = {
        ['ListenType'] = discrete_event_class_types.ListenType.default[1],
        ['EventData1'] = discrete_event_class_types.EventData1.default[1],
        ['EventData2'] = discrete_event_class_types.EventData2.default[1],
        ['EventData3'] = discrete_event_class_types.EventData3.default[1],
        ['Conversion'] = discrete_event_class_types.Conversion.default[1],
        ['InvalidReadingIgnore'] = discrete_event_class_types.InvalidReadingIgnore.default[1],
        ['InvalidReading'] = discrete_event_class_types.InvalidReading.default[1],
        ['Severity'] = 255
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.DiscreteEvent'] = {
            ['Property'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = discrete_event_intf_types.Property
            },
            ['EventDir'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = discrete_event_intf_types.EventDir
            },
            ['SensorObject'] = {
                ['baseType'] = 'String',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = discrete_event_intf_types.SensorObject
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/DiscreteEvents/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.DiscreteEvent'] = {
            ['property_defaults'] = {
                ['Property'] = discrete_event_intf_types.Property.default[1],
                ['EventDir'] = discrete_event_intf_types.EventDir.default[1],
                ['SensorObject'] = discrete_event_intf_types.SensorObject.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = discrete_event_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local IpmiSelDesc = {
    ['table_name'] = 't_ipmi_sel_descs',
    ['prop_configs'] = {
        ['SensorType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_desc_class_types.SensorType
        },
        ['ReadingType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_desc_class_types.ReadingType
        },
        ['AlarmLevel'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_desc_class_types.AlarmLevel
        },
        ['SelDesc'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'String',
            ['validator'] = ipmi_sel_desc_class_types.SelDesc
        },
        ['SelData1'] = {
            ['primaryKey'] = true,
            ['default'] = 255,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_desc_class_types.SelData1
        },
        ['SelData2'] = {
            ['primaryKey'] = true,
            ['default'] = 255,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_desc_class_types.SelData2
        },
        ['SelData3'] = {
            ['primaryKey'] = true,
            ['default'] = 255,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_desc_class_types.SelData3
        },
        ['ShieldFlag'] = {['default'] = 0, ['baseType'] = 'U8', ['validator'] = ipmi_sel_desc_class_types.ShieldFlag}
    },
    ['default_props'] = {
        ['SensorType'] = ipmi_sel_desc_class_types.SensorType.default[1],
        ['ReadingType'] = ipmi_sel_desc_class_types.ReadingType.default[1],
        ['AlarmLevel'] = ipmi_sel_desc_class_types.AlarmLevel.default[1],
        ['SelDesc'] = ipmi_sel_desc_class_types.SelDesc.default[1],
        ['SelData1'] = 255,
        ['SelData2'] = 255,
        ['SelData3'] = 255,
        ['ShieldFlag'] = 0
    }
}

local IpmiSelFilter = {
    ['table_name'] = 't_ipmi_sel_filters',
    ['prop_configs'] = {
        ['SensorType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_filter_class_types.SensorType
        },
        ['ReadingType'] = {
            ['primaryKey'] = true,
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_filter_class_types.ReadingType
        },
        ['FilterMask1'] = {
            ['primaryKey'] = true,
            ['default'] = 65535,
            ['baseType'] = 'U16',
            ['validator'] = ipmi_sel_filter_class_types.FilterMask1
        },
        ['FilterMask2'] = {
            ['default'] = 65535,
            ['baseType'] = 'U16',
            ['validator'] = ipmi_sel_filter_class_types.FilterMask2
        },
        ['FilterMask3'] = {
            ['default'] = 65535,
            ['baseType'] = 'U16',
            ['validator'] = ipmi_sel_filter_class_types.FilterMask3
        }
    },
    ['default_props'] = {
        ['SensorType'] = ipmi_sel_filter_class_types.SensorType.default[1],
        ['ReadingType'] = ipmi_sel_filter_class_types.ReadingType.default[1],
        ['FilterMask1'] = 65535,
        ['FilterMask2'] = 65535,
        ['FilterMask3'] = 65535
    }
}

local IpmiSelList = {
    ['table_name'] = 't_ipmi_sel_list',
    ['prop_configs'] = {
        ['RecordId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U16',
            ['validator'] = ipmi_sel_list_class_types.RecordId
        },
        ['SelType'] = {['notAllowNull'] = true, ['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SelType},
        ['Timestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['validator'] = ipmi_sel_list_class_types.Timestamp
        },
        ['GenerateId'] = {['baseType'] = 'U16', ['validator'] = ipmi_sel_list_class_types.GenerateId},
        ['SelMsgVersion'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SelMsgVersion},
        ['SensorType'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SensorType},
        ['SensorNumber'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SensorNumber},
        ['SelEventType'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SelEventType},
        ['SelData1'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SelData1},
        ['SelData2'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SelData2},
        ['SelData3'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_class_types.SelData3},
        ['SensorId'] = {['baseType'] = 'String', ['validator'] = ipmi_sel_list_class_types.SensorId},
        ['SensorName'] = {['baseType'] = 'String', ['validator'] = ipmi_sel_list_class_types.SensorName},
        ['SubjectName'] = {['baseType'] = 'String', ['validator'] = ipmi_sel_list_class_types.SubjectName},
        ['RecordSeq'] = {['baseType'] = 'U64', ['validator'] = ipmi_sel_list_class_types.RecordSeq}
    },
    ['default_props'] = {
        ['RecordId'] = ipmi_sel_list_class_types.RecordId.default[1],
        ['SelType'] = ipmi_sel_list_class_types.SelType.default[1],
        ['Timestamp'] = ipmi_sel_list_class_types.Timestamp.default[1],
        ['GenerateId'] = ipmi_sel_list_class_types.GenerateId.default[1],
        ['SelMsgVersion'] = ipmi_sel_list_class_types.SelMsgVersion.default[1],
        ['SensorType'] = ipmi_sel_list_class_types.SensorType.default[1],
        ['SensorNumber'] = ipmi_sel_list_class_types.SensorNumber.default[1],
        ['SelEventType'] = ipmi_sel_list_class_types.SelEventType.default[1],
        ['SelData1'] = ipmi_sel_list_class_types.SelData1.default[1],
        ['SelData2'] = ipmi_sel_list_class_types.SelData2.default[1],
        ['SelData3'] = ipmi_sel_list_class_types.SelData3.default[1],
        ['SensorId'] = ipmi_sel_list_class_types.SensorId.default[1],
        ['SensorName'] = ipmi_sel_list_class_types.SensorName.default[1],
        ['SubjectName'] = ipmi_sel_list_class_types.SubjectName.default[1],
        ['RecordSeq'] = ipmi_sel_list_class_types.RecordSeq.default[1]
    }
}

local IpmiSelListDump = {
    ['table_name'] = 't_ipmi_sel_list_dump',
    ['prop_configs'] = {
        ['RecordId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U16',
            ['validator'] = ipmi_sel_list_dump_class_types.RecordId
        },
        ['SelType'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['validator'] = ipmi_sel_list_dump_class_types.SelType
        },
        ['Timestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['validator'] = ipmi_sel_list_dump_class_types.Timestamp
        },
        ['GenerateId'] = {['baseType'] = 'U16', ['validator'] = ipmi_sel_list_dump_class_types.GenerateId},
        ['SelMsgVersion'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SelMsgVersion},
        ['SensorType'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SensorType},
        ['SensorNumber'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SensorNumber},
        ['SelEventType'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SelEventType},
        ['SelData1'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SelData1},
        ['SelData2'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SelData2},
        ['SelData3'] = {['baseType'] = 'U8', ['validator'] = ipmi_sel_list_dump_class_types.SelData3},
        ['SensorId'] = {['baseType'] = 'String', ['validator'] = ipmi_sel_list_dump_class_types.SensorId},
        ['SensorName'] = {['baseType'] = 'String', ['validator'] = ipmi_sel_list_dump_class_types.SensorName},
        ['SubjectName'] = {['baseType'] = 'String', ['validator'] = ipmi_sel_list_dump_class_types.SubjectName},
        ['RecordSeq'] = {['baseType'] = 'U64', ['validator'] = ipmi_sel_list_dump_class_types.RecordSeq}
    },
    ['default_props'] = {
        ['RecordId'] = ipmi_sel_list_dump_class_types.RecordId.default[1],
        ['SelType'] = ipmi_sel_list_dump_class_types.SelType.default[1],
        ['Timestamp'] = ipmi_sel_list_dump_class_types.Timestamp.default[1],
        ['GenerateId'] = ipmi_sel_list_dump_class_types.GenerateId.default[1],
        ['SelMsgVersion'] = ipmi_sel_list_dump_class_types.SelMsgVersion.default[1],
        ['SensorType'] = ipmi_sel_list_dump_class_types.SensorType.default[1],
        ['SensorNumber'] = ipmi_sel_list_dump_class_types.SensorNumber.default[1],
        ['SelEventType'] = ipmi_sel_list_dump_class_types.SelEventType.default[1],
        ['SelData1'] = ipmi_sel_list_dump_class_types.SelData1.default[1],
        ['SelData2'] = ipmi_sel_list_dump_class_types.SelData2.default[1],
        ['SelData3'] = ipmi_sel_list_dump_class_types.SelData3.default[1],
        ['SensorId'] = ipmi_sel_list_dump_class_types.SensorId.default[1],
        ['SensorName'] = ipmi_sel_list_dump_class_types.SensorName.default[1],
        ['SubjectName'] = ipmi_sel_list_dump_class_types.SubjectName.default[1],
        ['RecordSeq'] = ipmi_sel_list_dump_class_types.RecordSeq.default[1]
    }
}

local SensorSelInfo = {
    ['table_name'] = 't_sel_info',
    ['prop_configs'] = {
        ['CurRecordId'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['validator'] = sensor_sel_info_class_types.CurRecordId
        },
        ['QueryMaxCount'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U16',
            ['default'] = 2000,
            ['usage'] = {'CSR'},
            ['validator'] = sensor_sel_info_class_types.QueryMaxCount
        },
        ['AddTimestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['usage'] = {'CSR'},
            ['validator'] = sensor_sel_info_class_types.AddTimestamp
        },
        ['DelTimestamp'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U32',
            ['default'] = 4294967295,
            ['usage'] = {'CSR'},
            ['validator'] = sensor_sel_info_class_types.DelTimestamp
        },
        ['ReceiverAddr'] = {
            ['notAllowNull'] = true,
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['usage'] = {'CSR'},
            ['validator'] = sensor_sel_info_class_types.ReceiverAddr
        },
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = sensor_sel_info_class_types.Id
        }
    },
    ['default_props'] = {
        ['CurRecordId'] = 0,
        ['QueryMaxCount'] = 2000,
        ['AddTimestamp'] = 4294967295,
        ['DelTimestamp'] = 4294967295,
        ['ReceiverAddr'] = 255,
        ['Id'] = 1
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.SensorSelInfo'] = {
            ['SelMode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['notAllowNull'] = true,
                ['validator'] = sensor_sel_info_intf_types.SelMode
            },
            ['RecordSeq'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['notAllowNull'] = true,
                ['validator'] = sensor_sel_info_intf_types.RecordSeq
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/SensorSelInfo'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.SensorSelInfo'] = {
            ['property_defaults'] = {
                ['SelMode'] = sensor_sel_info_intf_types.SelMode.default[1],
                ['RecordSeq'] = sensor_sel_info_intf_types.RecordSeq.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['SelMode'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.BasicSetting}}
            },
            ['interface_types'] = sensor_sel_info_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local IpmiPefConfig = {
    ['table_name'] = 't_pef_config',
    ['prop_configs'] = {
        ['Enabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.Enabled
        },
        ['ActionEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.ActionEnabled
        },
        ['StartupDelayDisabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.StartupDelayDisabled
        },
        ['AlertStartupDelayDisabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.AlertStartupDelayDisabled
        },
        ['AlertEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.AlertEnabled
        },
        ['PowerOffEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.PowerOffEnabled
        },
        ['ResetEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.ResetEnabled
        },
        ['PowerCycleEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.PowerCycleEnabled
        },
        ['OEMEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.OEMEnabled
        },
        ['DiagInterruptEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.DiagInterruptEnabled
        },
        ['SystemGUIDEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.SystemGUIDEnabled
        },
        ['StartupDelay'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.StartupDelay
        },
        ['AlertStartupDelay'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.AlertStartupDelay
        },
        ['SystemGUID'] = {
            ['baseType'] = 'String',
            ['default'] = '000000000000000000',
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.SystemGUID
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_config_class_types.Id
        }
    },
    ['default_props'] = {
        ['Enabled'] = 1,
        ['ActionEnabled'] = 0,
        ['StartupDelayDisabled'] = 0,
        ['AlertStartupDelayDisabled'] = 0,
        ['AlertEnabled'] = 1,
        ['PowerOffEnabled'] = 1,
        ['ResetEnabled'] = 1,
        ['PowerCycleEnabled'] = 1,
        ['OEMEnabled'] = 0,
        ['DiagInterruptEnabled'] = 0,
        ['SystemGUIDEnabled'] = 0,
        ['StartupDelay'] = 0,
        ['AlertStartupDelay'] = 0,
        ['SystemGUID'] = '000000000000000000',
        ['Id'] = 1
    }
}

local IpmiPefControl = {
    ['table_name'] = 't_pef_control',
    ['prop_configs'] = {
        ['InProgress'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.InProgress
        },
        ['PostponeTimeout'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.PostponeTimeout
        },
        ['StartupDelayTID'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.StartupDelayTID
        },
        ['Action'] = {
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.Action
        },
        ['UnqueuedEvent'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.UnqueuedEvent
        },
        ['LastEventBMC'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.LastEventBMC
        },
        ['LastEventSMS'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.LastEventSMS
        },
        ['NextEvent'] = {
            ['baseType'] = 'U16',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.NextEvent
        },
        ['Id'] = {
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['usage'] = {'CSR'},
            ['validator'] = ipmi_pef_control_class_types.Id
        }
    },
    ['default_props'] = {
        ['InProgress'] = 0,
        ['PostponeTimeout'] = 0,
        ['StartupDelayTID'] = 0,
        ['Action'] = 0,
        ['UnqueuedEvent'] = 0,
        ['LastEventBMC'] = 0,
        ['LastEventSMS'] = 0,
        ['NextEvent'] = 0,
        ['Id'] = 1
    }
}

local IpmiPefFilter = {
    ['prop_configs'] = {
        ['Configuration'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Configuration
        },
        ['Action'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ipmi_pef_filter_class_types.Action},
        ['PolicyNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.PolicyNumber
        },
        ['Severity'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ipmi_pef_filter_class_types.Severity},
        ['GeneratorId1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.GeneratorId1
        },
        ['GeneratorId2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.GeneratorId2
        },
        ['SensorType'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.SensorType
        },
        ['SensorNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.SensorNumber
        },
        ['EventTrigger'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.EventTrigger
        },
        ['OffsetMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['validator'] = ipmi_pef_filter_class_types.OffsetMask
        },
        ['Event1AndMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event1AndMask
        },
        ['Event1Compare1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event1Compare1
        },
        ['Event1Compare2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event1Compare2
        },
        ['Event2AndMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event2AndMask
        },
        ['Event2Compare1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event2Compare1
        },
        ['Event2Compare2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event2Compare2
        },
        ['Event3AndMask'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event3AndMask
        },
        ['Event3Compare1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event3Compare1
        },
        ['Event3Compare2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_filter_class_types.Event3Compare2
        }
    },
    ['default_props'] = {
        ['Configuration'] = ipmi_pef_filter_class_types.Configuration.default[1],
        ['Action'] = ipmi_pef_filter_class_types.Action.default[1],
        ['PolicyNumber'] = ipmi_pef_filter_class_types.PolicyNumber.default[1],
        ['Severity'] = ipmi_pef_filter_class_types.Severity.default[1],
        ['GeneratorId1'] = ipmi_pef_filter_class_types.GeneratorId1.default[1],
        ['GeneratorId2'] = ipmi_pef_filter_class_types.GeneratorId2.default[1],
        ['SensorType'] = ipmi_pef_filter_class_types.SensorType.default[1],
        ['SensorNumber'] = ipmi_pef_filter_class_types.SensorNumber.default[1],
        ['EventTrigger'] = ipmi_pef_filter_class_types.EventTrigger.default[1],
        ['OffsetMask'] = ipmi_pef_filter_class_types.OffsetMask.default[1],
        ['Event1AndMask'] = ipmi_pef_filter_class_types.Event1AndMask.default[1],
        ['Event1Compare1'] = ipmi_pef_filter_class_types.Event1Compare1.default[1],
        ['Event1Compare2'] = ipmi_pef_filter_class_types.Event1Compare2.default[1],
        ['Event2AndMask'] = ipmi_pef_filter_class_types.Event2AndMask.default[1],
        ['Event2Compare1'] = ipmi_pef_filter_class_types.Event2Compare1.default[1],
        ['Event2Compare2'] = ipmi_pef_filter_class_types.Event2Compare2.default[1],
        ['Event3AndMask'] = ipmi_pef_filter_class_types.Event3AndMask.default[1],
        ['Event3Compare1'] = ipmi_pef_filter_class_types.Event3Compare1.default[1],
        ['Event3Compare2'] = ipmi_pef_filter_class_types.Event3Compare2.default[1]
    }
}

local IpmiPefAlertFilter = {
    ['prop_configs'] = {
        ['PolicyNum'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_filter_class_types.PolicyNum
        },
        ['Destination'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_filter_class_types.Destination
        },
        ['AlertString'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_filter_class_types.AlertString
        }
    },
    ['default_props'] = {
        ['PolicyNum'] = ipmi_pef_alert_filter_class_types.PolicyNum.default[1],
        ['Destination'] = ipmi_pef_alert_filter_class_types.Destination.default[1],
        ['AlertString'] = ipmi_pef_alert_filter_class_types.AlertString.default[1]
    }
}

local IpmiPefAlertString = {
    ['prop_configs'] = {
        ['Id'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ipmi_pef_alert_string_class_types.Id},
        ['FilterNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_string_class_types.FilterNumber
        },
        ['StringSet'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ipmi_pef_alert_string_class_types.StringSet
        },
        ['AlertString'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = ipmi_pef_alert_string_class_types.AlertString
        }
    },
    ['default_props'] = {
        ['Id'] = ipmi_pef_alert_string_class_types.Id.default[1],
        ['FilterNumber'] = ipmi_pef_alert_string_class_types.FilterNumber.default[1],
        ['StringSet'] = ipmi_pef_alert_string_class_types.StringSet.default[1],
        ['AlertString'] = ipmi_pef_alert_string_class_types.AlertString.default[1]
    }
}

local SelMsgList = {
    ['table_name'] = 't_sel_msg_list',
    ['prop_configs'] = {
        ['SensorId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = sel_msg_list_class_types.SensorId
        },
        ['EventMsgVersion'] = {['baseType'] = 'U8', ['validator'] = sel_msg_list_class_types.EventMsgVersion},
        ['SensorType'] = {['baseType'] = 'U8', ['validator'] = sel_msg_list_class_types.SensorType},
        ['SensorNumber'] = {['baseType'] = 'U8', ['validator'] = sel_msg_list_class_types.SensorNumber},
        ['EventType'] = {['baseType'] = 'U8', ['validator'] = sel_msg_list_class_types.EventType},
        ['EventDir'] = {['baseType'] = 'U8', ['validator'] = sel_msg_list_class_types.EventDir},
        ['EventData1'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['validator'] = sel_msg_list_class_types.EventData1
        },
        ['EventData2'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['validator'] = sel_msg_list_class_types.EventData2
        },
        ['EventData3'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['validator'] = sel_msg_list_class_types.EventData3
        },
        ['Level'] = {['baseType'] = 'U8', ['validator'] = sel_msg_list_class_types.Level}
    },
    ['default_props'] = {
        ['SensorId'] = sel_msg_list_class_types.SensorId.default[1],
        ['EventMsgVersion'] = sel_msg_list_class_types.EventMsgVersion.default[1],
        ['SensorType'] = sel_msg_list_class_types.SensorType.default[1],
        ['SensorNumber'] = sel_msg_list_class_types.SensorNumber.default[1],
        ['EventType'] = sel_msg_list_class_types.EventType.default[1],
        ['EventDir'] = sel_msg_list_class_types.EventDir.default[1],
        ['EventData1'] = sel_msg_list_class_types.EventData1.default[1],
        ['EventData2'] = sel_msg_list_class_types.EventData2.default[1],
        ['EventData3'] = sel_msg_list_class_types.EventData3.default[1],
        ['Level'] = sel_msg_list_class_types.Level.default[1]
    }
}

local PersistProperty = {
    ['table_name'] = 't_persist_property',
    ['prop_configs'] = {
        ['PerId'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = persist_property_class_types.PerId},
        ['Key'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = persist_property_class_types.Key},
        ['Value'] = {['baseType'] = 'String', ['validator'] = persist_property_class_types.Value}
    },
    ['default_props'] = {
        ['PerId'] = persist_property_class_types.PerId.default[1],
        ['Key'] = persist_property_class_types.Key.default[1],
        ['Value'] = persist_property_class_types.Value.default[1]
    }
}

local MCDLSDR = {
    ['prop_configs'] = {
        ['SlaveAddr'] = {
            ['baseType'] = 'U8',
            ['default'] = 32,
            ['usage'] = {'CSR'},
            ['validator'] = mcdlsdr_class_types.SlaveAddr
        },
        ['Channel'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = mcdlsdr_class_types.Channel
        },
        ['PowerStateInitialization'] = {
            ['baseType'] = 'U8',
            ['default'] = 128,
            ['usage'] = {'CSR'},
            ['validator'] = mcdlsdr_class_types.PowerStateInitialization
        },
        ['Capabilities'] = {
            ['baseType'] = 'U8',
            ['default'] = 45,
            ['usage'] = {'CSR'},
            ['validator'] = mcdlsdr_class_types.Capabilities
        },
        ['EntityId'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = mcdlsdr_class_types.EntityId},
        ['EntityInstance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = mcdlsdr_class_types.EntityInstance
        },
        ['DeviceName'] = {['baseType'] = 'String', ['usage'] = {'CSR'}, ['validator'] = mcdlsdr_class_types.DeviceName}
    },
    ['default_props'] = {
        ['SlaveAddr'] = 32,
        ['Channel'] = 0,
        ['PowerStateInitialization'] = 128,
        ['Capabilities'] = 45,
        ['EntityId'] = mcdlsdr_class_types.EntityId.default[1],
        ['EntityInstance'] = mcdlsdr_class_types.EntityInstance.default[1],
        ['DeviceName'] = mcdlsdr_class_types.DeviceName.default[1]
    }
}

local DEASDR = {
    ['prop_configs'] = {
        ['EntityId'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = deasdr_class_types.EntityId},
        ['EntityInstance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.EntityInstance
        },
        ['Address'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Address
        },
        ['Channel'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Channel
        },
        ['Flags'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = deasdr_class_types.Flags},
        ['Address1'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Address1
        },
        ['Channel1'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Channel1
        },
        ['Entity1Id'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = deasdr_class_types.Entity1Id},
        ['Entity1Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Entity1Instance
        },
        ['Address2'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Address2
        },
        ['Channel2'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Channel2
        },
        ['Entity2Id'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = deasdr_class_types.Entity2Id},
        ['Entity2Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Entity2Instance
        },
        ['Address3'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Address3
        },
        ['Channel3'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Channel3
        },
        ['Entity3Id'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = deasdr_class_types.Entity3Id},
        ['Entity3Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Entity3Instance
        },
        ['Address4'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Address4
        },
        ['Channel4'] = {
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Channel4
        },
        ['Entity4Id'] = {['baseType'] = 'U8', ['usage'] = {'CSR'}, ['validator'] = deasdr_class_types.Entity4Id},
        ['Entity4Instance'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = deasdr_class_types.Entity4Instance
        }
    },
    ['default_props'] = {
        ['EntityId'] = deasdr_class_types.EntityId.default[1],
        ['EntityInstance'] = deasdr_class_types.EntityInstance.default[1],
        ['Address'] = 0,
        ['Channel'] = 0,
        ['Flags'] = deasdr_class_types.Flags.default[1],
        ['Address1'] = 0,
        ['Channel1'] = 0,
        ['Entity1Id'] = deasdr_class_types.Entity1Id.default[1],
        ['Entity1Instance'] = deasdr_class_types.Entity1Instance.default[1],
        ['Address2'] = 0,
        ['Channel2'] = 0,
        ['Entity2Id'] = deasdr_class_types.Entity2Id.default[1],
        ['Entity2Instance'] = deasdr_class_types.Entity2Instance.default[1],
        ['Address3'] = 0,
        ['Channel3'] = 0,
        ['Entity3Id'] = deasdr_class_types.Entity3Id.default[1],
        ['Entity3Instance'] = deasdr_class_types.Entity3Instance.default[1],
        ['Address4'] = 0,
        ['Channel4'] = 0,
        ['Entity4Id'] = deasdr_class_types.Entity4Id.default[1],
        ['Entity4Instance'] = deasdr_class_types.Entity4Instance.default[1]
    }
}

local BMCEnables = {
    ['prop_configs'] = {
        ['RecvMsgIntrptEnabled'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['default'] = 1,
            ['validator'] = bmc_enables_class_types.RecvMsgIntrptEnabled
        },
        ['EvtMsgBufFullIntrptEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = bmc_enables_class_types.EvtMsgBufFullIntrptEnabled
        },
        ['EvtMsgBufEnabled'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['validator'] = bmc_enables_class_types.EvtMsgBufEnabled
        },
        ['SELEnabled'] = {['baseType'] = 'U8', ['default'] = 1, ['validator'] = bmc_enables_class_types.SELEnabled},
        ['OEM0Enabled'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = bmc_enables_class_types.OEM0Enabled},
        ['OEM1Enabled'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = bmc_enables_class_types.OEM1Enabled},
        ['OEM2Enabled'] = {['baseType'] = 'U8', ['default'] = 0, ['validator'] = bmc_enables_class_types.OEM2Enabled}
    },
    ['default_props'] = {
        ['RecvMsgIntrptEnabled'] = 1,
        ['EvtMsgBufFullIntrptEnabled'] = 1,
        ['EvtMsgBufEnabled'] = 1,
        ['SELEnabled'] = 1,
        ['OEM0Enabled'] = 0,
        ['OEM1Enabled'] = 0,
        ['OEM2Enabled'] = 0
    }
}

local BootError = {
    ['table_name'] = 't_boot_error',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['default'] = 1,
            ['primaryKey'] = true,
            ['usage'] = {'CSR'},
            ['validator'] = boot_error_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = 1},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPMIEvent'] = {
            ['SensorType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['default'] = 30,
                ['validator'] = ipmi_event_intf_types.SensorType
            },
            ['ReadingType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 111,
                ['validator'] = ipmi_event_intf_types.ReadingType
            },
            ['EventData'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 4294967295,
                ['validator'] = ipmi_event_intf_types.EventData
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/EventEntries/BootError'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPMIEvent'] = {
            ['property_defaults'] = {['SensorType'] = 30, ['ReadingType'] = 111, ['EventData'] = 4294967295},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = ipmi_event_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('ThresholdSensor', ThresholdSensor):set_bus(bus)
    class('Sensors', Sensors):set_bus(bus)
    class('DiscreteSensor', DiscreteSensor):set_bus(bus)
    class('Entity', Entity):set_bus(bus)
    class('DiscreteEvent', DiscreteEvent):set_bus(bus)
    class('IpmiSelDesc', IpmiSelDesc):set_bus(bus)
    class('IpmiSelFilter', IpmiSelFilter):set_bus(bus)
    class('IpmiSelList', IpmiSelList):set_bus(bus)
    class('IpmiSelListDump', IpmiSelListDump):set_bus(bus)
    class('SensorSelInfo', SensorSelInfo):set_bus(bus)
    class('IpmiPefConfig', IpmiPefConfig):set_bus(bus)
    class('IpmiPefControl', IpmiPefControl):set_bus(bus)
    class('IpmiPefFilter', IpmiPefFilter):set_bus(bus)
    class('IpmiPefAlertFilter', IpmiPefAlertFilter):set_bus(bus)
    class('IpmiPefAlertString', IpmiPefAlertString):set_bus(bus)
    class('SelMsgList', SelMsgList):set_bus(bus)
    class('PersistProperty', PersistProperty):set_bus(bus)
    class('MCDLSDR', MCDLSDR):set_bus(bus)
    class('DEASDR', DEASDR):set_bus(bus)
    class('BMCEnables', BMCEnables):set_bus(bus)
    class('BootError', BootError):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetThresholdSensorList(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetThresholdSensorList = function(obj, ctx, ...)
        local req = sensors_intf_types.GetThresholdSensorListReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetThresholdSensorListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsMockSensor(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].MockSensor = function(obj, ctx, ...)
        local req = sensors_intf_types.MockSensorReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.MockSensorRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetSensorList(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetSensorList = function(obj, ctx, ...)
        local req = sensors_intf_types.GetSensorListReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetSensorListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsSetSensorStatus(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].SetSensorStatus = function(obj, ctx, ...)
        local req = sensors_intf_types.SetSensorStatusReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.SetSensorStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsExportSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].ExportSel = function(obj, ctx, ...)
        local req = sensors_intf_types.ExportSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.ExportSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetSel = function(obj, ctx, ...)
        local req = sensors_intf_types.GetSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetDiscreteSensorList(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetDiscreteSensorList = function(obj, ctx, ...)
        local req = sensors_intf_types.GetDiscreteSensorListReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetDiscreteSensorListRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsGetReportedSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].GetReportedSel = function(obj, ctx, ...)
        local req = sensors_intf_types.GetReportedSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.GetReportedSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsDumpSDR(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].DumpSDR = function(obj, ctx, ...)
        local req = sensors_intf_types.DumpSDRReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.DumpSDRRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsAddOemSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].AddOemSel = function(obj, ctx, ...)
        local req = sensors_intf_types.AddOemSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.AddOemSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSensorsSensorsClearSel(cb)
    class('Sensors')['bmc.kepler.Chassis.Sensors'].ClearSel = function(obj, ctx, ...)
        local req = sensors_intf_types.ClearSelReq.new(...):validate(nil, nil, true)
        local rsp = sensors_intf_types.ClearSelRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
