#!/bin/bash
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
        #  http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

if [ -f /data/v3_partitioned_flag ]; then
    echo "emmc has V3-partitioned"
    exit 0
fi

# 检查当前是否为V2分区表
reserved_sectors_num=$(busybox fdisk -l /dev/mmcblk0 | awk '/\/dev\/mmcblk0p7/ {print $6}')
permanent_sectors_num=$(busybox fdisk -l /dev/mmcblk0 | awk '/\/dev\/mmcblk0p8/ {print $6}')
logpart_sectors_num=$(busybox fdisk -l /dev/mmcblk0 | awk '/\/dev\/mmcblk0p9/ {print $6}')
if [ "$reserved_sectors_num" != "1248624" ] || [ "$permanent_sectors_num" != "32768" ] || [ "$logpart_sectors_num" != "" ] ;then
    exit 0
fi

# 按照V2分区表进行重新分区
echo "d
8
d
7
n
l
11367040
11891327
n
l
12615680
12648447
n
l


w
" | busybox fdisk /dev/mmcblk0
echo "Partitioning finish with $?"

touch /data/v3_partitioned_flag

echo "RTOS would reboot now"
systemctl reboot
