#!/bin/sh
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
        #  http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

# This scripts insmod product based drivers.

KERNEL_VERSION=`uname -r`

##########insmod cachefs driver#########
insmod /lib/modules/${KERNEL_VERSION}/kernel/fs/fscache/fscache.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/fs/cachefiles/cachefiles.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/fs/nfs_common/grace.ko

##########insmod nfs driver#########
insmod /lib/modules/${KERNEL_VERSION}/kernel/net/sunrpc/sunrpc.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/fs/nfs_common/nfs_acl.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/fs/lockd/lockd.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/fs/nfs/nfs.ko
modprobe nfsv3.ko

##########insmod cifs driver#########
insmod /lib/modules/${KERNEL_VERSION}/kernel/crypto/ccm.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/crypto/md4.ko
modprobe cifs.ko

##########insmod isofs driver#########
modprobe isofs.ko

##########insmod dm-mod driver#########
insmod /lib/modules/${KERNEL_VERSION}/kernel/drivers/md/dm-mod.ko

##########insmod iptables driver#######
insmod /lib/modules/${KERNEL_VERSION}/kernel/net/netfilter/x_tables.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/net/netfilter/xt_limit.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/net/netfilter/xt_MASQUERADE.ko
##########insmod ip6tables driver#######
insmod /lib/modules/${KERNEL_VERSION}/kernel/net/ipv6/netfilter/ip6_tables.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/net/ipv6/netfilter/ip6table_filter.ko

insmod /lib/modules/${KERNEL_VERSION}/kernel/drivers/usb/host/xhci-plat-hcd.ko

#########insmode ipv6##################
insmod /lib/modules/${KERNEL_VERSION}/kernel/lib/crc-ccitt.ko
modprobe ipv6

insmod /lib/modules/${KERNEL_VERSION}/kernel/crypto/cryptd.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/crypto/crypto_simd.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/lib/crypto/libaes.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/arch/arm64/crypto/aes-ce-cipher.ko
insmod /lib/modules/${KERNEL_VERSION}/kernel/arch/arm64/crypto/aes-ce-blk.ko
